/* ***** BEGIN LICENSE BLOCK *****
 *
 * Copyright (C) 2009, 2010, 2011  Stéphane Sire
 *
 * This file contains files from the Adaptable XML Editing Library (AXEL)
 * Version 1.1.2-beta (Rev 260)
 *
 * Adaptable XML Editing Library (AXEL) is free software ; you can redistribute it 
 * and/or modify it under the terms of the GNU Lesser General Public License (the "LGPL")
 * as published by the Free Software Foundation ; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY ; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this library ; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307 USA.
 *
 * Web site : http://media.epfl.ch/Templates/
 * 
 * Contributors(s) : Stephane Sire, Antoine Yersin, Jonathan Wafellmann, Useful Web Sàrl 
 * 
 * ***** END LICENSE BLOCK ***** */
 if(typeof xtiger=="undefined"||!xtiger){var xtiger={};xtiger.COMPONENT=1;xtiger.REPEAT=2;xtiger.USE=3;xtiger.BAG=4;xtiger.ATTRIBUTE=5;xtiger.SERVICE=6;xtiger.UNKNOWN=-1}xtiger.parser={};xtiger.editor={};xtiger.service={};xtiger.cross={};xtiger.util={};if(typeof xtdom=="undefined"||!xtdom){xtdom={}}xtiger.util.Session=function(){this.store={}};xtiger.util.Session.prototype={save:function(c,b){this.store[c]=b},load:function(b){return this.store[b]}};xtiger.session=function(b){if(!b._xtigerSession){b._xtigerSession=new xtiger.util.Session()}return b._xtigerSession};xtiger.util.Resources=function(){this.bundles={};xtiger.bundles={}};xtiger.util.Resources.prototype={_mountBundle:function(d,f){var b=this.bundles[d];var e=xtiger.bundles[d];for(var c in b){e[c]=f+d+"/"+b[c]}},addBundle:function(d,b){this.bundles[d]=b;xtiger.bundles[d]={};for(var c in b){xtiger.bundles[d][c]=b[c]}},setBase:function(b){if(b.charAt(b.length-1)!="/"){b=b+"/"}for(var c in this.bundles){this._mountBundle(c,b)}}};xtiger.resources=new xtiger.util.Resources();xtiger.util.FactoryRegistry=function(){this.store={}};xtiger.util.FactoryRegistry.prototype={registerFactory:function(c,b){if(this.store[c]){alert("Error (AXEL) attempt to register an already registered factory : '"+c+"' !")}else{this.store[c]=b}},getFactoryFor:function(b){if(!this.store[b]){alert("Fatal Error (AXEL) unkown factory required : '"+b+"' \nYour editor will NOT be generated !")}else{return this.store[b]}}};xtiger.registry=new xtiger.util.FactoryRegistry();xtiger.factory=function(b){return xtiger.registry.getFactoryFor(b)};xtdom.counterId=0;xtdom.genId=function(){return xtdom.counterId++};xtdom.createTextNode=function(b,c){return b.createTextNode(c)};xtdom.hasAttribute=function(c,b){return c.hasAttribute(b)};xtdom.removeElement=function(b){var c=b.parentNode;if(!c){return}c.removeChild(b)};xtdom.containsXT=function(c){if(c.nodeType==xtdom.ELEMENT_NODE){if(xtdom.isXT(c)){return true}else{if(c.childNodes&&c.childNodes.length>0){for(var b=0;b<c.childNodes.length;b++){if(xtdom.containsXT(c.childNodes[b])){return true}}}}}return false};xtdom.getMenuMarkerXT=function(d){var c=false;var b=xtdom.getElementsByTagNameXT(d,"menu-marker");if(b.length>0){c=b[0]}return c};xtdom.getTagNameXT=function(c){var b=(xtiger.ATTRIBUTE==xtdom.getNodeTypeXT(c))?"name":"label";return c.getAttribute(b)};xtdom.extractDefaultContentXT=function(c){var d=false;if(xtiger.ATTRIBUTE==xtdom.getNodeTypeXT(c)){d=c.getAttribute("default")}else{if(c.childNodes){for(var b=0;b<c.childNodes.length;b++){var f;var e=c.childNodes[b];if(e.nodeType==xtdom.ELEMENT_NODE){f=e.innerHTML}else{f=e.nodeValue}if(d){d+=f}else{d=f}}}}return d};xtdom.getFirstElementChildOf=function(d){var c;for(var b=0;b<d.childNodes.length;b++){if(d.childNodes[b].nodeType==xtdom.ELEMENT_NODE){c=d.childNodes[b];break}}return c};xtdom.moveNodesAfter=function(b,d){var e;if(d.nextSibling){var c=d.nextSibling;while(e=b.shift()){c.parentNode.insertBefore(e,c)}}else{while(e=b.shift()){d.parentNode.appendChild(e)}}};xtdom.moveChildrenOfAfter=function(d,c){var e;if(c.nextSibling){var b=c.nextSibling;while(e=d.firstChild){d.removeChild(e);b.parentNode.insertBefore(e,b)}}else{while(e=d.firstChild){d.removeChild(e);c.parentNode.appendChild(e)}}};xtdom.importChildOfInto=function(c,d,f){for(var b=0;b<d.childNodes.length;b++){var e=d.childNodes[b];var g=xtdom.importNode(c,d.childNodes[b],true);f.appendChild(g)}};xtdom.replaceNodeByChildOf=function(d,b,e){var c=d.parentNode;var f;while(f=b.firstChild){b.removeChild(f);c.insertBefore(f,d,true);if(e){e.push(f)}}c.removeChild(d)};xtdom.removeChildrenOf=function(b){b.innerHTML=""};xtdom.moveChildOfInto=function(c,b,d){var e;while(e=c.firstChild){c.removeChild(e);b.appendChild(e);if(d){d.push(e)}}};xtdom.getInlineDisplay=function(b){var c="";if((b.style)&&(b.style.display)){c=b.style.display}return c};xtdom.getSelectedOpt=function(c){for(var b=0;b<c.options.length;b++){if(c.options[b].selected){break}}return b};xtdom.setSelectedOpt=function(c,b){c.selectedIndex=b};xtdom.addClassName=function(c,b){if(c.className){if(c.className.search(b)==-1){if(c.className.length==0){c.className=b}else{c.className+=" "+b}}}else{c.className=b}};xtdom.removeClassName=function(d,c){if(d.className){var b=d.className.search(c);if(b!=-1){d.className=d.className.substr(0,b)+d.className.substr(b+c.length)}}};xtdom.replaceClassNameBy=function(e,b,c){var d=e.className.search(b);if(d!=-1){e.className=e.className.substr(0,d)+c+e.className.substr(d+b.length)}else{xtdom.addClassName(e,c)}};xtdom.getComputedStyle=function(b,c){if(!b||!b.ownerDocument){return null}var d=b.ownerDocument;if(window.getComputedStyle){return window.getComputedStyle(b,null).getPropertyValue(c)}else{if(b.currentStyle){c=c.replace(/\-(\w)/g,function(e,f){return f.toUpperCase()});return b.currentStyle[c]}}return null};xtdom.findPos=function(c){var d=curtop=0;if(c.offsetParent){d=c.offsetLeft;curtop=c.offsetTop;if(document.defaultView){var b=document.defaultView.getComputedStyle(c,null).getPropertyValue("position")}else{if(document.uniqueID){var b=c.currentStyle.position}}if(c.scrollTop&&(b=="absolute")){curtop-=c.scrollTop}if(c.scrollLeft&&(b=="absolute")){d-=c.scrollLeft}while(c=c.offsetParent){d+=c.offsetLeft;curtop+=c.offsetTop;if(document.defaultView){var b=document.defaultView.getComputedStyle(c,null).getPropertyValue("position")}else{if(document.uniqueID){var b=c.currentStyle.position}}if(c.scrollTop&&(b=="absolute")){curtop-=c.scrollTop}if(c.scrollLeft&&(b=="absolute")){d-=c.scrollLeft}}}return[d,curtop]};xtdom.findPosAsSibling=function(c,e){var d=_curtop=0;var f=e;if(f.offsetParent){d+=f.offsetLeft;_curtop+=f.offsetTop;while(f=f.offsetParent){if(c.defaultView){var b=c.defaultView.getComputedStyle(f,null).getPropertyValue("position")}else{if(a){if(f.scrollTop&&b=="absolute"){_curtop-=f.scrollTop}}}if(f.scrollLeft&&(b=="absolute")){d-=f.scrollLeft}if(b=="absolute"||b=="fixed"||b=="relative"){break}d+=f.offsetLeft;_curtop+=f.offsetTop}}return[d,_curtop]};xtdom.isOffsetAncestorOf=function(c,d){var b=c.offsetParent;while(b!=null){if(b===d){return true}b=b.offsetParent}return false};xtdom.findPostitionFrom=function(c,d){if(!c||!d){return null}var b=c.ownerDocument;var e=d;while(!xtdom.isOffsetAncestor(c,e)){e=e.offsetParent}};xtdom.getWindowLimitFrom=function(e){var d=0,c=0,i=0,g=0;var b=e.ownerDocument;var f=b.defaultView||b.parentWindow;if(typeof(f.innerWidth)=="number"){d=f.innerWidth;c=f.innerHeight}else{if(b.documentElement&&(b.documentElement.clientWidth||b.documentElement.clientHeight)){d=b.documentElement.clientWidth;c=b.documentElement.clientHeight}else{if(b.body&&(b.body.clientWidth||b.body.clientHeight)){d=b.body.clientWidth;c=b.body.clientHeight}}}if(typeof(f.pageYOffset)=="number"){g=f.pageYOffset;i=f.pageXOffset}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){g=document.body.scrollTop;i=document.body.scrollLeft}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){g=document.documentElement.scrollTop;i=document.documentElement.scrollLeft}}}return[d+i,c+g]};xtiger.util.DOMDataSource=function(c){var e;this.xml=null;this.flow={};this.stack=[];if(c){if(c.constructor==={}.constructor){for(var b in c){e=c[b];if(e){(b=="document")?this.initFromDocument(e):this.initFlowFromDocument(e,b)}}}else{this.initFromDocument(c)}}};xtiger.util.DOMDataSource.prototype={hasData:function(){return(null!=this.xml)},_setRootNode:function(b){this.xml=b},_setFlowNode:function(b,c){this.flow[b]=[0,c]},_initFromTide:function(b){var f=b.childNodes;for(var d=0;d<f.length;d++){var e=f.item(d);if(e.nodeType==xtdom.ELEMENT_NODE){if(this.xml==null){this._setRootNode(e)}else{this._setFlowNode(xtdom.getLocalName(e),e)}}}},initFromDocument:function(d){this.xml=null;if(d&&d.documentElement){var b=d.documentElement;var c=b.nodeName=="tide"||b.nodeName=="xt:tide";if(c){this._initFromTide(b)}else{this._setRootNode(b)}}return(this.xml!=null)},initFlowFromDocument:function(d,c){var b=(d&&d.documentElement)?this._setFlowNode(c,d.documentElement):false;return b!=false},initFromString:function(f){var b=true;try{var g=xtiger.cross.makeDOMParser();var d=g.parseFromString(f,"text/xml");this.initFromDocument(d)}catch(c){alert("Exception : "+c.message);b=false}return b},openFlow:function(d,b,c){if(this.flow[d]){if(0===this.flow[d][0]){if(c&&(d==c)){this.flow[d]=[d,this.flow[d][1]]}else{this.flow[d]=this.makeRootVector(this.flow[d][1])}}this.stack.push([d,b]);return this.flow[d]}return false},closeFlow:function(c,b){var d=(this.stack.length>0)?this.stack[this.stack.length-1]:false;if(d&&(c==d[0])){this.stack.pop();if(this.stack.length>0){this.flow[c]=b}return d[1]}return false},nameFor:function(b){if(b instanceof Array){return xtdom.getLocalName(b[0])}else{return null}},lengthFor:function(b){if(b instanceof Array){return b.length-1}else{return 0}},makeRootVector:function(b){var e=[b];if(b){var g=b.childNodes;for(var d=0;d<g.length;d++){var f=g.item(d);if(f.nodeType==xtdom.ELEMENT_NODE){e.push(f)}}}return e},getRootVector:function(){return this.makeRootVector(this.xml)},hasDataFor:function(c,b){var d=false;if("@"==c.charAt(0)){if(b!==-1){d=xtdom.hasAttribute(b[0],c.substr(1))}}else{if((b instanceof Array)&&(b.length>1)){if(b[1]&&(b[1].nodeType==xtdom.ELEMENT_NODE)){var f=xtdom.getLocalName(b[1]);var e=c.search(f);d=(e!=-1)&&(((e+f.length)==c.length)||(c.charAt(e+f.length)==" "))}}}return d},getDataFor:function(b){if((b instanceof Array)&&(b.length>1)){return b[1]}else{return null}},isEmpty:function(b){var c=false;if((b instanceof Array)&&(b.length>1)){if(b.length==2){if(typeof(b[1])=="string"){c=(b[1].search(/\S/)==-1)}}}else{c=true}return c},getPointAtIndex:function(b,f,l){var j;var d=l.splice(f,1)[0];var k=d.childNodes;if((k.length==1)&&(k.item(0).nodeType==xtdom.TEXT_NODE)){var g=k.item(0).data;j=[d,g]}else{j=[d];for(var e=0;e<k.length;e++){var m=k.item(e);if(m.nodeType==xtdom.ELEMENT_NODE){j.push(m)}}if(j.length==1){j.push(null)}}return j},hasVectorFor:function(c,b){if(b instanceof Array){for(var d=1;d<b.length;d++){if((b[d]!==null)&&(b[d].nodeType==xtdom.ELEMENT_NODE)&&(xtdom.getLocalName(b[d])==c)){return true}}}return false},getVectorFor:function(c,b){if(b instanceof Array){for(var d=1;d<b.length;d++){if((b[d]!==null)&&(b[d].nodeType==xtdom.ELEMENT_NODE)&&(xtdom.getLocalName(b[d])==c)){return this.getPointAtIndex(c,d,b)}}}return -1},hasAttributeFor:function(c,b){return(b instanceof Array)&&(b[0].getAttribute(c)!=null)},getAttributeFor:function(d,c){var e=-1;if(c instanceof Array){var f=c[0];var b=f.getAttribute(d);if(b){f.removeAttribute(d);e=[f,b]}}return e},hasVectorForAnyOf:function(e,b){if(b instanceof Array){for(var d=1;d<b.length;d++){for(var c=0;c<e.length;c++){if((b[d]!==null)&&(b[d].nodeType==xtdom.ELEMENT_NODE)&&xtdom.getLocalName(b[d])==e[c]){return true}}}}return false},getVectorForAnyOf:function(e,b){if(b instanceof Array){for(var d=1;d<b.length;d++){for(var c=0;c<e.length;c++){if((b[d]!==null)&&(b[d].nodeType==xtdom.ELEMENT_NODE)&&xtdom.getLocalName(b[d])==e[c]){return this.getPointAtIndex(e[c],d,b)}}}}return -1}};xtiger.util.PseudoNode=function(b,c){this.type=b;this.discard=false;if(b==xtiger.util.PseudoNode.ELEMENT_NODE){this.name=c;this.attributes=null;this.content=null}else{this.content=c}};xtiger.util.PseudoNode.TEXT_NODE=0;xtiger.util.PseudoNode.ELEMENT_NODE=1;xtiger.util.PseudoNode.NEWLINE="\n";xtiger.util.PseudoNode.prototype={indent:["","  "],discardNodeIfEmpty:function(){this.discard=true},addChild:function(b){if(xtiger.util.PseudoNode.TEXT_NODE==b.type){this.content=b}else{if(!this.content){this.content=[]}if(this.content instanceof Array){this.content.push(b)}else{xtiger.cross.log("error","Mixed content ["+this.content+"] in "+this.name)}}},addAttribute:function(b,c){if(!this.attributes){this.attributes={}}this.attributes[b]=c},getIndentForLevel:function(c){if(typeof this.indent[c]!="string"){var b=this.indent[c-1];b+=this.indent[1];this.indent[c]=b}return this.indent[c]},dumpAttributes:function(){var c="";for(var b in this.attributes){c+=" ";c+=b;c+='="';c+=xtiger.util.encodeEntities(this.attributes[b]);c+='"'}return c},dump:function(d){if(xtiger.util.PseudoNode.TEXT_NODE==this.type){return xtiger.util.encodeEntities(this.content)}else{var c=this.getIndentForLevel(d);if(this.content){c+="<";c+=this.name;if(this.attributes){c+=this.dumpAttributes()}c+=">";if(this.content instanceof Array){c+=xtiger.util.PseudoNode.NEWLINE;for(var b=0;b<this.content.length;b++){c+=this.content[b].dump(d+1)}c+=this.getIndentForLevel(d)}else{c+=xtiger.util.encodeEntities(this.content.content)}c+="</";c+=this.name;c+=">"}else{c+="<";c+=this.name;if(this.attributes){c+=this.dumpAttributes()}else{if(this.discard){return""}}c+="/>"}c+=xtiger.util.PseudoNode.NEWLINE;return c}}};xtiger.util.DOMLogger=function(){this.stack=[];this.curTop=null;this.curAttr=null;this.curFlow=null;this.root=null;this.flow={};this.flowStack=[]};xtiger.util.DOMLogger.prototype={discardNodeIfEmpty:function(){if(this.curTop){this.curTop.discardNodeIfEmpty()}},openAttribute:function(b){this.curAttr=b},openFlow:function(c,b){if(!this.flow[c]){this.flow[c]=[null,null]}this.flowStack.push([c,this.curTop,this.curFlow]);this.curTop=this.flow[c][1];this.curFlow=c;return true},closeFlow:function(b){var c=(this.flowStack.length>0)?this.flowStack[this.flowStack.length-1]:false;if(c&&(b==c[0])){this.flowStack.pop();this.flow[b][1]=this.curTop||this.flow[b][0];this.curTop=c[1];this.curFlow=c[2];return true}return false},closeAttribute:function(b){if(this.curAttr!=b){alert("Attempt to close an attribute "+b+" while in attribute "+this.curAttr+"!")}this.curAttr=null},openTag:function(b){var d=new xtiger.util.PseudoNode(xtiger.util.PseudoNode.ELEMENT_NODE,b);if(!this.root){this.root=d}else{if(this.curFlow&&(!this.flow[this.curFlow][0])){if(this.curFlow==b){this.flow[this.curFlow][0]=d}else{var c=new xtiger.util.PseudoNode(xtiger.util.PseudoNode.ELEMENT_NODE,this.curFlow);this.flow[this.curFlow][0]=c;c.addChild(d)}}}if(this.curTop){this.curTop.addChild(d)}this.stack.push(this.curTop);this.curTop=d},closeTag:function(b){this.curTop=this.stack.pop()},emptyTag:function(b){this.openTag(b);this.closeTag(b)},write:function(b){if(this.curAttr){this.curTop.addAttribute(this.curAttr,b)}else{var c=new xtiger.util.PseudoNode(xtiger.util.PseudoNode.TEXT_NODE,b);this.curTop.addChild(c)}},writeAttribute:function(b,c){this.curTop.addAttribute(b,c)},_dump:function(b,c){if(b=="document"){if(this.root){return this.root.dump(c)}else{return xtiger.util.PseudoNode.prototype.indent[c]+"<document/>\n"}}else{if(this.flow[b]){return this.flow[b][0].dump(c)}else{return xtiger.util.PseudoNode.prototype.indent[c]+"<"+b+"/>\n"}}},dump:function(c){var b;var g=c||"document";if((g instanceof Array)||(g=="*")){if(((g instanceof Array)&&(g[0]=="*"))||((g=="*")&&(xtiger.util.countProperties(this.flow)>0))){b=["document"];for(var e in this.flow){b.push(e)}}else{b=(g=="*")?"document":g}}else{b=g}if(b instanceof Array){var d=[];d.push('<xt:tide xmlns:xt="'+xtiger.parser.nsXTiger+'">\n');for(var f=0;f<b.length;f++){d.push(this._dump(b[f],1))}d.push("</xt:tide>\n");return d.join("")}else{return this._dump(b,0)}},close:function(){}};xtiger.cross.UA={IE:!!(window.attachEvent&&navigator.userAgent.indexOf("Opera")===-1),opera:navigator.userAgent.indexOf("Opera")>-1,webKit:navigator.userAgent.indexOf("AppleWebKit/")>-1,gecko:navigator.userAgent.indexOf("Gecko")>-1&&navigator.userAgent.indexOf("KHTML")===-1,mobileSafari:!!navigator.userAgent.match(/Apple.*Mobile.*Safari/)};if(!(xtiger.cross.UA.gecko||xtiger.cross.UA.webKit||xtiger.cross.UA.IE||xtiger.cross.UA.opera||xtiger.cross.UA.mobileSafari)){xtiger.cross.log("warning","XTiger Forms could not detect user agent name, assuming a Gecko like browser");xtiger.cross.UA.gecko=true}xtiger.util.countProperties=function(d){var c=0;for(var b in d){if(d.hasOwnProperty(b)){c++}}return c};xtiger.util.encodeEntities=function(c){if(typeof(c)!="string"){return c}var b=c;if(c.indexOf("&")!=-1){b=b.replace(/&(?![a-zA-Z]{3,5};)/g,"&amp;")}if(c.indexOf("<")!=-1){b=b.replace(/</g,"&lt;")}if(c.indexOf(">")!=-1){b=b.replace(/>/g,"&gt;")}return b};xtiger.util.decodeEntities=function(c){if(c.indexOf("&amp;")!=-1){var b=c.replace(/&amp;/g,"&");if(c.indexOf("<")!=-1){return b.replace(/&lt;/g,"<")}return b}return c};xtiger.util.decodeParameters=function(c,g){if(!c){return}var b=c.split(";");for(var f=0;f<b.length;f++){var e=b[f].split("=");var d=e[0].replace(/^\s*/,"").replace(/\s*$/,"");if(d=="class"){d="hasClass"}g[d]=e[1]}};xtiger.util.mixin=function mixin(e,d){var c={};for(var b in d){if((typeof c[b]=="undefined")||(c[b]!=d[b])){e[b]=d[b]}}if(xtiger.cross.UA.IE&&(typeof(d.toString)=="function")&&(d.toString!=e.toString)&&(d.toString!=c.toString)){e.toString=d.toString}return e};xtiger.util.array_map=function array_map(e,b){if(!(typeof e=="object"&&typeof b=="function")){return e}var c=[];for(var d=0;d<e.length;d++){c[d]=b(e[d])}return c};xtiger.util.array_filter=function array_filter(e,b){if(!(typeof e=="object"&&typeof b=="function")){return e}var c=[];for(var d=0;d<e.length;d++){if(b(e[d])){c.push(e[d])}}return c};xtiger.util.array_contains=function array_contains(d,c){if(typeof d!="object"){return false}for(var b=0;b<d.length;b++){if(d[b]==c){return true}if(typeof(d[b])=="object"&&typeof(c)=="object"){if(xtiger.util.object_compare(d[b],c)){return true}}}return false};xtiger.util.object_compare=function object_compare(b,c){for(_prop in b){if(typeof(c[_prop])=="undefined"){return false}}for(_prop in b){if(b[_prop]){switch(typeof(b[_prop])){case"object":if(!xtiger.util.object_compare(b[_prop],c[_prop])){return false}break;case"function":if(typeof(c[_prop])=="undefined"||(_prop!="equals"&&b[_prop].toString()!=c[_prop].toString())){return false}break;default:if(b[_prop]!=c[_prop]){return false}}}else{if(c[_prop]){return false}}}for(_prop in c){if(typeof(b[_prop])=="undefined"){return false}}return true};xtiger.cross.getXHRObject=function(){var c=false;if(window.XMLHttpRequest){c=new XMLHttpRequest()}else{if(window.ActiveXObject){try{c=new ActiveXObject("Msxml2.XMLHTTP")}catch(b){try{c=new ActiveXObject("Microsoft.XMLHTTP")}catch(b){}}}}if(!c){alert("Your browser does not support XMLHTTPRequest")}return c};xtiger.cross.loadDocument=function(c,b){var g=xtiger.cross.getXHRObject();try{g.open("GET",c,false);g.send(null);if((g.status==200)||(g.status==0)){if(g.responseXML){return g.responseXML}else{if(b){b.logError("$$$ loaded but it contains no XML data",c)}}}else{if(b){var d=g.statusText?"("+g.statusText+")":"";b.logError("HTTP error while loading $$$, status code : "+g.status+d,c)}}}catch(f){if(b){b.logError("Exception while loading $$$ : "+(f.message?f.message:f.name),c)}}return false};xtiger.cross.log=function(b,c){switch(b){case"error":case"fatal":xtiger.cross.print("[XX] "+c);break;case"warning":xtiger.cross.print("[!!] "+c);break;case"info":break;case"debug":xtiger.cross.print("[dd] "+c);break;default:}};xtiger.cross.print=function(c){try{if(typeof(opera)!="undefined"&&opera.log){opera.postError(c)}else{if(typeof(console)!="undefined"){if(/^\[!!\]/.test(c)&&console.warn){console.warn(c)}else{if(/^\[XX\]/.test(c)&&console.error){console.error(c)}else{if(console.log){console.log(c)}}}}else{if(typeof(window.console)!="undefined"&&window.console.log){window.console.log(c)}}}}catch(b){alert(c+"\nUnable to print on console ("+b.message+")")}};if(typeof DOMParser=="undefined"){xtiger.util.DOMParser=function(){};xtiger.util.DOMParser.prototype.parseFromString=function(e,f){if(typeof ActiveXObject!="undefined"){var c=new ActiveXObject("MSXML.DomDocument");c.loadXML(e);return c}else{if(typeof XMLHttpRequest!="undefined"){var b=new XMLHttpRequest;b.open("GET","data:"+(f||"application/xml")+";charset=utf-8,"+encodeURIComponent(e),false);if(b.overrideMimeType){b.overrideMimeType(f)}b.send(null);return b.responseXML}}};xtiger.cross.makeDOMParser=function(){return new xtiger.util.DOMParser()}}else{xtiger.cross.makeDOMParser=function(){return new DOMParser()}}if(!document.createTreeWalker){xtiger.util.TreeWalker=function(d,b,c){this.nodeList=new Array();this.nodeType=b;this.filter=c;this.nodeIndex=-1;this.currentNode=null;this.findNodes(d)};xtiger.util.TreeWalker.prototype={nextNode:function(){this.nodeIndex+=1;if(this.nodeIndex<this.nodeList.length){this.currentNode=this.nodeList[this.nodeIndex];return true}else{this.nodeIndex=-1;return false}},findNodes:function(c){if(c.nodeType==this.nodeType&&this.filter(c)==xtdom.NodeFilter.FILTER_ACCEPT){this.nodeList.push(c)}if(c.nodeType==1){for(var b=0;b<c.childNodes.length;b++){this.findNodes(c.childNodes[b])}}}};xtiger.cross.makeTreeWalker=function(d,c,b){return new xtiger.util.TreeWalker(d,c,b)}}else{if(xtiger.cross.UA.webKit){xtiger.cross.makeTreeWalker=function(d,c,b){return document.createTreeWalker(d,c,b,false)}}else{xtiger.cross.makeTreeWalker=function(e,c,b){var d={acceptNode:b};return document.createTreeWalker(e,c,d,false)}}}xtdom.getNodeTypeXT=function(b){var c=b.nodeName.toLowerCase();if((c=="use")||(c=="xt:use")){return xtiger.USE}else{if((c=="component")||(c=="xt:component")){return xtiger.COMPONENT}else{if((c=="repeat")||(c=="xt:repeat")){return xtiger.REPEAT}else{if((c=="bag")||(c=="xt:bag")){return xtiger.BAG}else{if((c=="attribute")||(c=="xt:attribute")){return xtiger.ATTRIBUTE}else{if((c=="service")||(c=="xte:service")){return xtiger.SERVICE}else{return xtiger.UNKNOWN}}}}}}};xtdom.ELEMENT_NODE=1;xtdom.ATTRIBUTE_NODE=2;xtdom.TEXT_NODE=3;xtdom.CDATA_SECTION_NODE=4;xtdom.COMMENT_NODE=8;if((typeof NodeFilter=="undefined")||!NodeFilter){xtdom.NodeFilter={SHOW_ELEMENT:1,FILTER_ACCEPT:1,FILTER_SKIP:3}}else{xtdom.NodeFilter={SHOW_ELEMENT:NodeFilter.SHOW_ELEMENT,FILTER_ACCEPT:NodeFilter.FILTER_ACCEPT,FILTER_SKIP:NodeFilter.FILTER_SKIP}}xtdom.getWindow=function getWindow(b){if(window.document==b){return window}if(window.frames.length>0){for(var c=0;c<window.frames.length;c++){if(window.frames[c].document==b){return window.frames[c]}}}xtiger.cross.log("warning","The window object was not found.");return window};if(!xtiger.cross.UA.IE){xtdom.isXT=function isXT(c){var b=c.namespaceURI;return(b==xtiger.parser.nsXTiger)||(b==xtiger.parser.nsXTiger_deprecated)||(b==xtiger.parser.nsXTigerExt)};xtdom.isUseXT=function isUseX(b){return(b.nodeName=="use"||b.nodeName=="xt:use")};xtdom.isBagXT=function(b){return(b.nodeName=="bag"||b.nodeName=="xt:bag")};xtdom.getElementsByTagNameXT=function(b,c){var d=b.getElementsByTagName(c);if(0==d.length){d=b.getElementsByTagName("xt:"+c)}return d};xtdom.getLocalName=function(b){return b.localName};xtdom.getTextContent=function(b){if(b.textContent){return b.textContent}else{if(b.text){return b.text}else{return""}}};xtdom.createElement=function(c,b){return c.createElementNS("http://www.w3.org/1999/xhtml",b)};xtdom.createElementNS=function(d,b,c){return d.createElementNS(c,b)};xtdom.importNode=function(d,c,b){return d.importNode(c,b)};xtdom.cloneNode=function(d,c,b){return c.cloneNode(b)};xtdom.setAttribute=function(c,b,d){c.setAttribute(b,d)};xtdom.getStyleAttribute=function(b){return b.getAttribute("style")};xtdom.getEventTarget=function(b){return b.target};xtdom.addEventListener=function(d,c,e,b){d.addEventListener(c,e,b)};xtdom.removeEventListener=function(d,c,e,b){d.removeEventListener(c,e,b)};xtdom.removeAllEvents=function(b){alert("removeAllEvents should not be called on this browser")};xtdom.preventDefault=function(b){b.preventDefault()};xtdom.stopPropagation=function(b){b.stopPropagation()};xtdom.focusAndSelect=function(b){try{b.focus();b.select()}catch(c){}};xtdom.focusAndMoveCaretTo=function(c,b){try{c.focus();if(c.setSelectionRange){c.setSelectionRange(b,b)}}catch(d){}}}if(xtiger.cross.UA.IE){xtdom.hasAttribute=function(c,b){return c.getAttribute(b)!=null};xtdom.isXT=function(b){return xtiger.parser.isXTigerName.test(b.nodeName)};xtdom.isUseXT=function(b){return(b.nodeName=="use"||b.nodeName=="xt:use")};xtdom.isBagXT=function(b){return(b.nodeName=="bag"||b.nodeName=="xt:bag")};xtdom.getElementsByTagNameXT=function(b,c){var d=b.getElementsByTagName(c);if(0==d.length){d=b.getElementsByTagName("xt:"+c)}return d};xtdom.getLocalName=function(b){return b.nodeName};xtdom.getTextContent=function(b){if(b.innerText){return b.innerText}else{if(b.text){return b.text}else{return""}}};xtdom.createElement=function(c,b){return c.createElement(b)};xtdom.createElementNS=function(d,b,c){if(c==xtiger.parser.nsXTiger){return d.createElement("xt:"+b)}else{return d.createElement(c+":"+b)}};xtdom.importNode=function(f,e,b){switch(e.nodeType){case xtdom.ELEMENT_NODE:var d=xtdom.createElement(f,e.nodeName);if(e.attributes&&e.attributes.length>0){for(var c=0;c<e.attributes.length;c++){xtdom.setAttribute(d,e.attributes[c].name,e.attributes[c].value)}}if(b&&e.childNodes&&e.childNodes.length>0){for(var c=0;c<e.childNodes.length;c++){d.appendChild(xtdom.importNode(f,e.childNodes[c],b))}}return d;break;case xtdom.TEXT_NODE:case xtdom.CDATA_SECTION_NODE:case xtdom.COMMENT_NODE:return xtdom.createTextNode(f,e.nodeValue);break}};xtdom.cloneNode=function(d,c,b){var e=c.cloneNode(b);xtdom.removeAllEvents(e);return e};xtdom.setAttribute=function(c,b,d){if(b=="class"){c.className=d}else{c.setAttribute(b,d)}};xtdom.getStyleAttribute=function(b){if(b.style){return b.style.cssText}else{if(b.attributes[0]&&b.attributes[0].nodeName=="style"){return b.attributes[0].nodeValue}}};xtdom.getEventTarget=function(b){return(b&&b.srcElement)?b.srcElement:window.event.srcElement};xtdom.addEventListener=function(d,c,e,b){d.attachEvent("on"+c,e);if(!d.events){d.events=new Array()}d.events.push([c,e])};xtdom.removeEventListener=function(d,c,e,b){d.detachEvent("on"+c,e)};xtdom.removeAllEvents=function(c){if(c.events){for(var b=0;b<c.events.length;b++){xtdom.removeEventListener(c,c.events[b][0],c.events[b][1],true)}c.events=new Array()}};xtdom.preventDefault=function(b){b.returnValue=false};xtdom.stopPropagation=function(b){b.cancelBubble=true};xtdom.focusAndSelect=function(b){try{b.focus();var d=b.createTextRange();d.moveStart("character",0);d.moveEnd("character",b.value.length);d.select()}catch(c){}};xtdom.focusAndMoveCaretTo=function(c,b){try{c.focus();var f=c.createTextRange();f.collapse(false);f.select()}catch(d){}}}xtiger.util.filterable=function(d,f){if(!f){xtiger.cross.log("error",'filter "'+d+'" is undefined');return f}var c={};var e=d;f.registerFilter=function g(j,i){if(!typeof(i)=="object"){return}if(c[j]){xtiger.cross.log("warning",'"'+e+'" plugin: filter "'+j+'" is already registred. Overwriting it.')}c[j]=i};f.registerDelegate=f.registerFilter;f.applyFilters=function b(i,k){var s={};var l=k.split(" ");var r=i;for(var o=0;o<l.length;o++){var n=r;var q=c[l[o]];if(!q){xtiger.cross.log("warning",'"'+e+'" plugin: missing filter "'+l[o]+'"');continue}var p=function(){};p.prototype=n;r=new p();if(q){var m=q["->"];if(m){for(var j in m){if(s[j]===undefined||s[j]!=m[j]){if(m[j]==null){r[j]=null}else{r[m[j]]=n[j]||function(){}}}}}xtiger.util.mixin(r,q)}}return r};return f};xtiger.parser.NATIVE=0;xtiger.parser.CONSTRUCTED=1;xtiger.parser.nsXTiger="http://ns.inria.org/xtiger";xtiger.parser.nsXTigerExt="http://ns.media.epfl.ch/xtiger-extension";xtiger.parser.nsXTiger_deprecated="http://wam.inrialpes.fr/xtiger";xtiger.parser.nsXHTML="http://www.w3.org/1999/xhtml";xtiger.parser.isXTiger=/<[^>]*[(component)(use)(repeat)(service)]/;xtiger.parser.isXTigerName=/[(component)(use)(repeat)(service)]/;xtiger.parser.Component=function(c,b){this.nature=c;this.tree=b;this.str=null};xtiger.parser.Component.prototype={isNative:function(){return(xtiger.parser.NATIVE==this.nature)},hasBeenExpanded:function(){return(xtiger.parser.NATIVE==this.nature)||(this.str!=null)},getSource:function(){if(!this.str){this.str=this.tree.innerHTML}return this.str},getTree:function(){return this.tree},getClone:function(c){var b=xtdom.cloneNode(c,this.tree,true);return b},importStructTo:function(b){var c=xtdom.importNode(b,this.tree,true);this.tree=c}};xtiger.parser.Iterator=function(c,b){this.transformer=b;this.unionList=new Object();this.componentLib=new Object();this.transformer.coupleWithIterator(this);this.acquireComponentStructs(c);this.acquireUnion(c);this.acquireHeadLabel(c)};xtiger.parser.Iterator.prototype={hasType:function(b){return this.componentLib[b]?true:false},defineType:function(b,c){this.componentLib[b]=c},defineUnion:function(b,c){this.unionList[b]=c},getComponentForType:function(b){return this.componentLib[b]},acquireHeadLabel:function(b){var c;var d=xtdom.getElementsByTagNameXT(b,"head");if(d&&(d.length>0)){c=d[0].getAttributeNode("label");if(!c){d=xtdom.getElementsByTagNameXT(d[0],"head");if(d&&(d.length>0)){c=d[0].getAttributeNode("label")}}}this.headLabel=c?c.value:undefined},acquireComponentStructs:function(b){var c=xtdom.getElementsByTagNameXT(b,"component");var d=new Array();for(var f=0;f<c.length;f++){var e=c[f].getAttribute("name");if(e){d.push(e);this.componentLib[e]=new xtiger.parser.Component(xtiger.parser.CONSTRUCTED,c[f])}}this.unionList.anyComponent=d},acquireUnion:function(i){var g=xtdom.getElementsByTagNameXT(i,"union");for(var c=0;c<g.length;c++){var d;var b=g[c].getAttributeNode("name").value;d=g[c].getAttributeNode("include").value.split(" ");var f=this.flattenUnionTypes(d);var e=" "+f.join(" ")+" ";d=g[c].getAttributeNode("exclude");if(d){d=k.value.split(" ");var k=this.flattenUnionTypes(d);for(var j=0;j<k.length;j++){e=e.replace(new RegExp(" "+k[j]+" ")," ")}}e=e.substring(1,e.length-1);this.unionList[b]=e.split(" ")}this.unionList.any=this.unionList.anySimple.concat(this.unionList.anyElement,this.unionList.anyComponent)},flattenUnionTypes:function(e){var c=[];for(var f=0;f<e.length;f++){if(this.unionList[e[f]]!=null){var b=this.unionList[e[f]];for(var d=0;d<b.length;d++){c.push(b[d])}}else{c.push(e[f])}}return c},importComponentStructs:function(c){xtiger.cross.log("info","imports template component structures to target document");for(var b in this.componentLib){this.componentLib[b].importStructTo(c)}},transform:function(b,c){this.curDoc=c;this.transformer.prepareForIteration(this,c,this.headLabel);this.transformIter(b);this.transformer.finishTransformation(b)},transformIter:function(b){if(b.nodeType==xtdom.ELEMENT_NODE){var c=xtdom.getNodeTypeXT(b);if(xtiger.COMPONENT==c){this.changeComponent(b)}else{this.transformer.saveContext(b);switch(c){case xtiger.USE:this.changeUse(b);break;case xtiger.REPEAT:this.changeRepeat(b);break;case xtiger.ATTRIBUTE:this.changeAttribute(b);break;case xtiger.BAG:this.changeBag(b);break;case xtiger.SERVICE:this.changeService(b);break;default:this.continueWithChildOf(b)}this.transformer.restoreContext(b)}}},continueWithChildOf:function(b){var d=new Array();for(var c=0;c<b.childNodes.length;c++){if(xtdom.containsXT(b.childNodes[c])){d.push(b.childNodes[c])}}this.transformItems(d)},transformItems:function(b){if(b.length==0){return}var d;if(b[0]=="OPAQUE"){b.shift();var c=this.transformer.popContext();while(d=b.shift()){this.transformer.saveContext(d,true);this.transformIter(this.transformer.getNodeFromOpaqueContext(d));this.transformer.restoreContext(d,true)}this.transformer.pushContext(c)}else{while(d=b.shift()){this.transformIter(d)}}},changeComponent:function(c){var d=[];var b=xtdom.createElement(this.curDoc,"div");this.transformer.genComponentBody(c,b);this.transformer.genComponentContent(c,b,d);this.transformItems(d);this.transformer.finishComponentGeneration(c,b);xtdom.replaceNodeByChildOf(c,b)},changeRepeat:function(c){var d=[];var b=xtdom.createElement(this.curDoc,"div");this.transformer.genRepeatBody(c,b,d);this.transformer.genRepeatContent(c,b,d);this.transformItems(d);this.transformer.finishRepeatGeneration(c,b);xtdom.replaceNodeByChildOf(c,b)},changeUse:function(c){var f=[];var b=xtdom.createElement(this.curDoc,"div");var e=c.getAttribute("option")||"use";var d=c.getAttribute("types").split(" ");d=this.flattenUnionTypes(d);this.transformer.genIteratedTypeBody(e,c,b,d);this.transformer.genIteratedTypeContent(e,c,b,f,d);this.transformItems(f);this.transformer.finishIteratedTypeGeneration(e,c,b,d);xtdom.replaceNodeByChildOf(c,b)},changeAttribute:function(c){var f=null;var b=xtdom.createElement(this.curDoc,"div");var e="attribute";var d=[c.getAttribute("types")||c.getAttribute("type")];this.transformer.genIteratedTypeBody(e,c,b,d);this.transformer.genIteratedTypeContent(e,c,b,f,d);this.transformer.finishIteratedTypeGeneration(e,c,b,d);xtdom.replaceNodeByChildOf(c,b)},changeBag:function(d){var c=xtdom.createElement(this.curDoc,"span");xtdom.addClassName(c,"axel-generator-error");var b=xtdom.createTextNode(this.curDoc,"! unsupported Bag element !");c.appendChild(b);d.parentNode.insertBefore(c,d,true);d.parentNode.removeChild(d)},changeService:function(d){var b=xtiger.factory("service");if(b){var c=xtdom.createElement(this.curDoc,"div");var e=b.createModel(c,d,this.curDoc);e.xttService=b.createServiceFromTree(e,d,this.curDoc);xtdom.replaceNodeByChildOf(d,c)}else{xtiger.cross.log("warning",'Missing "service" factory - services will not be generated !')}}};xtiger.util.Form=function(b){this.baseUrl=b;this.doTab=false;this.loader=this.serializer=null};xtiger.util.Form.prototype={_report:function(b,d,c){this.status=b;this.msg=d;if(c&&(0==this.status)){c.logError(d)}},setLoader:function(b){this.loader=b},setSerializer:function(b){this.serializer=b},enableTabGroupNavigation:function(){this.doTab=true},setTemplateSource:function(c){this.srcDoc=c;this.srcForm=null;if(c){var b=c.getElementsByTagName("body");if(b&&(b.length>0)){this.srcForm=b[0]}else{try{c.setProperty("SelectionNamespaces","xmlns:xhtml='http://www.w3.org/1999/xhtml'");this.srcForm=c.selectSingleNode("//xhtml:body")}catch(d){}}if(!this.srcForm){alert("Could not get <body> element from the template to transform !")}this.curDoc=c;this.targetContainerId=false}else{alert("The document containing the template is null or undefined !")}},setTargetDocument:function(d,c,b){this.curDoc=d;this.targetContainerId=c;this.doEmptyTarget=b},transform:function(b){if(!this.srcForm){this._report(0,"no template to transform",b);return false}this.editor=new xtiger.editor.Generator(this.baseUrl);this.parser=new xtiger.parser.Iterator(this.srcDoc,this.editor);if(this.targetContainerId){var e=this.curDoc.getElementById(this.targetContainerId);if(e){if(this.doEmptyTarget){xtdom.removeChildrenOf(e)}xtdom.importChildOfInto(this.curDoc,this.srcForm,e);this.root=e}else{this._report(0,'transformation aborted because target container "'+this.targetContainerId+'" not found in target document',b);return false}this.parser.importComponentStructs(this.curDoc)}else{this.root=this.srcForm}var d=xtiger.session(this.curDoc).load("keyboard");if(!d){d=new xtiger.editor.Keyboard();xtiger.session(this.curDoc).save("keyboard",d);if(this.doTab){var c=new xtiger.editor.TabGroupManager(this.root);d.setTabGroupManager(c);xtiger.session(this.curDoc).save("tabgroupmgr",c)}}xtiger.session(this.curDoc).save("form",this);this.parser.transform(this.root,this.curDoc);this._report(1,"document transformed",b);return(this.status==1)},getEditor:function(){return this.editor},getRoot:function(){return this.root},injectStyleSheet:function(c,b){var d=this.curDoc?this.curDoc.getElementsByTagName("head")[0]:null;if(d){var e=document.createElement("link");e.setAttribute("rel","stylesheet");e.setAttribute("type","text/css");e.setAttribute("href",c);d.appendChild(e);this._report(1,"stylesheet injected",b)}else{this._report(0,"cannot inject editor's style sheet because target document has no head section",b)}return(this.status==1)},loadData:function(c,b){if(c.hasData()){this.editor.loadData(this.root,c,this.loader);this._report(1,"data loaded",b)}else{this._report(0,"data source empty",b)}return(this.status==1)},loadDataFromString:function(d,b){var c=new xtiger.util.DOMDataSource();if(c.initFromString(d)){this.loadData(c,b)}else{this._report(0,"failed to parse string data source",b)}return(this.status==1)},loadDataFromUrl:function(c,b){var f,e;var d=false;f=xtiger.cross.loadDocument(c,b);if(f){d=this.loadData(new xtiger.util.DOMDataSource(f),b)}return d},serializeData:function(b){this.editor.serializeData(this.root,b,this.serializer)},loadDataFromFile:function(c,g,b){try{g.open("GET",c,false);g.send(null);if((g.status==200)||(g.status==0)){if(g.responseXML){this.loadData(new xtiger.util.DOMDataSource(g.responseXML),b)}else{var d=g.responseText;d=d.replace(/^<\?xml\s+version\s*=\s*(["'])[^\1]+\1[^?]*\?>/,"");xtiger.cross.log("warning","attempt to use string parser on "+c+" instead of responseXML");if(!dataSource.initFromString(d)){this._report(0,"failed to create data source for data from file "+c+". Most probably no documentElement",b)}}}else{this._report(0,"failed to load XML data from file "+c+". XHR status : "+g.status,b)}}catch(f){this._report(0,"failed to open XML data file "+c+". Exception : "+f.name+"/"+f.message,b)}return(this.status==1)},postDataToUrl:function(c,i,b){var d=new xtiger.util.DOMLogger();var f=this.editor.serializeData(this.root,d,this.serializer);d.close();try{i.open("POST",c,false);i.setRequestHeader("Content-Type","application/xml; charset=UTF-8");i.send(d.dump("*"));if(i.readyState==4){if((i.status==200)||(i.status==201)||(i.status==0)){this._report(1,i.responseText,b)}else{this._report(0,"can't post data to \""+c+'". Error : '+i.status,b)}}else{this._report(0,"can't post data to \""+c+'". Error readyState is '+i.readyState,b)}}catch(g){i.abort();this._report(0,"can't post data to \""+c+'". Exception : '+g.name+"/"+g.message,b)}return(this.status==1)},saveDataToFile:function(b,j){if(xtiger.cross.UA.gecko){try{netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect")}catch(g){this._report(0,'Permission to save data to file "'+b+'" was denied. Exception : '+g.name+"/"+g.message,j);return false}try{var d=new xtiger.util.DOMLogger();var f=this.editor.serializeData(this.root,d,this.serializer);d.close();var c=Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);c.initWithPath(b);if(c.exists()==false){c.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE,420)}var i=Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);i.init(c,4|8|32,420,0);var m=Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);m.charset="UTF-8";var k=m.ConvertFromUnicode(d.dump("*"));var l=i.write(k,k.length);i.close();this._report(1,'Data saved to "'+b+'"',j)}catch(g){this._report(0,'Cannot save data to file "'+b+'". Exception : '+g.name+"/"+g.message,j)}}else{this.postDataToUrl(b,xtiger.cross.getXHRObject())}return(this.status==1)}};xtiger.editor.Plugin=function(){};xtiger.editor.Plugin.prototype={pluginEditors:{},getEditorFor:function(e,c){var b;if(c.length==1){var f=e.getAttribute("wrapper");var d=(f)?"string":c[0];b=this.pluginEditors[d]}return b},hasEditorFor:function(e,b){var c;if(this.pluginEditors[b]){c=true}else{var f=e.getAttribute("wrapper");var d=(f)?"string":b;c=(this.pluginEditors[d]!=undefined)}return c}};xtiger.editor.Generator=function(b){if(b){xtiger.resources.setBase(b)}this.plugins=new xtiger.editor.Plugin()};xtiger.editor.LABEL_MARK=0;xtiger.editor.REPEAT_MARK=1;xtiger.editor.CHOICE_MARK=2;xtiger.editor.Generator.prototype={markerNames:["xttOpenLabel","xttCloseLabel","startRepeatedItem","endRepeatedItem","beginChoiceItem","endChoiceItem"],isBoundarySafe:function(c){if(!c){alert("Empty node in transformation, the template may contain XHTML errors, please correct it !");return false}if(xtiger.cross.UA.IE&&(c.nodeType!=xtdom.ELEMENT_NODE)){return false}for(var b=0;b<this.markerNames.length;b++){if(c[this.markerNames[b]]){return false}}if((c.nodeType==xtdom.ELEMENT_NODE)&&(c.nodeName.search("menu-marker")!=-1)){return false}return true},verifyBoundaries:function(c,e){var d;if(!this.isBoundarySafe(c.firstChild)){d=xtdom.createElement(this.curDoc,"span");xtdom.addClassName(d,"axel-core-boundary")}if(!this.isBoundarySafe(c.lastChild)){var b=xtdom.createElement(this.curDoc,"span");xtdom.addClassName(b,"axel-core-boundary");c.appendChild(b)}if(d){c.insertBefore(d,c.firstChild)}},getNodeFromOpaqueContext:function(b){xtiger.cross.log("warning",'unexpected call to "getNodeFromOpaqueContext" in "generator.js"');return b},saveContext:function(b,c){if(xtdom.isUseXT(b)||xtdom.isBagXT(b)){this.context.push(b)}},restoreContext:function(b){if(xtdom.isUseXT(b)||xtdom.isBagXT(b)){this.context.pop()}},pushContext:function(b){this.context.push(b)},popContext:function(){return this.context.pop()},savePendingEditor:function(b,d){var c=this.popContext();this.pushContext([c,[b,d]])},getPendingEditor:function(){if(this.context.length>0){var b=this.context[this.context.length-1];if(b instanceof Array){return b[1]}}return false},peekTopContext:function(){var b=this.context[this.context.length-1];return(b instanceof Array?b[0]:b)},coupleWithIterator:function(c){this.iterator=c;var b=new Array("string","number","boolean");c.defineUnion("anySimple",b)},prepareForIteration:function(c,d,b){this.context=[];this.curDoc=d;this.headLabel=b;if(!d){alert("You must specify a document to prepareForIteration !")}},genComponentBody:function(c,b){},genComponentContent:function(c,b,d){xtdom.moveChildOfInto(c,b,d)},finishComponentGeneration:function(j,c){var d=this.getPendingEditor();if(d){var g=d[0];this.verifyBoundaries(c,xtiger.editor.CHOICE_MARK);var b=j.getAttribute("name");g.addChoiceItem(b,c.firstChild,c.lastChild);var l=j.getAttribute("i18n");if(l){var e=d[1];var m=e.getElementsByTagName("option");for(var f=0;f<m.length;f++){var k=m.item(f).firstChild;if(k.data==b){k.data=l;break}}}}},genRepeatBody:function(c,b){},genRepeatContent:function(c,b,d){xtdom.moveChildOfInto(c,b,d)},finishRepeatGeneration:function(c,b){this.verifyBoundaries(b,xtiger.editor.REPEAT_MARK);var d=new xtiger.editor.Repeat();d.initFromTree(b,c,this.curDoc)},genIteratedTypeBody:function(f,q,b,m){if(m.length>1){var d;var v=d=xtdom.createElement(this.curDoc,"select");for(var k=0;k<m.length;k++){var e=xtdom.createElement(this.curDoc,"option");var u=xtdom.createTextNode(this.curDoc,m[k]);e.appendChild(u);v.appendChild(e)}var l;var j=q.getAttribute("param");if(j){var k=j.indexOf("=");if(k!=-1){l=j.substr(k+1,j.length-k-1)}}if(l){var p=xtdom.createElement(this.curDoc,"span");xtdom.addClassName(p,l);var g=xtdom.createElementNS(this.curDoc,"menu-marker",xtiger.parser.nsXTiger);p.appendChild(g);var r=xtdom.createElement(this.curDoc,"br");p.appendChild(r);p.appendChild(d);d=p}b.appendChild(d);var n=new xtiger.editor.Choice();n.initFromTree(v,m,this.curDoc);this.savePendingEditor(n,v);xtdom.addEventListener(v,"change",function(c){n.handleSelect(c)},false);xtiger.cross.log("plant","Created a Choice editor for types /"+m+"/")}},genIteratedTypeContent:function(e,p,c,m,k){var j;if(j=this.plugins.getEditorFor(p,k)){var d=j.createModel(c,p,this.curDoc);var b=(e=="attribute")?p:this.peekTopContext();d.xttPrimitiveEditor=j.createEditorFromTree(d,b,this.curDoc)}else{for(var g=0;g<k.length;g++){var n=this.iterator.getComponentForType(k[g]);if(n){var l=n.getClone(this.curDoc);c.appendChild(l);m.push(l)}else{var o=xtdom.createElement(this.curDoc,"span");xtdom.addClassName(o,"axel-generator-error");var f=xtdom.createTextNode(this.curDoc,'ERROR: "'+k[g]+'" is undeclared or is terminal and part of a choice');o.appendChild(f);c.appendChild(o)}}}},finishIteratedTypeGeneration:function(g,f,b,e){var d=xtdom.getTagNameXT(f);if(!d){return}if(g=="attribute"){d="@"+d}if(!b.firstChild){xtiger.cross.log("warning",'XTiger component (label="'+d+'") definition is empty');return}this.verifyBoundaries(b,xtiger.editor.USE_MARK);xtiger.cross.log("plant","Planting use Start & End labels for "+d);if(b.firstChild.xttOpenLabel){xtiger.cross.log("warning",'use "'+d+'" and use "'+b.firstChild.xttOpenLabel+'" with same START !')}var c=f.getAttribute("flow");if(c){d="!"+c+"!"+d}b.firstChild.xttOpenLabel=d;if(b.lastChild.xttCloseLabel){xtiger.cross.log("warning",'use "'+d+'" and use "'+b.lastChild.xttCloseLabel+'" with same END !')}b.lastChild.xttCloseLabel=d},finishTransformation:function(c){var b=xtiger.cross.makeTreeWalker(c,xtdom.NodeFilter.SHOW_ELEMENT,function(d){return(d.markChoiceEditor)?xtdom.NodeFilter.FILTER_ACCEPT:xtdom.NodeFilter.FILTER_SKIP});while(b.nextNode()){if(b.currentNode.markChoiceEditor){b.currentNode.markChoiceEditor.initializeSelectedItem(0)}}},loadData:function(d,e,b){var c=b||this.defaultLoader;if(c){c.loadData(d,e)}else{alert("Default XML loader missing !")}},serializeData:function(b,c,e){var d=e?e:this.defaultSerializer;if(d){d.serializeData(b,c,this.headLabel)}else{alert("Default XML serializer missing !")}}};xtiger.editor.Repeat=function(){this.items=[];this.curDoc=null;this.originPosition=-1};xtiger.editor.Repeat.autoSelectRepeatIter=function(d){var c;var e=d;var b=0;var f=0;while(e){if(e.startRepeatedItem){b++}if((e!=d)&&e.endRepeatedItem){f++}if(b>f){c=e.startRepeatedItem;if((0==c.min)&&(0==c.total)){c.unsetOption()}e=c.getFirstNodeForSlice(0);b=f=0}e=e.previousSibling}if(d.parentNode){xtiger.editor.Repeat.autoSelectRepeatIter(d.parentNode)}};xtiger.editor.Repeat.prototype={trash:[],hasLabel:function(){return(this.label!="repeat")},getRepeatableLabel:function(){return this.pseudoLabel},dump:function(){return this.label},getSize:function(){return this.total},getOriginPosition:function(){return this.originPosition},getLastNodeForSlice:function(b){var c=(b<this.items.length)?b:this.items.length-1;return this.items[c][1]},getFirstNodeForSlice:function(c,b){var d;if(c<this.items.length){d=c}else{if(b&&(c==this.items.length)){this.appendSlice()}d=this.items.length-1}return this.items[d][0]},getSliceIndexForStartMarker:function(c){for(var b=0;b<this.items.length;b++){if(this.items[b][0]==c){return b}}return -1},makeSeed:function(c,e){if(this==c){xtiger.cross.log("clone-trace","*repeater* do not replicate top/master repeater",this.seed[3])}else{if(this.seed){if(this.seed[0]==-2){var b=e[this.seed[3]];if(!b){var d=xtdom.genId();xtiger.cross.log("clone-trace","*repeater* remaps a non top/master repeater",d);b=[-1,this.seed[1],this.seed[2],d,this.min,this.max,this.pseudoLabel];e[this.seed[3]]=b}return b}else{xtiger.cross.log("debug","*repeater* [should not happen] seed "+this.seed[3]+" already mapped as "+this.seed[0])}}else{var d=xtdom.genId();xtiger.cross.log("debug","*repeater*  [should not happen] making a entirely repeater seed",d);this.seed=[-1,c.label,c.model,d,this.min,this.max,this.pseudoLabel]}}return this.seed},initFromSeed:function(c,b){this.curDoc=b;this.label=c[1];this.model=c[2];this.min=c[4];this.max=c[5];this.pseudoLabel=c[6];this.total=(this.min>0)?1:0;this.items=[[null,null,null,null]]},setStartItem:function(b){this.items[0][0]=b},setEndItem:function(b){this.items[0][1]=b},setMarkItem:function(b){if(this.items[0][2]){this.items[0][3]=b}else{this.items[0][2]=b}var c=this;xtdom.addEventListener(b,"click",function(d){c.handleRepeat(d)},true);xtiger.cross.log("iter-trace","setMarkItem for repeater "+this.dump()+" on node "+b.tagName)},configureMenuForSlice:function(c){if(c>=this.items.length){xtiger.cross.log("error","Wrong menu configuration in repeater "+this.dump());return}var d=this.items[c][2];var e=this.items[c][3];var f=xtiger.bundles.repeat.checkedIconURL;if(0==this.min){if(0==this.total){f=xtiger.bundles.repeat.uncheckedIconURL}else{if(1==this.total){f=xtiger.bundles.repeat.checkedIconURL}else{f=xtiger.bundles.repeat.minusIconURL}}}else{if(this.total==this.min){f=xtiger.bundles.repeat.plusIconURL}else{f=xtiger.bundles.repeat.minusIconURL}}xtdom.setAttribute(d,"src",f);xtdom.setAttribute(e,"src",xtiger.bundles.repeat.plusIconURL);var b=false;if(0==this.min){if(((this.max>1)||(-1==this.max))&&(this.total>0)){b=true}}else{if((this.total>1)&&((this.max>1)||(-1==this.max))){b=true}}if(b){xtdom.removeClassName(e,"axel-core-off")}else{xtdom.addClassName(e,"axel-core-off")}},initFromTree:function(e,k,m){this.curDoc=m;this.label=k.getAttribute("label")||"repeat";this.pseudoLabel=k.getAttribute("pseudoLabel")||"repeat";var g=k.getAttribute("minOccurs")||0;this.min=isNaN(g)?1:parseInt(g);g=k.getAttribute("maxOccurs")||-1;this.max=isNaN(g)?-1:parseInt(g);this.total=(this.min>0)?1:0;xtiger.cross.log("plant","Create Repeat Editor "+this.min+"/"+this.max+"/"+this.label);var j=xtdom.createElement(this.curDoc,"img");var f="16";var i;if(i=xtdom.getMenuMarkerXT(e)){i.parentNode.replaceChild(j,i);f=i.getAttribute("size")||f}else{var d=0;var n=e.firstChild;while(n){if(n.nodeType==xtdom.ELEMENT_NODE){var c=n.className;if(c&&(-1!=c.indexOf("xtt-auto-wrapped"))){if(d==0){i=n}d++}}n=n.nextSibling}if(d==1){i.appendChild(j)}else{e.appendChild(j)}}xtdom.setAttribute(j,"width",f);xtdom.addClassName(j,"axel-repeat-right");var b=xtdom.createElement(this.curDoc,"img");xtdom.setAttribute(b,"width",f);xtdom.addClassName(b,"axel-repeat-left");j.parentNode.insertBefore(b,j,false);start=e.firstChild;end=e.lastChild;if(start.startRepeatedItem){xtiger.cross.log("warning",'Repeat "'+this.label+'" and repeat "'+start.startRepeatedItem.label+'" with same START boundaries !')}start.startRepeatedItem=this;if(end.endRepeatedItem){xtiger.cross.log("warning",'Repeat "'+this.label+'" and repeat "'+end.endRepeatedItem.label+'" with same END boundaries !')}end.endRepeatedItem=this;b.markRepeatedEditor=this;j.markRepeatedEditor=this;if(start.xttOpenLabel){xtiger.cross.log("warning",'Repeat "'+this.label+'" and use with same START boundaries !')}if(end.xttCloseLabel){xtiger.cross.log("warning",'Repeat "'+this.label+'" and use with same END boundaries !')}var l=this;xtdom.addEventListener(b,"click",function(o){l.handleRepeat(o)},true);xtdom.addEventListener(j,"click",function(o){l.handleRepeat(o)},true);this.model=this.shallowClone(e);this.items.push([start,end,b,j]);this.configureMenuForSlice(0);if(0==this.min){this.unactivateSliceAt(0)}},shallowFinishCloning:function(d,b,c){if(b.xttOpenLabel){d.xttOpenLabel=b.xttOpenLabel}if(b.xttCloseLabel){d.xttCloseLabel=b.xttCloseLabel}if(b.markRepeatedEditor){d.markRepeatedEditor=b.markRepeatedEditor.makeSeed(this,c)}if(b.startRepeatedItem){d.startRepeatedItem=b.startRepeatedItem.makeSeed(this,c)}if(b.endRepeatedItem){d.endRepeatedItem=b.endRepeatedItem.makeSeed(this,c)}if(b.markChoiceEditor){d.markChoiceEditor=b.markChoiceEditor.makeSeed()}if(b.beginChoiceItem){d.beginChoiceItem=b.beginChoiceItem.makeSeed()}if(b.endChoiceItem){d.endChoiceItem=b.endChoiceItem.makeSeed()}if(b.xttPrimitiveEditor){d.xttPrimitiveEditor=b.xttPrimitiveEditor.makeSeed()}if(b.xttService){d.xttService=b.xttService.makeSeed()}},shallowClone:function(c){var e={};var d=xtdom.cloneNode(this.curDoc,c,false);this.seed=[-2,this.label,d,xtdom.genId(),this.min,this.max,this.pseudoLabel];this.shallowFinishCloning(d,c,e);for(var b=0;b<c.childNodes.length;b++){this.shallowCloneIter(d,c.childNodes[b],e)}return d},shallowCloneIter:function(c,d,f){var e=xtdom.cloneNode(this.curDoc,d,false);this.shallowFinishCloning(e,d,f);c.appendChild(e);for(var b=0;b<d.childNodes.length;b++){this.shallowCloneIter(e,d.childNodes[b],f)}},getChoiceEditorClone:function(d,c){var b=d[c];if(!b){var b=new xtiger.editor.Choice();b.initFromSeed(c,this.curDoc);d[c]=b}return b},getRepeatEditorClone:function(d,c){var b=d[c[3]];if(!b){var b=new xtiger.editor.Repeat();b.initFromSeed(c,this.curDoc);d[c[3]]=b;xtiger.cross.log("stack-trace","cloning repeat editor",b.dump(),"("+c[3]+")")}return b},deepFinishCloning:function(i,c,k,b,j){if(c.xttOpenLabel){i.xttOpenLabel=c.xttOpenLabel}if(c.xttCloseLabel){i.xttCloseLabel=c.xttCloseLabel}if(c.startRepeatedItem){if(c.startRepeatedItem[0]==-1){var d=this.getRepeatEditorClone(k[0],c.startRepeatedItem);d.setStartItem(i);i.startRepeatedItem=d}else{i.startRepeatedItem=this;j[0]=i}}if(c.endRepeatedItem){if(c.endRepeatedItem[0]==-1){var d=this.getRepeatEditorClone(k[0],c.endRepeatedItem);d.setEndItem(i);i.endRepeatedItem=d}else{i.endRepeatedItem=this;j[1]=i}}if(c.markRepeatedEditor){if(c.markRepeatedEditor[0]==-1){var d=this.getRepeatEditorClone(k[0],c.markRepeatedEditor);d.setMarkItem(i);i.markRepeatedEditor=d}else{i.markRepeatedEditor=this;var g=this;xtdom.addEventListener(i,"click",function(l){g.handleRepeat(l)},true);if(j[2]){j[3]=i}else{j[2]=i}}}if(c.markChoiceEditor){var d=this.getChoiceEditorClone(k[1],c.markChoiceEditor);d.setChoiceMenu(i);i.markChoiceEditor=d}if(c.beginChoiceItem){var d=this.getChoiceEditorClone(k[1],c.beginChoiceItem);d.setBeginChoiceItem(i);i.beginChoiceItem=d}if(c.endChoiceItem){var d=this.getChoiceEditorClone(k[1],c.endChoiceItem);d.setEndChoiceItem(i);i.endChoiceItem=d}if(c.xttPrimitiveEditor){var f=c.xttPrimitiveEditor;var e=f[0];i.xttPrimitiveEditor=e.createEditorFromSeed(f,i,this.curDoc,this)}if(c.xttService){var f=c.xttService;var e=f[0];i.xttService=e.createServiceFromSeed(f,i,this.curDoc,this)}},deepClone:function(c,e){var f=xtdom.cloneNode(this.curDoc,c,false);var d=[{},{}];this.deepFinishCloning(f,c,d,this,e);for(var b=0;b<c.childNodes.length;b++){this.deepCloneIter(f,c.childNodes[b],d,this,e)}return f},deepCloneIter:function(c,d,f,e,g){if(d.xttPrimitiveEditor){var j=xtdom.cloneNode(this.curDoc,d,true);c.appendChild(j);this.deepFinishCloning(j,d,f,e,g);return}var j=xtdom.cloneNode(this.curDoc,d,false);c.appendChild(j);this.deepFinishCloning(j,d,f,e,g);for(var b=0;b<d.childNodes.length;b++){this.deepCloneIter(j,d.childNodes[b],f,e,g)}},getOneCopy:function(c,b){return this.deepClone(this.model,c)},reset:function(){var c=this.min+1;for(var b=c;b<this.total;b++){this.removeItemAtIndex(b,false)}this.total=this.min;this.configureMenuForSlice(0)},plantSlice:function(c,b){if(this.items.length==1){xtdom.removeClassName(this.items[0][2],"axel-core-off")}this.items.splice(b+1,0,c)},sliceLoaded:function(){this.total++;if((0==this.min)&&(1==this.total)){this.activateSliceAt(0)}if(((0==this.min)&&(2==this.total))||((this.min>0)&&(this.total==(this.min+1)))){for(var b=0;b<=this.min;b++){this.configureMenuForSlice(b)}}this.configureMenuForSlice(this.total-1)},appendSlice:function(){var e=this.items.length-1;var c=this.getLastNodeForSlice(e);var b=[null,null,null,null];this.originPosition=-1;var d=this.getOneCopy(b);xtdom.moveChildrenOfAfter(d,c);this.plantSlice(b,e);this.dispatchEvent(b,"duplicate");return e+1},handleRepeat:function(d){var c=false;var e=xtdom.getEventTarget(d);for(var b=0;b<this.items.length;b++){if(this.items[b][2]==e){if((0==this.min)&&(0==this.total)){this.unsetOption();c=true}else{if((this.min>0)&&(1==this.total)){this.addItem(e,b,d.shiftKey);c=true}else{if((0==this.min)&&(1==this.total)){this.setOption()}else{this.deleteItem(e,b,d.shiftKey)}}}break}else{if(this.items[b][3]==e){this.addItem(e,b,d.shiftKey);c=true;break}}}if(c){xtiger.editor.Repeat.autoSelectRepeatIter(this.getFirstNodeForSlice(0))}},unsetOption:function(){this.total++;this.configureMenuForSlice(0);this.activateSliceAt(0)},activateNodeIter:function(b,c){if((!c)||(c.total>=1)){xtdom.removeClassName(b,"axel-repeat-unset")}},activateSliceAt:function(b){this.mapFuncToSliceAt(xtiger.editor.Repeat.prototype.activateNodeIter,b,false)},setOption:function(){this.total--;this.configureMenuForSlice(0);this.unactivateSliceAt(0)},unactivateNodeIter:function(b,c){xtdom.addClassName(b,"axel-repeat-unset")},unactivateSliceAt:function(b){this.mapFuncToSliceAt(xtiger.editor.Repeat.prototype.unactivateNodeIter,b,true)},callPrimitiveEditors:function(d,b){var c=xtiger.cross.makeTreeWalker(d,xtdom.NodeFilter.SHOW_ELEMENT,function(e){if(e.xttPrimitiveEditor&&e.xttPrimitiveEditor.can(b)){return xtdom.NodeFilter.FILTER_ACCEPT}else{return xtdom.NodeFilter.FILTER_SKIP}});while(c.nextNode()){c.currentNode.xttPrimitiveEditor.execute(b,this)}},dispatchEvent:function(d,b){var c=d[0];do{this.callPrimitiveEditors(c,b);c=c.nextSibling}while(c&&(c!=d[1]))},addItem:function(d,g,j){var l,k,e,c,m,f;var b=this.items[g];if(j){for(f=0;f<this.trash.length;f++){if(this.trash[f][0]==this){l=this.trash[f];break}}}this.originPosition=g;if(l){m=l[2];k=l[1];xtdom.moveNodesAfter(k,b[1]);this.trash.splice(f,1)}else{m=[null,null,null,null];c=this.getOneCopy(m,g);xtdom.moveChildrenOfAfter(c,b[1])}this.originPosition=-1;this.plantSlice(m,g);this.total++;if(0==g){this.configureMenuForSlice(0)}this.configureMenuForSlice(g+1);this.configureMenuForSlice(this.total-1);this.dispatchEvent(m,"duplicate")},deleteItem:function(d,b,c){this.removeItemAtIndex(b,c);if(this.total<=1){this.configureMenuForSlice(0)}else{this.configureMenuForSlice(this.total-1)}},removeItemAtIndex:function(b,d){var g,e;this.originPosition=b;var c=this.items[b];var f=d?[]:null;if(c[0]==c[1]){if(d){f.push(c[0])}this.callPrimitiveEditors(c[0],"remove");c[0].parentNode.removeChild(c[0])}else{this.dispatchEvent(c,"remove");e=c[0].nextSibling;if(d){f.push(c[0])}c[0].parentNode.removeChild(c[0]);while(e&&(e!=c[1])){g=e;e=e.nextSibling;if(d){f.push(g)}c[1].parentNode.removeChild(g)}if(d){f.push(c[1])}c[1].parentNode.removeChild(c[1])}this.originPosition=-1;this.items.splice(b,1);if(d){this.trash.push([this,f,c])}this.total--},mapFuncToSliceAt:function(c,b){var i,g,f,e;var d=0;g=this.items[b];i=g[0];f=null;if(g[0]==g[1]){if(xtdom.ELEMENT_NODE==i.nodeType){c.call(this,i,f)}}else{while(i&&(i!=g[1])){if(i.startRepeatedItem&&(i.startRepeatedItem!=this)){if(f){if(!e){e=[f]}else{e.push(f)}}f=i.startRepeatedItem;if(i.endRepeatedItem&&(i.endRepeatedItem==i.startRepeatedItem)){if(!e){e=[f]}else{e.push(f)}}}if(i.endRepeatedItem&&(i.endRepeatedItem!=this)){if(e&&(e.length>0)){f=e.pop()}else{f=null}}if(xtdom.ELEMENT_NODE==i.nodeType){c.call(this,i,f)}i=i.nextSibling}}}};xtiger.resources.addBundle("repeat",{plusIconURL:"plus.png",minusIconURL:"minus.png",uncheckedIconURL:"unchecked.png",checkedIconURL:"checked.png"});xtiger.editor.Choice=function(){this.items=[];this.curItem=-1;this.curDoc=null};xtiger.editor.Choice.prototype={initFromTree:function(d,b,c){this.curDoc=c;this.menu=d;d.markChoiceEditor=this;this.types=b},getTypes:function(){return this.types},getSelectedChoiceName:function(){return this.types[this.curItem]},makeSeed:function(){if(!this.seed){this.seed=[this.items.length,this.types]}return this.seed},initFromSeed:function(b,c){this.curDoc=c;this.expectedLength=b[0];this.types=b[1]},setChoiceMenu:function(c){this.menu=c;var b=this;xtdom.addEventListener(c,"change",function(d){b.handleSelect(d)},false)},setBeginChoiceItem:function(b){this.items.push([b,null])},setEndChoiceItem:function(b){this.items[this.items.length-1][1]=b;if(this.items.length==this.expectedLength){xtiger.cross.log("stack-trace","Choice initialization terminated after cloning, size="+this.expectedLength);this.initializeSelectedItem(0)}},addChoiceItem:function(c,d,b){this.items.push([d,b]);if(d.beginChoiceItem){xtiger.cross.log("warning","Choice <",c,"> ends with an already existing choice")}if(b.endChoiceItem){xtiger.cross.log("warning","Choice <",c,"> ends with an already existing choice end")}d.beginChoiceItem=this;b.endChoiceItem=this},initializeSelectedItem:function(j){for(var d=0;d<this.items.length;d++){var c=[];var f=this.items[d];var e=f[0];var b=f[1];var g=e;c.push(xtdom.getInlineDisplay(g));if(d!=j){if(g.nodeType==xtdom.ELEMENT_NODE){g.style.display="none"}}while(g!=b){g=g.nextSibling;c.push(xtdom.getInlineDisplay(g));if(d!=j){if(g.nodeType==xtdom.ELEMENT_NODE){g.style.display="none"}}}f.push(c)}this.curItem=j},selectChoiceItem:function(j){xtiger.cross.log("plant","Choice.selectChoiceItem "+j);if(this.curItem==j){return}if(this.curItem!=-1){var f=this.items[this.curItem];var e=f[0];var b=f[1];var c=[];var g=e;c.push(xtdom.getInlineDisplay(g));if(g.nodeType==xtdom.ELEMENT_NODE){g.style.display="none"}while(g!=b){g=g.nextSibling;c.push(xtdom.getInlineDisplay(g));if(g.nodeType==xtdom.ELEMENT_NODE){g.style.display="none"}}f[2]=c}var f=this.items[j];var e=f[0];var b=f[1];var c=f[2];var d=0;var g=e;if(g.nodeType==xtdom.ELEMENT_NODE){g.style.display=c[d]}while(g!=b){d++;g=g.nextSibling;if(g.nodeType==xtdom.ELEMENT_NODE){g.style.display=c[d]}}this.curItem=j},selectChoiceForName:function(b){xtiger.cross.log("plant","Choice.selectChoiceForName "+b);var c;for(c=0;c<this.types.length;c++){if(this.types[c]==b){break}}if(c!=this.types.length){this.selectChoiceItem(c);xtdom.setSelectedOpt(this.menu,c);return c}else{return this.curItem}},handleSelect:function(c){var b=xtdom.getSelectedOpt(this.menu);this.selectChoiceItem(b)}};xtiger.editor.Keyboard=function(){this.tabGroupManager=false;this.currentDevice=false;this.allowRC=false};xtiger.editor.Keyboard.prototype={setTabGroupManager:function(b){this.tabGroupManager=b},register:function(d,e){var b=e?e:d.getHandle();var g=this;var f=d;var c={keydown:function(i){g.handleKeyDown(i,f)},keyup:function(i){g.handleKeyUp(i,f)}};xtdom.addEventListener(b,"keydown",c.keydown,false);xtdom.addEventListener(b,"keyup",c.keyup,false);return c},unregister:function(d,c,e){var b=e?e:d.getHandle();xtdom.removeEventListener(b,"keydown",c.keydown,false);xtdom.removeEventListener(b,"keyup",c.keyup,false)},handleKeyDown:function(c,b){if(b.isEditing()){if(this.tabGroupManager){this.tabGroupManager.filterKeyDown(c)}var d=(this.allowRC&&(c.keyCode==13)&&(!c.shiftKey))||((!this.allowRC)&&(c.keyCode==13));if(d){b.stopEditing(false)}else{if(c.keyCode==27){b.cancelEditing()}}b.doKeyDown(c)}},handleKeyUp:function(c,b){if(b.isEditing()){if(this.tabGroupManager&&this.tabGroupManager.filterKeyPress(c)){xtdom.preventDefault(c);xtdom.stopPropagation(c)}else{b.doKeyUp(c)}}},grab:function(c,b){if(this.tabGroupManager){this.tabGroupManager.startEditingSession(b)}},release:function(c,b){if(this.tabGroupManager){this.tabGroupManager.stopEditingSession()}},enableRC:function(){this.allowRC=true},disableRC:function(){this.allowRC=false}};xtiger.editor.TabGroupManager=function(b){this.root=b;this.isChangingFocus=false;this.direction=0};xtiger.editor.TabGroupManager.prototype={startEditingSession:function(b){if(this.isChangingFocus){return}this.tabs=[];var c=xtiger.cross.makeTreeWalker(this.root,xtdom.NodeFilter.SHOW_ELEMENT,function(d){if(d.xttPrimitiveEditor&&d.xttPrimitiveEditor.isFocusable()){return xtdom.NodeFilter.FILTER_ACCEPT}else{return xtdom.NodeFilter.FILTER_SKIP}});while(c.nextNode()){this.tabs.push(c.currentNode.xttPrimitiveEditor)}this.curEditor=b},stopEditingSession:function(){if(this.isChangingFocus){return}this.tabs=undefined;this.curEditor=undefined},filterKeyDown:function(b){this.direction=0;if(b.keyCode==9){if(xtiger.cross.UA.gecko){this.direction=b.shiftKey?-1:1}else{this._focusNextInput(b.shiftKey?-1:1)}try{xtdom.preventDefault(b);xtdom.stopPropagation(b)}catch(c){}return true}else{return false}},filterKeyPress:function(b){if(xtiger.cross.UA.gecko&&(this.direction!=0)){return(this._focusNextInput(this.direction))}return false},_focusNextInput:function(e){var c=false;if(!this.tabs){return}for(var b=0;b<this.tabs.length;b++){if(this.tabs[b]==this.curEditor){break}}if(b<this.tabs.length){var d;if((b+e)<0){d=this.tabs.length-1}else{d=(b+e)%this.tabs.length}this.isChangingFocus=true;this.tabs[b].unfocus();this.tabs[d].focus();this.isChangingFocus=false;this.curEditor=this.tabs[d];c=true}this.direction=0;return c}};xtiger.editor.StringModel=function(){};xtiger.editor.StringModel.prototype={createModel:function(c,i,f){var b=i.getAttribute("wrapper");var n=xtdom.createElement(f,"span");var j=xtdom.createTextNode(f,"");var l=xtdom.createElement(f,"input");n.appendChild(j);xtdom.addClassName(n,"axel-core-on");xtdom.addClassName(n,"axel-core-editable");xtdom.addClassName(l,"axel-core-off");var e=b&&("embedded"!=b);if(e){var m=b;if("auto"==b){m=i.getAttribute("types")}var k=xtdom.createElement(f,m);if("auto"==b){xtdom.addClassName(k,"xtt-auto-wrapped")}k.appendChild(n);k.appendChild(l);c.appendChild(k)}else{c.appendChild(n);c.appendChild(l)}var g=i.getAttribute("option");if(g){var d=xtdom.createElement(f,"input");xtdom.setAttribute(d,"type","checkbox");xtdom.addClassName(d,"axel-option-checkbox");n.parentNode.insertBefore(d,n)}return l},createEditorFromTree:function(e,c,d){var g=xtdom.extractDefaultContentXT(c);if(g){if(g.search(/\S/)==-1){g=null}else{var b=g.match(/^\s*\<.*\>(.*?)\<\/\w*\>\s*$/);if(b){g=b[1]}}}var i=c.getAttribute("param");var f=new xtiger.editor.String();f.initFromTree(e,d,g,i,c.getAttribute("option")||false);return f},createEditorFromSeed:function(b,e,c){var d=new xtiger.editor.String();d.initFromSeed(b,e,c);return d}};xtiger.editor.String=function(){this.defaultContent=null;this.param=null;this.isOptional=null;this.isSelected=false;this.doEdit=false;var b=this;this.lostFocusHandler=function(c){b.unfocus()}};xtiger.editor.String.prototype={isEditing:function(){return this.doEdit},startEditing:function(b,d){var c=this.editor.value.length;this.doEdit=true;this.keyboard.grab(this,this);xtdom.setAttribute(this.editor,"size",c+Number(this.param.lookahead));xtdom.replaceClassNameBy(this.handle,"axel-core-on","axel-core-off");xtdom.replaceClassNameBy(this.editor,"axel-core-off","axel-core-on");if(d||(this.editor.value==this.defaultContent)){xtdom.focusAndSelect(this.editor)}else{xtdom.focusAndMoveCaretTo(this.editor,c)}xtdom.addEventListener(this.editor,"blur",this.lostFocusHandler,true)},stopEditing:function(f,e,b){this.doEdit=false;var c=e||this.editor.value;if(c.search(/\S/)==-1){c=this.defaultContent}var d=(c!=this.defaultContent);this.setData(c);xtdom.replaceClassNameBy(this.handle,"axel-core-off","axel-core-on");xtdom.replaceClassNameBy(this.editor,"axel-core-on","axel-core-off");this.keyboard.release(this,this);xtdom.removeEventListener(this.editor,"blur",this.lostFocusHandler,true);if((!b)&&d){if((this.isOptional)&&(!this.isSelected)){this.setSelectionState(true)}xtiger.editor.Repeat.autoSelectRepeatIter(this.getHandle())}if(!d){this.setSelectionState(false)}if(xtiger.cross.UA.IE){this.editor.blur()}},cancelEditing:function(){this.stopEditing(false,this.dump(),true)},doKeyDown:function(b){},doKeyUp:function(b){},getHandle:function(b){return this.editor},decodeParameters:function(c,f){var e=f.split(";");for(var b=0;b<e.length;b++){var d=e[b].split("=");if(d.length==2){c[d[0]]=d[1]}}},initFromTree:function(c,f,b,e,d){this.param={lookahead:2};this.curDoc=f;this.handle=c.previousSibling;this.editor=c;this.defaultContent=b||"click to edit";if(e){this.decodeParameters(this.param,e)}if(d){this.isOptional=d.toLowerCase()}this.awake()},awake:function(){this.keyboard=xtiger.session(this.curDoc).load("keyboard");var c=this;xtdom.addEventListener(this.handle,"click",function(d){c.handleClick(d)},true);this.setData(this.defaultContent);this.editor.defaultValue=this.defaultContent;this.keyboard.register(this);if(this.isOptional){var b=this.handle.previousSibling;xtdom.addEventListener(b,"click",function(d){c.handleSelect(d)},true);this.setSelectionState("set"==this.isOptional)}},makeSeed:function(){if(!this.seed){var b=xtiger.editor.Plugin.prototype.pluginEditors.string;this.seed=[b,this.defaultContent,this.param,this.isOptional]}return this.seed},initFromSeed:function(b,d,c){this.curDoc=c;this.handle=d.previousSibling;this.editor=d;this.defaultContent=b[1];this.param=b[2];this.isOptional=b[3];this.awake()},setSelectionState:function(c){if(this.isOptional){var b=this.handle.previousSibling;this.isSelected=c;b.checked=c;if(c){xtdom.replaceClassNameBy(this.handle,"axel-option-unset","axel-option-set")}else{xtdom.replaceClassNameBy(this.handle,"axel-option-set","axel-option-unset")}}},load:function(b,c){if(b!==-1){var d=c.getDataFor(b);this.setData(d);this.setSelectionState(true)}else{this.setData(this.defaultContent);this.setSelectionState(false)}},save:function(b){if((!this.isOptional)||(this.isSelected)){b.write(this.dump())}else{b.discardNodeIfEmpty()}},dump:function(){return this.handle.firstChild.data},setData:function(c){var b=c?c.replace(/\s+/g," "):"click to edit";this.handle.firstChild.data=b;this.editor.value=b;this.editor.size=b.length},can:function(b){return false},handleClick:function(b){this.startEditing(true,b.shiftKey)},handleSelect:function(b){this.isSelected=this.handle.previousSibling.checked;if(this.isSelected){xtdom.replaceClassNameBy(this.handle,"axel-option-unset","axel-option-set");xtiger.editor.Repeat.autoSelectRepeatIter(this.getHandle())}else{xtdom.replaceClassNameBy(this.handle,"axel-option-set","axel-option-unset")}},isFocusable:function(){return true},focus:function(){this.startEditing(false,false)},unfocus:function(){this.stopEditing(false)}};xtiger.editor.Plugin.prototype.pluginEditors.string=new xtiger.editor.StringModel();xtiger.editor.BasicLoader=function(){};xtiger.editor.BasicLoader.prototype={loadData:function(e,c){var d=c.getRootVector();var b=[d];this.loadDataIter(e,c,b)},hasDataFor:function(d,b,c){var e=false;if(d.hasLabel()){e=(0!=c.lengthFor(b))}else{e=c.hasDataFor(d.getRepeatableLabel(),b)}return e},makeRepeatState:function(d,c,b,e){return[d,c,b,e]},loadDataSlice:function(s,e,l,i,n,u,j){var k=[];var d=s;var o=true;var m;while(d&&o){if(d.startRepeatedItem&&(d.startRepeatedItem!=j)){if((k.length==0)||((k[k.length-1][0])!=d.startRepeatedItem)){var f;if(d.startRepeatedItem.hasLabel()){var q=l.getVectorFor(d.startRepeatedItem.dump(),n);if((q instanceof Array)&&(l.lengthFor(q)>0)){i.push(q);n=q;f=this.makeRepeatState(d.startRepeatedItem,d.startRepeatedItem.getSize(),true,true)}else{d=d.startRepeatedItem.getLastNodeForSlice(d.startRepeatedItem.getSize());d=d.nextSibling;continue}}else{if(this.hasDataFor(d.startRepeatedItem,n,l)){f=this.makeRepeatState(d.startRepeatedItem,d.startRepeatedItem.getSize(),false,true)}else{d=d.startRepeatedItem.getLastNodeForSlice(d.startRepeatedItem.getSize());d=d.nextSibling;continue}}k.push(f)}}if(d.beginChoiceItem&&(d.beginChoiceItem!=u)){var r=d.beginChoiceItem;n=l.getVectorForAnyOf(r.getTypes(),n);if(n instanceof Array){i.push(n);var t=r.selectChoiceForName(l.nameFor(n));if(r.items[t][0]!=r.items[t][1]){this.loadDataSlice(r.items[t][0],r.items[t][1],l,i,n,r);d=r.items[r.items.length-1][1];if((d.xttCloseLabel&&(!d.xttOpenLabel))&&(t!=(r.items.length-1))){i.pop();n=i[i.length-1]}}else{this.loadDataIter(r.items[t][0],l,i);i.pop();n=i[i.length-1];d=r.items[r.items.length-1][1]}}}else{this.loadDataIter(d,l,i);n=i[i.length-1];if(u){if(d==u.items[u.curItem][1]){i.pop();n=i[i.length-1];return}}}if(d==e){o=false}m=d.nextSibling;if(d.endRepeatedItem&&(d.endRepeatedItem!=j)){var f=k[k.length-1];if(true||(d.endRepeatedItem==f[0])){--(f[1]);if(f[1]<0){if(d.endRepeatedItem.getSize()==0){d.endRepeatedItem.sliceLoaded()}}if(f[1]<=0){if(f[3]&&this.hasDataFor(d.endRepeatedItem,n,l)){var b=d.endRepeatedItem;while(this.hasDataFor(b,n,l)){xtiger.cross.log("stack-trace",">>[ extra ]>> start repetition for",b.dump());var p=[n];var g=b.appendSlice();var s=b.getFirstNodeForSlice(g);var e=b.getLastNodeForSlice(g);this.loadDataSlice(s,e,l,p,n,undefined,b);b.sliceLoaded()}}if(f[2]){i.pop();n=i[i.length-1]}k.pop()}}}d=m}},loadDataIter:function(j,g,e){var f,i;var d=e[e.length-1];if(j.xttOpenLabel){i=j.xttOpenLabel;if(i.charAt(0)=="!"){var c=i.match(/^!(.*?)!(.*)$/);f=c[1];i=c[2];d=g.openFlow(f,d,i)||d}var b=false;if(i.charAt(0)=="@"){d=g.getAttributeFor(i.substr(1,i.length-1),d);b=true}else{d=g.getVectorFor(i,d)}if(b||((d instanceof Array)&&(g.lengthFor(d)>0))){e.push(d)}else{d=-1;e.push(d)}}if(j.xttPrimitiveEditor){j.xttPrimitiveEditor.load(d,g);d=-1}if(j.firstChild){this.loadDataSlice(j.firstChild,j.lastChild,g,e,d)}if(j.xttCloseLabel){i=j.xttCloseLabel;if(i.charAt(0)=="!"){var c=i.match(/^!(.*?)!(.*)$/);f=c[1];i=c[2];g.closeFlow(f,d)}e.pop()}}};xtiger.editor.Generator.prototype.defaultLoader=new xtiger.editor.BasicLoader();xtiger.editor.BasicSerializer=function(b){};xtiger.editor.BasicSerializer.prototype={serializeData:function(d,c,b){c.openTag(b||"document");this.serializeDataIter(d,c);c.closeTag(b||"document")},serializeDataSlice:function(g,d,f,e){var b=[];var j=g;var i=true;while(j&&i){if(j.startRepeatedItem){if((b.length==0)||((b[b.length-1][0])!=j.startRepeatedItem)){if(j.startRepeatedItem.getSize()==0){j=j.startRepeatedItem.getLastNodeForSlice(0);j=j.nextSibling;continue}else{if(j.startRepeatedItem.hasLabel()){f.openTag(j.startRepeatedItem.dump())}}b.push([j.startRepeatedItem,j.startRepeatedItem.getSize()])}}if(j.beginChoiceItem&&(j.beginChoiceItem!=e)){var k=j.beginChoiceItem;f.openTag(k.getSelectedChoiceName());if(k.items[k.curItem][0]!=k.items[k.curItem][1]){this.serializeDataSlice(k.items[k.curItem][0],k.items[k.curItem][1],f,k)}else{this.serializeDataIter(k.items[k.curItem][0],f);f.closeTag(k.getSelectedChoiceName())}j=k.items[k.items.length-1][1];if(j.xttCloseLabel&&(k.curItem!=(k.items.length-1))){f.closeTag(j.xttCloseLabel)}}else{this.serializeDataIter(j,f);if(e){if(j==e.items[e.curItem][1]){f.closeTag(e.getSelectedChoiceName())}}}if(j.endRepeatedItem){if(true||(j.endRepeatedItem==b[b.length-1][0])){--(b[b.length-1][1]);if(b[b.length-1][1]<=0){if((j.endRepeatedItem.getSize()!=0)&&(j.endRepeatedItem.hasLabel())){f.closeTag(j.endRepeatedItem.dump())}b.pop()}}}if(j==d){i=false}j=j.nextSibling}},serializeDataIter:function(f,d){var c,e;if(f.xttOpenLabel){e=f.xttOpenLabel;if(e.charAt(0)=="!"){var b=e.match(/^!(.*?)!(.*)$/);c=b[1];e=b[2];d.openFlow(c,e)}if(e.charAt(0)=="@"){d.openAttribute(e.substr(1,e.length-1))}else{d.openTag(e)}}if(f.xttPrimitiveEditor){f.xttPrimitiveEditor.save(d)}if(f.firstChild){this.serializeDataSlice(f.firstChild,f.lastChild,d)}if(f.xttCloseLabel){c=false;e=f.xttCloseLabel;if(e.charAt(0)=="!"){var b=e.match(/^!(.*?)!(.*)$/);c=b[1];e=b[2]}if(e.charAt(0)=="@"){d.closeAttribute(e.substr(1,e.length-1))}else{d.closeTag(e)}if(c){d.closeFlow(c)}}}};xtiger.editor.Generator.prototype.defaultSerializer=new xtiger.editor.BasicSerializer();(function(){var _TextMetrics=function _TextMetrics(doc){this.div=xtdom.createElement(doc,"div");xtdom.addClassName(this.div,"axel-text-shadowbuffer");this.divText=xtdom.createTextNode(doc,"");this.div.appendChild(this.divText)};_TextMetrics.prototype={setBBox:function setBBox(w,h,handle,shape,type){var wpx=w+"px";var hpx=h+"px";this.lastWidth=w;this.lastHeight=h;if((type=="input")||(shape=="self")){this.div.style.width="";this.div.style.height=""}else{this.div.style.width=wpx;this.div.style.height="auto"}handle.style.width=wpx;handle.style.height=hpx},setText:function setText(text){this.divText.data=text+"m"},adjustWidth:function adjustWidth(handle){var w=Math.max(this.div.offsetWidth,this.div.clientWidth,this.div.scrollWidth);if(w>this.lastWidth){handle.style.width=w-(w%20)+20+"px";this.lastWidth=w}},adjustHeight:function adjustHeight(handle,init){var h=Math.max(this.div.offsetHeight,this.div.clientHeight,this.div.scrollHeight);if(h>this.lastHeight){handle.style.height=h+"px";this.lastHeight=h}},grab:function grab(field){field.hook.appendChild(this.div)},release:function(field,willEditAgain){field.hook.removeChild(this.div)}};xtiger.editor.TextDevice=function(input,kbd,doc){this.keyboard=kbd;this.field=input;this.metrics=xtiger.session(doc).load("metrics");if(!this.metrics){this.metrics=new _TextMetrics(doc);xtiger.session(doc).save("metrics",this.metrics)}this.currentEditor=null;var _this=this;this.blurHandler=function(ev){_this.handleBlur(ev)}};xtiger.editor.TextDevice.prototype={getHandle:function(){return this.field.getHandle()},isEditing:function(){return(null!=this.currentEditor)},_computeOffset:function(mouseEvent,editor){var offset=-1;var selObj,selRange;if(mouseEvent&&window.getSelection&&(editor.getParam("clickthrough")=="true")){selObj=window.getSelection();if(selObj&&(selObj.rangeCount>0)){selRange=selObj.getRangeAt(0);if(selRange){offset=selRange.startOffset}}}return offset},startEditing:function(editor,mouseEvent,doSelectAll){var ghost,offset;var constw,consth;var shape;var redux=false;var handle=this.field.getHandle();var coldStart=false;if(this.currentEditor){this.stopEditing(true)}else{this._kbdHandlers=this.keyboard.register(this);this.keyboard.grab(this,editor);if(editor.getParam("hasClass")){xtdom.addClassName(handle,editor.getParam("hasClass"))}if(!doSelectAll){offset=this._computeOffset(mouseEvent,editor)}coldStart=true;this.field.show(editor)}this.currentEditor=editor;ghost=editor.getGhost();constw=Math.max(ghost.offsetWidth,ghost.clientWidth,ghost.scrollWidth);consth=Math.max(ghost.offsetHeight,ghost.clientHeight,ghost.scrollHeight);this.field.grab(editor);this.metrics.grab(this.field);if(editor.getParam("enablelinebreak")=="true"){this.keyboard.enableRC()}if(doSelectAll){xtdom.focusAndSelect(handle)}else{if(offset){xtdom.focusAndMoveCaretTo(handle,(offset==-1)?handle.value.length:offset)}}shape=this.currentEditor.getParam("shape");if(shape.charAt(shape.length-1)=="x"){var m=shape.match(/\d+/);if(m){constw=constw-parseInt(m[0]);redux=true}}this.metrics.setBBox(constw,consth,handle,shape,this.field.deviceType);this.metrics.setText(this.field.getValue());if((this.field.deviceType=="input")||(shape=="self")){this.metrics.adjustWidth(handle)}if(redux){this.metrics.adjustHeight(handle)}if(coldStart){xtdom.addEventListener(handle,"blur",this.blurHandler,false)}},stopEditing:function(willEditAgain,isCancel){if(!this.currentEditor){return}if(!this.stopInProgress){this.stopInProgress=true;var model=this.currentEditor;this.currentEditor=null;this.field.release(model,willEditAgain);this.metrics.release(this.field);if(!isCancel){model.update(this.field.getValue())}if(!willEditAgain){if(model.getParam("enablelinebreak")=="true"){this.keyboard.disableRC()}this.keyboard.unregister(this,this._kbdHandlers);this.keyboard.release(this,model);xtdom.removeEventListener(this.getHandle(),"blur",this.blurHandler,false);if(model.getParam("hasClass")){xtdom.removeClassName(this.getHandle(),model.getParam("hasClass"))}}this.stopInProgress=false}},getCurrentModel:function(){return this.currentEditor},cancelEditing:function(){this.stopEditing(false,true)},handleBlur:function(ev){this.stopEditing(false)},doKeyDown:function(ev){if(this.currentEditor&&(this.currentEditor.getParam("expansion")=="grow")){this.curLength=this.field.getValue().length;this.adjustShape()}},doKeyUp:function(ev){if(this.currentEditor&&this.currentEditor.can("onkeyup")){this.currentEditor.execute("onkeyup",this.field.getHandle())}if(this.currentEditor&&(this.currentEditor.getParam("expansion")=="grow")){if(this.field.getValue().length>(this.curLength+1)){this.adjustShape()}}},adjustShape:function(){this.metrics.setText(this.field.getValue());var h=this.field.getHandle();this.metrics.adjustWidth(h);if(this.field.deviceType=="textarea"){this.metrics.adjustHeight(h)}}};xtiger.editor.FloatingField=function(kind,doc){this.deviceType=kind;this.handle=this.createHandleForDoc(kind,doc);this.hook=xtdom.createElement(doc,"div");xtdom.addClassName(this.hook,"axel-text-container");this.hook.appendChild(this.handle);this.hook.style.display="none"};xtiger.editor.FloatingField.prototype={createHandleForDoc:function(kind,doc){var device=xtiger.session(doc).load("ff_"+kind);if(!device){device=xtdom.createElement(doc,kind);xtdom.addClassName(device,"axel-text-float");xtiger.session(doc).save("ff_"+kind,device)}return device},getHandle:function(){return this.handle},getValue:function(){return this.handle.value},show:function(){this.hook.style.display="inline"},grab:function(editor){this.handle.value=editor.getData();this.editorHandle=editor.getHandle();this.editorHandle.parentNode.insertBefore(this.hook,this.editorHandle);editor.getHandle().style.visibility="hidden"},release:function(editor,willEditAgain){this.editorHandle.parentNode.removeChild(this.hook);editor.getHandle().style.visibility="visible";if(!willEditAgain){this.hook.style.display="none"}},setPosition:function(ghost){var pos=xtdom.findPos(ghost);with(this.handle.style){left=pos[0]+"px";top=pos[1]+"px"}}};xtiger.editor.PlacedField=function(kind,doc){this.myDoc=doc;this.deviceType=kind;this.handle=this.createHandleForDoc(kind,doc);this.handle.style.display="none";this.cache={};this.hook};xtiger.editor.PlacedField.prototype={createHandleForDoc:function(kind,doc){var device=xtiger.session(doc).load("pf_"+kind);if(!device){device=xtdom.createElement(doc,kind);xtdom.addClassName(device,"axel-text-placed");xtiger.session(doc).save("pf_"+kind,device)}return device},getHandle:function(){return this.handle},getValue:function(){return this.handle.value},show:function(editor){this.handle.style.display="inline"},grab:function(editor){var _htag;this.handle.value=editor.getData();this.editorHandle=editor.getHandle();_htag=xtdom.getLocalName(this.editorHandle);if(!this.cache[_htag]){this.hook=xtdom.createElement(this.myDoc,_htag);this.cache[_htag]=this.hook}else{this.hook=this.cache[_htag]}var parent=this.editorHandle.parentNode;if(this.hook.firstChild!=this.handle){this.hook.appendChild(this.handle)}parent.insertBefore(this.hook,this.editorHandle,true);parent.removeChild(this.editorHandle)},release:function(editor,willEditAgain){var parent=this.hook.parentNode;parent.insertBefore(this.editorHandle,this.hook,true);parent.removeChild(this.hook);if(!willEditAgain){this.handle.style.display="none"}}};xtiger.editor.TextDeviceFactory=function(){this.devKey="TextDeviceCache"};xtiger.editor.TextDeviceFactory.prototype={_getCache:function(doc){var cache=xtiger.session(doc).load(this.devKey);if(!cache){cache={input:{"float":null,placed:null},textarea:{"float":null,placed:null},filtered:{}};xtiger.session(doc).save(this.devKey,cache)}return cache},getInstance:function(doc,type,layout){var t=type||"input";if((t!="input")&&(t!="textarea")){xtiger.cross.log("error","AXEL error : unkown text device type '"+t+"' requested !");t="input"}var l=layout||"placed";if((l!="float")&&(l!="placed")){xtiger.cross.log("error","AXEL error : unkown text device layout '"+l+"' requested !");l="float"}var cache=this._getCache(doc);var fConstructor;var device=cache[t][l];if(!device){var wrapper=(l=="float")?new xtiger.editor.FloatingField(t,doc):new xtiger.editor.PlacedField(t,doc);device=new xtiger.editor.TextDevice(wrapper,xtiger.session(doc).load("keyboard"),doc);if(fConstructor){device.addFilter(fConstructor(doc))}cache[t][l]=device}return device}};xtiger.registry.registerFactory("text-device",new xtiger.editor.TextDeviceFactory())})();xtiger.editor.PopupDevice=function(b){this._document=b;this._menu=xtiger.session(b).load("popupmenu");if(!this._menu){this._menu=new xtiger.editor.PopupMenu(b);xtiger.session(b).save("popupmenu",this._menu)}this._keyboard=xtiger.session(b).load("keyboard");this._currentModel=null;this._keyboardHandlers=null;this._currentSelection=null;var c=this;this.clickHandler=function(d){c.handleClick(d)}};xtiger.editor.PopupDevice.prototype={MAX_HEIGHT:150,startEditing:function(b,d,i,f){var c=true;var g=this._menu.getHandle();if(this._currentModel!=null){this.stopEditing(true);c=false}g.style.width="";g.style.maxHeight=this.MAX_HEIGHT+"px";this._menu.setOptions(d,i);this._menu.setPosition(f);if(c){this._menu.show();xtdom.addEventListener(this._document,"mousedown",this.clickHandler,true);this._keyboardHandlers=this._keyboard.register(this,this._document)}this._currentModel=b;this._currentSelection=null;try{this._menu.adjustHeight(g,this.MAX_HEIGHT);if(this._menu.isScrollbarInside()){this._menu.adjustWidthToScrollbar(g)}}catch(j){}},stopEditing:function(c,b){if(!this._currentModel){return}if(!b){if(this.getSelection()){if(this._currentModel.onMenuSelection){this._currentModel.onMenuSelection(this.getSelection())}else{this._currentModel.update(this.getSelection())}}}if(!c){xtdom.removeEventListener(this._document,"mousedown",this.clickHandler,true);this._menu.hide();this._keyboard.unregister(this,this._keyboardHandlers,this._document)}if((!b)&&(this._currentModel.isOptional)&&(!this._currentModel.isSelected)){if(this._currentModel.setSelectionState){this._currentModel.setSelectionState(true)}else{this._currentModel.set()}}this._currentModel=null},cancelEditing:function(){this.stopEditing(false,true)},isEditing:function(){return this._currentModel?true:false},getSelection:function(){return this._currentSelection},setSelection:function(b){this._currentSelection=b},getHandle:function(){return this._menu.getHandle()},handleClick:function(b){this._menu.handleClick(b,this)},doKeyDown:function(b){switch(b.keyCode){case 38:this._menu.selectPrev();xtdom.preventDefault(b);xtdom.stopPropagation(b);break;case 40:this._menu.selectNext();xtdom.preventDefault(b);xtdom.stopPropagation(b);break;default:}this._currentSelection=this._menu.getSelected()},doKeyUp:function(b){}};xtiger.editor.PopupMenu=function(b){this._document=b;this._handle=this._createMenuForDoc(b);this._handle.style.visibility="hidden";this._currentSelection=-1;this._options=null};xtiger.editor.PopupMenu.prototype={_createMenuForDoc:function(c){var b=c.getElementsByTagName("body")[0];var d=xtdom.createElement(c,"div");xtdom.addClassName(d,"axel-popup-container");b.appendChild(d);return d},_createMenuElement:function(c,e){var d=xtdom.createElement(this._document,"li");d.isNestedList=false;switch(typeof c){case"object":if(c.value&&c.display){d.selectionvalue=c.value;xtdom.addClassName(d,"axel-popup-selectable");e.push(d);try{d.innerHTML=c.display}catch(i){xtiger.cross.log("warning",'The following text is not proper HTML code \n\t"'+c.display+'"\n\tCause : '+i.message);var g=xtdom.createTextNode(this._document,c.display);d.appendChild(g)}break}else{if(c.section){d.selectionvalue=null;d.isNestedList=true;try{d.innerHTML='<table class="axel-popup-sublist"><tbody><tr><td class="axel-popup-sublistheader"></td><td class="axel-popup-sublistbody"><ul style="margin-left:0"></ul></td></tr></tbody></table>';_header=d.firstChild.firstChild.firstChild.firstChild;_body=_header.nextSibling.firstChild;if(c.header){_header.innerHTML=c.header}for(var f=0;f<c.section.length;f++){var b=this._createMenuElement(c.section[f],e);_body.appendChild(b)}}catch(i){xtiger.cross.log("warning",'The following text is not proper HTML code \n\t"'+c.header+'"\n\tCause : '+i.message);var g=xtdom.createTextNode(this._document,c.display);d.appendChild(g)}break}}case"string":default:g=xtdom.createTextNode(this._document,c);d.selectionvalue=c;d.appendChild(g);xtdom.addClassName(d,"axel-popup-selectable");e.push(d)}return d},_setPositionXY:function(x,y){with(this._handle.style){left=x+"px";top=y+"px"}},getHandle:function(){return this._handle},isScrollbarInside:function(){return xtiger.cross.UA.gecko||xtiger.cross.UA.webKit||xtiger.cross.UA.IE},adjustWidthToScrollbar:function(i){var d,f=20,e=10+f;if(i.scrollHeight>i.clientHeight){var g=xtdom.findPos(i);var c=xtdom.getWindowLimitFrom(i);var b=c[0]-g[0]-e;d=((i.scrollWidth+f)<b)?i.scrollWidth+f:b;i.style.width=d+"px"}},adjustHeight:function(j,c){var d,e=20,b=c;var i=xtdom.findPos(j);var f=xtdom.getWindowLimitFrom(j);var g=f[1]-i[1]-e;if((g<j.clientHeight)||(j.scrollHeight>j.clientHeight)){b=(g>c)?g:c;b=b+"px";d=j.style.maxHeight||"";if(d!=b){j.style.maxHeight=b}}},setOptions:function(e,d){this._currentSelection=-1;this._options=[];this._handle.innerHTML='<ul style="margin-left:0"></ul>';for(var c=0;c<e.length;c++){var b=this._createMenuElement(e[c],this._options);if(d&&b.selectionvalue==d){xtdom.addClassName(b,"selected")}else{xtdom.removeClassName(b,"selected")}this._handle.firstChild.appendChild(b)}},setPosition:function(b){var c=xtdom.findPos(b);this._setPositionXY(c[0],b.offsetHeight+c[1])},selectNext:function(){if(this._currentSelection!=-1){xtdom.removeClassName(this._options[this._currentSelection],"selected")}this._currentSelection++;this._currentSelection%=(this._options.length);xtdom.addClassName(this._options[this._currentSelection],"selected")},selectPrev:function(){if(this._currentSelection!=-1){xtdom.removeClassName(this._options[this._currentSelection],"selected")}else{this._currentSelection=1}this._currentSelection--;if(this._currentSelection<0){this._currentSelection=this._options.length-1}xtdom.addClassName(this._options[this._currentSelection],"selected")},getSelected:function(){if(this._currentSelection==-1){return false}var b=this._options[this._currentSelection];if(b.value){return b.selectionvalue}return b.firstChild.data},show:function(){this._handle.style.visibility="visible"},hide:function(){this._handle.style.visibility="hidden"},handleClick:function(c,b){var d=xtdom.getEventTarget(c);while(d.parentNode){if(xtdom.getLocalName(d).toLowerCase()=="li"&&d.selectionvalue){b.setSelection(d.selectionvalue);xtdom.preventDefault(c);xtdom.stopPropagation(c);b.stopEditing(false,false);return}if(d==this._handle){return}d=d.parentNode}xtdom.preventDefault(c);xtdom.stopPropagation(c);b.stopEditing(false,true)}};xtiger.editor.LayoutManager=(function LayoutManager(){var e;var c;var b;var d=function d(){e=xtdom.createElement(b,"img");e.setAttribute("src",xtiger.bundles.lens.whiteIconURL)};return function(f){b=f;c=xtdom.createElement(f,"div");xtdom.addClassName(c,"axel-layout-container");this.getFakeDiv=function(){if(!e){d()}return e};this.getLayoutHandle=function(){return c}}})();xtiger.editor.LayoutManager.prototype={_getDistanceFor:function(b,f){var d=xtdom.getComputedStyle(b,f),c=d.match(/\d*/),e=(c&&c[0]&&(c[0]!=""))?parseInt(c):0;return(!isNaN(e))?e:0},_getOffset:function(f){var e=0,d=0,c,b;switch(xtdom.getComputedStyle(f,"position")){case"absolute":case"fixed":break;case"relative":e=this._getDistanceFor(f,"top");d=this._getDistanceFor(f,"left");case"static":default:c=this._getDistanceFor(f,"margin-top");b=this._getDistanceFor(f,"margin-left");e+=(c>0)?c:0;d+=(b>0)?b:0}return[d,e]},_confirmInsertion:function(c){var b=(!this.curHandle)||(this.curHandle!=c);if(this.curHandle&&(this.curHandle!=c)){this.restoreHandle()}return b},_setDisplay:function(d,c){var b=xtdom.getComputedStyle(c,"display");b=(/^block$|^inline$/.test(b))?b:"block";d.style.display=b},_setOrigin:function(c,d,b){c.style.left=""+(d[0]-b[0])+"px";c.style.top=""+(d[1]-b[1])+"px"},_insert:function(i,j,g,c,b){var k,d,e,l=c,f=this._confirmInsertion(j);if(f){k=this.getLayoutHandle();d=this._getOffset(j);this._setDisplay(k,j);k.style.visibility="hidden";if(i=="above"){j.parentNode.insertBefore(k,j)}else{e=this.getFakeDiv();j.parentNode.replaceChild(e,j);e.parentNode.insertBefore(k,e)}k.appendChild(g);if(b){l=b()}this._setOrigin(k,d,l);k.style.visibility="visible";this.curDisplay=i;this.curHandle=j;this.curLensContent=g}return f},insertAbove:function(d,c,b,e){this._insert("above",d,c,b,e)},insertInline:function(f,e,d,i){var j,b,g,c;if(this._insert("inline",f,e,d,i)){j=e.getBoundingClientRect();b=j?(j.right-j.left):1;g=j?(j.bottom-j.top):1;c=this.getFakeDiv();c.style.width=b+"px";c.style.height=g+"px"}},restoreHandle:function(){var b;if(this.curHandle){if(this.curDisplay=="inline"){b=this.getFakeDiv();b.parentNode.replaceChild(this.curHandle,b)}else{this.curHandle.style.visibility="visible"}xtdom.removeElement(this.curLensContent);xtdom.removeElement(this.getLayoutHandle());this.curHandle=this.curDisplay=this.curLensContent=undefined}}};xtiger.editor.LensDevice=function(y){var x=y;var i=xtiger.session(y).load("keyboard");var g;var c;var j;var m;var b={trigger:"click",display:"above",padding:"10px"};var k=false;var v=false;var u=this;var A={click:["click",function(D){u._onClick(D)}],mouseover:["mousemove",function(D){u._onMouseMove(D)}]};var B=function(E,D){return(D.getParam&&D.getParam(E))||b[E]};var t=function(){if(!m){m=new xtiger.editor.LayoutManager(x)}return m};var f=function(E){var D=xtiger.factory("lens").getWrapper(x,E);if(!D){xtiger.cross.log("warning",'Missing wrapper "'+aWrapperName+'" in lens device, startEditing aborted')}return D};var e=function(H,E,D,F){var G;try{G=c.grab(H,D,F)}catch(I){xtiger.cross.log("error ( "+I.message+' ) "',E+'" failed to grab the lens device, startEditing compromised')}return G||F};var d=function(D,F){if(!D.isEditing()){return}if(c.isFocusable()){i.unregister(D,D._handlers)}t().restoreHandle();var E=B("trigger",g);if(A[E]){xtdom.removeEventListener(x,A[E][0],A[E][1],true);k=false}if(F){g.update(c.getData())}c.release();g=null;c=null;j=null};this.startEditing=function C(G,F,E){var J,H,I,K;var D=E?true:false;if(this.isEditing()){this.stopEditing()}c=f(F);if(c){g=G;if(c.isFocusable()){this._handlers=i.register(this);i.grab(this,G)}H=B("padding",G).match(/\d*/)[0];H=(I&&I!="")?parseInt(I):10;I=[H,H];j=c.getHandle();J=B("display",g);if(J=="above"){t().insertAbove(g.getHandle(),j,I,function(){return e(u,F,D,I)})}else{if(J=="inline"){t().insertInline(g.getHandle(),j,I,function(){return e(u,F,D,I)})}else{xtiger.cross.log("error",'unkown display "'+J+'" in lens device, startEditing compromised')}}c.activate(this,E);K=B("trigger",G);if(A[K]){xtdom.addEventListener(x,A[K][0],A[K][1],true);k=false}else{xtiger.cross.log("error",'unkown trigger mode "'+K+'" in lens device, startEditing compromised')}}};this.stopEditing=function o(){d(this,true)};this.cancelEditing=function q(){d(this,false)};this.isEditing=function s(){return g?true:false};this.getHandle=function w(){if(c){return c.getHandle()}return null};this.getCurrentModel=function z(){if(g){return g}return null};this.keepAlive=function n(D){v=D};this._onClick=function(D){if(v){return}var F=true;var E=xtdom.getEventTarget(D);while(E.parentNode){if(E==j){F=false;break}E=E.parentNode}if(F){this.stopEditing()}};this._onMouseMove=function(E){if(v||(!j)){return}var G=E.clientX;var F=E.clientY;var D=j.getBoundingClientRect();if(k){if(!(D.left>G||D.top>F||D.right<=G||D.bottom<=F)){k=false}}else{if(D.left>G||D.top>F||D.right<=G||D.bottom<=F){this.stopEditing();xtdom.stopPropagation(E)}}};this.doKeyUp=function p(D){};this.doKeyDown=function l(D){if(!this.isEditing()){return}if(D.keyCode=="38"||D.keyCode=="40"){c.toggleField()}if(D.keyCode=="27"){this.cancelEditing()}xtdom.stopPropagation(D)};this.mouseMayLeave=function r(){k=true}};xtiger.editor.LensDeviceFactory=function(){this.devKey="LensDeviceCache";this.wrappers={}};xtiger.editor.LensDeviceFactory.prototype={_getCache:function(c){var b=xtiger.session(c).load(this.devKey);if(!b){b={device:null,wrappers:{}};xtiger.session(c).save(this.devKey,b)}return b},registerWrapper:function(c,b){if(this.wrappers[c]){xtiger.cross.log("error","Error (AXEL) attempt to register an already registered wrapper : '"+c+"' with 'lens' device !")}else{this.wrappers[c]=b}},getWrapper:function(b,e){var c=this._getCache(b);var f=c.wrappers[e];if(!f){var d=this.wrappers[e];if(d){f=c.wrappers[e]=d(b)}}if(!f){xtiger.cross.log("error","Error (AXEL) : unkown wrapper '"+e+"' requested in 'lens' device !")}return f},getInstance:function(b){var c=this._getCache(b);var d=c.device;if(!d){d=c.device=new xtiger.editor.LensDevice(b)}return d}};xtiger.resources.addBundle("lens",{whiteIconURL:"white.png"});xtiger.registry.registerFactory("lens",new xtiger.editor.LensDeviceFactory());xtiger.editor.UploadManager=function(b){this.available=[];this.curDoc=b};xtiger.editor.UploadManager.prototype={_reset:function(b){if(this.inProgress!=b){alert("Warning: attempt to close an unkown transmission !")}b.reset();this.available.push(b);this.inProgress=null},getUploader:function(){return(this.available.length>0)?this.available.pop():new xtiger.editor.FileUpload(this)},isReady:function(){return(null==this.inProgress)},isTransmitting:function(b){return(b&&(b==this.inProgress))},startTransmission:function(c,b){this.inProgress=c;c.start(b)},reportEoT:function(c,b){if(!this.inProgress){}else{if(c==1){this.notifyComplete(this.inProgress,b)}else{this.notifyError(this.inProgress,0,b)}}},notifyComplete:function(d,b){var c=d.client;this._reset(d);c.onComplete(b)},notifyError:function(e,d,c){var b=e.client;this._reset(e);b.onError(c)},cancelTransmission:function(c){var b=c.client;c.cancel();this._reset(c);b.onCancel()}};xtiger.editor.FileUpload=function(b){this.manager=b;this.xhr=null;this.defaultUrl="/upload"};xtiger.editor.FileUpload.prototype={reset:function(){delete this.url},setDataType:function(b){this.dataType=b},setAction:function(b){this.url=b},getClient:function(){return this.client},setClient:function(b){this.client=b},start:function(b){this.client=b;try{if(this.dataType=="dnd"){this.startXHR()}else{var c=this.client.getPayload();if(this.url){xtdom.setAttribute(c,"action",this.url)}else{if(!c.getAttribute("action")){xtdom.setAttribute(c,"action",this.defaultUrl)}}c.documentId.value=this.client.getDocumentId()||"noid";c.submit()}}catch(d){this.manager.notifyError(this,d.name,d.message)}},startXHR:function(){this.xhr=new XMLHttpRequest();var c=this;this.xhr.onreadystatechange=function(){try{if(4==c.xhr.readyState){if(c.xhr.status==201){c.manager.notifyComplete(c,c.xhr.responseText)}else{c.manager.notifyError(c,c.xhr.status,c.xhr.statusText)}}c.xhr=null}catch(d){c.manager.notifyError(c,d.name,d.message)}};this.xhr.open("POST",this.url||this.defaultUrl);this.xhr.overrideMimeType("text/plain; charset=x-user-defined-binary");var b=this.client.getDocumentId()||"noid";this.xhr.sendAsBinary(b+"$$$"+this.client.getPayload().getAsBinary())},cancel:function(){if(this.xhr){this.xhr.abort()}else{var b=this.client.getPayload();b.reset()}}};var _UploadFactory={getInstance:function(c){var b=xtiger.session(c).load("upload");if(!b){b=new xtiger.editor.UploadManager(c);xtiger.session(c).save("upload",b)}return b}};xtiger.registry.registerFactory("upload",_UploadFactory);xtiger.editor.TextFactory=(function TextFactory(){var f=function(k,j){var l={device:"text-device",type:"input",layout:"placed",shape:"self",expansion:"grow",clickthrough:"true",enablelinebreak:"false"};this._handle=k;this._data=null;this._defaultData=this._data;this._noData=this._handle.firstChild;this._document=j;this._params=l;this._isOptional=false;this._isOptionSet=false;this._optCheckBox;this._device=null;this._seed=null;this._isModified=false;this._uniqueKey;this.create()};f.prototype={_setData:function(j){if(this._handle.firstChild){this._handle.firstChild.data=j}this._data=j},create:function(){},init:function(o,m,k,j,l){if(m){if(typeof(m)=="string"){xtiger.util.decodeParameters(m,this._params)}else{if(typeof(m)=="object"){this._params=m}}}if(o&&typeof o=="string"){this._defaultData=o}else{this._defaultData="click to edit"}this._data=this._defaultData;this._setData(this._defaultData);this._isOptional=k?true:false;if(k){this._optCheckBox=this._handle.previousSibling;if(k=="unset"){this._isOptionSet=true}(k=="set")?this.set(false):this.unset(false)}this._uniqueKey=j;if(this.getParam("hasClass")){xtdom.addClassName(this._handle,this.getParam("hasClass"))}var n=this._params.device?xtiger.factory(this._params.device):xtiger.factory(this._params.defaultDevice);this._device=n.getInstance(this._document,this._params.type,this._params.layout);this.awake()},makeSeed:function(){if(!this._seed){this._seed=[xtiger.editor.TextFactory,this._defaultData,this._params,this._isOptional]}return this._seed},remove:function(){},can:function(j){return typeof this[j]=="function"},execute:function(j,k){return this[j](k)},load:function(l,k){var j;if(l!==-1){j=k.getDataFor(l);this._setData(j||this._defaultData);this._isModified=(j!=this._defaultData);this.set(false)}else{this.clear(false)}},save:function(j){if(this.isOptional()&&!this._isOptionSet){j.discardNodeIfEmpty();return}if(!this._data){return}j.write(this._data)},update:function(j){if(j==this._data){return}if(j.search(/\S/)==-1||(j==this._defaultData)){this.clear(true);return}this._setData(j);this._isModified=true;this.set(true)},clear:function(j){this._setData(this._defaultData);this._isModified=false;if(this.isOptional()&&this.isSet()){this.unset(j)}},setDefaultData:this.clear,getData:function(){return this._data},getDefaultData:function(){return this._defaultData},getHandle:function(j){if(j){if(this._params.layout=="placed"&&this._device&&this._device.getCurrentModel()==this){return this._device.getHandle()}}return this._handle},getDocument:function(){return this._document},getGhost:function(){var j=this._params.shape;return(j&&j.charAt(0)=="p")?this._handle.parentNode:this._handle},getParam:function(j){return this._params[j]},getUniqueKey:function(){return this._uniqueKey},isModified:function(){return this._isModified},setModified:function(j){this._isModified=j},isFocusable:function(){return !this._params.noedit},focus:function(){this.startEditing({shiftKey:true})},unfocus:function(){this.stopEditing()},isOptional:function(){return this._isOptional},isSet:function(){return this._isOptional&&(this._isOptionSet?true:false)},set:function(j){if(j){if(!this._params.noedit){xtiger.editor.Repeat.autoSelectRepeatIter(this.getHandle(true))}xtdom.removeClassName(this._handle,"axel-repeat-unset")}if(this._isOptionSet){return}this._isOptionSet=true;if(this._isOptional){xtdom.removeClassName(this._handle,"axel-option-unset");xtdom.addClassName(this._handle,"axel-option-set");this._optCheckBox.checked=true}},unset:function(j){if(!this._isOptionSet){return}this._isOptionSet=false;if(this._isOptional){xtdom.removeClassName(this._handle,"axel-option-set");xtdom.addClassName(this._handle,"axel-option-unset");this._optCheckBox.checked=false}},awake:function(){var j=this;if(!this._params.noedit){xtdom.addClassName(this._handle,"axel-core-editable");xtdom.addEventListener(this._handle,"click",function(k){j.startEditing(k)},true)}if(this.isOptional()){xtdom.addEventListener(this._optCheckBox,"click",function(k){j.onToggleOpt(k)},true)}},startEditing:function(k){var j=k?(!this._isModified||k.shiftKey):false;this._device.startEditing(this,k,j)},stopEditing:function(){this._device.stopEditing(false,false)},onToggleOpt:function(j){this._isOptionSet?this.unset(true):this.set(true)}};var i="text";var b=0;return{createModel:function c(p,n,l){var k=n.getAttribute("handle");k=k?k:"span";var j=xtdom.createElement(l,k);var o=xtdom.createTextNode(l,"");j.appendChild(o);xtdom.addClassName(j,"axel-core-on");var q=n.getAttribute("option");if(q){var m=xtdom.createElement(l,"input");xtdom.setAttribute(m,"type","checkbox");xtdom.addClassName(m,"axel-option-checkbox");p.appendChild(m)}p.appendChild(j);return j},createEditorFromTree:function e(l,k,j){var n=xtdom.extractDefaultContentXT(k);if(n&&(n.search(/\S/)==-1)){n=null}var o=new f(l,j);var m={};xtiger.util.decodeParameters(k.getAttribute("param"),m);if(m.filter){o=this.applyFilters(o,m.filter)}o.init(n,k.getAttribute("param"),k.getAttribute("option"),this.createUniqueKey());return o},createEditorFromSeed:function g(n,q,j,l){var p=new f(q,j);var m=n[1];var k=n[2];var o=n[3];if(k.filter){p=this.applyFilters(p,k.filter)}p.init(m,k,o,this.createUniqueKey(),l);return p},createUniqueKey:function d(){return i+(b++)}}})();xtiger.editor.Plugin.prototype.pluginEditors.text=xtiger.util.filterable("text",xtiger.editor.TextFactory);xtiger.editor.SelectFactory=(function SelectFactory(){var c={select_dispatch:"value"};var b=function b(g){var e="popupdevice";var f=xtiger.session(g).load(e);if(!f){f=new xtiger.editor.PopupDevice(g);xtiger.session(g).save(e,f)}return f};var d=function(f,e){this.handle=f;this.isOptional=undefined;this.isOptionSet=false;this._data=null};d.prototype={getParam:function(e){return this.param?(this.param[e]||c[e]):c[e]},isFocusable:function(){return false},getHandle:function(){return this.handle},can:function(e){return false},init:function(k,j,g,f,i){this.param=j;this.defaultScreenData=k;this.device=b(this.handle.ownerDocument);if(this.getParam("hasClass")){xtdom.addClassName(this.handle,this.getParam("hasClass"))}this._setData(this.i18nFilter(this.defaultScreenData,false),this.defaultScreenData);if(g){var e=this.handle.previousSibling;this.isOptional=g.toLowerCase();if(this.isOptional=="unset"){this.isOptionSet=true}(this.isOptional=="set")?this.set(false):this.unset(false)}this.awake()},awake:function(){var f=this;xtdom.addEventListener(this.handle,"click",function(g){f.startEditing(g)},true);if(this.isOptional!==undefined){var e=this.handle.previousSibling;xtdom.addEventListener(e,"click",function(g){f.isOptionSet?f.unset(true):f.set(true)},true)}},duplicate:function(){},load:function(e,f){if(e!==-1){var g=f.getDataFor(e);if(g){this._setData(g)}this.set(false)}else{this.clear(false)}},save:function(e){if((this.isOptional===undefined)||(this.isOptionSet)){e.write(this._data)}else{e.discardNodeIfEmpty()}},startEditing:function(g){var f=this.getParam("values");var e=("string"!=typeof(f[0]))?f[0]:f;this.device.startEditing(this,e,this.i18nFilter(this._data,true),this.getHandle())},getData:function(){var e=(this.getParam("select_dispatch")=="value")?this._data:this.i18nFilter(this._data,true);return e},stopEditing:function(){},update:function(e){var f=(this.getParam("select_dispatch")=="value")?e:this.i18nFilter(e,false);if(f==this._data){return}this._setData(f);this.set(true)},_setData:function(e,f){var g=f||this.i18nFilter(e,true);if(this.handle.firstChild){this.handle.firstChild.data=g}this._data=e},clear:function(e){this._setData(this.i18nFilter(this.defaultScreenData,false),this.defaultScreenData);if(this.isOptional!==undefined){this.unset(e)}},set:function(f){if(f){xtiger.editor.Repeat.autoSelectRepeatIter(this.getHandle())}if(this.isOptionSet){return}this.isOptionSet=true;if(this.isOptional!==undefined){var e=this.handle.previousSibling;e.checked=true;xtdom.replaceClassNameBy(this.handle,"axel-option-unset","axel-option-set")}},unset:function(f){if(!this.isOptionSet){return}this.isOptionSet=false;if(this.isOptional!==undefined){var e=this.handle.previousSibling;xtdom.replaceClassNameBy(this.handle,"axel-option-set","axel-option-unset");e.checked=false}},remove:function(){},makeSeed:function(){if(!this.seed){this.seed=[xtiger.editor.SelectFactory,this.defaultScreenData,this.param,this.isOptional]}return this.seed},onMenuSelection:function(e){if(this.getParam("select_dispatch")=="value"){this.update(this.i18nFilter(e,false))}else{this.update(e)}},i18nFilter:function(k,e){var j=k;var f=this.getParam("values");if(!f){throw ({name:"TemplateError",message:'missing "values" attribute in xt:attribute element'})}if("string"!=typeof(f[0])){var m=f[e?1:0];var l=f[e?0:1];for(var g=0;g<m.length;g++){if(k==m[g]){if(g<l.length){j=l[g]}else{j="**Error**"}break}}}return j}};return{createModel:function(i,g,j){var f=xtdom.createElement(j,"span");var k=xtdom.createTextNode(j,"");f.appendChild(k);xtdom.addClassName(f,"axel-core-editable");var l=g.getAttribute("option");if(l){var e=xtdom.createElement(j,"input");xtdom.setAttribute(e,"type","checkbox");xtdom.addClassName(e,"axel-option-checkbox");i.appendChild(e)}i.appendChild(f);return f},createEditorFromTree:function(e,f,i){var j=xtdom.extractDefaultContentXT(f);var l=new d(e,i);var k={};xtiger.util.decodeParameters(f.getAttribute("param"),k);if(k.filter){l=this.applyFilters(l,k.filter)}var n=f.getAttribute("values");var o=f.getAttribute("i18n");var g=n?n.split(" "):"null";var m=o?o.split(" "):false;k.values=m?[m,g]:g;l.init(j,k,f.getAttribute("option"),"nokey");return l},createEditorFromSeed:function(i,m,e,g){var l=new d(m,e);var k=i[1];var f=i[2];var j=i[3];if(f.filter){l=this.applyFilters(l,f.filter)}l.init(k,f,j,"nokey",g);return l}}})();xtiger.editor.Plugin.prototype.pluginEditors.select=xtiger.util.filterable("select",xtiger.editor.SelectFactory);xtiger.editor.LinkFactory=(function LinkFactory(){var c=function(k,j){var l={defaultText:"enter link's text here",defaultUrl:"http://",defaultDevice:"lens",wrapper:"togglewrapper",linkRefTagName:"linkRef",linkTextTagName:"linkText",trigger:"click",padding:"10"};this._handle=k;this._data={text:l.defautText,url:l.defautUrl};this._defaultData=this._data;this._document=j;this._params=l;this._isOptional=false;this._isOptionSet=false;this._optCheckBox;this._device=null;this._seed=null;this._isModified=false;this._uniqueKey;this.create()};c.prototype={_setData:function(k,j){this._data={text:k,url:j};this._handle.firstChild.data=k},create:function(){},init:function(o,m,k,j,l){if(m){if(typeof(m)=="string"){xtiger.util.decodeParameters(m,this._params)}else{if(typeof(m)=="object"){this._params=m}}}if(o&&o.text&&o.url){this._setData(o.text,o.url);this._defaultData=o}if(k){this._isOptional=true;this._optCheckBox=this._handle.nextSibling;(k=="set")?this.set():this.unset()}this._uniqueKey=j;var n=this._params.device?xtiger.factory(this._params.device):xtiger.factory(this._params.defaultDevice);this._device=n.getInstance(this._document);this.awake()},makeSeed:function(){if(!this._seed){this._seed=[xtiger.editor.LinkFactory,this._defaultData,this._params,this._isOptional]}return this._seed},can:function(j){return typeof this[j]=="function"},execute:function(j,k){return this[j](k)},load:function(n,m){var j,l;try{j=m.getDataFor(m.getVectorFor("linkRef",n));l=m.getDataFor(m.getVectorFor("linkText",n))}catch(k){tiger.cross.log("warning","Unable to load the link editor with the following content :\n text="+l+", url="+j)}if(this.isOptional()){if(j||l){this.set()}else{this.unset()}}if(!j){j=this._defaultData.url}if(!l){l=this._defaultData.text}this._setData(l,j)},save:function(j){if(this.isOptional()&&!this._isOptionSet){j.discardNodeIfEmpty();return}var k=this.getData();j.openTag(this._params.linkRefTagName);j.write(k.url);j.closeTag(this._params.linkRefTagName);j.openTag(this._params.linkTextTagName);j.write(k.text);j.closeTag(this._params.linkTextTagName)},update:function(j){if(j.text==this._data.text&&j.url==this._data.url){return}if(!j||(j.text==null&&j.url==null)){this.clear(true);return}this._setData(j.text,j.url);this._isModified=true;this.set(true)},clear:function(j){this._setData(this._defaultData.text,this._defaultData.url);this._isModified=false;if(this.isOptional()&&this.isSet()){this.unset(j)}},getData:function(){return this._data},getDefaultData:function(){return this._defaultData},getHandle:function(){return this._handle},getDocument:function(){return this._document},getParam:function(j){return this._params[j]},getUniqueKey:function(){return this._uniqueKey},isModified:function(){return this._isModified},setModified:function(j){this._idModified=j},isOptional:function(){return this._isOptional},isSet:function(){return this._isOptional&&(this._isOptionSet?true:false)},set:function(j){if(j){xtiger.editor.Repeat.autoSelectRepeatIter(this.getHandle(true));xtdom.removeClassName(this._handle,"axel-repeat-unset")}if(this._isOptionSet){return}this._isOptionSet=true;if(this._isOptional){xtdom.removeClassName(this._handle,"axel-option-unset");xtdom.addClassName(this._handle,"axel-option-set");this._optCheckBox.checked=true}},unset:function(){if(!this._isOptional){return}xtdom.removeClassName(this._handle,"axel-option-set");xtdom.addClassName(this._handle,"axel-option-unset");this._isOptionSet=false;this._optCheckBox.checked=false},isFocusable:function(){return true},focus:function(){this.startEditing(null)},unfocus:function(){this.stopEditing()},awake:function(){var j=this;if(this.isOptional()){xtdom.addEventListener(this._optCheckBox,"click",function(k){j.onToggleOpt(k)},true)}xtdom.addEventListener(this._handle,this._params.trigger,function(k){j.startEditing(k)},true)},startEditing:function(k){var j=k?(!this._isModified||k.shiftKey):false;this._device.startEditing(this,"linkLensWrapper",j);if(k){xtdom.stopPropagation(k)}},stopEditing:function(){this._device.stopEditing()},onToggleOpt:function(j){this._isOptionSet?this.unset():this.set()}};var i="link";var b=0;return{createModel:function d(l,k,j){var o=xtdom.createElement(j,"span");xtdom.addClassName(o,"axel-core-on");xtdom.addClassName(o,"axel-core-editable");xtdom.addClassName(o,"axel-link-handle");o.appendChild(xtdom.createTextNode(j,""));l.appendChild(o);var m=k.getAttribute("option");if(m){var n=xtdom.createElement(j,"input");xtdom.setAttribute(n,"type","checkbox");xtdom.addClassName(n,"axel-option-checkbox");l.appendChild(n)}return o},createEditorFromTree:function f(m,l,j){var p=new c(m,j);var n;var o=l.childNodes;switch(o.length){case 2:if(o[0].nodeType==xtdom.ELEMENT_NODE&&o[1].nodeType==xtdom.ELEMENT_NODE&&o[0].nodeName=="linkText"&&o[1].nodeName=="linkRef"){n={text:o.childNodes[0].nodeValue,url:o.childNodes[1].nodeValue}}break;case 1:if(o[0].nodeType==xtdom.ELEMENT_NODE&&(/^a$/i).test(o[0].nodeName)){n={text:o[0].firstChild.nodeValue,url:o[0].getAttribute("href")}}else{if(o[0].nodeType==xtdom.TEXT_NODE){n={text:o[0].nodeValue,url:"http://"}}}break;default:n={text:"link",url:"http://"}}var k={};xtiger.util.decodeParameters(l.getAttribute("param"),k);if(k.filter){p=this.applyFilters(p,k.filter)}p.init(n,l.getAttribute("param"),l.getAttribute("option"),this.createUniqueKey());return p},createEditorFromSeed:function g(n,q,j,l){var p=new c(q,j);var m=n[1];var k=n[2];var o=n[3];if(k.filter){p=this.applyFilters(p,k.filter)}p.init(m,k,o,this.createUniqueKey(),l);return p},createUniqueKey:function e(){return i+(b++)}}})();xtiger.editor.Plugin.prototype.pluginEditors.link=xtiger.util.filterable("link",xtiger.editor.LinkFactory);var _LinkLensWrapper=function(b){this._handle;this._handleToRestore;this._document=b;this._isFocused=false;this._build()};_LinkLensWrapper.prototype={_build:function(){this._topDiv=xtdom.createElement(this._document,"div");xtdom.addClassName(this._topDiv,"axel-lens-container");xtdom.addClassName(this._topDiv,"axel-lens-containerstyle");this._topDiv.style.display="block";this._upperP=xtdom.createElement(this._document,"p");with(this._upperP){style.margin="0 0 15px 0";style.padding="0px";style.width="100%"}this._anchorInput=xtdom.createElement(this._document,"input");with(this._anchorInput){type="text"}xtdom.addClassName(this._anchorInput,"axel-link-handle");this._upperP.appendChild(this._anchorInput);this._topDiv.appendChild(this._upperP);this._lowerP=xtdom.createElement(this._document,"p");with(this._lowerP){style.margin="0px";style.padding="0px";style.width="100%"}this._urlInput=xtdom.createElement(this._document,"input");with(this._urlInput){style.width="75%"}this._goButtonLink=xtdom.createElement(this._document,"a");with(this._goButtonLink){href="";target="_blank";style.margin="0 10px";style.width="25%"}this._goButton=xtdom.createElement(this._document,"img");with(this._goButton){src=xtiger.bundles.link.gotoURL;style.height="20px";style.width="30px";style.display="inline";style.verticalAlign="bottom"}this._goButtonLink.appendChild(this._goButton);this._lowerP.appendChild(this._urlInput);this._lowerP.appendChild(this._goButtonLink);this._topDiv.appendChild(this._lowerP)},_setData:function(c,b){if(c&&typeof(c)=="string"){this._anchorInput.value=c}if(b&&typeof(b)=="string"){this._urlInput.value=b;this._goButtonLink.href=b}},getHandle:function(){return this._topDiv},grab:function(e,c,d){this._currentDevice=e;var f=this._currentDevice.getCurrentModel().getData();this._setData(f.text,f.url);var b=this._currentDevice.getCurrentModel().getHandle();this._topDiv.style.padding=d[0]+"px "+d[1]+"px";var g=this;xtdom.addEventListener(this._anchorInput,"focus",function(i){g.onFocus(i)},false);xtdom.addEventListener(this._urlInput,"focus",function(i){g.onFocus(i)},false);xtdom.addEventListener(this._anchorInput,"blur",function(i){g.onBlur(i)},false);xtdom.addEventListener(this._urlInput,"blur",function(i){g.onBlur(i)},false);return[d[0],d[1]+4]},activate:function(c,b){if(b){xtdom.focusAndSelect(this._anchorInput)}else{this._anchorInput.focus()}},release:function(){this._isFocused=false;xtdom.removeElement(this._topDiv);this._currentDevice=null},toggleField:function(){if(this._isFocused){if(this._focusedField==this._anchorInput){this._anchorInput.blur();xtdom.focusAndMoveCaretTo(this._urlInput,this._urlInput.value.length)}else{this._urlInput.blur();xtdom.focusAndMoveCaretTo(this._anchorInput,this._anchorInput.value.length)}}},getData:function(){return{url:this._urlInput.value,text:this._anchorInput.value}},isFocusable:function(){return true},onBlur:function(c){var b=xtdom.getEventTarget(c);if(b==this._urlInput){this._goButtonLink.href=this._urlInput.value}this._isFocused=false;this._focusedField=null;this._currentDevice.keepAlive(false)},onFocus:function(b){this._isFocused=true;this._currentDevice.keepAlive(true);this._focusedField=xtdom.getEventTarget(b)}};xtiger.resources.addBundle("link",{gotoURL:"goto.png"});xtiger.factory("lens").registerWrapper("linkLensWrapper",function(b){return new _LinkLensWrapper(b)});xtiger.editor.RichTextFactory=(function RichTextFactory(){var f=function(k,j){var l={defaultDevice:"lens",trigger:"click",padding:"10"};this._handle=k;this._data={};this._updateFilter=["br","p","span","i","u","b","strong","em","a","font"];this._defaultData=this._data;this._document=j;this._params=l;this._isOptional=false;this._isOptionSet=false;this._optCheckBox;this._device=null;this._seed=null;this._isModified=false;this._uniqueKey;this.create()};f.prototype={_setData:function(j){this._handle.innerHTML=j;this._treeFilter(this._handle,this._updateFilter);this._removeTrailingBRNodes(this._handle,true)},_sanitizeAttribute:function(j){var k=j.replace(/"/g,"'");k=k.replace(/&(?!\w{3,6};)/g,"&amp;");return k},_treeFilter:function(m,t,s){if(!m||!t){return m}if(s!==false){s=true}try{var k=m.firstChild;while(k){var n=k.nextSibling;if(k.nodeType==xtdom.ELEMENT_NODE){if(s){this._treeFilter(k,t,s)}var l=false;for(var q in t){if((t[q]).toLowerCase()==(k.nodeName).toLowerCase()){l=true;break}}if(!l){var r=k.firstChild;var p=r;while(r){var j=r.nextSibling;m.insertBefore(r,k);r=j}xtdom.removeElement(k)}}k=n}}catch(o){console.warn("(richtext.js: "+o.lineNumber+") Problem in tree conversion: "+o.message);return m}},_removeTrailingBRNodes:function(j,m){if(!j||!j.lastChild){return false}var k=false;for(var l=j.childNodes.length-1;l>=0;l--){if(j.childNodes[l].nodeName.toLowerCase()=="br"){xtdom.removeElement(j.childNodes[l]);k=true}else{if(m===true){return this._removeTrailingBRNodes(j.childNodes[l],true)}return k}}},_saveData:function(l,q){var j=l.childNodes[0];var k=false;var n=true;while(j){n=true;switch(j.nodeType){case xtdom.ELEMENT_NODE:k=true;var p=j.nodeName;var r=null;switch(p){case"b":case"B":case"STRONG":p="span";r="font-weight: bold";break;case"i":case"I":case"EM":p="span";r="font-style: italic";break;case"u":case"U":p="span";r="text-decoration: underline";break}q.openTag(p.toLowerCase());if(j.attributes.length){for(var o=0;o<j.attributes.length;o++){if(j.attributes[o].nodeName=="_moz_dirty"||j.attributes[o].nodeName=="xmlns"||(!j.attributes[o].specified&&xtiger.cross.UA.IE)){continue}q.openAttribute(j.attributes[o].nodeName);if(j.attributes[o].nodeName=="style"&&xtiger.cross.UA.IE){q.write(this._sanitizeAttribute(j.style.cssText.toLowerCase()))}else{q.write(this._sanitizeAttribute(j.getAttribute(j.attributes[o].nodeName)))}q.closeAttribute(j.attributes[o].nodeName)}}if(r){q.openAttribute("style");q.write(r);q.closeAttribute("style")}this._saveData(j,q);q.closeTag(p.toLowerCase());break;case xtdom.TEXT_NODE:if(!j.nodeValue.match(/\S/)&&j.nodeValue!=" "){break}var m="";while(j&&j.nodeType==xtdom.TEXT_NODE){m+=j.nodeValue;j=j.nextSibling;n=false}if(k||j){q.openTag("span")}m=m.replace(/&(?!\w{3,5};)/g,"&amp;");q.write(m);if(k||j){q.closeTag("span")}break;default:}if(j&&n){j=j.nextSibling}}},_loadData:function(o,w,t){if(w.isEmpty(o)){return}if(o instanceof Array&&o.length==2&&o[1].nodeType==xtdom.TEXT_NODE){t.appendChild(xtdom.createTextNode(this._document,xtdom.getTextContent(o[1])))}else{if(o instanceof Array&&o.length==2&&typeof(o[1])=="string"){t.appendChild(xtdom.createTextNode(this._document,o[1]))}else{if(o instanceof Array&&o.length>=2){for(var p=1;p<o.length;p++){if(o[p].nodeType==xtdom.TEXT_NODE){continue}var v=xtdom.getLocalName(o[p]);switch(v){case"span":if(o[p].attributes.length==0){t.appendChild(xtdom.createTextNode(this._document,xtdom.getTextContent(o[p])));break}if(xtiger.cross.UA.IE||xtiger.cross.UA.opera){var l=xtdom.getStyleAttribute(o[p]);if(l&&l!=""){var j=l.split(";");var u;var r;var q="";for(var n=0;n<j.length;n++){switch(j[n]){case"font-weight: bold":u=xtdom.createElement(this._document,"strong");if(r){r.appendChild(u)}r=u;break;case"font-style: italic":u=xtdom.createElement(this._document,"em");if(r){r.appendChild(u)}r=u;break;case"text-decoration: underline":u=xtdom.createElement(this._document,"u");if(r){r.appendChild(u)}r=u;break;default:if(/\S/.test(j[n])){q+=j[n]+";"}}}if(q!=""){u=xtdom.createElement(this._document,"span");if(xtiger.cross.UA.IE){u.style.setAttribute("cssText",q)}else{u.setAttribute("style",q)}if(r){r.appendChild(u)}r=u}for(var m=0;m<o[p].attributes.length;m++){if(o[p].attributes[m].nodeName!="style"){u.setAttribute(o[p].attributes[m].nodeName,o[p].attributes[m].nodeValue)}}var s=[null];for(var k=0;k<o[p].childNodes.length;k++){s.push(o[p].childNodes[k])}this._loadData(s,w,u);t.appendChild(u);break}}default:var u=xtdom.createElement(this._document,v);for(var m=0;m<o[p].attributes.length;m++){u.setAttribute(o[p].attributes[m].nodeName,o[p].attributes[m].nodeValue)}var s=[null];for(var n=0;n<o[p].childNodes.length;n++){s.push(o[p].childNodes[n])}this._loadData(s,w,u);t.appendChild(u)}}}}}},create:function(){},init:function(p,n,k,j,l){if(n){if(typeof(n)=="string"){xtiger.util.decodeParameters(n,this._params)}else{if(typeof(n)=="object"){this._params=n}}}if(p){try{this._setData(p);this._defaultData=p}catch(m){xtiger.cross.log("warning","Unable to init the rich text editor with the following content :\n"+aData)}}if(k){this._isOptional=true;this._optCheckBox=this._handle.previousSibling;(k=="set")?this.set():this.unset()}this._uniqueKey=j;var o=this._params.device?xtiger.factory(this._params.device):xtiger.factory(this._params.defaultDevice);if(o){this._device=o.getInstance(this._document)}else{xtiger.cross.log("warning","no device for this editor "+this)}this.awake()},makeSeed:function(){if(!this._seed){this._seed=[xtiger.editor.RichTextFactory,this._defaultData,this._params,this._isOptional]}return this._seed},can:function(j){return typeof this[j]=="function"},execute:function(j,k){return this[j](k)},load:function(n,m){var j=xtdom.createElement(this._document,"div");var l=j.innerHTML;try{this._loadData(n,m,j);this._setData(j.innerHTML)}catch(k){xtiger.cross.log("error","Richtext.js : failed to load data : "+k.message)}if(j.innerHTML==l&&this.isOptional()){this.unset()}if(j.innerHTML!=l&&this.isOptional()){this.set()}},save:function(j){j.openAttribute("xml:space");j.write("preserve");j.closeAttribute("xml:space");if(this.isOptional()&&!this._isOptionSet){j.discardNodeIfEmpty();return}this._saveData(this._handle,j)},update:function(k){if(this._data==k){return}if(!k||k.search(/\S/)==-1||(k==this._defaultData)){this.clear(true);return}var j=k;j=j.replace(/<br>/ig,"<br/>");j=j.replace(/<br\/>/gi,"<br></br>");try{this._setData(j);if(xtdom.getTextContent(this._handle).search(/\S/)==-1){this.clear(true);return}this._isModified=true;this.set(true)}catch(l){xtiger.cross.log("warning","Unable to update the rich text editor with the following content :\n"+k)}},clear:function(k){for(var j=this._handle.childNodes.length;j>0;j--){this._handle.removeChild(this._handle.childNodes[j-1])}this._setData(this._defaultData);this._isModified=false;if(this.isOptional()&&this.isSet()){this.unset(k)}},getData:function(){return this._handle.innerHTML.replace(/^\s+|\s+$/g,"")},getDefaultData:function(){return this._defaultData},getHandle:function(){return this._handle},getDocument:function(){return this._document},getParam:function(j){return this._params[j]},getUniqueKey:function(){return this._uniqueKey},isModified:function(){return this._isModified},setModified:function(j){this._idModified=j},isOptional:function(){return this._isOptional},isSet:function(){return this._isOptional&&(this._isOptionSet?true:false)},set:function(j){if(j){xtiger.editor.Repeat.autoSelectRepeatIter(this.getHandle(true));xtdom.removeClassName(this._handle,"axel-repeat-unset")}if(this._isOptionSet){return}this._isOptionSet=true;if(this._isOptional){xtdom.removeClassName(this._handle,"axel-option-unset");xtdom.addClassName(this._handle,"axel-option-set");this._optCheckBox.checked=true}},unset:function(){if(!this._isOptional){return}xtdom.removeClassName(this._handle,"axel-option-set");xtdom.addClassName(this._handle,"axel-option-unset");this._isOptionSet=false;this._optCheckBox.checked=false},isFocusable:function(){return true},focus:function(j){if(this._isOptional&&j&&!this._isOptionSet){this.set()}this._handle.focus();this.startEditing()},unfocus:function(){this._handle.blur();this.stopEditing()},awake:function(){var j=this.getParam("device");var k=this;xtdom.addEventListener(this._handle,this._params.trigger,function(l){if(k._isOptional&&!k._isOptionSet){k.set()}k.startEditing(l);xtdom.stopPropagation(l)},true);if(this.isOptional()){xtdom.addEventListener(this._optCheckBox,"click",function(l){k.onToggleOpt(l)},true)}},startEditing:function(k){var j=k?(!this._isModified||k.shiftKey):false;this._device.startEditing(this,"richtextwrapper",j)},stopEditing:function(){this._device.stopEditing()},onToggleOpt:function(j){this._isOptionSet?this.unset():this.set()}};var i="richtext";var b=0;return{createModel:function c(n,l,j){var k={};xtiger.util.decodeParameters(l.getAttribute("param"),k);switch(k.display){case"inline":var m=xtdom.createElement(j,"span");break;case"single":var m=xtdom.createElement(j,"p");break;default:var m=xtdom.createElement(j,"div")}xtdom.addClassName(m,"axel-core-on");xtdom.addClassName(m,"axel-core-editable");var o=l.getAttribute("option");if(o){var p=xtdom.createElement(j,"input");xtdom.setAttribute(p,"type","checkbox");xtdom.addClassName(p,"axel-option-checkbox");n.appendChild(p)}n.appendChild(m);return m},createEditorFromTree:function e(n,l,j){var p=new f(n,j);var o=xtdom.createElement(j,"div");var q=l.firstChild;while(q){var m=q.nextSibling;o.appendChild(q);q=m}var k={};xtiger.util.decodeParameters(l.getAttribute("param"),k);if(k.filter){p=this.applyFilters(p,k.filter)}p.init(o.innerHTML,l.getAttribute("param"),l.getAttribute("option"),this.createUniqueKey());return p},createEditorFromSeed:function g(n,q,j,l){var p=new f(q,j);var m=n[1];var k=n[2];var o=n[3];if(k.filter){p=this.applyFilters(p,k.filter)}p.init(m,k,o,this.createUniqueKey(),l);return p},createUniqueKey:function d(){return i+(b++)}}})();xtiger.editor.Plugin.prototype.pluginEditors.richtext=xtiger.util.filterable("richtext",xtiger.editor.RichTextFactory);xtiger.resources.addBundle("richtext",{plusIconURL:"plus.png",minusIconURL:"minus.png",uncheckedIconURL:"unchecked.png",checkedIconURL:"checked.png"});var _RichTextWrapper=function(aDocument){this._document=aDocument;this._markupRE=new RegExp("(</?[^<>]+/?>)","g");var _this=this;this._listener={onkeyup:function(ev){_this.onKeyUp(ev)},onkeydown:function(ev){_this.onKeyDown(ev)}};this._handle=xtdom.createElement(aDocument,"div");with(this._handle.style){display="none";top="-30px"}xtdom.addClassName(this._handle,"axel-lens-container");xtdom.addClassName(this._handle,"axel-lens-containerstyle");xtdom.addClassName(this._handle,"axel-core-editing");var _buttonbar=xtdom.createElement(aDocument,"div");with(_buttonbar){style.height="20px";style.padding="0";style.marginBottom="10px";style.width="100%"}this._handle.appendChild(_buttonbar);var _this=this;var _buttonBL=xtdom.createElement(aDocument,"input");with(_buttonBL){type="button";value="bold";style.display="inline";style.marginRight="2px";style.height="20px"}xtdom.addEventListener(_buttonBL,"click",function(ev){_this._document.execCommand("bold",false,false);_this._editablediv.focus()},true);_buttonbar.appendChild(_buttonBL);var _buttonUL=xtdom.createElement(aDocument,"input");with(_buttonUL){type="button";value="underline";style.display="inline";style.marginRight="2px";style.height="20px"}xtdom.addEventListener(_buttonUL,"click",function(ev){_this._document.execCommand("underline",false,false);_this._editablediv.focus()},true);_buttonbar.appendChild(_buttonUL);var _buttonIT=xtdom.createElement(aDocument,"input");with(_buttonIT){type="button";value="italic";style.display="inline";style.marginRight="2px";style.height="20px"}xtdom.addEventListener(_buttonIT,"click",function(ev){_this._document.execCommand("italic",false,false);_this._editablediv.focus()},true);_buttonbar.appendChild(_buttonIT);var _buttonOK=xtdom.createElement(aDocument,"input");with(_buttonOK){type="button";value="OK";style.marginRight="2px";style.marginLeft="40px";style.height="20px";style.width="50px";style.cssFloat="right";style.styleFloat="right"}xtdom.addEventListener(_buttonOK,"click",function(ev){_this._currentDevice.keepAlive(false);_this._currentDevice.stopEditing()},true);_buttonbar.appendChild(_buttonOK);this._editablediv=xtdom.createElement(aDocument,"div");with(this._editablediv){style.backgroundColor="white";style.color="black";style.margin="0";style.overflowX="auto";style.width="auto"}this._editablediv.setAttribute("contentEditable","true");this._editablediv.setAttribute("contenteditable","true");this._handle.appendChild(this._editablediv);xtdom.addEventListener(this._editablediv,"focus",function(ev){_this.onInputFocus(ev)},false);xtdom.addEventListener(this._editablediv,"blur",function(ev){_this.onInputBlur(ev)},true)};_RichTextWrapper.prototype={grab:function(aDevice,aDoSelect){if(this._currentDevice){this.release()}this._currentDevice=aDevice;var _modelHandle=this._currentDevice.getCurrentModel().getHandle();with(this._handle){style.display="block"}var _display=this._currentDevice.getCurrentModel().getParam("display");var _pad=this._currentDevice.getCurrentModel().getParam("padding");var _newwidth=(_display=="inline")?null:(_modelHandle.offsetWidth);if(xtiger.cross.UA.IE){_newwidth+=2*_pad}with(this._handle.style){minHeight=(_modelHandle.offsetHeight+40)+"px";minWidth=(_display=="inline")?(_modelHandle.offsetWidth)+"px":null;maxWidth=(_display=="inline")?(_modelHandle.parentNode.offsetWidth)+"px":null;width=_newwidth+"px";padding=_pad+"px"}with(this._editablediv.style){paddingLeft=xtdom.getComputedStyle(_modelHandle,"padding-left");paddingRight=xtdom.getComputedStyle(_modelHandle,"padding-right");paddingTop=xtdom.getComputedStyle(_modelHandle,"padding-top");paddingBottom=xtdom.getComputedStyle(_modelHandle,"padding-bottom")}this.setData(this._currentDevice.getCurrentModel().getData())},activate:function(c,b){if(b){this.selectData()}var d=this;xtdom.addEventListener(this._document,"keyup",this._listener.onkeyup,true);xtdom.addEventListener(this._document,"keydown",this._listener.onkeydown,true);this._lastKey=null;if(!b){this._editablediv.focus();this.setCaretToEnd()}},release:function(){if(!this._currentDevice){return}var b=this;xtdom.removeEventListener(this._document,"keyup",this._listener.onKeyUp,true);xtdom.removeEventListener(this._document,"keydown",this._listener.onKeyDown,true);this.setData("");xtdom.removeElement(this._handle);this._currentDevice=null},isFocusable:function(){return false},getData:function(){return this._editablediv.innerHTML},setData:function(b){if(!typeof(b)=="string"){return}this._editablediv.innerHTML=b},toggleField:function(){},selectData:function(){try{this._editablediv.focus();this._document.execCommand("selectAll",false,false)}catch(b){xtiger.cross.log("warning","Unable to move the caret at the end of the contentEditable field\n\tCause: "+b.message)}},getHandle:function(){return this._handle},isEmpty:function(c){var b=c.innerHTML.replace(this._markupRE,"");return b.search(/\S/)==-1},setCaretToEnd:function(){var e,d;this._editablediv.focus();var b=this._editablediv.lastChild;try{if(window.getSelection&&this._document.createRange){e=xtdom.getWindow(this._document).getSelection();e.removeAllRanges();d=this._document.createRange();d.selectNodeContents(b);d.collapse(false);e.addRange(d)}else{if(this._document.body.createTextRange){d=this._document.body.createTextRange();d.moveToElementText(this._editablediv);d.collapse(false);d.select()}}}catch(c){console.log(c)}console.log("caret on end")},onKeyDown:function(b){if((b.keyCode==13)&&(this._lastKey==13)){xtdom.preventDefault(b);xtdom.stopPropagation(b)}this._lastKey=b.keyCode},onKeyUp:function(d){try{if(this.isEmpty(this._editablediv)){this._editablediv.innerHTML="";this._document.execCommand("insertParagraph",false,false)}else{if(this._editablediv.firstChild.nodeName.toLowerCase()!="p"||this._editablediv.firstChild.nodeType!=xtdom.ELEMENT_NODE){var c="";var f=this._editablediv.firstChild;while(f&&(f.nodeType!=xtdom.ELEMENT_NODE||f.nodeName.toLowerCase()!="p")){c+=xtdom.getTextContent(f);_prev=f;f=f.nextSibling;xtdom.removeElement(_prev)}var b=xtdom.createElement(this._document,"p");b.innerHTML=c;if(this._editablediv.firstChild){this._editablediv.insertBefore(b,this._editablediv.firstChild)}else{this._editablediv.appendChild(b)}this.setCaretToEnd()}}}catch(e){xtiger.cross.log("error",e.message)}},onInputFocus:function(b){this._currentDevice.keepAlive(true)},onInputBlur:function(b){this._currentDevice.keepAlive(false)}};xtiger.factory("lens").registerWrapper("richtextwrapper",function(b){return new _RichTextWrapper(b)});xtiger.editor.PhotoFactory=(function PhotoFactory(){return{createModel:function(d,c,e){var b=xtdom.createElement(e,"img");xtdom.setAttribute(b,"src",xtiger.bundles.photo.photoIconURL);xtdom.addClassName(b,"axel-drop-target");xtdom.addClassName(b,"axel-photo-model");d.appendChild(b);return b},createEditorFromTree:function(d,b,c){var g=new xtiger.editor.Photo(d,c);var f=xtdom.extractDefaultContentXT(b);var e={};xtiger.util.decodeParameters(b.getAttribute("param"),e);if(e.filter){g=this.applyFilters(g,e.filter)}g.init(f,e,false);return g},createEditorFromSeed:function(b,i,c,e){var g=new xtiger.editor.Photo(i,c);var f=b[1];var d=b[2];if(d.filter){g=this.applyFilters(g,d.filter)}g.init(f,d,false,undefined,e);return g}}})();xtiger.editor.PhotoState=function(b){this.status=this.READY;this.photoUrl=null;this.resourceId=null;this.errMsg=null;this.transmission=null;this.delegate=b};xtiger.editor.PhotoState.prototype={READY:0,ERROR:1,UPLOADING:2,COMPLETE:3,isPhotoStateObject:true,setDelegate:function(b){this.delegate=b},getPayload:function(){return this.payload},getDocumentId:function(){return xtiger.session(this.myDoc).load("documentId")},startTransmission:function(f,d,e,b){this.cached=[this.status,this.photoUrl,this.resourceId,this.errMsg];var c=xtiger.factory("upload").getInstance(f);this.myDoc=f;this.transmission=c.getUploader();this.transmission.setDataType(d);if(b){this.transmission.setAction(b)}this.payload=e;this.status=this.UPLOADING;c.startTransmission(this.transmission,this);this.delegate.redraw()},cancelTransmission:function(){if(this.transmission){var b=xtiger.factory("upload").getInstance(this.myDoc);b.cancelTransmission(this.transmission)}},onComplete:function(b){this.status=this.COMPLETE;if(typeof(b)=="string"){this.photoUrl=b;this.resourceId=null}else{this.photoUrl=b.url;this.resourceId=b.resource_id}this.errMsg=null;this.transmission=null;this.delegate.redraw()},onError:function(b,c){this.status=this.ERROR;if(!c){this.photoUrl=null}this.errMsg=b;this.transmission=null;this.delegate.redraw()},onCancel:function(){this.status=this.cached[0];this.photoUrl=this.cached[1];this.resourceId=this.cached[2];this.errMsg=this.cached[3];this.transmission=null;this.delegate.redraw()}};xtiger.editor.Photo=function(c,b){this.curDoc=b;this.handle=c;this.defaultContent=null;this.state=new xtiger.editor.PhotoState(this)};xtiger.editor.Photo.prototype={defaultParams:{trigger:"click"},getParam:function(b){return(this.param&&this.param[b])||this.defaultParams[b]},can:function(b){return typeof this[b]=="function"},execute:function(b,c){return this[b](c)},init:function(f,e,c,b,d){this.defaultContent=f;if(typeof(e)=="object"){this.param=e}this.awake()},awake:function(){this.device=xtiger.factory("lens").getInstance(this.curDoc);var b=this;xtdom.addEventListener(this.handle,"error",function(c){b.state.onError("Broken Image",true)},false);xtdom.addEventListener(this.handle,this.getParam("trigger"),function(c){b.device.startEditing(b,"photo");xtdom.preventDefault(c);xtdom.stopPropagation(c)},false);this._constructStateFromUrl(this.defaultContent);this.redraw(false)},makeSeed:function(){if(!this.seed){var b=xtiger.editor.Plugin.prototype.pluginEditors.photo;this.seed=[b,this.defaultContent,this.param]}return this.seed},_constructStateFromUrl:function(b){this.state.resourceId=null;if(b&&(b.search(/\S/)!=-1)){this.state.status=xtiger.editor.PhotoState.prototype.COMPLETE;this.state.photoUrl=b}else{this.state.status=xtiger.editor.PhotoState.prototype.READY;this.state.photoUrl=null}},_dump:function(){return(this.state.photoUrl)?this.state.photoUrl:""},redraw:function(b){var d;switch(this.state.status){case xtiger.editor.PhotoState.prototype.READY:d=xtiger.bundles.photo.photoIconURL;break;case xtiger.editor.PhotoState.prototype.ERROR:d=xtiger.bundles.photo.photoBrokenIconURL;break;case xtiger.editor.PhotoState.prototype.UPLOADING:d=xtiger.bundles.photo.spiningWheelIconURL;break;case xtiger.editor.PhotoState.prototype.COMPLETE:if(b){var c=this.handle.getAttribute("src");if(c!=this.state.photoUrl){xtiger.editor.Repeat.autoSelectRepeatIter(this.handle)}}d=this.state.photoUrl;break;default:d=xtiger.bundles.photo.photoBrokenIconURL}xtdom.setAttribute(this.handle,"src",d)},load:function(b,c){var d=(b!==-1)?c.getDataFor(b):this.defaultContent;this._constructStateFromUrl(d);if(c.hasAttributeFor("resource_id",b)){var e=c.getAttributeFor("resource_id",b);this.state.resourceId=c.getDataFor(e)}this.redraw(false)},save:function(b){b.write(this._dump());if(this.state.resourceId){b.writeAttribute("resource_id",this.state.resourceId)}},update:function(b){if(b.isPhotoStateObject===undefined){if(b.photoUrl){this._constructStateFromUrl(b.photoUrl);if(b.resource_id){this.state.resourceId=b.resource_id}}else{this._constructStateFromUrl(b)}this.redraw(true)}},getData:function(){return this.state},getFile:function(){return this.file},isFocusable:function(){return false},getHandle:function(){return this.handle},onDragEnter:function(b){xtdom.addClassName(this.handle,"axel-dnd-over");xtdom.stopPropagation(b);xtdom.preventDefault(b)},onDragOver:function(b){xtdom.stopPropagation(b);xtdom.preventDefault(b)},onDragLeave:function(b){xtdom.removeClassName(this.handle,"axel-dnd-over");xtdom.stopPropagation(b);xtdom.preventDefault(b)},onDrop:function(f){var e=f.dataTransfer;var d=e.files;xtdom.stopPropagation(f);xtdom.preventDefault(f);for(var c=0;c<d.length;c++){var b=d[c];var g=/image.*/;if(!b.type.match(g)){continue}this.state.startTransmission(this.curDoc,"dnd",b,this.getParam("photo_URL"))}}};xtiger.editor.PhotoViewer=function(c,g,f,k){var b=this.view=xtdom.createElement(g,"div");xtdom.setAttribute(b,"id","xt-photo");xtdom.addClassName(b,"axel-lens-container");xtdom.addClassName(b,"axel-lens-containerstyle");f.appendChild(this.view);try{var i=xtiger.cross.getXHRObject();i.open("GET",c,false);i.send(null);if((i.status==200)||(i.status==0)){if(i.responseText){b.innerHTML=i.responseText}else{throw {name:"Error",message:"Photo plugin initialization failed : empty lens bundle content"}}}else{throw {name:"Error",message:"Photo plugin initialization failed : HTTP error ("+i.status+")"}}this.formular=g.getElementById("xt-photo-form");this.icon=g.getElementById("xt-photo-icon");this.infobox=g.getElementById("xt-photo-info");this.errorbox=g.getElementById("xt-photo-error");this.filemenu=g.getElementById("xt-photo-form-body");this.btnselfile=g.getElementById("xt-photo-file");this.btnupload=g.getElementById("xt-photo-save");this.btncancel=g.getElementById("xt-photo-cancel");this.result=g.getElementById("xt-photo-target");var j=this;xtdom.addEventListener(this.btnselfile,"click",function(){j.startSelectCb()},false);xtdom.addEventListener(this.btnupload,"click",function(){j.saveCb()},false);xtdom.addEventListener(this.btncancel,"click",function(){j.cancelCb()},false);this.btncancel.style.display="none";this.failed=false;this.hide()}catch(d){this.view.innerHTML="<p>File Upload is not available...<br/><br/>Failed to make lens with '"+c+"'.<br/><br/>"+d.name+" : "+d.message+"</p>";this.failed=true}this.ready();this.wrapper=k};xtiger.editor.PhotoViewer.prototype={showPhoto:function(b){if(this.failed){return}if(this.btnselfile.value.length>0){this.formular.reset()}this.icon.setAttribute("src",b);this.icon.style.visibility="visible";if(b==xtiger.bundles.photo.spiningWheelIconURL){this.btncancel.style.display="block"}else{this.btncancel.style.display="none"}},hideError:function(){if(this.failed){return}this.errorbox.style.display="none"},hideMessage:function(){if(this.failed){return}this.infobox.style.display="none"},showError:function(b){if(this.failed){return}this.errorbox.style.display="block";this.errorbox.firstChild.data=b},showUplButtons:function(){if(this.failed){return}this.filemenu.style.display=""},hideUplButtons:function(){if(this.failed){return}this.filemenu.style.display="none"},hide:function(){this.view.style.display="none"},show:function(){this.view.style.display=""},showMessage:function(b){if(this.failed){return}this.infobox.style.display="block";this.infobox.firstChild.data=b},getTopDiv:function(){return this.view},ready:function(){this.showPhoto(xtiger.bundles.photo.photoIconURL);this.showMessage("You can select a file and upload it");this.hideError();this.showUplButtons()},complete:function(b){this.showPhoto(b);this.hideMessage();this.hideError();this.showUplButtons()},loading:function(){this.showPhoto(xtiger.bundles.photo.spiningWheelIconURL);this.showMessage("Wait while loading");this.hideError();this.hideUplButtons()},error:function(b){this.showPhoto(xtiger.bundles.photo.photoBrokenIconURL);this.showError(b);this.hideMessage();this.showUplButtons()},busy:function(){this.btncancel.style.display="none";this.icon.style.visibility="hidden";this.hideError();this.showMessage("Another upload is in progress, please wait until it finishes.");this.hideUplButtons()},activateUpload:function(){this.btnupload.removeAttribute("disabled")},deactivateUpload:function(){xtdom.setAttribute(this.btnupload,"disabled","true")},startSelectCb:function(){this.wrapper.onStartSelect()},saveCb:function(){if(this.btnselfile.value.length>0){this.wrapper.onStartUpload(this.formular)}},cancelCb:function(){this.wrapper.onCancelUpload()}};xtiger.editor.PhotoWrapper=function(d){this._handle;this._handleToRestore;this.myDoc=d;var c=xtiger.session(d).load("form");var b=(c&&c.getRoot())||d.getElementsByTagName("body")[0];this.view=new xtiger.editor.PhotoViewer(xtiger.bundles.photo.lensBoxURL,d,b,this);this.state=null};xtiger.editor.PhotoWrapper.prototype={isFocusable:function(){return false},getHandle:function(){return this.view.getTopDiv()},getData:function(){return this.state},grab:function(d,b,c){this.device=d;this.editor=d.getCurrentModel();this.state=this.editor.getData();this.state.setDelegate(this);this.redraw();this.view.show();if(c[0]>0){this.view.getTopDiv().style.padding=c[0]+"px"}},activate:function(c,b){},release:function(){this.view.hide();this.device=null;this.state.setDelegate(this.editor);this.editor.redraw(true)},onStartSelect:function(){this.device.mouseMayLeave()},onStartUpload:function(b){this.state.startTransmission(this.myDoc,"upload",b,this.editor.getParam("photo_URL"))},onCancelUpload:function(b){this.state.cancelTransmission()},redraw:function(){var b=xtiger.factory("upload").getInstance(this.myDoc);if(b.isReady()||b.isTransmitting(this.state.transmission)){switch(this.state.status){case xtiger.editor.PhotoState.prototype.READY:this.view.ready();break;case xtiger.editor.PhotoState.prototype.ERROR:this.view.error(this.state.errMsg);break;case xtiger.editor.PhotoState.prototype.UPLOADING:this.view.loading();break;case xtiger.editor.PhotoState.prototype.COMPLETE:this.view.complete(this.state.photoUrl);break;default:this.view.error("Unkown Photo status "+this.state.status);break}}else{this.view.busy()}}};xtiger.editor.Plugin.prototype.pluginEditors.photo=xtiger.util.filterable("photo",xtiger.editor.PhotoFactory);xtiger.resources.addBundle("photo",{photoIconURL:"icons/photo.png",photoBrokenIconURL:"icons/photobroken.png",spiningWheelIconURL:"icons/spiningwheel.gif",lensBoxURL:"photo.xhtml"});xtiger.factory("lens").registerWrapper("photo",function(b){return new xtiger.editor.PhotoWrapper(b)});xtiger.editor.VideoFactory=(function VideoFactory(){var _VideoModel=function(aHandleNode,aDocument){var _DEFAULT_PARAMS={defaultDevice:"lens",trigger:"mouseover",lang:"fr_FR",inputFieldMessage:"Paste the video's link here",width:425,height:344};this._handle=aHandleNode;this._data=null;this._defaultData=this._data;this._noData=this._handle.firstChild;this._document=aDocument;this._params=_DEFAULT_PARAMS;this._isOptional=false;this._isOptionSet=false;this._optCheckBox;this._device=null;this._seed=null;this._isModified=false;this._uniqueKey;this.create()};_VideoModel.prototype={_isValidUrl:function(aInput){var _URL_R=/^(http\:\/\/|~\/|\/)?(\w+:\w+@)?(([-\w\d{1-3}]+\.)+(com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|edu|co\.uk|ac\.uk|it|fr|tv|museum|asia|local|travel|[a-z]{2})?)(?::[\d]{1,5})?(?:(?:(?:\/(?:[-\w~!$+|.,=]|%[a-f\d]{2})+)+|\/)+|\?|#)?(?:(?:[\?&](?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)(?:&(?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)*)*(?:#(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)?(?:&)?$/;return _URL_R.test(aInput)},_removeLTSpaces:function(aInput){if(!aInput||aInput==""){return""}return aInput.replace(/^\s+|\s+$/g,"")},_buildYoutubeSnippet:function(aVideoID,aSize,aParams){var _params=aParams?aParams:{};_params.movie=aVideoID;if(!_params.allowFullScreen){_params.allowFullScreen="true"}if(!_params.alloscriptaccess){_params.alloscriptaccess="always"}var _obj=xtdom.createElement(this._document,"object");if(aSize){_obj.height=aSize[0];_obj.width=aSize[1]}else{_obj.height=this.getParam("height");_obj.width=this.getParam("width")}_obj.style.zIndex=1000;for(var _param in _params){var _p=xtdom.createElement(this._document,"param");_p.name=_param;_p.value=_params[_param];_obj.appendChild(_p)}var _embed=xtdom.createElement(this._document,"embed");xtdom.setAttribute(_embed,"src",aVideoID);xtdom.setAttribute(_embed,"type","application/x-shockwave-flash");xtdom.setAttribute(_embed,"allowfullscreen","true");xtdom.setAttribute(_embed,"allowscriptaccess","always");xtdom.setAttribute(_embed,"width",this.getParam("width"));xtdom.setAttribute(_embed,"height",this.getParam("height"));_embed.style.zIndex=1000;if(xtiger.cross.UA.IE){_obj=_embed}else{_obj.appendChild(_embed)}return _obj},_extractVideoId:function(aValidUrl){var _tmp=aValidUrl.match(/^[^&]*/)[0];return _tmp.match(/[^\=\/]*$/)[0]},_isCodeSnippet:function(aInput){var _SNIPPET_O_R=/(<object>).*(<param[^>]*(name\="movie"))/;var _SNIPPET_E_R=/(<embed\s)([^>]+)(\ssrc\=")([^"]+)"/;return _SNIPPET_O_R.test(aInput)||_SNIPPET_E_R.test(aInput)},_setData:function(aData){var _tdata=this._removeLTSpaces(aData);if(!this._isValidUrl(_tdata)){if(this._isCodeSnippet(_tdata)){_tdata=this._extractUrlFromSnippet(_tdata)}else{return false}}var _type="youtube";switch(_type){case"youtube":var _videoID=this._extractVideoId(_tdata);var _newdata="http://www.youtube.com/v/"+_videoID;if(this._data==_newdata){return false}this._data=_newdata;_newdata+="&hl="+this._params.lang+"&fs=1&";var _newContent=this._buildYoutubeSnippet(this._data,null,null);try{var _tmp=xtdom.createElement(this._document,"div");_tmp.style.visibility="hidden";this._document.getElementsByTagName("body")[0].appendChild(_tmp);_tmp.appendChild(_newContent);with(this._handle.style){width=this.getParam("width")+"px";height=this.getParam("height")+"px"}this._handle.replaceChild(_newContent,this._handle.firstChild);this.setModified(true);xtdom.removeElement(_tmp)}catch(err){xtiger.cross.log("warning",err);return false}break;default:xtiger.cross.log("warning","Video type "+type+" is currently unsupported");return false}return true},create:function(){},init:function(aDefaultData,aParams,aOption,aUniqueKey,aRepeater){if(aParams){if(typeof(aParams)=="string"){xtiger.util.decodeParameters(aParams,this._params)}else{if(typeof(aParams)=="object"){this._params=aParams}}}if(aDefaultData){if(this._isValidUrl(aDefaultData)||this._isCodeSnippet(aDefaultData)){this._setData(aDefaultData);this._defaultData=this._data}else{this._params.inputFieldMessage=aDefaultData}}if(aOption){this._isOptional=true;this._optCheckBox=this._handle.previousSibling;(aOption=="set")?this.set(false):this.unset(false)}this._uniqueKey=aUniqueKey;var _deviceFactory=this._params.device?xtiger.factory(this._params.device):xtiger.factory(this._params.defaultDevice);this._device=_deviceFactory.getInstance(this._document);this.awake()},makeSeed:function(){if(!this._seed){this._seed=[xtiger.editor.VideoFactory,this._defaultData,this._params,this._isOptional]}return this._seed},can:function(aFunction){return typeof this[aFunction]=="function"},execute:function(aFunction,aParam){return this[aFunction](aParam)},load:function(aPoint,aDataSrc){if(aPoint!==-1){var _value=aDataSrc.getDataFor(aPoint);this._setData(_value)||this.clear();this.set(false)}else{this.clear();this.unset(false)}},save:function(aLogger){if(this.isOptional()&&!this._isOptionSet){aLogger.discardNodeIfEmpty();return}if(!this._data){return}aLogger.write(this._data)},update:function(aData){var _success=false;if(aData&&(typeof(aData)=="string")&&(aData.search(/\S/)!=-1)){_success=(aData==this._data)||this._setData(aData)}if(_success){this.set(true)}},clear:function(){this._data="";this.setModified(false);this._handle.replaceChild(this._noData,this._handle.firstChild);var _width=this._noData.offsetWidth;var _height=this._noData.offsetHeight;with(this._handle.style){width=(_width>2?_width:80)+"px";height=(_height>2?_height:80)+"px"}},getData:function(){if(this._data&&this._data!=""){return this._data}return null},getDefaultData:function(){return this._defaultData},getHandle:function(){return this._handle},getDocument:function(){return this._document},getParam:function(aKey){return this._params[aKey]},getUniqueKey:function(){return this._uniqueKey},isModified:function(){return this._isModified},setModified:function(isModified){this._isModified=isModified},isFocusable:function(){return true},focus:function(){this.startEditing(null)},unfocus:function(){this._device.stopEditing()},isOptional:function(){return this._isOptional},isSet:function(){return this._isOptional&&(this._isOptionSet?true:false)},set:function(doPropagate){if(doPropagate){xtiger.editor.Repeat.autoSelectRepeatIter(this.getHandle())}if(this._isOptional&&!this._isOptionSet){this._isOptionSet=true;xtdom.removeClassName(this._handle,"axel-option-unset");xtdom.addClassName(this._handle,"axel-option-set");this._optCheckBox.checked=true}},unset:function(doPropagate){if(this._isOptional&&this._isOptionSet){this._isOptionSet=false;xtdom.removeClassName(this._handle,"axel-option-set");xtdom.addClassName(this._handle,"axel-option-unset");this._optCheckBox.checked=false}},awake:function(){var _this=this;if(this.isOptional()){xtdom.addEventListener(this._optCheckBox,"click",function(ev){_this.onToggleOpt(ev)},true)}xtdom.addEventListener(this._handle,"mouseover",function(ev){_this.startEditing(ev)},true)},startEditing:function(aEvent){var _doSelect=aEvent?(!this._isModified||aEvent.shiftKey):false;this._device.startEditing(this,"videoLensWrapper",_doSelect)},stopEditing:function(){this._device.stopEditing()},onToggleOpt:function(ev){this._isOptionSet?this.unset(true):this.set(true)}};var _BASE_KEY="video";var _keyCounter=0;return{createModel:function createModel(aContainer,aXTUse,aDocument){var _h=xtdom.createElement(aDocument,"div");xtdom.addClassName(_h,"axel-core-on");xtdom.addClassName(_h,"axel-core-editable");var _img=xtdom.createElement(aDocument,"img");_img.src=xtiger.bundles.video.tvIconURL;var _optional=aXTUse.getAttribute("option");if(_optional){var _checkbox=xtdom.createElement(aDocument,"input");xtdom.setAttribute(_checkbox,"type","checkbox");xtdom.addClassName(_checkbox,"axel-option-checkbox");aContainer.appendChild(_checkbox)}_h.appendChild(_img);var _tmp=xtdom.createElement(aDocument,"div");_tmp.style.visibility="hidden";aDocument.getElementsByTagName("body")[0].appendChild(_tmp);_tmp.appendChild(_h);var _width,_height;_width=_img.offsetWidth;_height=_img.offsetHeight;_h.style.width=(_width>2?_width:80)+"px";_h.style.height=(_height>2?_height:80)+"px";aContainer.appendChild(_h);xtdom.removeElement(_tmp);return _h},createEditorFromTree:function createEditorFromTree(aHandleNode,aXTUse,aDocument){var _model=new _VideoModel(aHandleNode,aDocument);var _data,_cur;_cur=aXTUse.firstChild;while(_cur&&!_data){switch(_cur.nodeType){case aDocument.TEXT_NODE:if((/\w+/).test(_cur.nodeValue)){var _data=_cur.nodeValue}break;case aDocument.ELEMENT_NODE:if(_cur.localName="object"){var _data=_cur}}_cur=_cur.nextSibling}var _param={};xtiger.util.decodeParameters(aXTUse.getAttribute("param"),_param);if(_param.filter){_model=this.applyFilters(_model,_param.filter)}_model.init(_data,aXTUse.getAttribute("param"),aXTUse.getAttribute("option"),this.createUniqueKey());return _model},createEditorFromSeed:function createEditorFromSeed(aSeed,aClone,aDocument,aRepeater){var _model=new _VideoModel(aClone,aDocument);var _defaultData=aSeed[1];var _param=aSeed[2];var _option=aSeed[3];if(_param.filter){_model=this.applyFilters(_model,_param.filter)}_model.init(_defaultData,_param,_option,this.createUniqueKey(),aRepeater);return _model},createUniqueKey:function createUniqueKey(){return _BASE_KEY+(_keyCounter++)}}})();xtiger.resources.addBundle("video",{tvIconURL:"tv.png"});xtiger.editor.Plugin.prototype.pluginEditors.video=xtiger.util.filterable("video",xtiger.editor.VideoFactory);var _VideoLensWrapper=function(b){this._handle;this._handleToRestore;this._document=b;this._isFocused=false;this._loaded=false;this.build()};_VideoLensWrapper.prototype={build:function(){this._topdiv=xtdom.createElement(this._document,"div");xtdom.addClassName(this._topdiv,"axel-lens-container");with(this._topdiv){style.display="none";style.minWidth="200px"}var _innerHTML="";_innerHTML+='<div style="background: none; position: relative"> </div>';_innerHTML+='<div class="axel-lens-containerstyle" style="width: 410px; padding: 5px; position: relative">';_innerHTML+='<p style="';_innerHTML+="display: none; font-size: 7pt; cursor: pointer; ";_innerHTML+="text-decoration:underline; text-align: right; margin: 0;";_innerHTML+='">delete</p>';_innerHTML+="<div>";_innerHTML+='<label for="videolensinput" style="display: block">Paste url here</label>';_innerHTML+='<input type="text" name="videolensinput" value="" style="width: 90%"></input>';_innerHTML+="</div>";_innerHTML+='<div style="text-align: center">';_innerHTML+="<button>Cancel</button>";_innerHTML+="<button>Save</button>";_innerHTML+="</div></div>";this._topdiv.innerHTML=_innerHTML;this._maskdiv=this._topdiv.firstChild;this._contentdiv=this._maskdiv.nextSibling;this._deletespan=this._contentdiv.firstChild;this._inputdiv=this._deletespan.nextSibling;this._input=this._inputdiv.firstChild.nextSibling;this._buttondiv=this._inputdiv.nextSibling;this._cancelbutton=this._buttondiv.firstChild;this._savebutton=this._buttondiv.firstChild.nextSibling;var _this=this;this._handlers={clearModel:[this._deletespan,"click",function(ev){_this.clearModel()}],onInputBlur:[this._input,"blur",function(ev){_this._onInputBlur(ev)}],onInputFocus:[this._input,"focus",function(ev){_this._onInputFocus(ev)}],onInputKeyDown:[this._input,"keydown",function(ev){_this._onInputKeyDown(ev)}],onInputKeyUp:[this._input,"keyup",function(ev){_this._onInputKeyUp(ev)}],onCancel:[this._cancelbutton,"click",function(ev){_this._onCancel(ev)}],onSave:[this._savebutton,"click",function(ev){_this._onSave(ev)}]}},grab:function(aDevice,aDoSelect,aPadding){if(this._currentDevice){this.release()}this._currentDevice=aDevice;var _handle=this._currentDevice.getCurrentModel().getHandle();_pad=(aPadding[0]>=10)?aPadding[0]:10;var _width=_handle.offsetWidth;var _height=_handle.offsetHeight;if(xtiger.cross.UA.IE){_width+=2*_pad;_height+=2*_pad}with(this._topdiv.style){display="block";width=_width+"px";padding=_pad+"px"}with(this._maskdiv.style){border=""+_pad+"px solid rgb(115, 166, 42)";width=_width+"px";height=_height+"px";if(!xtiger.cross.UA.IE){left="-"+_pad+"px";top="-"+_pad+"px"}}with(this._contentdiv.style){if(!xtiger.cross.UA.IE){left="-"+_pad+"px";top="-"+_pad+"px"}}this._cancelbutton.disabled=false;this._savebutton.disabled=true;if(this._currentDevice.getCurrentModel().isModified()){this.setData(this._currentDevice.getCurrentModel().getData());this._deletespan.style.display="block";this._loaded=true}else{var _message=this._currentDevice.getCurrentModel().getParam("inputFieldMessage");this.setData(_message);this._loaded=false}for(var k in this._handlers){xtdom.addEventListener(this._handlers[k][0],this._handlers[k][1],this._handlers[k][2],true)}},activate:function(c,b){},release:function(){if(!this._currentDevice){return}for(var b in this._handlers){xtdom.removeEventListener(this._handlers[b][0],this._handlers[b][1],this._handlers[b][2],true)}this._deletespan.style.display="none";this._currentDevice=null;xtdom.removeElement(this._topdiv)},getHandle:function(){return this._topdiv},getData:function(){return this._input.value},setData:function(b){this._input.value=(b&&typeof(b)=="string")?b:""},isFocusable:function(){return true},clearModel:function(){if(!this._currentDevice){return}this._input.value="";this._currentDevice.getCurrentModel().clear();this._currentDevice.keepAlive(false);this._currentDevice.getCurrentModel().unfocus()},toggleField:function(){},_onInputBlur:function(b){this._currentDevice.keepAlive(false)},_onInputFocus:function(c){if(this._loaded){var b=0;var e=this._input.value.length;if(this._input.setSelectionRange){this._input.setSelectionRange(b,e)}else{if(this._input.createTextRange){var d=this._input.createTextRange();d.moveStart("character",b);d.moveEnd("character",e);d.select()}}}else{this._input.value=""}this._currentDevice.keepAlive(true)},_onInputKeyDown:function(b){this._savedValue=this._input.value},_onInputKeyUp:function(b){if(this._input.value!=this._savedValue){this._cancelbutton.disabled=false;this._savebutton.disabled=false}},_onCancel:function(b){if(!this._currentDevice){return}this._currentDevice.cancelEditing();xtdom.stopPropagation(b)},_onSave:function(b){if(!this._currentDevice){return}this._currentDevice.stopEditing();xtdom.stopPropagation(b)}};xtiger.factory("lens").registerWrapper("videoLensWrapper",function(b){return new _VideoLensWrapper(b)});xtiger.service.ServiceFilter=(function _ServiceFilter(){var d=function d(t){var u=t.target.previousSibling;var s=u?u.xttPrimitiveEditor:undefined;if(s){var q=s.getData();var r=s._getServiceKey();if(r.producer){s._notifyServices(r.producer,"notifyUpdate",s.getHandle(true),q);if(s._serviceHookFlag){m(s);s._serviceHookFlag=false}}}else{xtiger.cross.log("error","canno't find source editor in service trigger callback")}};var b=function b(q){h=q.getHandle(true);trigger=h?h.nextSibling:undefined;if(trigger&&trigger.className&&(trigger.className.search("axel-service-trigger")!=-1)){return trigger}};var j=function j(t){var u,s,r=t.getHandle(true),q=b(t);if(q){xtdom.removeClassName(q,"axel-core-off")}else{q=xtdom.createElement(t.getDocument(),"input");q.setAttribute("type","button");q.setAttribute("value",t.getParam("service_label")||"suggest");xtdom.addClassName(q,"axel-service-trigger");u=xtdom.createElement(t.getDocument(),"span");xtdom.addClassName(u,"axel-core-boundary");s=r.parentNode;if(r.nextSibling){s.insertBefore(u,r.nextSibling,true);s.insertBefore(q,u,true)}else{s.appendChild(q);s.appendChild(u)}xtdom.addEventListener(q,"click",d,false)}};var m=function m(r){var q=b(r);if(q){xtdom.addClassName(q,"axel-core-off")}};var l=function l(r,s){var q=r.getParam("service_trigger");return(q&&(q.indexOf(s)!=-1))||((!q)&&(s=="update"))||((q&&(q.indexOf("load")!=-1))&&(s=="update"))};var o=function o(r,q,w,u,t){var v=q.getKey();if(v){for(var s=0;s<u.length;s++){if(u[s].key==v){q[w](r,u[s].resource,t)}}}};return{"->":{init:"__serviceSuperInit",update:"__serviceSuperUpdate",remove:"__serviceSuperRemove",load:"__serviceSuperLoad"},_notifyServices:function i(s,y,u,t){var v;var w=u;var q=0;var x=0;while(w){if(w.xttService&&w.xttService[y]){o(this,w.xttService,y,s,t)}if(w.startRepeatedItem){q++}if((w!=u)&&w.endRepeatedItem){x++}if(q>x){v=w.startRepeatedItem;w=v.getFirstNodeForSlice(0);q=x=0}w=w.previousSibling}if(u.parentNode){this._notifyServices(s,y,u.parentNode,t)}},_getServiceKey:function k(){var s=this.getParam("service_key");var u=s.split(" ");var r={};for(var t=0;t<u.length;t++){var q=u[t].match(/^([\w-_]+):(\w+)\[(.*)\]$/);var v=q[2];if(v){if(!r[v]){r[v]=[]}r[v].push({key:q[1],resource:q[3]})}}return r},checkServiceKey:function c(s,t){var q=this._getServiceKey();if(q.consumer){for(var r=0;r<q.consumer.length;r++){if((s==q.consumer[r].key)&&(t==q.consumer[r].resource)){return true}}}return false},init:function p(w,v,s,r,u){var t,q;this.__serviceSuperInit(w,v,s,r,u);if(u){t=this._getServiceKey();if(t.consumer){this._notifyServices(t.consumer,"askUpdate",u.getFirstNodeForSlice(0))}}else{t=this._getServiceKey();if(t.producer&&l(this,"button")){j(this)}}},duplicate:function g(s){var q,r=this._getServiceKey();if(r&&r.producer){q=b(this);if(q){xtdom.addEventListener(q,"click",d,false)}}},update:function e(r,t){var s=this._getServiceKey();var q=(r!=this.getData());if(q&&(l(this,"update")||l(this,"auto"))){if(s.producer||s.configurator){if(t){}else{if(s.producer){this._notifyServices(s.producer,"notifyUpdate",this.getHandle(true),r)}else{if(s.configurator){this._notifyServices(s.configurator,"configure",this.getHandle(true),r)}}}}if(this._serviceHookFlag){m(this);this._serviceHookFlag=false}}this.__serviceSuperUpdate(r)},load:function n(s,r){var q;this.__serviceSuperLoad(s,r);if(l(this,"auto")){j(this);this._serviceHookFlag=true}else{if(l(this,"load")){q=this._getServiceKey();if(q.producer){this._notifyServices(q.producer,"notifyLoad",this.getHandle(true),this.getData())}else{if(q.consumer){this._notifyServices(q.consumer,"askUpdate",this.getHandle(true))}}}}},remove:function f(){var q=this._getServiceKey();if(q.producer){this._notifyServices(q.producer,"notifyRemove",this.getHandle(true),this.getData())}this.__serviceSuperRemove()}}})();xtiger.editor.Plugin.prototype.pluginEditors.video.registerFilter("service",xtiger.service.ServiceFilter);xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("service",xtiger.service.ServiceFilter);xtiger.editor.Plugin.prototype.pluginEditors.richtext.registerFilter("service",xtiger.service.ServiceFilter);xtiger.editor.Plugin.prototype.pluginEditors.link.registerFilter("service",xtiger.service.ServiceFilter);xtiger.editor.Plugin.prototype.pluginEditors.photo.registerFilter("service",xtiger.service.ServiceFilter);xtiger.editor.Plugin.prototype.pluginEditors.select.registerFilter("service",xtiger.service.ServiceFilter);var _NoXMLFilter=(function _NoXMLFilter(){return{"->":{},load:function(b,c){},save:function(b){}}})();xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("noxml",_NoXMLFilter);xtiger.editor.Plugin.prototype.pluginEditors.select.registerFilter("noxml",_NoXMLFilter);var _DebugFilter=(function _DebugFilter(){function j(t,s,w,u){var v="";v+="["+t.getUniqueKey()+"]";v+=" : "+s;v+="(";if(w){v+=w}v+=")";if(u){v+=" : "+u}xtiger.cross.log("debug",v)}function d(u){var s="[";for(var t=0;t<u.length;t++){s+=u[t]+", "}return s}return{"->":{create:"__debugSuperCreate",init:"__debugSuperInit",load:"__debugSuperLoad",save:"__debugSuperSave",update:"__debugSuperUpdate",clear:"__debugSuperClear",getData:"__debugSuperGetData",focus:"__debugSuperFocus",unfocus:"__debugSuperUnfocus",set:"__debugSuperSet",unset:"__debugSuperUnset",awake:"__debugSuperAwake",startEditing:"__debugSuperStartEditing",stopEditing:"__debugSuperStopEditing"},create:function g(){j(this,"create");this.__debugSuperCreate()},init:function p(w,v,u,t){var s=""+w;if(typeof v=="string"){s+=v}else{s+=", "+d(v)}s+=", "+u;s+=", "+t;j(this,"init",s);this.__debugSuperInit(w,v,u,t)},load:function n(t,s){j(this,"load");this.__debugSuperLoad(t,s)},save:function k(s){j(this,"save");this.__debugSuperSave(s)},update:function e(s){j(this,"update",s,"Old data = "+this.__debugSuperGetData());this.__debugSuperUpdate(s)},clear:function i(){j(this,"clear",null,"Old data = "+this.__debugSuperGetData());this.__debugSuperClear()},getData:function f(){j(this,"getData");return this.__debugSuperGetData()},focus:function r(){j(this,"focus");this.__debugSuperFocus()},unfocus:function b(){j(this,"unfocus");this.__debugSuperUnocus()},set:function m(){if(this.isOptional()){j(this,"set")}else{j(this,"set",null,"Warning, thring to set a non-optional editor")}this.__debugSuperSet()},unset:function o(){if(this.isOptional()){j(this,"unset")}else{j(this,"unset",null,"Warning, thring to unset a non-optional editor")}this.__debugSuperUnet()},awake:function q(){j(this,"awake");this.__debugSuperAwake()},startEditing:function l(s){j(this,"startEditing");this.__debugSuperStartEditing(s)},stopEditing:function c(){j(this,"stopEditing");this.__debugSuperStopEditing()}}})();xtiger.editor.Plugin.prototype.pluginEditors.video.registerFilter("debug",_DebugFilter);xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("debug",_DebugFilter);xtiger.editor.Plugin.prototype.pluginEditors.richtext.registerFilter("debug",_DebugFilter);xtiger.editor.Plugin.prototype.pluginEditors.link.registerFilter("debug",_DebugFilter);var _DocumentIdFilter=(function _DocumentIdFilter(){return{"->":{_setData:"__DocumentIdSuperSetData"},_setData:function(b){this.__DocumentIdSuperSetData(b);xtiger.session(this.getDocument()).save("documentId",b)}}})();xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("documentId",_DocumentIdFilter);var _ImageFilter=(function _ImageFilter(){function f(i,l){var g=i.getHandle();var j=i.getParam("base");xtdom.removeChildrenOf(g);var k=xtdom.createElement(i.getDocument(),"img");xtdom.setAttribute(k,"src",j?j+l:l);xtdom.setAttribute(k,"alt","image "+l);g.appendChild(k)}function c(j){var g;var i=j.getHandle();var k=j.getParam("base");var l=i.firstChild;if(l.nodeType!=xtdom.TEXT_NODE){g=l.getAttribute("src")}else{g=l.data}return(k&&(g.indexOf(k)!=-1))?g.substr(k.length,g.length):g}function d(g){var i=g.dataTransfer.types.contains("text/uri-list");if(i){xtdom.preventDefault(g);xtdom.stopPropagation(g)}}function b(g){xtdom.preventDefault(g);xtdom.stopPropagation(g)}function e(j){var k=false;var g=j.target.xttPrimitiveEditor||j.target.parentNode.xttPrimitiveEditor;if(g){var i=j.dataTransfer.getData("URL");if(i.search(/(png|jpg|jpeg|gif)$/i)!=-1){g.update(i)}else{xtiger.cross.log("warning","Not a supported image link (must end with png, jpg, jpeg or gif) !\n")}}xtdom.stopPropagation(j);xtdom.preventDefault(j)}return{"->":{awake:"__ImageSuperAwake",update:"__ImageSuperUpdate",_setData:"__ImageSuperSetData",load:"__ImageSuperLoad"},_setData:function(g){if(g.search(/(png|jpg|jpeg|gif)$/i)!=-1){f(this,g)}else{var j=this.getHandle();if(j.firstChild.nodeType!=xtdom.TEXT_NODE){xtdom.removeChildrenOf(j);var i=xtdom.createTextNode(this.getDocument(),"");j.appendChild(i)}this.__ImageSuperSetData(g)}},update:function(g){if((g.search(/\S/)!=-1)&&(g!==this.getDefaultData())&&(g.search(/(png|jpg|jpeg|gif)$/i)==-1)){this.__ImageSuperUpdate("Not a supported image file (must end with png, jpg, jpeg or gif)")}else{this.__ImageSuperUpdate(g)}},awake:function(){this.__ImageSuperAwake();var g=this.getHandle();xtdom.addEventListener(g,"dragenter",d,false);xtdom.addEventListener(g,"dragover",b,false);xtdom.addEventListener(g,"drop",e,true)},load:function(g,i){var j;var k=g[0];j=g[0].getAttribute(this.getParam("image-tag")||"Source");if((!j)||(j.search(/(png|jpg|jpeg|gif)$/i)==-1)){this.__ImageSuperLoad(g,i)}else{f(this,j);this.setModified(true);this.set(false)}},save:function(g){var i=c(this);g.openAttribute(this.getParam("image-tag")||"Source");g.write(i);g.closeAttribute(this.getParam("image-tag")||"Source")},getData:function(){return c(this)}}})();xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("image",_ImageFilter);var _ClearFilter=(function _ClearFilter(){var b=function b(d,f,e){var g=d;for(var c=e;c>0;c--){g=g.parentNode}if((f=="both")||(f=="left")||(f=="right")){g.style.clear=f}else{g.style.clear=""}};return{"->":{load:"__ClearSuperLoad",update:"__ClearSuperUpdate"},load:function(c,d){var f;if(!d.isEmpty(c)){f=d.getDataFor(c);var e=parseInt(this.getParam("clear"));b(this.getHandle(),f,e)}this.__ClearSuperLoad(c,d)},update:function(d){var c=parseInt(this.getParam("clear"));b(this.getHandle(true),d,c);this.__ClearSuperUpdate(d)}}})();xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("clear",_ClearFilter);var _PositionFilter=(function _PositionFilter(){var b=function b(d,e){var f=d.parentNode.parentNode.parentNode;var c=f.parentNode.getElementsByTagName("span")[0];if((e=="left")||(e=="right")){f.style.cssFloat=c.style.cssFloat=e;if(e=="right"){f.style.marginLeft="20px";f.style.marginRight=""}else{f.style.marginRight="20px";f.style.marginLeft=""}}else{f.style.cssFloat=c.style.cssFloat="";f.style.marginRight="";f.style.marginLeft=""}};return{"->":{load:"__PositionSuperLoad",update:"__PositionSuperUpdate"},load:function(c,d){var e;if(!d.isEmpty(c)){e=d.getDataFor(c);b(this.getHandle(),e)}this.__PositionSuperLoad(c,d)},update:function(c){b(this.getHandle(true),c);this.__PositionSuperUpdate(c)}}})();xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("position",_PositionFilter);var _VideoFilter=(function _VideoFilter(){var d=function d(e){var f=e.match(/^[^&]*/)[0];return f.match(/[^\=\/]*$/)[0]};var b=function b(f,m,g,n){var l=g||{};l.movie=f;if(!l.allowFullScreen){l.allowFullScreen="true"}if(!l.alloscriptaccess){l.alloscriptaccess="always"}var j=xtdom.createElement(n,"object");if(m){j.height=m[0];j.width=m[1]}else{j.height=344;j.width=425}j.style.zIndex=1000;for(var i in l){var e=xtdom.createElement(n,"param");e.name=i;e.value=l[i];j.appendChild(e)}var k=xtdom.createElement(n,"embed");xtdom.setAttribute(k,"src",f);xtdom.setAttribute(k,"type","application/x-shockwave-flash");xtdom.setAttribute(k,"allowfullscreen","true");xtdom.setAttribute(k,"allowscriptaccess","always");xtdom.setAttribute(k,"width","425");xtdom.setAttribute(k,"height","344");k.style.zIndex=1000;if(xtiger.cross.UA.IE){j=k}else{j.appendChild(k)}return j};var c=function c(g){var f=g.getHandle(true);var i=f.nextSibling?f.nextSibling.nextSibling:undefined;var j=false;if(i){var e=xtdom.getLocalName(i);if((e.toLowerCase()=="object")||(e.toLowerCase()=="embed")){j=true}else{if(e.toLowerCase()!="img"){i=undefined}}}return[i,j]};return{"->":{init:"__videoSuperInit",set:"__videoSuperSet",unset:"__videoSuperUnset",_setData:"__videoSuperSetData"},_setData:function(k){var m=c(this);var f=k;if(m[0]){if(k!=this.getDefaultData()){var j=this.getData();var g=d(k);var i="http://www.youtube.com/v/"+g;if(j!=i){var l=b(i,null,null,this.getDocument());m[0].parentNode.replaceChild(l,m[0]);f=i}}else{if(m[1]){var e=xtdom.createElement(this.getDocument(),"img");e.src=xtiger.bundles.video.tvIconURL;m[0].parentNode.replaceChild(e,m[0])}}}this.__videoSuperSetData(f)},init:function(k,e,f,n,l){if(!l){var i=this.getHandle();var o=xtdom.createElement(this.getDocument(),"br");var g=xtdom.createElement(this.getDocument(),"img");var j=xtdom.createElement(this.getDocument(),"span");xtdom.addClassName(j,"axel-core-boundary");g.src=xtiger.bundles.video.tvIconURL;var m=i.parentNode;if(i.nextSibling){m.insertBefore(j,i.nextSibling,true);m.insertBefore(g,j,true);m.insertBefore(o,g,true)}else{m.appendChild(o);m.appendChild(g);m.appendChild(j)}}this.__videoSuperInit(k,e,f,n)},set:function(f){this.__videoSuperSet(f);if(this.isOptional()){var e=this.getHandle(true);if(e.nextSibling&&e.nextSibling.nextSibling){xtdom.replaceClassNameBy(e.nextSibling.nextSibling,"axel-option-unset","axel-option-set")}}},unset:function(f){this.__videoSuperUnset(f);if(this.isOptional()){var e=this.getHandle(true);if(e.nextSibling&&e.nextSibling.nextSibling){xtdom.replaceClassNameBy(e.nextSibling.nextSibling,"axel-option-set","axel-option-unset")}}}}})();xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("video",_VideoFilter);var _WikiFilter=(function _WikiFilter(){var n="\\*|'";var o=new RegExp("(http://[\\.\\w/\\-\\?\\=_&;#]*)\\[([^\\]]*)\\]|("+n+"){2}(.*?)\\3{2}","g");var g={html:{Fragment:"span",FragmentKind:"class",Link:"a"},"default":{Fragment:"Fragment",FragmentKind:"FragmentKind",Link:"Link"}};var f={em:"important",tt:"verbatim",important:"em",verbatim:"tt","*":"em","'":"tt"};var l={em:"**",tt:"''"};var s=function s(A,x,y,w,z){if(x){return"<a href='"+xtiger.util.encodeEntities(x)+"' target='_blank'>"+xtiger.util.encodeEntities(y)+"</a>"}else{if(w){var u=f[w];var v=f[u];return"<"+u+' class="'+v+'">'+xtiger.util.encodeEntities(z)+"</"+u+">"}}};var d=function d(u){var w=[];var y=u.childNodes;for(var v=0;v<y.length;v++){var x=y.item(v);if(x.nodeType==xtdom.ELEMENT_NODE){w.push(x)}}return w};var j=function j(x,w,z,v){var u;var y=x;var B=w.firstChild?w.firstChild.nodeValue:"";var A=w.getAttribute(g[v]["FragmentKind"]);var C=A?f[A]:null;if(C){u=xtdom.createElement(z,C);xtdom.setAttribute(u,"class",A);y.appendChild(u);y=u}if(y.lastChild&&(y.lastChild.nodeType==xtdom.TEXT_NODE)){y.lastChild.appendData(B)}else{u=xtdom.createTextNode(z,B);y.appendChild(u)}};var m=function m(x,B,y,w){var C,u;if(w=="html"){C=B;u=B.getAttribute("href")}else{var D=d(B);var v=xtdom.getLocalName(D[0]);var F=iref=0;if(v=="LinkText"){iref=1}else{F=1}C=D[F];u=D[iref].firstChild?D[iref].firstChild.nodeValue:""}var E=xtdom.createElement(y,"a");var A=C.firstChild?C.firstChild.nodeValue:"url";var z=xtdom.createTextNode(y,A);E.appendChild(z);E.setAttribute("href",u);x.appendChild(E)};c=function c(A,z,u,x){var v;var y=d(z);for(var w=0;w<y.length;w++){v=xtdom.getLocalName(y[w]);if(v==g[x]["Fragment"]){j(A,y[w],u,x)}else{if(v==g[x]["Link"]){m(A,y[w],u,x)}}}};q=function q(v){var u="popupdevice";var w=xtiger.session(v).load(u);if(!w){w=new xtiger.editor.PopupDevice(v);xtiger.session(v).save(u,w)}return w};return{"->":{load:"_wikiSuperLoad",startEditing:"_wikiSuperStartEditing"},_setData:function b(u){try{this.getHandle().innerHTML=xtiger.util.encodeEntities(u).replace(o,s)}catch(v){xtiger.cross.log("error","Exception "+v.name+"\n"+v.message);try{this.getHandle().innerHTML=xtiger.util.encodeEntities(u)+" (Exception : "+v.name+" - "+v.message+")"}catch(v){}}},load:function i(w,v){if(v.isEmpty(w)){this._wikiSuperLoad(w,v)}else{var u=this.getHandle();xtdom.removeChildrenOf(u);c(u,w[0],this.getDocument(),this.getParam("wiki_lang")||"default");this.setModified(true);this.set(false)}},save:function p(v){if(this.isOptional()&&!this._isOptionSet){v.discardNodeIfEmpty();return}var y,x,w,u;var A=this.getParam("wiki_lang")||"default";var z=this.getHandle().firstChild;while(z){if(z.nodeType==xtdom.ELEMENT_NODE){y=xtdom.getLocalName(z);u=f[y];if(u){if(z.firstChild){v.openTag(g[A]["Fragment"]);v.openAttribute(g[A]["FragmentKind"]);v.write(u);v.closeAttribute(g[A]["FragmentKind"]);v.write(z.firstChild.data);v.closeTag(g[A]["Fragment"])}}else{if(y=="a"){x=(z.firstChild)?z.firstChild.data:"null";w=z.getAttribute("href")||"null";v.openTag(g[A]["Link"]);if(A=="html"){v.write(x);v.openAttribute("href");v.write(w);v.closeAttribute("href")}else{v.openTag("LinkText");v.write(x);v.closeTag("LinkText");v.openTag("LinkRef");v.write(w);v.closeTag("LinkRef")}v.closeTag(g[A]["Link"])}}}else{if(z.data&&(z.data.search(/\S/)!=-1)){v.openTag(g[A]["Fragment"]);v.write(z.data);v.closeTag(g[A]["Fragment"])}}z=z.nextSibling}},getData:function k(){var v,u;var w="";var x=this.getHandle().firstChild;while(x){if(x.nodeType==xtdom.ELEMENT_NODE){v=xtdom.getLocalName(x);u=l[v];if(u){if(x.firstChild){w+=u+x.firstChild.data+u}}else{if(v=="a"){w+=(x.getAttribute("href")||"")+"["+(x.firstChild?x.firstChild.data:"null")+"]"}}}else{w+=x.data}x=x.nextSibling}return w},startEditing:function t(x,y){if(x){var w=xtdom.getEventTarget(x);var v=xtdom.getLocalName(w);if(/^a$/i.test(v)){xtdom.preventDefault(x);xtdom.stopPropagation(x);var u=q(this.getDocument());this._url=w.getAttribute("href");if((!this._url)||(this._url=="")){this._url=w.getAttribute("HREF")}u.startEditing(this,["edit","open"],"edit",w);return}}this._wikiSuperStartEditing(x,y)},onMenuSelection:function r(u){if(u=="edit"){this._wikiSuperStartEditing()}else{if(u=="open"){window.open(this._url)}}},setSelectionState:function e(u){u?this.set():this.unset()}}})();xtiger.editor.Plugin.prototype.pluginEditors.text.registerFilter("wiki",_WikiFilter);xtiger.service.ServiceFactory=(function _ServiceFactory(){var i=function(s,t,n,o,m,v){var j,q,l=m,u=0,p=0,k={key:s.getKey(),resource:n};while(l){q=l.xttPrimitiveEditor;if(q){v(s,t,n,o,q)}if(l.firstChild){i(s,t,n,o,l.firstChild,v)}if(l.endRepeatedItem){p++}if((l!=m)&&l.startRepeatedItem){u++}if(p>u){return}l=l.nextSibling}};var c=function(s,n,o,m){var k;var l=m;var t=0;var p=0;var j=s.getKey();while(l){var q=l.xttPrimitiveEditor;if(q&&q.checkServiceKey){if(q.checkServiceKey(j,n)){s.onBroadcast(q,n,o)}}if(l.firstChild){c(s,n,o,l.firstChild)}if(l.endRepeatedItem){p++}if((l!=m)&&l.startRepeatedItem){t++}if(p>t){return}l=l.nextSibling}};var d=function(u,n,k,r){var j=k;var s=0;var o=0;while(j){var q=j.xttPrimitiveEditor;if(q){var p=q.getParam("service_key");if(p&&p!=""){var t=p.split(" ");for(var m=0;m<t.length;m++){var l=t[m].match(/^([\w-_]+):(\w+)\[(.*)\]$/);if(l[1]==u&&(!n||l[2]==n)&&!xtiger.util.array_contains(r,l[3])){r.push(l[3])}}}}if(j.firstChild){d(u,n,j.firstChild,r)}if(j.endRepeatedItem){o++}if((j!=k)&&j.startRepeatedItem){s++}if(o>s){return}j=j.nextSibling}};var g=function(k,j){var l={};this._handle=k;this._document=j;this._params=l;this._key;this._cache=undefined;this._types};g.prototype={getKey:function(){return this._key},getHandle:function(){return this._handle},getParam:function(j){return this._params[j]},init:function(j,m,k,l){this._types=j;if(m){this._defaultData=m}this._key=k;if(l){if(typeof(l)=="string"){xtiger.util.decodeParameters(l,this._params)}else{if(typeof(l)=="object"){this._params=l}}}},makeSeed:function(){return[xtiger.factory("service"),this._types,this._defaultData,this._key,this._params]},_apply:function(k,j,l,m,n){i(this,k,j,l,m,n)},_broadcast:function(j,k,l){c(this,j,k,l)},_collectRegistrations:function(j){var k=[];d(this.getKey(),j,this.getHandle(),k);return k},configure:function(l,j,k){this._params[j]=k},notifyLoad:function(k,j,l){this._cache={resource:j,data:l}},notifyUpdate:function(k,j,l){this._cache={resource:j,data:l};this._broadcast(j,l,this.getHandle())},askUpdate:function(k,j){if(this._cache&&this._cache.resource==j){this.onBroadcast(k,this._cache.resource,this._cache.data)}},notifyRemove:function(k,j,l){},onBroadcast:function(l,j,k){}};return{createModel:function b(k,m,j){var l=xtdom.createElement(j,"span");xtdom.addClassName(l,"axel-service-handle");k.appendChild(l);return l},createServiceFromTree:function e(l,m,j){var k=new g(l,j);var n=m.getAttribute("types");k=this.applyFilters(k,n);k.init(n,undefined,m.getAttribute("key"),m.getAttribute("param"));return k},createServiceFromSeed:function f(m,k,l,o){var r=new g(k,l);var p=m[1];var n=m[2];var j=m[3];var q=m[4];r=this.applyFilters(r,p);r.init(p,n,j,q);return r}}})();xtiger.registry.registerFactory("service",xtiger.util.filterable("service",xtiger.service.ServiceFactory));var _CopyService=(function(){return{"->":{onBroadcast:"__copySuperBroadcast"},onBroadcast:function(b,d,c){b.update(c,true);this.__copySuperBroadcast(b,d,c)}}})();xtiger.factory("service").registerDelegate("copy",_CopyService);var _CopyCondService=(function(){var b=function(f,c,i,e,d){var g;if(d==c){return}if(d.checkServiceKey(f.getKey(),i+"(floor)")){g=parseInt(d.getData());if(isNaN(g)||(e<g)){d.update(e.toString(),true)}}else{if(d.checkServiceKey(f.getKey(),i+"(ceiling)")){g=parseInt(d.getData());if(isNaN(g)||(e>g)){d.update(e.toString(),true)}}}};return{"->":{},notifyUpdate:function(c,f,e){var d=parseInt(e);if(!isNaN(d)){this._apply(c,f,d,this.getHandle(),b)}}}})();xtiger.factory("service").registerDelegate("copycond",_CopyCondService);var _DateService=(function(){var g=function(n,m,j,l){var k="("+n+")";m._broadcast("Day"+k,j.Day,l);m._broadcast("Month"+k,j.Month,l);m._broadcast("Year"+k,j.Year,l)};var i=function(j){return(j.Day&&j.Month&&j.Year)};var e=function(k,j){j.Day=k.Day;j.Month=k.Month;j.Year=k.Year};var d=function(j){xtiger.cross.log("debug",j.Day+"/"+j.Month+"/"+j.Year)};var c=function(k,j){return i(k)&&i(j)&&((k.Year<j.Year)||((k.Year==j.Year)&&((k.Month<j.Month)||((k.Month==j.Month)&&(k.Day<j.Day)))))};var f=function(k,l){var j=k.match(/^(Day|Month|Year)\(?(floor|ceiling|referent)?\)?/);if(j){l.key=j[1];l.condition=j[2];return true}return false};var b=function(k,l){var j=parseInt(k);return isNaN(j)?l:j};return{"->":{init:"__dateSuperInit"},init:function(o,l,n,j){var r,q,m,p,k;this.__dateSuperInit.apply(this,arguments);r=this.getParam("date_default")||"1 1 2010";k=r.split(" ");q=b(k[0],1);m=b(k[1],1);p=b(k[2],2010);this._floor={Day:q,Month:m,Year:p};this._ceiling={Day:q,Month:m,Year:p};this.__key=n},notifyUpdate:function(j,m,k){var l={};if(f(m,l)){if(l.condition=="floor"){this._floor[l.key]=parseInt(k);if(c(this._ceiling,this._floor)){e(this._floor,this._ceiling);g("ceiling",this,this._floor,this.getHandle())}}else{if(l.condition=="ceiling"){this._ceiling[l.key]=parseInt(k);if(c(this._ceiling,this._floor)){e(this._ceiling,this._floor);g("floor",this,this._ceiling,this.getHandle())}}}}},notifyLoad:function(j,m,k){var l={};if(f(m,l)&&(l.condition=="floor")){this._floor[l.key]=parseInt(k)}else{if(l.condition=="ceiling"){this._ceiling[l.key]=parseInt(k)}}}}})();xtiger.factory("service").registerDelegate("date",_DateService);var _DebugService=(function(){return{"->":{configure:"__debugSuperConfigure",notifyLoad:"__debugSuperNotifyLoad",notifyUpdate:"__debugSuperNotifyUpdate",askUpdate:"__debugSuperAskUpdate",notifyRemove:"__debugSuperNotifyRemove",onBroadcast:"__debugSuperOnBroadcast"},configure:function(c,d,b){xtiger.cross.log("debug","configure["+d+"] => "+b);this.__debugSuperConfigure(c,d,b)},notifyLoad:function(b,d,c){xtiger.cross.log("debug","notifyLoad["+d+"] => "+c);this.__debugSuperNotifyLoad(b,d,c)},notifyUpdate:function(b,d,c){xtiger.cross.log("debug","notifyUpdate["+d+"] => "+c);this.__debugSuperNotifyUpdate(b,d,c)},askUpdate:function(b,c){xtiger.cross.log("debug","askUpdate["+c+"]");this.__debugSuperAskUpdate(b,c)},notifyRemove:function(b,d,c){xtiger.cross.log("debug","notifyRemove["+d+"] => "+c);this.__debugSuperNotifyRemove(b,d,c)},onBroadcast:function(c,d,b){xtiger.cross.log("debug","onBroadcast["+d+"] => "+b);this.__debugSuperOnBroadcast(c,d,b)}}})();xtiger.factory("service").registerDelegate("debug",_DebugService);xtiger.debug={};xtiger.debug.loadDocument=function(d,c){if(window.navigator.appName=="Microsoft Internet Explorer"){var f;try{var b=new ActiveXObject("MSXML2.DOMDocument.6.0");b.async=false;b.resolveExternals=false;b.validateOnParse=false;b.setProperty("ProhibitDTD",false);b.load(d);if(b.parseError.errorCode!=0){f=b.parseError+" "+b.parseError.reason}else{return b}}catch(g){f=g.name}if(f){if(c){c.logError("Error while loading $$$ : "+f,d)}else{alert("ERROR:"+f)}b=null}}else{return xtiger.cross.loadDocument(d,c)}return false};xtiger.util.Logger=function(){this.errors=[]};xtiger.util.Logger.prototype={inError:function(){return(this.errors.length>0)},logError:function(e,d){if(e.indexOf("$$$")!=-1){var b=d.match(/([^\/]*)$/);var c=b?b[1]:d;this.errors.push(e.replace("$$$",'"'+c+'"'))}else{this.errors.push(e)}},printErrors:function(){return this.errors.join(";")}};xtiger.util.LogWin=function(c,d,b,e){var f="width="+d+",height="+b+",status=yes,resizable=yes,scrollbars=yes,title="+c;if(xtiger.cross.UA.IE){this.window=window.open("about:blank")}else{this.window=window.open(null,c,f)}this.doc=this.window.document;this.doc.open();this.isTranscoding=e};xtiger.util.LogWin.prototype={dumpSchema:function(d,b,c){var f=new xtiger.util.SchemaLogger();var e=d.serializeData(f);this.write(f.dump("*"));this.close()},dump:function(e,c,d){var b;var g=new xtiger.util.DOMLogger();var f=e.serializeData(g);b='<?xml version="1.0"?>\n';if(c){b+='<?xml-stylesheet type="text/xml" href="'+c+'"?>\n'}if(d){b+='<?xtiger template="'+d+'" version="1.0" ?>\n'}b+=g.dump("*");this.write(b);this.close()},transcode:function(e){var d=e.replace(/</g,"&lt;");var c=d.replace(/\n/g,"<br/>");var b=c.replace(/ /g,"&nbsp;");return b},write:function(c){var b=this.isTranscoding?this.transcode(c):c;this.doc.writeln(b)},close:function(b){this.doc.close()},dispose:function(){this.doc.close()}};xtiger.util.fileDialog=function(k,g,j){var c;try{netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect")}catch(i){alert("Permission to get enough privilege was denied.");return false}var f=Components.interfaces.nsIFilePicker;c=Components.classes["@mozilla.org/filepicker;1"].createInstance(f);if(g){c.appendFilter("My filter",g)}var b;if(k=="open"){b=f.modeOpen}else{if(k=="save"){b=f.modeSave}else{b=f.modeGetFolder}}c.init(window,j,b);var d=c.show();if((d==f.returnOK)||(d==f.returnReplace)){return c.file.path}else{return false}};