# Collective Mind toolkit (CM aka CK2)

[![PyPI version](https://badge.fury.io/py/cmind.svg)](https://pepy.tech/project/cmind)
[![Downloads](https://pepy.tech/badge/cmind)](https://pepy.tech/project/cmind)
[![Python Version](https://img.shields.io/badge/python-3+-blue.svg)](https://github.com/mlcommons/ck/tree/master/cm)
[![License](https://img.shields.io/badge/License-Apache%202.0-green)](https://github.com/mlcommons/ck/tree/master/cm)


We have developed the Collective Mind toolkit (CM aka CK2) to make existing DevOps and MLOps 
more portable, interoperable, deterministic, reusable and reproducible 
with minimal or no changes to existing projects!

CM transforms existing projects into an [open database of intelligent components (IC)](https://github.com/octoml/cm-mlops/tree/main/ic) 
that simply wrap existing user scripts and artifacts 
to provide a common API and extensible meta descriptions 
with dependencies on other IC and platforms.

Such evolutionary approach helps to avoid vendor lock-in on specific workflow frameworks and platforms
while simplifying and automating the development and deployment of complex applications
across rapidly evolving software and hardware stacks from the cloud to the edge.

The CM toolkit is the 2nd generation of the [Collective Knowledge framework (CK)]( https://arxiv.org/abs/2011.01149 )
that was [successfully validated in academia and industry]( https://cKnowledge.org/partners.html ) in the past years 
to enable collaborative and reproducible development, opitmization and deployment
of Pareto-efficient ML Systems in terms of accuracy, latency, throughput, energy, size and costs
across continuously changing software, hardware, user environments, settings, models and data.



# License

Apache 2.0



# Documentation

* [Online docs](https://cknowledge.org/docs/cm)

# Tutorials

* [Understanding intelligent CM components](https://cknowledge.org/docs/cm/tutorial-ic.html)
* [Understanding CM concepts](https://cknowledge.org/docs/cm/tutorial-concept.html)

# Community meetings

* [Public notes](meetings/)
* [Regular conf-calls](meetings/conf-calls.md)


# News

* **2022 May 20:** Brainstorming session for CM-powered ["intelligent components"](https://cknowledge.org/docs/cm/tutorial-ic.html) in Seattle, WA.

* **2022 April 20:** MLCommons virutal community meeting.

* **2022 April 3:** We presented our approach to bridge the growing gap between ML Systems research and production 
  at the HPCA'22 workshop on [benchmarking deep learning systems](https://sites.google.com/g.harvard.edu/mlperf-bench-hpca22/home).

* **2022 March:** We presented our concept to [enable collaborative and reproducible ML Systems R&D](https://meetings.siam.org/sess/dsp_programsess.cfm?SESSIONCODE=73126) 
  at the SIAM'22 workshop on "Research Challenges and Opportunities within Software Productivity, Sustainability, and Reproducibility"

* **2022 March:** we've released the first prototype of [the Collective Mind toolkit (aka CK2)](https://github.com/mlcommons/ck/tree/master/cm)
  based on your feedback and our practical experience [reproducing 150+ ML and Systems papers and validating them in the real world](https://www.youtube.com/watch?v=7zpeIVwICa4).




# Development

## CM core (database)

We use [GitHub tickets](https://github.com/mlcommons/ck/issues) 
to improve and enhance the CM core that manages shared projects
as a collective database of reusable artifacts and automations.
Please don't hesitate to share your ideas and report encountered issues!



## CM-based projects

### Automating development, optimization and deployment of efficient ML Systems

CM provides a common playground and a common language to help researchers and engineers
discuss and learn how to make benchmarking, optimization, co-design and deployment
of complex ML Systems more deterministic, portable and reproducible across
continusly changing software and hardware stacks.

* CM repositories to bridge [the gap between MLOps and DevOps](https://www.mihaileric.com/posts/mlops-is-a-mess):
  * [CM automations]( https://github.com/mlcommons/ck/tree/master/cm-devops )
  * [Intelligent CM components]( https://github.com/octoml/cm-mlops/tree/main/ic )




# Related resources

* [MLOps](docs/KB/MLOps.md)


# Acknowledgments

We thank the [users and partners of the original CK framework](https://cKnowledge.org/partners.html), 
[OctoML](https://octoml.ai), [MLCommons](https://mlcommons.org) 
and all our colleagues for their valuable feedback and support!


# Contacts

* [Grigori Fursin](https://cKnowledge.io/@gfursin)
* [Arjun Suresh](https://www.linkedin.com/in/arjunsuresh)
