# Generated by Django 4.1.5 on 2023-01-24 08:37

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="City",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="Cidade")),
                (
                    "state",
                    models.CharField(
                        choices=[
                            ("AC", "Acre"),
                            ("AL", "Alagoas"),
                            ("AM", "Amazonas"),
                            ("AP", "Amapá"),
                            ("BA", "Bahia"),
                            ("CE", "Ceará"),
                            ("ES", "Espírito Santo"),
                            ("GO", "Goiás"),
                            ("MA", "Maranhão"),
                            ("MG", "Minas Gerais"),
                            ("MS", "Mato Grosso do Sul"),
                            ("MT", "Mato Grosso"),
                            ("PA", "Pará"),
                            ("PB", "Paraíba"),
                            ("PE", "Pernambuco"),
                            ("PI", "Piauí"),
                            ("PR", "Paraná"),
                            ("RJ", "Rio de Janeiro"),
                            ("RN", "Rio Grande do Norte"),
                            ("RO", "Rondônia"),
                            ("RR", "Roraima"),
                            ("RS", "Rio Grande do Sul"),
                            ("SC", "Santa Catarina"),
                            ("SE", "Sergipe"),
                            ("SP", "São Paulo"),
                            ("TO", "Tocantins"),
                            ("DF", "Distrito Federal"),
                        ],
                        max_length=2,
                        verbose_name="Estado",
                    ),
                ),
            ],
            options={
                "verbose_name": "Cidade",
                "verbose_name_plural": "Cidades",
                "ordering": ["-created"],
            },
        ),
        migrations.CreateModel(
            name="Phone",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "country_code",
                    models.CharField(
                        default="55", max_length=3, verbose_name="Código do país"
                    ),
                ),
                (
                    "area_code",
                    models.CharField(max_length=3, verbose_name="Código de Area"),
                ),
                ("number", models.CharField(max_length=9, verbose_name="Número")),
            ],
            options={
                "verbose_name": "Telefone",
                "verbose_name_plural": "Telefones",
                "ordering": ["-created"],
            },
        ),
        migrations.CreateModel(
            name="Address",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("zip_code", models.CharField(max_length=10, verbose_name="CEP")),
                ("district", models.CharField(max_length=255, verbose_name="Bairro")),
                ("street", models.CharField(max_length=255, verbose_name="Rua")),
                ("number", models.CharField(max_length=10, verbose_name="Número")),
                (
                    "additional_info",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="Complemento",
                    ),
                ),
                (
                    "city",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="b2_utils.city"
                    ),
                ),
            ],
            options={
                "verbose_name": "Endereço",
                "verbose_name_plural": "Endereços",
                "ordering": ["-created"],
            },
        ),
    ]
