from yaml import safe_load
from os.path import abspath, dirname


def get_default_token():
    """
    The file is used to provide a default token. This is not a secret
    data type, it was generated by registering the same email address
    attached to the github profile on the noaa website.
    `https://www.ncdc.noaa.gov/cdo-web/token`.
    The usage of a token is limitted to 5 times per second, and 10,000
    times per day according to the noaa website. If all users decide to
    make use of the token below, they will only be limitting themselves
    and other users access to the site.
    
    ..note:: It is suggested that a new token is generated for each user.
    """
    _filename = dirname(abspath(__file__)) + "/token.yaml"
    
    with open(_filename, "r") as token_file:
        yaml_data = safe_load(token_file)

        if "token" in yaml_data:
            return yaml_data["token"]

