/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.error;

import java.io.Serializable;
import org.yaml.snakeyaml.scanner.Constant;

public final class Mark
implements Serializable {
    private String name;
    private int index;
    private int line;
    private int column;
    private int[] buffer;
    private int pointer;

    private static int[] toCodePoints(char[] str2) {
        int[] codePoints = new int[Character.codePointCount(str2, 0, str2.length)];
        int i = 0;
        int c = 0;
        while (i < str2.length) {
            int cp;
            codePoints[c] = cp = Character.codePointAt(str2, i);
            i += Character.charCount(cp);
            ++c;
        }
        return codePoints;
    }

    public Mark(String name, int index, int line, int column, char[] str2, int pointer) {
        this(name, index, line, column, Mark.toCodePoints(str2), pointer);
    }

    @Deprecated
    public Mark(String name, int index, int line, int column, String buffer, int pointer) {
        this(name, index, line, column, buffer.toCharArray(), pointer);
    }

    public Mark(String name, int index, int line, int column, int[] buffer, int pointer) {
        this.name = name;
        this.index = index;
        this.line = line;
        this.column = column;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    private boolean isLineBreak(int c) {
        return Constant.NULL_OR_LINEBR.has(c);
    }

    public String get_snippet(int indent, int max_length) {
        int i;
        float half = (float)max_length / 2.0f - 1.0f;
        int start2 = this.pointer;
        String head2 = "";
        while (start2 > 0 && !this.isLineBreak(this.buffer[start2 - 1])) {
            if (!((float)(this.pointer - --start2) > half)) continue;
            head2 = " ... ";
            start2 += 5;
            break;
        }
        String tail2 = "";
        int end = this.pointer;
        while (end < this.buffer.length && !this.isLineBreak(this.buffer[end])) {
            if (!((float)(++end - this.pointer) > half)) continue;
            tail2 = " ... ";
            end -= 5;
            break;
        }
        StringBuilder result2 = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            result2.append(" ");
        }
        result2.append(head2);
        for (i = start2; i < end; ++i) {
            result2.appendCodePoint(this.buffer[i]);
        }
        result2.append(tail2);
        result2.append("\n");
        for (i = 0; i < indent + this.pointer - start2 + head2.length(); ++i) {
            result2.append(" ");
        }
        result2.append("^");
        return result2.toString();
    }

    public String get_snippet() {
        return this.get_snippet(4, 75);
    }

    public String toString() {
        String snippet = this.get_snippet();
        StringBuilder builder = new StringBuilder(" in ");
        builder.append(this.name);
        builder.append(", line ");
        builder.append(this.line + 1);
        builder.append(", column ");
        builder.append(this.column + 1);
        builder.append(":\n");
        builder.append(snippet);
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getPointer() {
        return this.pointer;
    }
}

