/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.Deque;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactfx.collection.ListModificationSequence;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.util.AccumulationFacility;
import org.reactfx.util.AccumulativeStreamNotifications;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.ListNotifications;
import org.reactfx.util.NonAccumulativeStreamNotifications;
import org.reactfx.util.QueuingStreamNotifications;
import org.reactfx.util.ReducingStreamNotifications;
import org.reactfx.util.RetailOldestValNotifications;
import org.reactfx.util.RetainLatestStreamNotifications;

public interface NotificationAccumulator<O, V, A> {
    public static <T, A> NotificationAccumulator<Consumer<? super T>, T, A> accumulativeStreamNotifications(Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> reduction) {
        return new AccumulativeStreamNotifications<T, A>(size, head2, tail2, initialTransformation, reduction);
    }

    public static <T> NotificationAccumulator<Consumer<? super T>, T, Deque<T>> queuingStreamNotifications() {
        return new QueuingStreamNotifications();
    }

    public static <T> NotificationAccumulator<Consumer<? super T>, T, T> reducingStreamNotifications(BinaryOperator<T> reduction) {
        return new ReducingStreamNotifications<T>(reduction);
    }

    public static <T> NotificationAccumulator<Consumer<? super T>, T, T> retainLatestStreamNotifications() {
        return new RetainLatestStreamNotifications();
    }

    public static <T> NotificationAccumulator<Consumer<? super T>, T, T> retainOldestValNotifications() {
        return new RetailOldestValNotifications();
    }

    public static <T> NotificationAccumulator<Consumer<? super T>, T, T> nonAccumulativeStreamNotifications() {
        return new NonAccumulativeStreamNotifications();
    }

    public static <E> NotificationAccumulator<LiveList.Observer<? super E, ?>, QuasiListChange<? extends E>, ListModificationSequence<E>> listNotifications() {
        return new ListNotifications();
    }

    public boolean isEmpty();

    public Runnable takeOne();

    public void addAll(Iterator<O> var1, V var2);

    public void clear();

    public AccumulationFacility<V, A> getAccumulationFacility();
}

