/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;
import org.reactfx.util.ConcatView;
import org.reactfx.util.ListConcatenation;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

public final class Lists {
    private Lists() {
    }

    public static <E> int hashCode(List<E> list) {
        int hashCode2 = 1;
        for (E e : list) {
            hashCode2 = 31 * hashCode2 + Objects.hashCode(e);
        }
        return hashCode2;
    }

    public static boolean equals(List<?> list, Object o) {
        if (o == list) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        if (list.size() != that.size()) {
            return false;
        }
        Iterator<?> it1 = list.iterator();
        Iterator it2 = that.iterator();
        while (it1.hasNext()) {
            if (Objects.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static String toString(List<?> list) {
        StringBuilder res = new StringBuilder();
        res.append('[');
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            res.append(it.next());
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        res.append(']');
        return res.toString();
    }

    public static <E> Iterator<E> readOnlyIterator(final Collection<? extends E> col) {
        return new Iterator<E>(){
            private final Iterator<? extends E> delegate;
            {
                this.delegate = col.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public E next() {
                return this.delegate.next();
            }
        };
    }

    public static boolean isValidIndex(int index, int size) {
        return Lists.isValidIndex(0, index, size);
    }

    public static boolean isValidIndex(int min, int index, int max) {
        return min <= index && index < max;
    }

    public static void checkIndex(int index, int size) {
        Lists.checkIndex(0, index, size);
    }

    public static void checkIndex(int min, int index, int max) {
        if (!Lists.isValidIndex(min, index, max)) {
            throw new IndexOutOfBoundsException(index + " not in [" + min + ", " + max + ")");
        }
    }

    public static boolean isValidPosition(int position, int size) {
        return Lists.isValidPosition(0, position, size);
    }

    public static boolean isValidPosition(int min, int position, int max) {
        return min <= position && position <= max;
    }

    public static void checkPosition(int position, int size) {
        Lists.checkPosition(0, position, size);
    }

    public static void checkPosition(int min, int position, int max) {
        if (!Lists.isValidPosition(min, position, max)) {
            throw new IndexOutOfBoundsException(position + " not in [" + min + ", " + max + "]");
        }
    }

    public static boolean isValidRange(int from2, int to, int size) {
        return Lists.isValidRange(0, from2, to, size);
    }

    public static boolean isValidRange(int min, int from2, int to, int max) {
        return min <= from2 && from2 <= to && to <= max;
    }

    public static void checkRange(int from2, int to, int size) {
        Lists.checkRange(0, from2, to, size);
    }

    public static void checkRange(int min, int from2, int to, int max) {
        if (!Lists.isValidRange(min, from2, to, max)) {
            throw new IndexOutOfBoundsException("[" + from2 + ", " + to + ") is not a valid range within [" + min + ", " + max + ")");
        }
    }

    public static boolean isNonEmptyRange(int from2, int to, int size) {
        return Lists.isNonEmptyRange(0, from2, to, size);
    }

    public static boolean isNonEmptyRange(int min, int from2, int to, int max) {
        return min <= from2 && from2 < to && to <= max;
    }

    public static boolean isProperRange(int from2, int to, int size) {
        return Lists.isProperRange(0, from2, to, size);
    }

    public static boolean isProperRange(int min, int from2, int to, int max) {
        return Lists.isValidRange(min, from2, to, max) && (min < from2 || to < max);
    }

    public static boolean isProperNonEmptyRange(int from2, int to, int size) {
        return Lists.isProperNonEmptyRange(0, from2, to, size);
    }

    public static boolean isProperNonEmptyRange(int min, int from2, int to, int max) {
        return Lists.isNonEmptyRange(min, from2, to, max) && (min < from2 || to < max);
    }

    public static boolean isStrictlyInsideRange(int from2, int to, int size) {
        return Lists.isStrictlyInsideRange(0, from2, to, size);
    }

    public static boolean isStrictlyInsideRange(int min, int from2, int to, int max) {
        return min < from2 && from2 <= to && to < max;
    }

    public static boolean isStrictlyInsideNonEmptyRange(int from2, int to, int size) {
        return Lists.isStrictlyInsideNonEmptyRange(0, from2, to, size);
    }

    public static boolean isStrictlyInsideNonEmptyRange(int min, int from2, int to, int max) {
        return min < from2 && from2 < to && to < max;
    }

    public static <E, F> List<F> mappedView(final List<? extends E> source, final Function<? super E, ? extends F> f) {
        return new AbstractList<F>(){

            @Override
            public F get(int index) {
                return f.apply(source.get(index));
            }

            @Override
            public int size() {
                return source.size();
            }
        };
    }

    @SafeVarargs
    public static <E> List<E> concatView(List<? extends E> ... lists) {
        return Lists.concatView(Arrays.asList(lists));
    }

    public static <E> List<E> concatView(List<List<? extends E>> lists) {
        if (lists.isEmpty()) {
            return Collections.emptyList();
        }
        return ConcatView.create(lists);
    }

    @SafeVarargs
    public static <E> List<E> concat(List<? extends E> ... lists) {
        return Lists.concat(Arrays.asList(lists));
    }

    public static <E> List<E> concat(List<List<? extends E>> lists) {
        return ListConcatenation.create(lists);
    }

    public static int commonPrefixLength(List<?> l, List<?> m) {
        ListIterator<?> i = l.listIterator();
        ListIterator<?> j = m.listIterator();
        while (i.hasNext() && j.hasNext()) {
            if (Objects.equals(i.next(), j.next())) continue;
            return i.nextIndex() - 1;
        }
        return i.nextIndex();
    }

    public static int commonSuffixLength(List<?> l, List<?> m) {
        ListIterator<?> i = l.listIterator(l.size());
        ListIterator<?> j = m.listIterator(m.size());
        while (i.hasPrevious() && j.hasPrevious()) {
            if (Objects.equals(i.previous(), j.previous())) continue;
            return l.size() - i.nextIndex() - 1;
        }
        return l.size() - i.nextIndex();
    }

    public static Tuple2<Integer, Integer> commonPrefixSuffixLengths(List<?> l1, List<?> l2) {
        int n1 = l1.size();
        int n2 = l2.size();
        if (n1 == 0 || n2 == 0) {
            return Tuples.t(0, 0);
        }
        int pref = Lists.commonPrefixLength(l1, l2);
        if (pref == n1 || pref == n2) {
            return Tuples.t(pref, 0);
        }
        int suff = Lists.commonSuffixLength(l1, l2);
        return Tuples.t(pref, suff);
    }
}

