/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.NotificationAccumulatorBase;

final class AccumulativeStreamNotifications<T, A>
extends NotificationAccumulatorBase<Consumer<? super T>, T, A> {
    private final Function<? super A, AccumulatorSize> size;
    private final Function<? super A, ? extends T> head;
    private final Function<? super A, ? extends A> tail;
    private final Function<? super T, ? extends A> initialTransformation;
    private final BiFunction<? super A, ? super T, ? extends A> reduction;

    AccumulativeStreamNotifications(Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> reduction) {
        this.size = size;
        this.head = head2;
        this.tail = tail2;
        this.initialTransformation = initialTransformation;
        this.reduction = reduction;
    }

    @Override
    protected AccumulatorSize size(Consumer<? super T> observer, A accumulatedValue) {
        return this.size.apply(accumulatedValue);
    }

    @Override
    protected Runnable head(Consumer<? super T> observer, A accumulatedValue) {
        Object event = this.head.apply(accumulatedValue);
        return () -> observer.accept((Object)event);
    }

    @Override
    protected A tail(Consumer<? super T> observer, A accumulatedValue) {
        return this.tail.apply(accumulatedValue);
    }

    @Override
    public A initialAccumulator(T value) {
        return this.initialTransformation.apply(value);
    }

    @Override
    public A reduce(A accum, T value) {
        return this.reduction.apply(accum, value);
    }
}

