/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.AbstractList;
import java.util.List;

class SubList<E>
extends AbstractList<E> {
    private final List<E> list;
    private final int from;
    private final int to;

    public SubList(List<E> list, int from2, int to) {
        if (from2 < 0 || from2 > to || to > list.size()) {
            throw new IndexOutOfBoundsException("0 <= " + from2 + " <= " + to + " <= " + list.size());
        }
        this.list = list;
        this.from = from2;
        this.to = to;
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.list.get(this.from + index);
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index);
        return this.list.set(this.from + index, element);
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        this.list.add(this.from + index, element);
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        return this.list.remove(this.from + index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
    }
}

