/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.reactfx.Subscription;
import org.reactfx.collection.ListChangeAccumulator;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.ProperLiveList;

public final class LiveArrayList<E>
extends LiveListBase<E> {
    private List<E> list;

    public LiveArrayList() {
        this.list = new ArrayList();
    }

    public LiveArrayList(Collection<? extends E> c) {
        this.list = new ArrayList<E>(c);
    }

    @SafeVarargs
    public LiveArrayList(E ... initialElements) {
        this(Arrays.asList(initialElements));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        E replaced = this.list.set(index, element);
        this.fireElemReplacement(index, replaced);
        return replaced;
    }

    @Override
    public boolean setAll(Collection<? extends E> c) {
        List<E> removed = this.list;
        this.list = new ArrayList<E>(c);
        this.fireContentReplacement(removed);
        return true;
    }

    @Override
    @SafeVarargs
    public final boolean setAll(E ... elems) {
        return this.setAll((Collection<? extends E>)Arrays.asList(elems));
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.fireElemInsertion(index);
    }

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.list.addAll(index, c);
        this.fireRangeInsertion(index, c.size());
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    @SafeVarargs
    public final boolean addAll(E ... elems) {
        return this.addAll((Collection<? extends E>)Arrays.asList(elems));
    }

    @Override
    public E remove(int index) {
        E removed = this.list.remove(index);
        this.fireElemRemoval(index, removed);
        return removed;
    }

    @Override
    public void remove(int from2, int to) {
        List<E> sublist = this.list.subList(from2, to);
        ArrayList<E> removed = new ArrayList<E>(sublist);
        sublist.clear();
        this.fireRemoveRange(from2, removed);
    }

    @Override
    public boolean remove(Object o) {
        int i = this.list.indexOf(o);
        if (i != -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ListChangeAccumulator<E> acc = new ListChangeAccumulator<E>();
        for (Object o : c) {
            int i = this.list.indexOf(o);
            if (i == -1) continue;
            E removed = this.list.remove(i);
            acc.add(ProperLiveList.elemRemoval(i, removed));
        }
        if (acc.isEmpty()) {
            return false;
        }
        this.notifyObservers(acc.fetch());
        return true;
    }

    @Override
    @SafeVarargs
    public final boolean removeAll(E ... elems) {
        return this.removeAll((Collection<?>)Arrays.asList(elems));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ListChangeAccumulator<E> acc = new ListChangeAccumulator<E>();
        for (int i = this.size() - 1; i >= 0; --i) {
            E elem = this.list.get(i);
            if (c.contains(elem)) continue;
            this.list.remove(i);
            acc.add(ProperLiveList.elemRemoval(i, elem));
        }
        if (acc.isEmpty()) {
            return false;
        }
        this.notifyObservers(acc.fetch());
        return true;
    }

    @Override
    @SafeVarargs
    public final boolean retainAll(E ... elems) {
        return this.retainAll((Collection<?>)Arrays.asList(elems));
    }

    @Override
    public void clear() {
        this.setAll(Collections.emptyList());
    }

    @Override
    protected Subscription observeInputs() {
        return Subscription.EMPTY;
    }
}

