/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.binding.Binding;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Task;
import javafx.scene.Node;
import org.reactfx.AccumulateBetweenStream;
import org.reactfx.AccumulateUntilLaterStream;
import org.reactfx.AccumulatingStream;
import org.reactfx.AccumulativeEventStream;
import org.reactfx.AwaitingEventStream;
import org.reactfx.CompletionStageStream;
import org.reactfx.DefaultEventStream;
import org.reactfx.DistinctStream;
import org.reactfx.EmitBothOnEachStream;
import org.reactfx.EmitOnEachStream;
import org.reactfx.EmitOnStream;
import org.reactfx.EventSink;
import org.reactfx.EventStreamBase;
import org.reactfx.EventStreams;
import org.reactfx.FilterMapStream;
import org.reactfx.FilterStream;
import org.reactfx.FlatMapOptStream;
import org.reactfx.FlatMapStream;
import org.reactfx.ForgetfulEventStream;
import org.reactfx.Guardian;
import org.reactfx.HookStream;
import org.reactfx.LatestNStream;
import org.reactfx.LimitedInvocationSubscriber;
import org.reactfx.MappedStream;
import org.reactfx.MappedToCompletionStageStream;
import org.reactfx.MappedToTaskStream;
import org.reactfx.Observable;
import org.reactfx.PausableEventStream;
import org.reactfx.RecursiveStream;
import org.reactfx.ReducibleEventStream;
import org.reactfx.RepeatOnStream;
import org.reactfx.ScheduledExecutorServiceTimer;
import org.reactfx.StreamBinding;
import org.reactfx.Subscription;
import org.reactfx.SuccessionReducingStream;
import org.reactfx.SuppressibleEventStream;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspenderStream;
import org.reactfx.SuspenderStreamImpl;
import org.reactfx.TaskStream;
import org.reactfx.ThenAccumulateForStream;
import org.reactfx.ThreadBridge;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.Either;
import org.reactfx.util.Experimental;
import org.reactfx.util.FxTimer;
import org.reactfx.util.NotificationAccumulator;
import org.reactfx.util.Timer;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;

public interface EventStream<T>
extends Observable<Consumer<? super T>> {
    default public Subscription subscribe(Consumer<? super T> subscriber) {
        return this.observe(subscriber);
    }

    default public Subscription subscribeFor(int n, Consumer<? super T> subscriber) {
        return new LimitedInvocationSubscriber<T>(n, subscriber).subscribeTo(this);
    }

    default public Subscription subscribeForOne(Consumer<? super T> subscriber) {
        return this.subscribeFor(1, subscriber);
    }

    default public Subscription feedTo(EventSink<? super T> sink) {
        return this.subscribe(sink::push);
    }

    default public Subscription feedTo(WritableValue<? super T> dest) {
        return this.subscribe(dest::setValue);
    }

    default public Subscription pin() {
        return this.subscribe(x -> {});
    }

    default public EventStream<T> withDefaultEvent(T defaultEvent) {
        return new DefaultEventStream<T>(this, defaultEvent);
    }

    default public EventStream<T> hook(Consumer<? super T> sideEffect) {
        return new HookStream<T>(this, sideEffect);
    }

    default public EventStream<T> filter(Predicate<? super T> predicate) {
        return new FilterStream<T>(this, predicate);
    }

    default public <U extends T> EventStream<U> filter(Class<U> subtype) {
        return this.filterMap(subtype::isInstance, subtype::cast);
    }

    default public EventStream<T> distinct() {
        return new DistinctStream(this);
    }

    default public <U> EventStream<U> supply(U value) {
        return this.map(x -> value);
    }

    default public <U> EventStream<U> supply(Supplier<? extends U> f) {
        return this.map(x -> f.get());
    }

    default public <U> CompletionStageStream<U> supplyCompletionStage(Supplier<CompletionStage<U>> f) {
        return this.mapToCompletionStage(x -> (CompletionStage)f.get());
    }

    default public <U> TaskStream<U> supplyTask(Supplier<Task<U>> f) {
        return this.mapToTask(x -> (Task)f.get());
    }

    default public <U> EventStream<U> map(Function<? super T, ? extends U> f) {
        return new MappedStream<T, U>(this, f);
    }

    default public <U extends T> EventStream<U> cast(Class<U> subtype) {
        return this.map(subtype::cast);
    }

    default public EventStream<Either<T, T>> splitBy(Predicate<? super T> test) {
        return this.map(t -> test.test(t) ? Either.left(t) : Either.right(t));
    }

    default public Tuple2<EventStream<T>, EventStream<T>> fork(Predicate<? super T> test) {
        return Tuples.t(this.filter(test), this.filter(test.negate()));
    }

    default public <U> CompletionStageStream<U> mapToCompletionStage(Function<? super T, CompletionStage<U>> f) {
        return new MappedToCompletionStageStream<T, U>(this, f);
    }

    default public <U> TaskStream<U> mapToTask(Function<? super T, Task<U>> f) {
        return new MappedToTaskStream<T, U>(this, f);
    }

    default public <U> EventStream<U> filterMap(Predicate<? super T> predicate, Function<? super T, ? extends U> f) {
        return new FilterMapStream<T, U>(this, predicate, f);
    }

    default public <U> EventStream<U> filterMap(Function<? super T, Optional<U>> f) {
        return new FlatMapOptStream<T, U>(this, f);
    }

    default public <U> EventStream<U> flatMap(Function<? super T, ? extends EventStream<U>> f) {
        return new FlatMapStream(this, f);
    }

    default public EventStream<T> conditionOn(ObservableValue<Boolean> condition) {
        return EventStreams.valuesOf(condition).flatMap(c -> c != false ? this : EventStreams.never());
    }

    default public EventStream<T> conditionOnShowing(Node node) {
        return this.conditionOn(Val.showingProperty(node));
    }

    default public <U> EventStream<Either<T, U>> or(final EventStream<? extends U> right) {
        final EventStream left = this;
        return new EventStreamBase<Either<T, U>>(){

            @Override
            protected Subscription observeInputs() {
                return Subscription.multi(left.subscribe(l -> this.emit(Either.left(l))), right.subscribe(r -> this.emit(Either.right(r))));
            }
        };
    }

    default public EventStream<List<T>> latestN(int n) {
        return new LatestNStream(this, n);
    }

    default public EventStream<T> emitOn(EventStream<?> impulse) {
        return new EmitOnStream(this, impulse);
    }

    default public EventStream<T> emitOnEach(EventStream<?> impulse) {
        return new EmitOnEachStream(this, impulse);
    }

    default public <I> EventStream<Tuple2<T, I>> emitBothOnEach(EventStream<I> impulse) {
        return new EmitBothOnEachStream(this, impulse);
    }

    default public EventStream<T> repeatOn(EventStream<?> impulse) {
        return new RepeatOnStream(this, impulse);
    }

    default public SuspendableEventStream<T> suppressible() {
        return new SuppressibleEventStream(this);
    }

    default public EventStream<T> suppressWhen(ObservableValue<Boolean> condition) {
        return this.suppressible().suspendedWhen(condition);
    }

    default public SuspendableEventStream<T> pausable() {
        return new PausableEventStream(this);
    }

    default public EventStream<T> pauseWhen(ObservableValue<Boolean> condition) {
        return this.pausable().suspendedWhen(condition);
    }

    default public SuspendableEventStream<T> forgetful() {
        return new ForgetfulEventStream(this);
    }

    default public EventStream<T> retainLatestWhen(ObservableValue<Boolean> condition) {
        return this.forgetful().suspendedWhen(condition);
    }

    default public SuspendableEventStream<T> reducible(BinaryOperator<T> reduction) {
        return new ReducibleEventStream<T>(this, reduction);
    }

    default public EventStream<T> reduceWhen(ObservableValue<Boolean> condition, BinaryOperator<T> reduction) {
        return this.reducible(reduction).suspendedWhen(condition);
    }

    default public <A> SuspendableEventStream<T> accumulative(Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2) {
        return new AccumulativeEventStream<T, A>(this, initialTransformation, accumulation, size, head2, tail2);
    }

    default public <A> EventStream<T> accumulateWhen(ObservableValue<Boolean> condition, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2) {
        return this.accumulative(initialTransformation, accumulation, size, head2, tail2).suspendedWhen(condition);
    }

    default public <A> SuspendableEventStream<T> accumulative(Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2) {
        Function<Object, Object> initialTransformation = t -> accumulation.apply((Object)unit.get(), (Object)t);
        return this.accumulative(initialTransformation, accumulation, size, head2, tail2);
    }

    default public <A> EventStream<T> accumulateWhen(ObservableValue<Boolean> condition, Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2) {
        return this.accumulative(unit, accumulation, size, head2, tail2).suspendedWhen(condition);
    }

    default public <A> EventStream<T> accumulateBetween(EventStream<?> ticks, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction) {
        return new AccumulateBetweenStream<T, A>(this, ticks, initialTransformation, accumulation, deconstruction);
    }

    default public <A> EventStream<T> accumulateBetween(EventStream<?> ticks, Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction) {
        Function<Object, Object> initialTransformation = t -> accumulation.apply((Object)unit.get(), (Object)t);
        return this.accumulateBetween(ticks, initialTransformation, accumulation, deconstruction);
    }

    default public EventStream<T> reduceBetween(EventStream<?> ticks, BinaryOperator<T> reduction) {
        return this.accumulateBetween(ticks, Function.identity(), reduction, Collections::singletonList);
    }

    default public EventStream<T> queueBetween(EventStream<?> ticks) {
        return this.accumulateBetween(ticks, ArrayList::new, (? super A l, ? super T t) -> {
            l.add(t);
            return l;
        }, Function.identity());
    }

    default public EventStream<T> retainLatestBetween(EventStream<?> ticks) {
        return this.emitOn(ticks);
    }

    default public <A> EventStream<T> accumulateUntilLater(Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction, Executor eventThreadExecutor) {
        return new AccumulateUntilLaterStream<T, A>(this, initialTransformation, accumulation, deconstruction, eventThreadExecutor);
    }

    default public <A> EventStream<T> accumulateUntilLater(Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction) {
        return this.accumulateUntilLater(initialTransformation, accumulation, deconstruction, Platform::runLater);
    }

    default public <A> EventStream<T> accumulateUntilLater(Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction, Executor eventThreadExecutor) {
        return this.accumulateUntilLater((? super T t) -> accumulation.apply((Object)unit.get(), (Object)t), accumulation, deconstruction, eventThreadExecutor);
    }

    default public <A> EventStream<T> accumulateUntilLater(Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction) {
        return this.accumulateUntilLater(unit, accumulation, deconstruction, Platform::runLater);
    }

    default public EventStream<T> reduceUntilLater(BinaryOperator<T> reduction, Executor eventThreadExecutor) {
        return this.accumulateUntilLater(Function.identity(), reduction, Collections::singletonList, eventThreadExecutor);
    }

    default public EventStream<T> reduceUntilLater(BinaryOperator<T> reduction) {
        return this.reduceUntilLater(reduction, Platform::runLater);
    }

    default public EventStream<T> retainLatestUntilLater(Executor eventThreadExecutor) {
        return this.reduceUntilLater((a, b) -> b, eventThreadExecutor);
    }

    default public EventStream<T> retainLatestUntilLater() {
        return this.retainLatestUntilLater(Platform::runLater);
    }

    default public EventStream<T> queueUntilLater(Executor eventThreadExecutor) {
        return this.accumulateUntilLater(ArrayList::new, (? super A l, ? super T t) -> {
            l.add(t);
            return l;
        }, (? super A l) -> l, eventThreadExecutor);
    }

    default public EventStream<T> queueUntilLater() {
        return this.queueUntilLater(Platform::runLater);
    }

    default public Binding<T> toBinding(T initialValue) {
        return new StreamBinding<T>(this, initialValue);
    }

    default public EventStream<T> accumulate(BinaryOperator<T> reduction) {
        return this.accumulate(reduction, Function.identity());
    }

    default public <U> EventStream<U> accumulate(U unit, BiFunction<? super U, ? super T, ? extends U> reduction) {
        return this.accumulate(reduction, (? super T t) -> reduction.apply((Object)unit, (Object)t));
    }

    default public <U> EventStream<U> accumulate(BiFunction<? super U, ? super T, ? extends U> reduction, Function<? super T, ? extends U> initialTransformation) {
        return new AccumulatingStream<T, U>(this, initialTransformation, reduction);
    }

    default public AwaitingEventStream<T> reduceSuccessions(BinaryOperator<T> reduction, Duration timeout) {
        return this.reduceSuccessions(Function.identity(), reduction, timeout);
    }

    default public <U> AwaitingEventStream<U> reduceSuccessions(Function<? super T, ? extends U> initialTransformation, BiFunction<? super U, ? super T, ? extends U> reduction, Duration timeout) {
        Function<Runnable, Timer> timerFactory = action -> FxTimer.create(timeout, action);
        return new SuccessionReducingStream<T, U>(this, initialTransformation, reduction, timerFactory);
    }

    default public <U> AwaitingEventStream<U> reduceSuccessions(Supplier<? extends U> unitSupplier, BiFunction<? super U, ? super T, ? extends U> reduction, Duration timeout) {
        Function<Object, Object> map2 = t -> reduction.apply((Object)unitSupplier.get(), (Object)t);
        return this.reduceSuccessions(map2, reduction, timeout);
    }

    default public AwaitingEventStream<T> reduceSuccessions(BinaryOperator<T> reduction, Duration timeout, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        return this.reduceSuccessions(Function.identity(), reduction, timeout, scheduler, eventThreadExecutor);
    }

    default public <U> AwaitingEventStream<U> reduceSuccessions(Function<? super T, ? extends U> initialTransformation, BiFunction<? super U, ? super T, ? extends U> reduction, Duration timeout, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        Function<Runnable, Timer> timerFactory = action -> ScheduledExecutorServiceTimer.create(timeout, action, scheduler, eventThreadExecutor);
        return new SuccessionReducingStream<T, U>(this, initialTransformation, reduction, timerFactory);
    }

    default public <U> AwaitingEventStream<U> reduceSuccessions(Supplier<? extends U> unitSupplier, BiFunction<? super U, ? super T, ? extends U> reduction, Duration timeout, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        Function<Object, Object> map2 = t -> reduction.apply((Object)unitSupplier.get(), (Object)t);
        return this.reduceSuccessions(map2, reduction, timeout, scheduler, eventThreadExecutor);
    }

    default public AwaitingEventStream<T> successionEnds(Duration timeout) {
        return this.reduceSuccessions((a, b) -> b, timeout);
    }

    default public AwaitingEventStream<T> successionEnds(Duration timeout, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        return this.reduceSuccessions((a, b) -> b, timeout, scheduler, eventThreadExecutor);
    }

    default public <A> AwaitingEventStream<T> thenAccumulateFor(Duration duration, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> reduction, Function<? super A, List<T>> deconstruction) {
        return new ThenAccumulateForStream<T, A>(this, initialTransformation, reduction, deconstruction, action -> FxTimer.create(duration, action));
    }

    default public <A> AwaitingEventStream<T> thenAccumulateFor(Duration duration, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> reduction, Function<? super A, List<T>> deconstruction, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        Function<Runnable, Timer> timerFactory = action -> ScheduledExecutorServiceTimer.create(duration, action, scheduler, eventThreadExecutor);
        return new ThenAccumulateForStream<T, A>(this, initialTransformation, reduction, deconstruction, timerFactory);
    }

    default public <A> AwaitingEventStream<T> thenAccumulateFor(Duration duration, Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> reduction, Function<? super A, List<T>> deconstruction) {
        Function<Object, Object> initialTransformation = t -> reduction.apply((Object)unit.get(), (Object)t);
        return this.thenAccumulateFor(duration, initialTransformation, reduction, deconstruction);
    }

    default public <A> AwaitingEventStream<T> thenAccumulateFor(Duration duration, Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> reduction, Function<? super A, List<T>> deconstruction, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        Function<Object, Object> initialTransformation = t -> reduction.apply((Object)unit.get(), (Object)t);
        return this.thenAccumulateFor(duration, initialTransformation, reduction, deconstruction, scheduler, eventThreadExecutor);
    }

    default public AwaitingEventStream<T> thenReduceFor(Duration duration, BinaryOperator<T> reduction) {
        return this.thenAccumulateFor(duration, Function.identity(), reduction, Collections::singletonList);
    }

    default public AwaitingEventStream<T> thenReduceFor(Duration duration, BinaryOperator<T> reduction, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        return this.thenAccumulateFor(duration, Function.identity(), reduction, Collections::singletonList, scheduler, eventThreadExecutor);
    }

    default public AwaitingEventStream<T> thenRetainLatestFor(Duration duration) {
        return this.thenReduceFor(duration, (a, b) -> b);
    }

    default public AwaitingEventStream<T> thenRetainLatestFor(Duration duration, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        return this.thenReduceFor(duration, (a, b) -> b, scheduler, eventThreadExecutor);
    }

    default public AwaitingEventStream<T> thenIgnoreFor(Duration duration) {
        return this.thenAccumulateFor(duration, (? super T t) -> Collections.emptyList(), (? super A l, ? super T t) -> l, Function.identity());
    }

    default public AwaitingEventStream<T> thenIgnoreFor(Duration duration, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        return this.thenAccumulateFor(duration, (? super T t) -> Collections.emptyList(), (? super A l, ? super T t) -> l, Function.identity(), scheduler, eventThreadExecutor);
    }

    default public <A> EventStream<T> onRecurseAccumulate(Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> reduction, Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2) {
        return new RecursiveStream<T>(this, NotificationAccumulator.accumulativeStreamNotifications(size, head2, tail2, initialTransformation, reduction));
    }

    default public <A> EventStream<T> onRecurseAccumulate(Supplier<? extends A> unit, BiFunction<? super A, ? super T, ? extends A> reduction, Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2) {
        Function<Object, Object> initialTransformation = t -> reduction.apply((Object)unit.get(), (Object)t);
        return this.onRecurseAccumulate(initialTransformation, reduction, size, head2, tail2);
    }

    default public EventStream<T> onRecurseReduce(BinaryOperator<T> reduction) {
        return new RecursiveStream<T>(this, NotificationAccumulator.reducingStreamNotifications(reduction));
    }

    default public EventStream<T> onRecurseQueue() {
        return new RecursiveStream(this, NotificationAccumulator.queuingStreamNotifications());
    }

    default public EventStream<T> onRecurseRetainLatest() {
        return new RecursiveStream(this, NotificationAccumulator.retainLatestStreamNotifications());
    }

    default public EventStream<T> threadBridge(Executor sourceThreadExecutor, Executor targetThreadExecutor) {
        return new ThreadBridge(this, sourceThreadExecutor, targetThreadExecutor);
    }

    default public EventStream<T> threadBridgeFromFx(Executor targetThreadExecutor) {
        return this.threadBridge(Platform::runLater, targetThreadExecutor);
    }

    default public EventStream<T> threadBridgeToFx(Executor sourceThreadExecutor) {
        return this.threadBridge(sourceThreadExecutor, Platform::runLater);
    }

    @Deprecated
    default public EventStream<T> guardedBy(Guardian ... guardians) {
        return this.suspenderOf(Guardian.combine(guardians)::guard);
    }

    @Experimental
    default public <S extends Suspendable> SuspenderStream<T, S> suspenderOf(S suspendable) {
        return new SuspenderStreamImpl(this, suspendable);
    }
}

