/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactfx.EventStream;
import org.reactfx.SuspendableEventStreamBase;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.NotificationAccumulator;

final class AccumulativeEventStream<T, A>
extends SuspendableEventStreamBase<T, A> {
    private final Function<? super A, AccumulatorSize> size;
    private final Function<? super A, ? extends T> head;
    private final Function<? super A, ? extends A> tail;

    AccumulativeEventStream(EventStream<T> source, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, AccumulatorSize> size, Function<? super A, ? extends T> head2, Function<? super A, ? extends A> tail2) {
        super(source, NotificationAccumulator.accumulativeStreamNotifications(size, head2, tail2, initialTransformation, accumulation));
        this.size = size;
        this.head = head2;
        this.tail = tail2;
    }

    @Override
    protected AccumulatorSize sizeOf(A accum) {
        return this.size.apply(accum);
    }

    @Override
    protected T headOf(A accum) {
        return this.head.apply(accum);
    }

    @Override
    protected A tailOf(A accum) {
        return this.tail.apply(accum);
    }
}

