/*
 * Decompiled with CFR 0.152.
 */
package org.gciatto.kt.math;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u001aG\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u000e\u001a0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0000\u001a,\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016*\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a&\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00070\t\"\u0006\b\u0000\u0010\u0007\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00070\tH\u0080\b\u00a2\u0006\u0002\u0010\u001d\u001a\f\u0010\u001c\u001a\u00020\u000f*\u00020\u000fH\u0000\u001a\u0014\u0010\u001e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0001H\u0000\u001a$\u0010\u001e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001H\u0000\u001a$\u0010\"\u001a\u00060\u0015j\u0002`\u0016*\u00060\u0015j\u0002`\u00162\u0006\u0010#\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020$H\u0000\u001a$\u0010%\u001a\u00060\u0015j\u0002`\u0016*\u00060\u0015j\u0002`\u00162\u0006\u0010#\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'H\u0000\u001a\f\u0010(\u001a\u00020\u0004*\u00020$H\u0000\u001a\u0014\u0010(\u001a\u00020\u0004*\u00020$2\u0006\u0010)\u001a\u00020\u0001H\u0000\u001a\f\u0010*\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010*\u001a\u00020\u0001*\u00020+H\u0000\u001a\f\u0010,\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010-\u001a\u00020\u0018*\u00020'H\u0000\u001a\f\u0010.\u001a\u00020\u0001*\u00020$H\u0000\u001a\u0014\u0010.\u001a\u00020\u0001*\u00020$2\u0006\u0010)\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"CHAR_MAX_RADIX", "", "CHAR_MIN_RADIX", "DEBUG", "", "arrayCopy", "", "T", "src", "", "srcIndex", "dest", "destIndex", "size", "([Ljava/lang/Object;I[Ljava/lang/Object;II)V", "", "log", "lazyObject", "Lkotlin/Function0;", "", "appendCharArray", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "char", "", "offset", "len", "bitCount", "cloneArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", "fill", "x", "from", "to", "insertChar", "index", "", "insertCharSeq", "string", "", "isDigit", "radix", "numberOfLeadingZeros", "", "numberOfTrailingZeros", "toCharArray", "toDigit", "kt-math"})
@JvmName(name="Utils")
public final class Utils {
    public static final boolean DEBUG = false;
    public static final int CHAR_MIN_RADIX = 2;
    public static final int CHAR_MAX_RADIX = 36;

    public static final void log(@NotNull Function0<? extends Object> lazyObject) {
        Intrinsics.checkNotNullParameter(lazyObject, "lazyObject");
    }

    public static final int numberOfLeadingZeros(long $this$numberOfLeadingZeros) {
        if ($this$numberOfLeadingZeros == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)($this$numberOfLeadingZeros >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)$this$numberOfLeadingZeros;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static final int numberOfLeadingZeros(int $this$numberOfLeadingZeros) {
        int x = $this$numberOfLeadingZeros;
        if (x == 0) {
            return 32;
        }
        int n = 1;
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static final int numberOfTrailingZeros(int $this$numberOfTrailingZeros) {
        int y = 0;
        int i = $this$numberOfTrailingZeros;
        if (i == 0) {
            return 32;
        }
        int n = 31;
        y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - (i << 1 >>> 31);
    }

    public static final boolean isDigit(char $this$isDigit) {
        return Utils.isDigit($this$isDigit, 10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDigit(char $this$isDigit, int radix) {
        if (36 > radix) return false;
        if (radix > 36) return false;
        boolean bl = true;
        if (!bl) return false;
        if (radix > 10) {
            boolean bl2;
            boolean bl3;
            int delta = radix - 10;
            if ('0' <= $this$isDigit) {
                if ($this$isDigit <= '9') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('a' <= $this$isDigit) {
                if ($this$isDigit < (char)(97 + delta)) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('A' > $this$isDigit) return false;
            if ($this$isDigit >= (char)(65 + delta)) return false;
            return true;
        }
        if ('0' > $this$isDigit) return false;
        if ($this$isDigit >= (char)(48 + radix)) return false;
        return true;
    }

    public static final int toDigit(char $this$toDigit) {
        return Utils.toDigit($this$toDigit, 10);
    }

    public static final int toDigit(char $this$toDigit, int radix) {
        boolean bl = 2 <= radix ? radix <= 36 : false;
        if (bl) {
            if (radix > 10) {
                int delta = radix - 10;
                char c = $this$toDigit;
                boolean bl2 = '0' <= c ? c <= '9' : false;
                if (bl2) {
                    return $this$toDigit - 48;
                }
                boolean bl3 = 'a' <= c ? c < (char)(97 + delta) : false;
                if (bl3) {
                    return $this$toDigit - 97 + 10;
                }
                boolean bl4 = 'A' <= c ? c < (char)(65 + delta) : false;
                if (bl4) {
                    return $this$toDigit - 65 + 10;
                }
            } else {
                boolean bl5 = '0' <= $this$toDigit ? $this$toDigit < (char)(48 + radix) : false;
                if (bl5) {
                    return $this$toDigit - 48;
                }
            }
        }
        return -1;
    }

    public static final <T> void arrayCopy(@NotNull T[] src, int srcIndex, @NotNull T[] dest, int destIndex, int size) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dest, "dest");
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                dest[destIndex + i] = src[srcIndex + i];
            } while (n < size);
        }
    }

    public static final void arrayCopy(@NotNull int[] src, int srcIndex, @NotNull int[] dest, int destIndex, int size) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dest, "dest");
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                dest[destIndex + i] = src[srcIndex + i];
            } while (n < size);
        }
    }

    public static final /* synthetic */ <T> T[] cloneArray(T[] $this$cloneArray) {
        Intrinsics.checkNotNullParameter($this$cloneArray, "<this>");
        boolean $i$f$cloneArray = false;
        int n = 0;
        int n2 = $this$cloneArray.length;
        Intrinsics.reifiedOperationMarker(0, "T");
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = $this$cloneArray[n3];
        }
        return objectArray;
    }

    @NotNull
    public static final int[] cloneArray(@NotNull int[] $this$cloneArray) {
        Intrinsics.checkNotNullParameter($this$cloneArray, "<this>");
        int n = 0;
        int n2 = $this$cloneArray.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = $this$cloneArray[n3];
        }
        return nArray;
    }

    public static final int bitCount(int $this$bitCount) {
        int i = $this$bitCount;
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x3F;
    }

    @NotNull
    public static final StringBuilder insertChar(@NotNull StringBuilder $this$insertChar, int index, char c) {
        Intrinsics.checkNotNullParameter($this$insertChar, "<this>");
        return Utils.insertCharSeq($this$insertChar, index, String.valueOf(c));
    }

    @NotNull
    public static final StringBuilder insertCharSeq(@NotNull StringBuilder $this$insertCharSeq, int index, @NotNull CharSequence string2) {
        Intrinsics.checkNotNullParameter($this$insertCharSeq, "<this>");
        Intrinsics.checkNotNullParameter(string2, "string");
        StringBuilder temp = new StringBuilder($this$insertCharSeq.subSequence(0, index));
        temp.append(string2);
        temp.append($this$insertCharSeq.subSequence(index, $this$insertCharSeq.length()));
        return temp;
    }

    @NotNull
    public static final char[] toCharArray(@NotNull CharSequence $this$toCharArray) {
        Intrinsics.checkNotNullParameter($this$toCharArray, "<this>");
        int n = 0;
        int n2 = $this$toCharArray.length();
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = $this$toCharArray.charAt(n3);
        }
        return cArray;
    }

    @NotNull
    public static final int[] fill(@NotNull int[] $this$fill, int x) {
        Intrinsics.checkNotNullParameter($this$fill, "<this>");
        return Utils.fill($this$fill, 0, $this$fill.length, x);
    }

    @NotNull
    public static final int[] fill(@NotNull int[] $this$fill, int from2, int to, int x) {
        Intrinsics.checkNotNullParameter($this$fill, "<this>");
        int n = from2;
        if (n < to) {
            do {
                int i = n++;
                $this$fill[i] = x;
            } while (n < to);
        }
        return $this$fill;
    }

    @NotNull
    public static final StringBuilder appendCharArray(@NotNull StringBuilder $this$appendCharArray, @NotNull char[] cArray, int offset, int len) {
        Intrinsics.checkNotNullParameter($this$appendCharArray, "<this>");
        Intrinsics.checkNotNullParameter(cArray, "char");
        int n = offset;
        int n2 = offset + len;
        if (n < n2) {
            do {
                int i = n++;
                $this$appendCharArray.append(cArray[i]);
            } while (n < n2);
        }
        return $this$appendCharArray;
    }
}

