/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event.internal;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class PrefixTree<K, V> {
    final Ops<K, V> ops;

    public static <K, V> PrefixTree<K, V> empty(Ops<K, V> ops) {
        return new Empty<K, V>(ops);
    }

    private static <A, B, C> BiFunction<B, A, C> flip(BiFunction<A, B, C> f) {
        return (a, b) -> f.apply(b, a);
    }

    private PrefixTree(Ops<K, V> ops) {
        this.ops = ops;
    }

    public abstract Stream<Map.Entry<K, V>> entries();

    public abstract PrefixTree<K, V> insert(K var1, V var2, BiFunction<? super V, ? super V, ? extends V> var3);

    public abstract <W> PrefixTree<K, W> map(Function<? super V, ? extends W> var1, Ops<K, W> var2);

    public final PrefixTree<K, V> map(Function<? super V, ? extends V> f) {
        return this.map(f, this.ops);
    }

    abstract PrefixTree<K, V> insertInside(K var1, V var2, BiFunction<? super V, ? super V, ? extends V> var3);

    private static class Data<K, V>
    extends NonEmpty<K, V> {
        private final K key;
        private final V value;

        Data(Ops<K, V> ops, K key, V value) {
            super(ops);
            this.key = key;
            this.value = value;
        }

        @Override
        K getPrefix() {
            return this.key;
        }

        @Override
        public Stream<Map.Entry<K, V>> entries() {
            return Stream.of(new AbstractMap.SimpleEntry<K, V>(this.key, this.value));
        }

        @Override
        Data<K, V> collapse() {
            return this;
        }

        @Override
        NonEmpty<K, V> insertInside(K key, V value, BiFunction<? super V, ? super V, ? extends V> combine2) {
            assert (this.ops.isPrefixOf(this.key, key));
            return new Data<K, V>(this.ops, this.key, combine2.apply(this.value, this.ops.promote(value, key, this.key)));
        }

        NonEmpty<K, V> insertInside(NonEmpty<K, V> tree, BiFunction<? super V, ? super V, ? extends V> combine2) {
            Data<K, V> d = tree.collapse();
            return this.insertInside((Object)d.key, (Object)d.value, (BiFunction)combine2);
        }

        Data<K, V> promote(K key) {
            assert (this.ops.isPrefixOf(key, this.key));
            return new Data<K, V>(this.ops, key, this.ops.promote(this.value, this.key, key));
        }

        Data<K, V> squash(Data<K, V> that) {
            assert (Objects.equals(this.key, that.key));
            return new Data<K, V>(this.ops, this.key, this.ops.squash(this.value, that.value));
        }

        @Override
        public <W> Data<K, W> map(Function<? super V, ? extends W> f, Ops<K, W> ops) {
            return new Data<K, W>(ops, this.key, f.apply(this.value));
        }
    }

    private static class Branch<K, V>
    extends NonEmpty<K, V> {
        private final K prefix;
        private final List<NonEmpty<K, V>> subTrees;

        Branch(Ops<K, V> ops, K prefix, List<NonEmpty<K, V>> subTrees) {
            super(ops);
            assert (Objects.equals(prefix, subTrees.stream().map(NonEmpty::getPrefix).reduce(ops::commonPrefix).get()));
            assert (subTrees.stream().noneMatch(tree -> Objects.equals(tree.getPrefix(), prefix)));
            this.prefix = prefix;
            this.subTrees = subTrees;
        }

        private Branch(Ops<K, V> ops, NonEmpty<K, V> t1, NonEmpty<K, V> t2) {
            this(ops, ops.commonPrefix(t1.getPrefix(), t2.getPrefix()), Arrays.asList(t1, t2));
        }

        @Override
        K getPrefix() {
            return this.prefix;
        }

        @Override
        public Stream<Map.Entry<K, V>> entries() {
            return this.subTrees.stream().flatMap(tree -> tree.entries());
        }

        @Override
        Data<K, V> collapse() {
            return this.subTrees.stream().map((? super T tree) -> tree.collapse().promote(this.prefix)).reduce(Data::squash).get();
        }

        @Override
        NonEmpty<K, V> insertInside(K key, V value, BiFunction<? super V, ? super V, ? extends V> combine2) {
            assert (this.ops.isPrefixOf(this.prefix, key));
            if (Objects.equals(key, this.prefix)) {
                return new Data<K, V>(this.ops, key, value).insertInside(this.collapse(), PrefixTree.flip(combine2));
            }
            for (int i = 0; i < this.subTrees.size(); ++i) {
                NonEmpty<K, V> st = this.subTrees.get(i);
                K commonPrefix = this.ops.commonPrefix(key, st.getPrefix());
                if (Objects.equals(commonPrefix, this.prefix)) continue;
                if (Objects.equals(commonPrefix, st.getPrefix())) {
                    return this.replaceBranch(i, (NonEmpty<K, V>)st.insertInside((Object)key, (Object)value, combine2));
                }
                if (Objects.equals(commonPrefix, key)) {
                    return this.replaceBranch(i, new Data<K, V>(this.ops, key, value).insertInside(st.collapse(), PrefixTree.flip(combine2)));
                }
                return this.replaceBranch(i, new Branch<K, V>(this.ops, st, new Data<K, V>(this.ops, key, value)));
            }
            ArrayList<NonEmpty<K, V>> branches = new ArrayList<NonEmpty<K, V>>(this.subTrees.size() + 1);
            branches.addAll(this.subTrees);
            branches.add(new Data<K, V>(this.ops, key, value));
            return new Branch<K, V>(this.ops, this.prefix, branches);
        }

        private Branch<K, V> replaceBranch(int i, NonEmpty<K, V> replacement) {
            assert (this.ops.isPrefixOf(this.prefix, replacement.getPrefix()));
            assert (this.ops.isPrefixOf(replacement.getPrefix(), this.subTrees.get(i).getPrefix()));
            ArrayList<NonEmpty<K, V>> branches = new ArrayList<NonEmpty<K, V>>(this.subTrees);
            branches.set(i, replacement);
            return new Branch<K, V>(this.ops, this.prefix, branches);
        }

        @Override
        public <W> NonEmpty<K, W> map(Function<? super V, ? extends W> f, Ops<K, W> ops) {
            ArrayList<NonEmpty<K, V>> mapped2 = new ArrayList<NonEmpty<K, V>>(this.subTrees.size());
            for (NonEmpty<K, V> tree : this.subTrees) {
                mapped2.add((NonEmpty<K, V>)tree.map(f, (Ops)ops));
            }
            return new Branch<K, W>(ops, this.prefix, mapped2);
        }
    }

    private static abstract class NonEmpty<K, V>
    extends PrefixTree<K, V> {
        public NonEmpty(Ops<K, V> ops) {
            super(ops);
        }

        abstract K getPrefix();

        abstract Data<K, V> collapse();

        @Override
        public abstract <W> NonEmpty<K, W> map(Function<? super V, ? extends W> var1, Ops<K, W> var2);

        @Override
        abstract NonEmpty<K, V> insertInside(K var1, V var2, BiFunction<? super V, ? super V, ? extends V> var3);

        @Override
        public PrefixTree<K, V> insert(K key, V value, BiFunction<? super V, ? super V, ? extends V> combine2) {
            if (this.ops.isPrefixOf(key, this.getPrefix())) {
                return new Data<K, V>(this.ops, key, value).insertInside(this.collapse(), PrefixTree.flip(combine2));
            }
            if (this.ops.isPrefixOf(this.getPrefix(), key)) {
                return this.insertInside((Object)key, (Object)value, (BiFunction)combine2);
            }
            return new Branch(this.ops, this, new Data<K, V>(this.ops, key, value));
        }
    }

    private static class Empty<K, V>
    extends PrefixTree<K, V> {
        public Empty(Ops<K, V> ops) {
            super(ops);
        }

        @Override
        public Stream<Map.Entry<K, V>> entries() {
            return Stream.empty();
        }

        @Override
        public PrefixTree<K, V> insert(K key, V value, BiFunction<? super V, ? super V, ? extends V> combine2) {
            return this.insertInside(key, value, combine2);
        }

        @Override
        PrefixTree<K, V> insertInside(K key, V value, BiFunction<? super V, ? super V, ? extends V> combine2) {
            return new Data<K, V>(this.ops, key, value);
        }

        @Override
        public <W> PrefixTree<K, W> map(Function<? super V, ? extends W> f, Ops<K, W> ops) {
            return new Empty<K, W>(ops);
        }
    }

    public static interface Ops<K, V> {
        public boolean isPrefixOf(K var1, K var2);

        public K commonPrefix(K var1, K var2);

        public V promote(V var1, K var2, K var3);

        public V squash(V var1, V var2);
    }
}

