/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBase;
import org.fxmisc.richtext.model.TwoDimensional;

class SubSpans<S>
extends StyleSpansBase<S> {
    private final StyleSpans<S> original;
    private final int firstIdxInOrig;
    private final int spanCount;
    private final StyleSpan<S> firstSpan;
    private final StyleSpan<S> lastSpan;
    int length = -1;

    public SubSpans(StyleSpans<S> original, TwoDimensional.Position from2, TwoDimensional.Position to) {
        this.original = original;
        this.firstIdxInOrig = from2.getMajor();
        this.spanCount = to.getMajor() - from2.getMajor() + 1;
        if (this.spanCount == 1) {
            StyleSpan<S> span = original.getStyleSpan(this.firstIdxInOrig);
            int len = to.getMinor() - from2.getMinor();
            this.lastSpan = new StyleSpan<S>(span.getStyle(), len);
            this.firstSpan = this.lastSpan;
        } else {
            StyleSpan<S> startSpan = original.getStyleSpan(this.firstIdxInOrig);
            int len = startSpan.getLength() - from2.getMinor();
            this.firstSpan = new StyleSpan<S>(startSpan.getStyle(), len);
            StyleSpan<S> endSpan = original.getStyleSpan(to.getMajor());
            this.lastSpan = new StyleSpan<S>(endSpan.getStyle(), to.getMinor());
        }
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = 0;
            for (StyleSpan span : this) {
                this.length += span.getLength();
            }
        }
        return this.length;
    }

    @Override
    public int getSpanCount() {
        return this.spanCount;
    }

    @Override
    public StyleSpan<S> getStyleSpan(int index) {
        if (index == 0) {
            return this.firstSpan;
        }
        if (index == this.spanCount - 1) {
            return this.lastSpan;
        }
        if (index < 0 || index >= this.spanCount) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.original.getStyleSpan(this.firstIdxInOrig + index);
    }

    public String toString() {
        ArrayList<StyleSpan<S>> spans = new ArrayList<StyleSpan<S>>(this.spanCount);
        for (int i = 0; i < this.spanCount; ++i) {
            spans.add(this.getStyleSpan(i));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SubSpans(length=").append(this.length).append(" spanCount=").append(this.getSpanCount()).append(" spans=").append(spans).append(")");
        return sb.toString();
    }
}

