/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.TwoDimensional;

public interface StyledDocument<PS, SEG, S>
extends TwoDimensional {
    public int length();

    public String getText();

    public List<Paragraph<PS, SEG, S>> getParagraphs();

    public StyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> var1);

    public StyledDocument<PS, SEG, S> subSequence(int var1, int var2);

    default public String getText(IndexRange range) {
        return this.getText(range.getStart(), range.getEnd());
    }

    default public String getText(int start2, int end) {
        return this.subSequence(start2, end).getText();
    }

    default public String getText(int paragraphIndex) {
        return this.getParagraph(paragraphIndex).getText();
    }

    default public Paragraph<PS, SEG, S> getParagraph(int index) {
        return this.getParagraphs().get(index);
    }

    default public int getParagraphLength(int paragraphIndex) {
        return this.getParagraph(paragraphIndex).length();
    }

    default public StyledDocument<PS, SEG, S> subSequence(IndexRange range) {
        return this.subSequence(range.getStart(), range.getEnd());
    }

    default public StyledDocument<PS, SEG, S> subDocument(int paragraphIndex) {
        return new ReadOnlyStyledDocument<PS, SEG, S>(Collections.singletonList(this.getParagraphs().get(paragraphIndex)));
    }

    default public char charAt(int index) {
        TwoDimensional.Position pos = this.offsetToPosition(index, TwoDimensional.Bias.Forward);
        return this.getParagraphs().get(pos.getMajor()).charAt(pos.getMinor());
    }

    default public S getStyleOfChar(int index) {
        TwoDimensional.Position pos2D = this.offsetToPosition(index, TwoDimensional.Bias.Forward);
        int paragraph = pos2D.getMajor();
        int col = pos2D.getMinor();
        return this.getParagraphs().get(paragraph).getStyleOfChar(col);
    }

    default public S getStyleOfChar(int paragraph, int column) {
        return this.getParagraphs().get(paragraph).getStyleOfChar(column);
    }

    default public S getStyleAtPosition(int position) {
        TwoDimensional.Position pos2D = this.offsetToPosition(position, TwoDimensional.Bias.Forward);
        return this.getStyleAtPosition(pos2D.getMajor(), pos2D.getMinor());
    }

    default public S getStyleAtPosition(int paragraph, int position) {
        return this.getParagraphs().get(paragraph).getStyleAtPosition(position);
    }

    default public PS getParagraphStyle(int paragraph) {
        return this.getParagraphs().get(paragraph).getParagraphStyle();
    }

    default public PS getParagraphStyleAtPosition(int position) {
        TwoDimensional.Position pos = this.offsetToPosition(position, TwoDimensional.Bias.Forward);
        return this.getParagraphStyle(pos.getMajor());
    }

    default public IndexRange getStyleRangeAtPosition(int position) {
        TwoDimensional.Position pos2D = this.offsetToPosition(position, TwoDimensional.Bias.Forward);
        int paragraph = pos2D.getMajor();
        int col = pos2D.getMinor();
        return this.getParagraphs().get(paragraph).getStyleRangeAtPosition(col);
    }

    default public IndexRange getStyleRangeAtPosition(int paragraph, int position) {
        return this.getParagraphs().get(paragraph).getStyleRangeAtPosition(position);
    }

    default public StyleSpans<S> getStyleSpans(int from2, int to) {
        TwoDimensional.Position start2 = this.offsetToPosition(from2, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end = to == from2 ? start2 : start2.offsetBy(to - from2, TwoDimensional.Bias.Backward);
        int startParIdx = start2.getMajor();
        int endParIdx = end.getMajor();
        int affectedPars = endParIdx - startParIdx + 1;
        ArrayList<StyleSpans<S>> subSpans = new ArrayList<StyleSpans<S>>(affectedPars);
        if (startParIdx == endParIdx) {
            Paragraph<PS, SEG, S> par = this.getParagraphs().get(startParIdx);
            subSpans.add(par.getStyleSpans(start2.getMinor(), end.getMinor()));
        } else {
            Paragraph<PS, SEG, S> startPar = this.getParagraphs().get(startParIdx);
            subSpans.add(startPar.getStyleSpans(start2.getMinor(), startPar.length() + 1));
            for (int i = startParIdx + 1; i < endParIdx; ++i) {
                Paragraph<PS, SEG, S> par = this.getParagraphs().get(i);
                subSpans.add(par.getStyleSpans(0, par.length() + 1));
            }
            Paragraph<PS, SEG, S> endPar = this.getParagraphs().get(endParIdx);
            subSpans.add(endPar.getStyleSpans(0, end.getMinor()));
        }
        int n = subSpans.stream().mapToInt(StyleSpans::getSpanCount).sum();
        StyleSpansBuilder builder = new StyleSpansBuilder(n);
        for (StyleSpans styleSpans : subSpans) {
            for (StyleSpan span : styleSpans) {
                builder.add(span);
            }
        }
        return builder.create();
    }

    default public StyleSpans<S> getStyleSpans(int paragraph) {
        return this.getParagraphs().get(paragraph).getStyleSpans();
    }

    default public StyleSpans<S> getStyleSpans(int paragraph, int from2, int to) {
        return this.getParagraphs().get(paragraph).getStyleSpans(from2, to);
    }

    default public int getAbsolutePosition(int paragraphIndex, int columnPosition) {
        int position = this.position(paragraphIndex, columnPosition).toOffset();
        if (position < 0) {
            throw new IndexOutOfBoundsException(String.format("Negative index! Out of bounds by %s.", 0 - position));
        }
        if (this.length() < position) {
            throw new IndexOutOfBoundsException(String.format("Out of bounds by %s. Area Length: %s", position - this.length(), this.length()));
        }
        return position;
    }
}

