/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import javafx.geometry.Rectangle2D;

class TextFlowSpan {
    private Rectangle2D bounds;
    private double y;
    private double width;
    private double height;
    private int start;
    private int length;

    TextFlowSpan(int start2, int length, double minY, double width, double height) {
        this.start = start2;
        this.length = length;
        this.height = height;
        this.width = width;
        this.y = minY;
    }

    Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle2D(0.0, this.y, this.width, this.height);
        }
        return this.bounds;
    }

    float getCenterY() {
        return (float)(this.y + this.height / 2.0);
    }

    int getStart() {
        return this.start;
    }

    int getLength() {
        return this.length;
    }

    double getHeight() {
        return this.height;
    }

    double getWidth() {
        return this.width;
    }

    void setHeight(double h) {
        this.height = h;
        this.bounds = null;
    }

    void addLengthAndWidth(int len, double w) {
        this.width += w + 1.0;
        this.bounds = null;
        this.length += len;
    }
}

