/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import org.fxmisc.richtext.BackgroundPath;
import org.fxmisc.richtext.BorderPath;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.JavaFXCompatibility;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.TextFlowExt;
import org.fxmisc.richtext.UnderlinePath;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;

class ParagraphText<PS, SEG, S>
extends TextFlowExt {
    private final ObservableSet<CaretNode> carets = FXCollections.observableSet(new HashSet(1));
    private final ObservableMap<Selection<PS, SEG, S>, SelectionPath> selections = FXCollections.observableMap(new HashMap(1));
    private final MapChangeListener<? super Selection<PS, SEG, S>, ? super SelectionPath> selectionPathListener;
    private final SetChangeListener<? super CaretNode> caretNodeListener;
    private final ObjectProperty<Paint> highlightTextFill = new SimpleObjectProperty<Color>(Color.WHITE);
    private Paragraph<PS, SEG, S> paragraph;
    private final CustomCssShapeHelper<Paint> backgroundShapeHelper;
    private final CustomCssShapeHelper<BorderAttributes> borderShapeHelper;
    private final CustomCssShapeHelper<UnderlineAttributes> underlineShapeHelper;
    private int selectionShapeStartIndex = 0;

    public final ObservableSet<CaretNode> caretsProperty() {
        return this.carets;
    }

    public final ObservableMap<Selection<PS, SEG, S>, SelectionPath> selectionsProperty() {
        return this.selections;
    }

    public ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    ParagraphText(Paragraph<PS, SEG, S> par, Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        this.paragraph = par;
        this.getStyleClass().add("paragraph-text");
        Val<Double> leftInset = Val.map(this.insetsProperty(), Insets::getLeft);
        Val<Double> topInset = Val.map(this.insetsProperty(), Insets::getTop);
        ChangeListener<IndexRange> selectionRangeListener = (obs, ov, nv) -> this.requestLayout();
        this.selectionPathListener = change -> {
            SelectionPath p;
            if (change.wasRemoved()) {
                p = (SelectionPath)change.getValueRemoved();
                p.rangeProperty().removeListener(selectionRangeListener);
                p.layoutXProperty().unbind();
                p.layoutYProperty().unbind();
                this.getChildren().remove(p);
            }
            if (change.wasAdded()) {
                p = (SelectionPath)change.getValueAdded();
                p.rangeProperty().addListener(selectionRangeListener);
                p.layoutXProperty().bind(leftInset);
                p.layoutYProperty().bind(topInset);
                this.getChildren().add(this.selectionShapeStartIndex, p);
                this.updateSingleSelection(p);
            }
        };
        this.selections.addListener(this.selectionPathListener);
        ChangeListener<Integer> caretPositionListener = (obs, ov, nv) -> this.requestLayout();
        this.caretNodeListener = change -> {
            CaretNode caret;
            if (change.wasRemoved()) {
                caret = (CaretNode)change.getElementRemoved();
                caret.columnPositionProperty().removeListener(caretPositionListener);
                caret.layoutXProperty().unbind();
                caret.layoutYProperty().unbind();
                this.getChildren().remove(caret);
            }
            if (change.wasAdded()) {
                caret = (CaretNode)change.getElementAdded();
                caret.columnPositionProperty().addListener(caretPositionListener);
                caret.layoutXProperty().bind(leftInset);
                caret.layoutYProperty().bind(topInset);
                this.getChildren().add(caret);
                this.updateSingleCaret(caret);
            }
        };
        this.carets.addListener(this.caretNodeListener);
        par.getStyledSegments().stream().map(nodeFactory).forEach(n -> {
            if (n instanceof TextExt) {
                TextExt t = (TextExt)n;
                JavaFXCompatibility.Text_selectionFillProperty(t).bind(t.fillProperty());
            }
            this.getChildren().add((Node)n);
        });
        UnaryOperator configurePath = shape -> {
            shape.setManaged(false);
            shape.layoutXProperty().bind(leftInset);
            shape.layoutYProperty().bind(topInset);
            return shape;
        };
        Supplier<Path> createBackgroundShape = () -> (Path)configurePath.apply(new BackgroundPath());
        Supplier<Path> createBorderShape = () -> (Path)configurePath.apply(new BorderPath());
        Supplier<Path> createUnderlineShape = () -> (Path)configurePath.apply(new UnderlinePath());
        Consumer<Collection<Path>> clearUnusedShapes = paths -> this.getChildren().removeAll((Collection<?>)paths);
        Consumer<Path> addToBackground = path2 -> this.getChildren().add(0, (Node)path2);
        Consumer<Path> addToBackgroundAndIncrementSelectionIndex = addToBackground.andThen(ignore -> ++this.selectionShapeStartIndex);
        Consumer<Path> addToForeground = path2 -> this.getChildren().add((Node)path2);
        this.backgroundShapeHelper = new CustomCssShapeHelper(createBackgroundShape, (backgroundShape, tuple) -> {
            backgroundShape.setStrokeWidth(0.0);
            backgroundShape.setFill((Paint)tuple._1);
            backgroundShape.getElements().setAll((PathElement[])this.getRangeShape((IndexRange)tuple._2));
        }, addToBackgroundAndIncrementSelectionIndex, clearUnusedShapes);
        this.borderShapeHelper = new CustomCssShapeHelper(createBorderShape, (borderShape, tuple) -> {
            BorderAttributes attributes = (BorderAttributes)tuple._1;
            borderShape.setStrokeWidth(attributes.width);
            borderShape.setStroke(attributes.color);
            if (attributes.type != null) {
                borderShape.setStrokeType(attributes.type);
            }
            if (attributes.dashArray != null) {
                borderShape.getStrokeDashArray().setAll((Double[])attributes.dashArray);
            }
            borderShape.getElements().setAll((PathElement[])this.getRangeShape((IndexRange)tuple._2));
        }, addToBackground, clearUnusedShapes);
        this.underlineShapeHelper = new CustomCssShapeHelper(createUnderlineShape, (underlineShape, tuple) -> {
            UnderlineAttributes attributes = (UnderlineAttributes)tuple._1;
            underlineShape.setStroke(attributes.color);
            underlineShape.setStrokeWidth(attributes.width);
            underlineShape.setStrokeLineCap(attributes.cap);
            if (attributes.dashArray != null) {
                underlineShape.getStrokeDashArray().setAll((Double[])attributes.dashArray);
            }
            underlineShape.getElements().setAll((PathElement[])this.getUnderlineShape((IndexRange)tuple._2));
        }, addToForeground, clearUnusedShapes);
    }

    void dispose() {
        this.carets.clear();
        this.selections.clear();
        this.selections.removeListener(this.selectionPathListener);
        this.carets.removeListener(this.caretNodeListener);
        this.getChildren().stream().filter(n -> n instanceof TextExt).map(n -> (TextExt)n).forEach(t -> JavaFXCompatibility.Text_selectionFillProperty(t).unbind());
        this.getChildren().clear();
    }

    public Paragraph<PS, SEG, S> getParagraph() {
        return this.paragraph;
    }

    public <T extends Node> double getCaretOffsetX(T caret) {
        this.layout();
        if (this.isVisible()) {
            this.checkWithinParagraph(caret);
        }
        Bounds bounds = caret.getLayoutBounds();
        return (bounds.getMinX() + bounds.getMaxX()) / 2.0;
    }

    public <T extends Node> Bounds getCaretBounds(T caret) {
        this.layout();
        this.checkWithinParagraph(caret);
        return caret.getBoundsInParent();
    }

    public <T extends Node> Bounds getCaretBoundsOnScreen(T caret) {
        this.layout();
        this.checkWithinParagraph(caret);
        Bounds localBounds = caret.getBoundsInLocal();
        return caret.localToScreen(localBounds);
    }

    public Bounds getRangeBoundsOnScreen(int from2, int to) {
        this.layout();
        PathElement[] rangeShape = this.getRangeShapeSafely(from2, to);
        Path p = new Path();
        p.setManaged(false);
        p.setLayoutX(this.getInsets().getLeft());
        p.setLayoutY(this.getInsets().getTop());
        this.getChildren().add(p);
        p.getElements().setAll((PathElement[])rangeShape);
        Bounds localBounds = p.getBoundsInLocal();
        Bounds rangeBoundsOnScreen = p.localToScreen(localBounds);
        this.getChildren().remove(p);
        return rangeBoundsOnScreen;
    }

    public Optional<Bounds> getSelectionBoundsOnScreen(Selection<PS, SEG, S> selection) {
        if (selection.getLength() == 0) {
            return Optional.empty();
        }
        this.layout();
        SelectionPath selectionShape = (SelectionPath)this.selections.get(selection);
        this.checkWithinParagraph(selectionShape);
        Bounds localBounds = selectionShape.getBoundsInLocal();
        return Optional.ofNullable(selectionShape.localToScreen(localBounds));
    }

    public int getCurrentLineStartPosition(Caret caret) {
        return this.getLineStartPosition(this.getClampedCaretPosition(caret));
    }

    public int getCurrentLineEndPosition(Caret caret) {
        return this.getLineEndPosition(this.getClampedCaretPosition(caret));
    }

    public int currentLineIndex(Caret caret) {
        return this.getLineOfCharacter(this.getClampedCaretPosition(caret));
    }

    public int currentLineIndex(int position) {
        return this.getLineOfCharacter(position);
    }

    private <T extends Node> void checkWithinParagraph(T shape) {
        if (shape.getParent() != this) {
            throw new IllegalArgumentException(String.format("This ParagraphText is not the parent of the given shape (%s):\nExpected: %s\nActual:   %s", shape, this, shape.getParent()));
        }
    }

    private int getClampedCaretPosition(Caret caret) {
        return Math.min(caret.getColumnPosition(), this.paragraph.length());
    }

    private void updateAllCaretShapes() {
        this.carets.forEach(this::updateSingleCaret);
    }

    private void updateSingleCaret(CaretNode caretNode) {
        PathElement[] shape = this.getCaretShape(this.getClampedCaretPosition(caretNode), true);
        caretNode.getElements().setAll((PathElement[])shape);
    }

    private void updateAllSelectionShapes() {
        this.selections.values().forEach(this::updateSingleSelection);
    }

    private void updateSingleSelection(SelectionPath path2) {
        path2.getElements().setAll((PathElement[])this.getRangeShapeSafely((IndexRange)path2.rangeProperty().getValue()));
    }

    private PathElement[] getRangeShapeSafely(IndexRange range) {
        return this.getRangeShapeSafely(range.getStart(), range.getEnd());
    }

    private PathElement[] getRangeShapeSafely(int start2, int end) {
        PathElement[] shape;
        if (end <= this.paragraph.length()) {
            shape = this.getRangeShape(start2, end);
        } else if (this.paragraph.length() == 0) {
            shape = this.createRectangle(0.0, 0.0, this.getWidth(), this.getHeight());
        } else if (start2 == this.paragraph.length()) {
            shape = this.getRangeShape(start2 - 1, start2);
            LineTo lineToTopRight = (LineTo)shape[shape.length - 4];
            shape = this.createRectangle(lineToTopRight.getX(), lineToTopRight.getY(), this.getWidth(), this.getHeight());
        } else {
            shape = this.getRangeShape(start2, this.paragraph.length());
            int length = shape.length;
            if (length > 3) {
                int bottomRightIndex = length - 3;
                int topRightIndex = bottomRightIndex - 1;
                LineTo lineToTopRight = (LineTo)shape[topRightIndex];
                shape[topRightIndex] = new LineTo(this.getWidth(), lineToTopRight.getY());
                shape[bottomRightIndex] = new LineTo(this.getWidth(), this.getHeight());
            }
        }
        if (this.getLineSpacing() > 0.0) {
            double half = this.getLineSpacing() / 2.0;
            for (int g = 0; g < shape.length; g += 5) {
                MoveTo tl = (MoveTo)shape[g];
                tl.setY(tl.getY() - half);
                LineTo tr = (LineTo)shape[g + 1];
                tr.setY(tl.getY());
                LineTo br = (LineTo)shape[g + 2];
                br.setY(br.getY() + half);
                LineTo bl = (LineTo)shape[g + 3];
                bl.setY(br.getY());
                LineTo t2 = (LineTo)shape[g + 4];
                t2.setY(tl.getY());
            }
        }
        if (this.getLineCount() > 1) {
            boolean wrappedAtEndPos = end > 0 && this.getLineOfCharacter(end) > this.getLineOfCharacter(end - 1);
            int adjustLength = shape.length - (wrappedAtEndPos ? 0 : 5);
            for (int i = 0; i < adjustLength; ++i) {
                if (!(shape[i] instanceof MoveTo)) continue;
                ((LineTo)shape[i + 1]).setX(this.getWidth());
                ((LineTo)shape[i + 2]).setX(this.getWidth());
            }
        }
        return shape;
    }

    private PathElement[] createRectangle(double topLeftX, double topLeftY, double bottomRightX, double bottomRightY) {
        return new PathElement[]{new MoveTo(topLeftX, topLeftY), new LineTo(bottomRightX, topLeftY), new LineTo(bottomRightX, bottomRightY), new LineTo(topLeftX, bottomRightY), new LineTo(topLeftX, topLeftY)};
    }

    private void updateBackgroundShapes() {
        int start2 = 0;
        for (Node node : this.getManagedChildren()) {
            UnderlineAttributes underline;
            BorderAttributes border;
            if (!(node instanceof TextExt)) {
                ++start2;
                continue;
            }
            TextExt text = (TextExt)node;
            int end = start2 + text.getText().length();
            Paint backgroundColor = text.getBackgroundColor();
            if (backgroundColor != null) {
                ((CustomCssShapeHelper)this.backgroundShapeHelper).updateSharedShapeRange(backgroundColor, start2, end, Object::equals);
            }
            if (!(border = new BorderAttributes(text)).isNullValue()) {
                ((CustomCssShapeHelper)this.borderShapeHelper).updateSharedShapeRange(border, start2, end, BorderAttributes::equalsFaster);
            }
            if (!(underline = new UnderlineAttributes(text)).isNullValue()) {
                ((CustomCssShapeHelper)this.underlineShapeHelper).updateSharedShapeRange(underline, start2, end, UnderlineAttributes::equalsFaster);
            }
            start2 = end;
        }
        ((CustomCssShapeHelper)this.borderShapeHelper).updateSharedShapes();
        ((CustomCssShapeHelper)this.backgroundShapeHelper).updateSharedShapes();
        ((CustomCssShapeHelper)this.underlineShapeHelper).updateSharedShapes();
    }

    @Override
    public String toString() {
        return String.format("ParagraphText@%s(paragraph=%s)", this.hashCode(), this.paragraph);
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        this.updateAllCaretShapes();
        this.updateAllSelectionShapes();
        this.updateBackgroundShapes();
    }

    private static class LineAttributesBase {
        final double width;
        final Paint color;
        final Double[] dashArray;

        public final boolean isNullValue() {
            return this.color == null || this.width == -1.0;
        }

        LineAttributesBase(Paint color, Number width, ObjectProperty<Number[]> dashArrayProp) {
            this.color = color;
            if (color == null || width == null || width.doubleValue() <= 0.0) {
                this.width = -1.0;
                this.dashArray = null;
            } else {
                this.width = width.doubleValue();
                Object dashArrayProperty = dashArrayProp.get();
                if (dashArrayProperty != null) {
                    if (dashArrayProperty.getClass().isArray()) {
                        Number[] numberArray = (Number[])dashArrayProperty;
                        this.dashArray = new Double[numberArray.length];
                        int idx = 0;
                        for (Number d : numberArray) {
                            this.dashArray[idx++] = (Double)d;
                        }
                    } else {
                        this.dashArray = new Double[1];
                        this.dashArray[0] = (double)((Double)dashArrayProperty);
                    }
                } else {
                    this.dashArray = null;
                }
            }
        }

        public boolean equalsFaster(LineAttributesBase attr) {
            return Objects.equals(this.width, attr.width) && Objects.equals(this.color, attr.color) && Arrays.equals((Object[])this.dashArray, (Object[])attr.dashArray);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineAttributesBase) {
                LineAttributesBase attr = (LineAttributesBase)obj;
                return this.equalsFaster(attr);
            }
            return false;
        }

        protected final String getSubString() {
            return String.format("width=%s color=%s dashArray=%s", this.width, this.color, Arrays.toString((Object[])this.dashArray));
        }
    }

    private static class UnderlineAttributes
    extends LineAttributesBase {
        final StrokeLineCap cap;

        UnderlineAttributes(TextExt text) {
            super(text.getUnderlineColor(), text.getUnderlineWidth(), text.underlineDashArrayProperty());
            this.cap = text.getUnderlineCap();
        }

        public boolean equalsFaster(UnderlineAttributes attr) {
            return super.equalsFaster(attr) && Objects.equals((Object)this.cap, (Object)attr.cap);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof UnderlineAttributes) {
                UnderlineAttributes attr = (UnderlineAttributes)obj;
                return this.equalsFaster(attr);
            }
            return false;
        }

        public String toString() {
            return String.format("UnderlineAttributes[cap=%s %s]", new Object[]{this.cap, this.getSubString()});
        }
    }

    private static class BorderAttributes
    extends LineAttributesBase {
        final StrokeType type;

        BorderAttributes(TextExt text) {
            super(text.getBorderStrokeColor(), text.getBorderStrokeWidth(), text.borderStrokeDashArrayProperty());
            this.type = text.getBorderStrokeType();
        }

        public boolean equalsFaster(BorderAttributes attr) {
            return super.equalsFaster(attr) && Objects.equals((Object)this.type, (Object)attr.type);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BorderAttributes) {
                BorderAttributes attributes = (BorderAttributes)obj;
                return this.equalsFaster(attributes);
            }
            return false;
        }

        public String toString() {
            return String.format("BorderAttributes[type=%s %s]", new Object[]{this.type, this.getSubString()});
        }
    }

    private static class CustomCssShapeHelper<T> {
        private final List<Tuple2<T, IndexRange>> ranges = new LinkedList<Tuple2<T, IndexRange>>();
        private final List<Path> shapes = new LinkedList<Path>();
        private final Supplier<Path> createShape;
        private final BiConsumer<Path, Tuple2<T, IndexRange>> configureShape;
        private final Consumer<Path> addToChildren;
        private final Consumer<Collection<Path>> clearUnusedShapes;

        CustomCssShapeHelper(Supplier<Path> createShape, BiConsumer<Path, Tuple2<T, IndexRange>> configureShape, Consumer<Path> addToChildren, Consumer<Collection<Path>> clearUnusedShapes) {
            this.createShape = createShape;
            this.configureShape = configureShape;
            this.addToChildren = addToChildren;
            this.clearUnusedShapes = clearUnusedShapes;
        }

        private void updateSharedShapeRange(T value, int start2, int end, BiFunction<T, T, Boolean> equals) {
            Runnable addNewValueRange = () -> this.ranges.add(Tuples.t(value, new IndexRange(start2, end)));
            if (this.ranges.isEmpty()) {
                addNewValueRange.run();
            } else {
                int lastIndex = this.ranges.size() - 1;
                Tuple2<T, IndexRange> lastShapeValueRange = this.ranges.get(lastIndex);
                Object lastShapeValue = lastShapeValueRange._1;
                int prevEndNext = lastShapeValueRange.get2().getEnd();
                if (start2 == prevEndNext && equals.apply(lastShapeValue, value).booleanValue()) {
                    IndexRange lastRange = (IndexRange)lastShapeValueRange._2;
                    IndexRange extendedRange = new IndexRange(lastRange.getStart(), end);
                    this.ranges.set(lastIndex, Tuples.t(lastShapeValue, extendedRange));
                } else {
                    addNewValueRange.run();
                }
            }
        }

        private void updateSharedShapes() {
            int availableNumber;
            int neededNumber = this.ranges.size();
            if (neededNumber < (availableNumber = this.shapes.size())) {
                List<Path> unusedShapes = this.shapes.subList(neededNumber, availableNumber);
                this.clearUnusedShapes.accept(unusedShapes);
                unusedShapes.clear();
            } else if (availableNumber < neededNumber) {
                for (int i = 0; i < neededNumber - availableNumber; ++i) {
                    Path shape = this.createShape.get();
                    this.shapes.add(shape);
                    this.addToChildren.accept(shape);
                }
            }
            for (int i = 0; i < this.ranges.size(); ++i) {
                this.configureShape.accept(this.shapes.get(i), this.ranges.get(i));
            }
            this.ranges.clear();
        }
    }
}

