/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import javafx.beans.property.ObjectProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.SelectionImpl;

class LineSelection<PS, SEG, S>
extends SelectionImpl<PS, SEG, S> {
    LineSelection(GenericStyledArea<PS, SEG, S> area, ObjectProperty<Paint> lineHighlighterFill) {
        super("line-highlighter", area, path2 -> {
            if (lineHighlighterFill == null) {
                path2.setHighlightFill(Color.YELLOW);
            } else {
                path2.highlightFillProperty().bind(lineHighlighterFill);
            }
            path2.getElements().addListener(chg -> {
                if (chg.next() && chg.wasAdded() || chg.wasReplaced()) {
                    double width = path2.getParent().getLayoutBounds().getWidth();
                    chg.getAddedSubList().stream().skip(1L).limit(2L).forEach(ele -> ((LineTo)ele).setX(width));
                    if (chg.getAddedSize() > 5) {
                        path2.getElements().remove(5, 10);
                    }
                    path2.toBack();
                }
            });
        });
    }

    @Override
    public void selectRange(int start2, int end) {
        this.selectCurrentLine();
    }

    public void selectCurrentLine() {
        int p = this.getArea().getCurrentParagraph();
        int start2 = this.getArea().getAbsolutePosition(p, this.getArea().getCurrentLineStartInParargraph());
        int end = this.getArea().getAbsolutePosition(p, this.getArea().getCurrentLineEndInParargraph());
        super.selectRange(start2, end > start2 ? end : start2 + 1);
    }
}

