/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import org.fxmisc.flowless.Virtualized;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class ScaledVirtualized<V extends Node>
extends Region
implements Virtualized {
    private final V content;
    private Scale zoom = new Scale();
    private Val<Double> estHeight;
    private Val<Double> estWidth;
    private Var<Double> estScrollX;
    private Var<Double> estScrollY;

    public ScaledVirtualized(V content2) {
        this.content = content2;
        this.getChildren().add((Node)content2);
        this.getTransforms().add(this.zoom);
        this.estHeight = Val.combine(((Virtualized)content2).totalHeightEstimateProperty(), this.zoom.yProperty(), (estHeight, scaleFactor) -> estHeight * scaleFactor.doubleValue());
        this.estWidth = Val.combine(((Virtualized)content2).totalWidthEstimateProperty(), this.zoom.xProperty(), (estWidth, scaleFactor) -> estWidth * scaleFactor.doubleValue());
        this.estScrollX = Var.mapBidirectional(((Virtualized)content2).estimatedScrollXProperty(), scrollX -> scrollX * this.zoom.getX(), scrollX -> scrollX / this.zoom.getX());
        this.estScrollY = Var.mapBidirectional(((Virtualized)content2).estimatedScrollYProperty(), scrollY -> scrollY * this.zoom.getY(), scrollY -> scrollY / this.zoom.getY());
        this.zoom.xProperty().addListener((obs, ov, nv) -> this.requestLayout());
        this.zoom.yProperty().addListener((obs, ov, nv) -> this.requestLayout());
        this.zoom.zProperty().addListener((obs, ov, nv) -> this.requestLayout());
        this.zoom.pivotXProperty().addListener((obs, ov, nv) -> this.requestLayout());
        this.zoom.pivotYProperty().addListener((obs, ov, nv) -> this.requestLayout());
        this.zoom.pivotZProperty().addListener((obs, ov, nv) -> this.requestLayout());
    }

    @Override
    protected void layoutChildren() {
        double width = this.getLayoutBounds().getWidth();
        double height = this.getLayoutBounds().getHeight();
        ((Node)this.content).resize(width / this.zoom.getX(), height / this.zoom.getY());
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return this.estScrollX;
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return this.estScrollY;
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return this.estHeight;
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return this.estWidth;
    }

    @Override
    public void scrollXBy(double deltaX) {
        ((Virtualized)this.content).scrollXBy(deltaX);
    }

    @Override
    public void scrollYBy(double deltaY) {
        ((Virtualized)this.content).scrollYBy(deltaY);
    }

    @Override
    public void scrollXToPixel(double pixel) {
        ((Virtualized)this.content).scrollXToPixel(pixel);
    }

    @Override
    public void scrollYToPixel(double pixel) {
        ((Virtualized)this.content).scrollYToPixel(pixel);
    }

    public Scale getZoom() {
        return this.zoom;
    }
}

