/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import javafx.beans.property.DoubleProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.OrientationHelper;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

final class HorizontalHelper
implements OrientationHelper {
    HorizontalHelper() {
    }

    @Override
    public Orientation getContentBias() {
        return Orientation.VERTICAL;
    }

    @Override
    public double getX(double x, double y) {
        return y;
    }

    @Override
    public double getY(double x, double y) {
        return x;
    }

    @Override
    public double minBreadth(Node node) {
        return node.minHeight(-1.0);
    }

    @Override
    public double prefBreadth(Node node) {
        return node.prefHeight(-1.0);
    }

    @Override
    public double prefLength(Node node, double breadth) {
        return node.prefWidth(breadth);
    }

    @Override
    public double breadth(Bounds bounds) {
        return bounds.getHeight();
    }

    @Override
    public double length(Bounds bounds) {
        return bounds.getWidth();
    }

    @Override
    public double minX(Bounds bounds) {
        return bounds.getMinY();
    }

    @Override
    public double minY(Bounds bounds) {
        return bounds.getMinX();
    }

    @Override
    public double layoutX(Node node) {
        return node.getLayoutY();
    }

    @Override
    public double layoutY(Node node) {
        return node.getLayoutX();
    }

    @Override
    public DoubleProperty layoutYProperty(Node node) {
        return node.layoutXProperty();
    }

    @Override
    public void resizeRelocate(Node node, double b0, double l0, double breadth, double length) {
        node.resizeRelocate(l0, b0, length, breadth);
    }

    @Override
    public void resize(Node node, double breadth, double length) {
        node.resize(length, breadth);
    }

    @Override
    public void relocate(Node node, double b0, double l0) {
        node.relocate(l0, b0);
    }

    @Override
    public Val<Double> widthEstimateProperty(VirtualFlow<?, ?> content2) {
        return content2.totalLengthEstimateProperty();
    }

    @Override
    public Val<Double> heightEstimateProperty(VirtualFlow<?, ?> content2) {
        return content2.totalBreadthEstimateProperty();
    }

    @Override
    public Var<Double> estimatedScrollXProperty(VirtualFlow<?, ?> content2) {
        return content2.lengthOffsetEstimateProperty();
    }

    @Override
    public Var<Double> estimatedScrollYProperty(VirtualFlow<?, ?> content2) {
        return content2.breadthOffsetProperty();
    }

    @Override
    public void scrollHorizontallyBy(VirtualFlow<?, ?> content2, double dx) {
        content2.scrollLength(dx);
    }

    @Override
    public void scrollVerticallyBy(VirtualFlow<?, ?> content2, double dy) {
        content2.scrollBreadth(dy);
    }

    @Override
    public void scrollHorizontallyToPixel(VirtualFlow<?, ?> content2, double pixel) {
        content2.setLengthOffset(pixel);
    }

    @Override
    public void scrollVerticallyToPixel(VirtualFlow<?, ?> content2, double pixel) {
        content2.setBreadthOffset(pixel);
    }

    @Override
    public <C extends Cell<?, ?>> VirtualFlowHit<C> hitBeforeCells(double bOff, double lOff) {
        return VirtualFlowHit.hitBeforeCells(lOff, bOff);
    }

    @Override
    public <C extends Cell<?, ?>> VirtualFlowHit<C> hitAfterCells(double bOff, double lOff) {
        return VirtualFlowHit.hitAfterCells(lOff, bOff);
    }

    @Override
    public <C extends Cell<?, ?>> VirtualFlowHit<C> cellHit(int itemIndex, C cell, double bOff, double lOff) {
        return VirtualFlowHit.cellHit(itemIndex, cell, lOff, bOff);
    }
}

