/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javafx.scene.Node;
import org.fxmisc.flowless.Cell;

abstract class CellWrapper<T, N extends Node, C extends Cell<T, N>>
implements Cell<T, N> {
    private final C delegate;

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> beforeDispose(C cell, final Runnable action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void dispose() {
                action.run();
                super.dispose();
            }
        };
    }

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> afterDispose(C cell, final Runnable action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void dispose() {
                super.dispose();
                action.run();
            }
        };
    }

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> beforeReset(C cell, final Runnable action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void reset() {
                action.run();
                super.reset();
            }
        };
    }

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> afterReset(C cell, final Runnable action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void reset() {
                super.reset();
                action.run();
            }
        };
    }

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> beforeUpdateItem(C cell, final Consumer<? super T> action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void updateItem(T item) {
                action.accept(item);
                super.updateItem(item);
            }
        };
    }

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> afterUpdateItem(C cell, final Consumer<? super T> action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void updateItem(T item) {
                super.updateItem(item);
                action.accept(item);
            }
        };
    }

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> beforeUpdateIndex(C cell, final IntConsumer action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void updateIndex(int index) {
                action.accept(index);
                super.updateIndex(index);
            }
        };
    }

    public static <T, N extends Node, C extends Cell<T, N>> CellWrapper<T, N, C> afterUpdateIndex(C cell, final IntConsumer action) {
        return new CellWrapper<T, N, C>(cell){

            @Override
            public void updateIndex(int index) {
                super.updateIndex(index);
                action.accept(index);
            }
        };
    }

    public CellWrapper(C delegate) {
        this.delegate = delegate;
    }

    public C getDelegate() {
        return this.delegate;
    }

    @Override
    public N getNode() {
        return this.delegate.getNode();
    }

    @Override
    public boolean isReusable() {
        return this.delegate.isReusable();
    }

    @Override
    public void updateItem(T item) {
        this.delegate.updateItem(item);
    }

    @Override
    public void updateIndex(int index) {
        this.delegate.updateIndex(index);
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

