/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.launcher;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.launcher.Java13CommandLauncher;
import org.apache.commons.exec.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VmsCommandLauncher
extends Java13CommandLauncher {
    @Override
    public Process exec(CommandLine cmd, Map<String, String> env) throws IOException {
        CommandLine vmsCmd = new CommandLine(this.createCommandFile(cmd, env).getPath());
        return super.exec(vmsCmd, env);
    }

    @Override
    public Process exec(CommandLine cmd, Map<String, String> env, File workingDir) throws IOException {
        CommandLine vmsCmd = new CommandLine(this.createCommandFile(cmd, env).getPath());
        return super.exec(vmsCmd, env, workingDir);
    }

    @Override
    public boolean isFailure(int exitValue) {
        return exitValue % 2 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCommandFile(CommandLine cmd, Map<String, String> env) throws IOException {
        File script = File.createTempFile("EXEC", ".TMP");
        script.deleteOnExit();
        PrintWriter out2 = null;
        try {
            String[] args2;
            out2 = new PrintWriter(new FileWriter(script.getAbsolutePath(), true));
            if (env != null) {
                Set<Map.Entry<String, String>> entries2 = env.entrySet();
                for (Map.Entry<String, String> entry : entries2) {
                    out2.print("$ ");
                    out2.print(entry.getKey());
                    out2.print(" == ");
                    out2.println('\"');
                    String value = entry.getValue();
                    if (value.indexOf(34) > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < value.length(); ++i) {
                            char c = value.charAt(i);
                            if (c == '\"') {
                                sb.append('\"');
                            }
                            sb.append(c);
                        }
                        value = sb.toString();
                    }
                    out2.print(value);
                    out2.println('\"');
                }
            }
            String command2 = cmd.getExecutable();
            if (cmd.isFile()) {
                out2.print("$ @");
                String[] parts = StringUtils.split(command2, "/");
                out2.print(parts[0]);
                out2.print(":[");
                out2.print(parts[1]);
                int lastPart = parts.length - 1;
                for (int i = 2; i < lastPart; ++i) {
                    out2.print(".");
                    out2.print(parts[i]);
                }
                out2.print("]");
                out2.print(parts[lastPart]);
            } else {
                out2.print("$ ");
                out2.print(command2);
            }
            for (String arg : args2 = cmd.getArguments()) {
                out2.println(" -");
                out2.print(arg);
            }
            out2.println();
        }
        finally {
            if (out2 != null) {
                out2.close();
            }
        }
        return script;
    }
}

