/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.ExpandedTypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorBasedTypeSignatureMappingKt {
    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        Object object;
        T jvmType;
        ClassifierDescriptor classifierDescriptor;
        Object builtInType;
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        Intrinsics.checkNotNullParameter(factory, "factory");
        Intrinsics.checkNotNullParameter(mode, "mode");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, "typeMappingConfiguration");
        Intrinsics.checkNotNullParameter(writeGenericType, "writeGenericType");
        KotlinType kotlinType2 = typeMappingConfiguration.preprocessType(kotlinType);
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType newType = kotlinType3;
            boolean bl3 = false;
            return DescriptorBasedTypeSignatureMappingKt.mapType(newType, factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType, typeMappingConfiguration.releaseCoroutines()), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        Object object2 = SimpleClassicTypeSystemContext.INSTANCE;
        boolean bl = false;
        boolean bl4 = false;
        SimpleClassicTypeSystemContext $this$mapType_u24lambda_u2d1 = object2;
        boolean bl5 = false;
        kotlinType2 = TypeSignatureMappingKt.mapBuiltInType($this$mapType_u24lambda_u2d1, kotlinType, factory, mode);
        if (kotlinType2 != null) {
            object2 = kotlinType2;
            bl = false;
            bl4 = false;
            builtInType = object2;
            boolean bl6 = false;
            Object jvmType2 = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke(kotlinType, jvmType2, mode);
            return (T)jvmType2;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            KotlinType kotlinType4 = ((IntersectionTypeConstructor)constructor).getAlternativeType();
            KotlinType intersectionType = kotlinType4 == null ? typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)constructor).getSupertypes()) : kotlinType4;
            return DescriptorBasedTypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(intersectionType), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter = constructor.getDeclarationDescriptor();
        if (jvmDescriptorTypeWriter == null) {
            throw new UnsupportedOperationException(Intrinsics.stringPlus("no descriptor for type constructor of ", kotlinType));
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor = jvmDescriptorTypeWriter;
        if (ErrorUtils.isError(descriptor2)) {
            jvmType = factory.createObjectType("error/NonExistentClass");
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)descriptor2);
            jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                jvmDescriptorTypeWriter.writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            if (kotlinType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            builtInType = memberProjection.getType();
            Intrinsics.checkNotNullExpressionValue(builtInType, "memberProjection.type");
            Object memberType = builtInType;
            Object arrayElementType = null;
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter2 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter2 != null) {
                    JvmDescriptorTypeWriter<T> jvmType2 = jvmDescriptorTypeWriter2;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    JvmDescriptorTypeWriter<T> $this$mapType_u24lambda_u2d3 = jvmType2;
                    boolean bl9 = false;
                    $this$mapType_u24lambda_u2d3.writeArrayType();
                    $this$mapType_u24lambda_u2d3.writeClass(arrayElementType);
                    $this$mapType_u24lambda_u2d3.writeArrayEnd();
                }
            } else {
                Object object3 = descriptorTypeWriter;
                if (object3 != null) {
                    ((JvmDescriptorTypeWriter)object3).writeArrayType();
                }
                object3 = memberProjection.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue(object3, "memberProjection.projectionKind");
                arrayElementType = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)memberType, factory, mode.toGenericArgumentMode((Variance)((Object)object3), true), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
                object3 = descriptorTypeWriter;
                if (object3 != null) {
                    ((JvmDescriptorTypeWriter)object3).writeArrayEnd();
                }
            }
            return factory.createFromString(Intrinsics.stringPlus("[", factory.toString(arrayElementType)));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Object object4;
            KotlinType expandedType;
            if (InlineClassesUtilsKt.isInlineClass(descriptor2) && !mode.getNeedInlineClassWrapping() && (expandedType = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass(SimpleClassicTypeSystemContext.INSTANCE, kotlinType)) != null) {
                return DescriptorBasedTypeSignatureMappingKt.mapType(expandedType, factory, mode.wrapInlineClassesMode(), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                object4 = factory.getJavaLangClassType();
            } else {
                object = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkNotNullExpressionValue(object, "descriptor.original");
                jvmDescriptorTypeWriter = typeMappingConfiguration.getPredefinedTypeForClass((ClassDescriptor)object);
                if (jvmDescriptorTypeWriter == null) {
                    boolean bl10 = false;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    ClassDescriptor enumClassIfEnumEntry = ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY ? (ClassDescriptor)((ClassDescriptor)descriptor2).getContainingDeclaration() : (ClassDescriptor)descriptor2;
                    ClassDescriptor classDescriptor = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkNotNullExpressionValue(classDescriptor, "enumClassIfEnumEntry.original");
                    object4 = factory.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration));
                } else {
                    object4 = jvmDescriptorTypeWriter;
                }
            }
            jvmType = object4;
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            jvmDescriptorTypeWriter = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2);
            object = FunctionsKt.getDO_NOTHING_3();
            T type2 = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)((Object)jvmDescriptorTypeWriter), factory, mode, typeMappingConfiguration, null, object);
            jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                object = descriptor2.getName();
                Intrinsics.checkNotNullExpressionValue(object, "descriptor.getName()");
                jvmDescriptorTypeWriter.writeTypeVariable((Name)object, type2);
            }
            return type2;
        }
        if (descriptor2 instanceof TypeAliasDescriptor && mode.getMapTypeAliases()) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(((TypeAliasDescriptor)descriptor2).getExpandedType(), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        throw new UnsupportedOperationException(Intrinsics.stringPlus("Unknown type ", kotlinType));
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        Intrinsics.checkNotNull(kotlinType2);
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, "typeMappingConfiguration");
        String string2 = typeMappingConfiguration.getPredefinedFullInternalNameForClass(klass);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            return it;
        }
        DeclarationDescriptor declarationDescriptor = klass.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "klass.containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        String string4 = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string4, "safeIdentifier(klass.name).identifier");
        String name = string4;
        if (container instanceof PackageFragmentDescriptor) {
            String string5;
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (fqName2.isRoot()) {
                string5 = name;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string6 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue(string6, "fqName.asString()");
                string5 = stringBuilder.append(StringsKt.replace$default(string6, '.', '/', false, 4, null)).append('/').append(name).toString();
            }
            return string5;
        }
        ClassDescriptor classDescriptor2 = classDescriptor = container instanceof ClassDescriptor ? (ClassDescriptor)container : null;
        if (classDescriptor == null) {
            throw new IllegalArgumentException("Unexpected container: " + container + " for " + klass);
        }
        ClassDescriptor containerClass = classDescriptor;
        String string7 = typeMappingConfiguration.getPredefinedInternalNameForClass(containerClass);
        String containerInternalName = string7 == null ? DescriptorBasedTypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration) : string7;
        return containerInternalName + '$' + name;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }
}

