/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import javafx.application.Application;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.converter.StringConverter;
import javafx.scene.text.Font;

public final class URLConverter
extends StyleConverter<ParsedValue[], String> {
    public static StyleConverter<ParsedValue[], String> getInstance() {
        return Holder.INSTANCE;
    }

    private URLConverter() {
    }

    @Override
    public String convert(ParsedValue<ParsedValue[], String> parsedValue, Font font) {
        String string2;
        URL uRL;
        String string3;
        String string4 = null;
        ParsedValue[] parsedValueArray = parsedValue.getValue();
        String string5 = string3 = parsedValueArray.length > 0 ? StringConverter.getInstance().convert(parsedValueArray[0], font) : null;
        if (string3 != null && !string3.trim().isEmpty() && (uRL = this.resolve(string2 = parsedValueArray.length > 1 && parsedValueArray[1] != null ? (String)parsedValueArray[1].getValue() : null, string3 = string3.startsWith("url(") ? Utils.stripQuotes(string3.substring(4, string3.length() - 1)) : Utils.stripQuotes(string3))) != null) {
            string4 = uRL.toExternalForm();
        }
        return string4;
    }

    URL resolve(String string2, String string3) {
        String string4;
        String string5 = string4 = string3 != null ? string3.trim() : null;
        if (string4 == null || string4.isEmpty()) {
            return null;
        }
        try {
            String string6;
            URI uRI = new URI(string4);
            if (uRI.isAbsolute()) {
                return uRI.toURL();
            }
            URL uRL = this.resolveRuntimeImport(uRI);
            if (uRL != null) {
                return uRL;
            }
            String string7 = uRI.getPath();
            if (string7.startsWith("/")) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader.getResource(string7.substring(1));
            }
            String string8 = string6 = string2 != null ? string2.trim() : null;
            if (string6 != null && !string6.isEmpty()) {
                URI uRI2 = new URI(string6);
                if (!uRI2.isOpaque()) {
                    URI uRI3 = uRI2.resolve(uRI);
                    return uRI3.toURL();
                }
                URL uRL2 = uRI2.toURL();
                return new URL(uRL2, uRI.getPath());
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.getResource(string7);
        }
        catch (MalformedURLException | URISyntaxException exception2) {
            PlatformLogger platformLogger = Logging.getCSSLogger();
            if (platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                platformLogger.warning(exception2.getLocalizedMessage());
            }
            return null;
        }
    }

    private URL resolveRuntimeImport(URI uRI) {
        String string2;
        String string3 = uRI.getPath();
        String string4 = string2 = string3.startsWith("/") ? string3.substring(1) : string3;
        if ((string2.startsWith("com/sun/javafx/scene/control/skin/modena/") || string2.startsWith("com/sun/javafx/scene/control/skin/caspian/")) && (string2.endsWith(".css") || string2.endsWith(".bss"))) {
            System.err.println("WARNING: resolveRuntimeImport cannot resolve: " + string2);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL uRL = classLoader.getResource(string2);
                return uRL;
            }
            try {
                URL uRL = AccessController.doPrivileged(() -> {
                    ProtectionDomain protectionDomain = Application.class.getProtectionDomain();
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    return codeSource.getLocation();
                });
                URI uRI2 = uRL.toURI();
                String string5 = uRI2.getScheme();
                String string6 = uRI2.getPath();
                if ("file".equals(string5) && string6.endsWith(".jar") && "file".equals(string5)) {
                    string5 = "jar:file";
                    string6 = string6.concat("!/");
                }
                string6 = string6.concat(string2);
                String string7 = uRI2.getUserInfo();
                String string8 = uRI2.getHost();
                int n = uRI2.getPort();
                URI uRI3 = new URI(string5, string7, string8, n, string6, null, null);
                return uRI3.toURL();
            }
            catch (MalformedURLException | URISyntaxException | PrivilegedActionException exception2) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        return "URLType";
    }

    private static class Holder {
        static final URLConverter INSTANCE = new URLConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue[], String>[], String[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public String[] convert(ParsedValue<ParsedValue<ParsedValue[], String>[], String[]> parsedValue, Font font) {
            ParsedValue<ParsedValue[], String>[] parsedValueArray = parsedValue.getValue();
            String[] stringArray = new String[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                stringArray[i] = URLConverter.getInstance().convert(parsedValueArray[i], font);
            }
            return stringArray;
        }

        public String toString() {
            return "URLSeqType";
        }
    }
}

