/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.repl;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.parsing.ParseException;
import it.unibo.tuprolog.core.parsing.TermParserExtensions;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.Solver;
import it.unibo.tuprolog.ui.repl.TuPrologCmd;
import it.unibo.tuprolog.ui.repl.TuPrologUtils;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lit/unibo/tuprolog/ui/repl/TuPrologSolveQuery;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "maxSolutions", "", "getMaxSolutions", "()I", "maxSolutions$delegate", "Lkotlin/properties/ReadOnlyProperty;", "parentCommand", "Lit/unibo/tuprolog/ui/repl/TuPrologCmd;", "getParentCommand", "()Lit/unibo/tuprolog/ui/repl/TuPrologCmd;", "query", "", "getQuery", "()Ljava/lang/String;", "query$delegate", "evalAndPrint", "", "solver", "Lit/unibo/tuprolog/solve/Solver;", "run", "repl"})
public final class TuPrologSolveQuery
extends CliktCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty query$delegate = ArgumentKt.argument$default(this, null, null, null, null, 15, null).provideDelegate(this, $$delegatedProperties[0]);
    @NotNull
    private final ReadOnlyProperty maxSolutions$delegate;

    public TuPrologSolveQuery() {
        super("Compute a particular query and then terminate", null, "solve", false, false, null, null, false, false, 506, null);
        String[] stringArray = new String[]{"-n", "--numberOfSolutions"};
        this.maxSolutions$delegate = OptionWithValuesKt.default$default(IntKt.int(OptionWithValuesKt.option$default(this, stringArray, "Number of solution to calculate", null, false, null, null, null, null, 252, null)), 0, null, 2, null).provideDelegate(this, $$delegatedProperties[1]);
    }

    private final String getQuery() {
        return (String)this.query$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final int getMaxSolutions() {
        return ((Number)this.maxSolutions$delegate.getValue(this, $$delegatedProperties[1])).intValue();
    }

    private final TuPrologCmd getParentCommand() {
        CliktCommand cliktCommand;
        Context context2 = this.getCurrentContext().getParent();
        CliktCommand cliktCommand2 = cliktCommand = context2 == null ? null : context2.getCommand();
        if (cliktCommand == null) {
            throw new NullPointerException("null cannot be cast to non-null type it.unibo.tuprolog.ui.repl.TuPrologCmd");
        }
        return (TuPrologCmd)cliktCommand;
    }

    @Override
    public void run() {
        Solver solver2 = this.getParentCommand().getSolver();
        this.evalAndPrint(solver2);
    }

    private final void evalAndPrint(Solver solver2) {
        block5: {
            CharSequence charSequence = this.getQuery();
            boolean bl = false;
            if (charSequence.length() > 0) {
                try {
                    long duration = this.getParentCommand().getTimeout();
                    Iterator<Solution> solutions2 = solver2.solve(TermParserExtensions.parse(Struct.Companion, this.getQuery()), duration).iterator();
                    if (this.getMaxSolutions() == 0) {
                        TuPrologUtils.INSTANCE.printSolutions(solutions2, solver2.getOperators());
                        break block5;
                    }
                    TuPrologUtils.INSTANCE.printNumSolutions(solutions2, this.getMaxSolutions(), solver2.getOperators());
                }
                catch (ParseException e) {
                    TuPrologUtils.INSTANCE.printParseException(e);
                }
            } else {
                charSequence = "throw adequate exception";
                bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + (String)charSequence);
            }
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(TuPrologSolveQuery.class, "query", "getQuery()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(TuPrologSolveQuery.class, "maxSolutions", "getMaxSolutions()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

