/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import it.unibo.tuprolog.ui.gui.GraphvizRenderer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020,H\u0002J\b\u0010/\u001a\u00020,H\u0002J\u0018\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u000203H\u0002R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00068\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001e\u0010\u000e\u001a\u00020\u00068\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020 8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020&8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00065"}, d2={"Lit/unibo/tuprolog/ui/gui/GraphRenderView;", "Ljavafx/scene/layout/VBox;", "dotGraph", "", "(Ljava/lang/String;)V", "btnCopy", "Ljavafx/scene/control/Button;", "getBtnCopy", "()Ljavafx/scene/control/Button;", "setBtnCopy", "(Ljavafx/scene/control/Button;)V", "btnRender", "getBtnRender", "setBtnRender", "btnSave", "getBtnSave", "setBtnSave", "imageBytes", "", "imageView", "Ljavafx/scene/image/ImageView;", "getImageView", "()Ljavafx/scene/image/ImageView;", "setImageView", "(Ljavafx/scene/image/ImageView;)V", "labelMsg", "Ljavafx/scene/control/Label;", "getLabelMsg", "()Ljavafx/scene/control/Label;", "setLabelMsg", "(Ljavafx/scene/control/Label;)V", "progressBar", "Ljavafx/scene/control/ProgressBar;", "getProgressBar", "()Ljavafx/scene/control/ProgressBar;", "setProgressBar", "(Ljavafx/scene/control/ProgressBar;)V", "textArea", "Ljavafx/scene/control/TextArea;", "getTextArea", "()Ljavafx/scene/control/TextArea;", "setTextArea", "(Ljavafx/scene/control/TextArea;)V", "copyToClipboard", "", "hideMessage", "renderToImage", "saveToFile", "showMessage", "text", "error", "", "Companion", "ide-plp"})
public final class GraphRenderView
extends VBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dotGraph;
    @FXML
    public Button btnCopy;
    @FXML
    public Button btnRender;
    @FXML
    public Button btnSave;
    @FXML
    public TextArea textArea;
    @FXML
    public ImageView imageView;
    @FXML
    public Label labelMsg;
    @FXML
    public ProgressBar progressBar;
    @Nullable
    private byte[] imageBytes;
    @NotNull
    private static final String FXML = "GraphRenderView.fxml";

    public GraphRenderView(@NotNull String dotGraph) {
        Intrinsics.checkNotNullParameter(dotGraph, "dotGraph");
        this.dotGraph = dotGraph;
        FXMLLoader loader = new FXMLLoader(GraphRenderView.class.getResource(FXML));
        loader.setController(this);
        loader.setRoot(this);
        try {
            loader.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.getBtnCopy().setOnAction(arg_0 -> GraphRenderView._init_$lambda-0(this, arg_0));
        this.getBtnRender().setOnAction(arg_0 -> GraphRenderView._init_$lambda-1(this, arg_0));
        this.getBtnSave().setOnAction(arg_0 -> GraphRenderView._init_$lambda-2(this, arg_0));
        this.getBtnSave().setVisible(false);
        this.getImageView().setVisible(false);
        this.getTextArea().setText(this.dotGraph);
        this.getBtnRender().setDisable(!GraphvizRenderer.INSTANCE.isAvailable());
        if (!GraphvizRenderer.INSTANCE.isReady()) {
            this.showMessage("The image renderer is still initializing...\nClose and reopen this panel in few seconds.", true);
        } else if (!GraphvizRenderer.INSTANCE.isAvailable()) {
            this.showMessage("The image renderer is not available.\nPlease check the docs at: https://github.com/nidi3/graphviz-java", true);
        } else {
            this.showMessage("The image rendered is ready.", false);
        }
    }

    @NotNull
    public final Button getBtnCopy() {
        Button button = this.btnCopy;
        if (button != null) {
            return button;
        }
        Intrinsics.throwUninitializedPropertyAccessException("btnCopy");
        return null;
    }

    public final void setBtnCopy(@NotNull Button button) {
        Intrinsics.checkNotNullParameter(button, "<set-?>");
        this.btnCopy = button;
    }

    @NotNull
    public final Button getBtnRender() {
        Button button = this.btnRender;
        if (button != null) {
            return button;
        }
        Intrinsics.throwUninitializedPropertyAccessException("btnRender");
        return null;
    }

    public final void setBtnRender(@NotNull Button button) {
        Intrinsics.checkNotNullParameter(button, "<set-?>");
        this.btnRender = button;
    }

    @NotNull
    public final Button getBtnSave() {
        Button button = this.btnSave;
        if (button != null) {
            return button;
        }
        Intrinsics.throwUninitializedPropertyAccessException("btnSave");
        return null;
    }

    public final void setBtnSave(@NotNull Button button) {
        Intrinsics.checkNotNullParameter(button, "<set-?>");
        this.btnSave = button;
    }

    @NotNull
    public final TextArea getTextArea() {
        TextArea textArea = this.textArea;
        if (textArea != null) {
            return textArea;
        }
        Intrinsics.throwUninitializedPropertyAccessException("textArea");
        return null;
    }

    public final void setTextArea(@NotNull TextArea textArea) {
        Intrinsics.checkNotNullParameter(textArea, "<set-?>");
        this.textArea = textArea;
    }

    @NotNull
    public final ImageView getImageView() {
        ImageView imageView = this.imageView;
        if (imageView != null) {
            return imageView;
        }
        Intrinsics.throwUninitializedPropertyAccessException("imageView");
        return null;
    }

    public final void setImageView(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter(imageView, "<set-?>");
        this.imageView = imageView;
    }

    @NotNull
    public final Label getLabelMsg() {
        Label label = this.labelMsg;
        if (label != null) {
            return label;
        }
        Intrinsics.throwUninitializedPropertyAccessException("labelMsg");
        return null;
    }

    public final void setLabelMsg(@NotNull Label label) {
        Intrinsics.checkNotNullParameter(label, "<set-?>");
        this.labelMsg = label;
    }

    @NotNull
    public final ProgressBar getProgressBar() {
        ProgressBar progressBar = this.progressBar;
        if (progressBar != null) {
            return progressBar;
        }
        Intrinsics.throwUninitializedPropertyAccessException("progressBar");
        return null;
    }

    public final void setProgressBar(@NotNull ProgressBar progressBar) {
        Intrinsics.checkNotNullParameter(progressBar, "<set-?>");
        this.progressBar = progressBar;
    }

    private final void copyToClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        Intrinsics.checkNotNullExpressionValue(clipboard, "getSystemClipboard()");
        Clipboard clipboard2 = clipboard;
        ClipboardContent content2 = new ClipboardContent();
        content2.putString(this.dotGraph);
        content2.putHtml(this.dotGraph);
        clipboard2.setContent(content2);
        this.showMessage("Text has been copied to clipboard.", false);
    }

    private final void renderToImage() {
        if (!GraphvizRenderer.INSTANCE.isAvailable()) {
            return;
        }
        this.getProgressBar().setVisible(true);
        this.showMessage("Rendering graph image...", false);
        GraphRenderView graphRenderView = this;
        boolean bl = false;
        boolean bl2 = false;
        GraphRenderView it = graphRenderView;
        boolean bl3 = false;
        CompletableFuture.supplyAsync(() -> GraphRenderView.renderToImage$lambda-5$lambda-4(this, it));
    }

    private final void saveToFile() {
        if (this.imageBytes != null && this.getImageView().isVisible()) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save Image");
            FileChooser.ExtensionFilter[] extensionFilterArray = new FileChooser.ExtensionFilter[2];
            Object object = new String[]{"*.png"};
            extensionFilterArray[0] = new FileChooser.ExtensionFilter("PNG image file", (String)object);
            object = new String[]{"*.*"};
            extensionFilterArray[1] = new FileChooser.ExtensionFilter("All files", (String)object);
            fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])extensionFilterArray);
            fileChooser.setInitialFileName("bdd-" + System.currentTimeMillis() + ".png");
            File file = fileChooser.showSaveDialog(this.getScene().getWindow());
            this.showMessage("Saving image to file...", false);
            object = file;
            if (object != null) {
                Intrinsics.checkNotNull(this.imageBytes);
                FilesKt.writeBytes((File)object, this.imageBytes);
            }
            this.showMessage("File saved successfully.", false);
        }
    }

    private final void showMessage(String text, boolean error) {
        this.getLabelMsg().setText(text);
        this.getLabelMsg().setTextFill(Color.color(error ? 1.0 : 0.0, 0.0, 0.0));
        this.getLabelMsg().setVisible(true);
    }

    private final void hideMessage() {
        this.getLabelMsg().setVisible(false);
    }

    private static final void _init_$lambda-0(GraphRenderView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.copyToClipboard();
    }

    private static final void _init_$lambda-1(GraphRenderView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.renderToImage();
    }

    private static final void _init_$lambda-2(GraphRenderView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.saveToFile();
    }

    private static final void renderToImage$lambda-5$lambda-4$lambda-3(GraphRenderView this$0, GraphRenderView $it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($it, "$it");
        this$0.getImageView().setImage(new Image(new ByteArrayInputStream(this$0.imageBytes)));
        this$0.getImageView().setVisible(true);
        this$0.getBtnSave().setVisible(true);
        this$0.getProgressBar().setVisible(false);
        this$0.hideMessage();
        $it.getScene().getWindow().sizeToScene();
    }

    private static final Unit renderToImage$lambda-5$lambda-4(GraphRenderView this$0, GraphRenderView $it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($it, "$it");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GraphvizRenderer.INSTANCE.renderAsPNG(this$0.dotGraph, outputStream);
        this$0.imageBytes = outputStream.toByteArray();
        Platform.runLater(() -> GraphRenderView.renderToImage$lambda-5$lambda-4$lambda-3(this$0, $it));
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lit/unibo/tuprolog/ui/gui/GraphRenderView$Companion;", "", "()V", "FXML", "", "ide-plp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

