/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.problog.lib.knowledge.impl;

import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Fact;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Truth;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.exception.TuPrologException;
import it.unibo.tuprolog.solve.problog.lib.exception.ClauseMappingException;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMapper;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMappingUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/EvidenceClauseMapper;", "Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/ClauseMapper;", "()V", "apply", "", "Lit/unibo/tuprolog/core/Clause;", "clause", "isCompatible", "", "solve-problog"})
public final class EvidenceClauseMapper
implements ClauseMapper {
    @NotNull
    public static final EvidenceClauseMapper INSTANCE = new EvidenceClauseMapper();

    private EvidenceClauseMapper() {
    }

    @Override
    public boolean isCompatible(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter(clause, "clause");
        return clause instanceof Rule && Intrinsics.areEqual(((Rule)clause).getHead().getFunctor(), "evidence");
    }

    @Override
    @NotNull
    public List<Clause> apply(@NotNull Clause clause) {
        Rule rule;
        Term[] termArray;
        Intrinsics.checkNotNullParameter(clause, "clause");
        if (!(clause instanceof Rule)) {
            throw new ClauseMappingException(Intrinsics.stringPlus("Clause is not an instance of Rule: ", clause), null, 2, null);
        }
        if (((Rule)clause).getHead().getArity() > 2) {
            throw new TuPrologException(Intrinsics.stringPlus("Invalid evidence predicate: ", ((Rule)clause).getHead()), null, 2, null);
        }
        if (((Rule)clause).getHead().getArity() == 2 && !(((Rule)clause).getHead().get(1) instanceof Truth)) {
            throw new TuPrologException(Intrinsics.stringPlus("Invalid evidence predicate: ", ((Rule)clause).getHead()), null, 2, null);
        }
        Struct headTerm = ((Rule)clause).getHead();
        if (headTerm.getArity() == 1) {
            termArray = new Term[]{headTerm.get(0), Truth.TRUE};
            headTerm = Struct.Companion.of(headTerm.getFunctor(), termArray);
        }
        if (clause instanceof Fact) {
            rule = Fact.Companion.of(headTerm);
        } else {
            termArray = new Term[]{ClauseMappingUtilsKt.withBodyExplanation(clause.getBody(), Var.Companion.anonymous())};
            rule = Rule.Companion.of(headTerm, termArray);
        }
        return CollectionsKt.listOf(rule);
    }
}

