/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.problog.lib.knowledge.impl;

import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Directive;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.solve.problog.lib.exception.ClauseMappingException;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMapper;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMappingUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/DirectiveClauseMapper;", "Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/ClauseMapper;", "()V", "apply", "", "Lit/unibo/tuprolog/core/Clause;", "clause", "isCompatible", "", "solve-problog"})
public final class DirectiveClauseMapper
implements ClauseMapper {
    @NotNull
    public static final DirectiveClauseMapper INSTANCE = new DirectiveClauseMapper();

    private DirectiveClauseMapper() {
    }

    @Override
    public boolean isCompatible(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter(clause, "clause");
        return clause.isDirective();
    }

    @Override
    @NotNull
    public List<Clause> apply(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter(clause, "clause");
        Term body = clause.getBody();
        if (!(clause instanceof Directive)) {
            throw new ClauseMappingException(Intrinsics.stringPlus("Clause is not an instance of Directive: ", clause), null, 2, null);
        }
        if (body instanceof Struct && (Intrinsics.areEqual(((Struct)body).getFunctor(), "static") || Intrinsics.areEqual(((Struct)body).getFunctor(), "dynamic"))) {
            Term indicatorTerm = ((Struct)body).get(0);
            if (!(indicatorTerm instanceof Indicator)) {
                throw new ClauseMappingException(Intrinsics.stringPlus("Malformed directive: ", clause), null, 2, null);
            }
            Term name = ((Indicator)indicatorTerm).getNameTerm();
            Term arity = ((Indicator)indicatorTerm).getArityTerm();
            if (!(arity instanceof Numeric)) {
                throw new ClauseMappingException(Intrinsics.stringPlus("Malformed directive: ", clause), null, 2, null);
            }
            Term[] termArray = new Term[]{Indicator.Companion.of(name, Numeric.Companion.of(((Numeric)arity).getDecimalValue().toInt() + 1))};
            return CollectionsKt.listOf(Directive.Companion.of(Struct.Companion.of(((Struct)body).getFunctor(), termArray), new Term[0]));
        }
        if (body instanceof Struct && (Intrinsics.areEqual(((Struct)body).getFunctor(), "initialization") || Intrinsics.areEqual(((Struct)body).getFunctor(), "solve"))) {
            Term[] termArray = new Term[]{ClauseMappingUtilsKt.withBodyExplanation(((Struct)body).get(0), Var.Companion.anonymous())};
            return CollectionsKt.listOf(Directive.Companion.of(Struct.Companion.of(((Struct)body).getFunctor(), termArray), new Term[0]));
        }
        return CollectionsKt.listOf(clause);
    }
}

