/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.problog.lib.knowledge.impl;

import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.exception.TuPrologException;
import it.unibo.tuprolog.solve.problog.lib.exception.ClauseMappingException;
import it.unibo.tuprolog.solve.problog.lib.knowledge.ProbExplanation;
import it.unibo.tuprolog.solve.problog.lib.knowledge.ProbTerm;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMapper;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ClauseMappingUtilsKt;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.ProbabilisticClauseMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/AnnotatedDisjunctionClauseMapper;", "Lit/unibo/tuprolog/solve/problog/lib/knowledge/impl/ClauseMapper;", "()V", "apply", "", "Lit/unibo/tuprolog/core/Clause;", "clause", "collectAllHeads", "", "head", "Lit/unibo/tuprolog/core/Term;", "accumulator", "", "Lit/unibo/tuprolog/core/Struct;", "isCompatible", "", "solve-problog"})
public final class AnnotatedDisjunctionClauseMapper
implements ClauseMapper {
    @NotNull
    public static final AnnotatedDisjunctionClauseMapper INSTANCE = new AnnotatedDisjunctionClauseMapper();

    private AnnotatedDisjunctionClauseMapper() {
    }

    @Override
    public boolean isCompatible(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter(clause, "clause");
        return clause instanceof Rule && Intrinsics.areEqual(((Rule)clause).getHead().getFunctor(), ";");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Clause> apply(@NotNull Clause clause) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(clause, "clause");
        if (!(clause instanceof Rule)) {
            throw new ClauseMappingException(Intrinsics.stringPlus("Clause is not an instance of Rule: ", clause), null, 2, null);
        }
        Term body = clause.getBody();
        boolean bl = false;
        List disjointHeads = new ArrayList();
        this.collectAllHeads(((Rule)clause).getHead(), disjointHeads);
        double probSum = 0.0;
        Iterable $this$map$iv = disjointHeads;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void cur;
            Struct struct = (Struct)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            double curProb = ((Numeric)cur.get(0)).getDecimalValue().toDouble();
            Struct curRuleHead = cur.get(1) instanceof Struct ? (Struct)cur.get(1) : Struct.Companion.of(cur.get(1).toString(), new Term[0]);
            Term[] termArray = new Term[]{Numeric.Companion.of(curProb / (1.0 - ((probSum += curProb) - curProb))), curRuleHead};
            Struct struct2 = Struct.Companion.of("::", termArray);
            termArray = new Term[]{body};
            object = ProbabilisticClauseMapper.INSTANCE.mapRuleInternal(Rule.Companion.of(struct2, termArray));
            collection.add(object);
        }
        List mappedRules = CollectionsKt.toList((List)destination$iv$iv);
        ProbExplanation explanation = null;
        explanation = ProbExplanation.Companion.getTRUE();
        Iterable $this$map$iv2 = mappedRules;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            ProbExplanation thisExplanation = ProbExplanation.Companion.of((ProbTerm)it.getSecond());
            ProbExplanation resultExplanation = thisExplanation.and(explanation);
            explanation = explanation.and(thisExplanation.not());
            object = ProbabilisticClauseMapper.INSTANCE.mapRuleWithExplanation((Rule)it.getFirst(), resultExplanation);
            collection.add(object);
        }
        return (List)destination$iv$iv2;
    }

    private final void collectAllHeads(Term head2, List<Struct> accumulator) {
        if (head2 instanceof Struct && ((Struct)head2).getArity() == 2) {
            if (!Intrinsics.areEqual(((Struct)head2).getFunctor(), ";") && !Intrinsics.areEqual(((Struct)head2).getFunctor(), "::")) {
                throw new TuPrologException(Intrinsics.stringPlus("Badly formatted disjoint annotation: ", head2), null, 2, null);
            }
            if (Intrinsics.areEqual(((Struct)head2).getFunctor(), ";")) {
                this.collectAllHeads(((Struct)head2).get(1), accumulator);
            }
        }
        double curHeadProb = 1.0;
        Term curHead = head2;
        if (head2 instanceof Struct) {
            Term term = curHead = Intrinsics.areEqual(((Struct)head2).getFunctor(), ";") ? ((Struct)head2).get(0) : head2;
            if (curHead instanceof Struct && Intrinsics.areEqual(((Struct)curHead).getFunctor(), "::")) {
                Term curHeadProbTerm = ((Struct)curHead).get(0);
                Term term2 = curHeadProbTerm;
                curHeadProb = term2 instanceof Numeric ? ((Numeric)curHeadProbTerm).getDecimalValue().toDouble() : ClauseMappingUtilsKt.solveArithmeticExpression(curHeadProbTerm);
                curHead = ((Struct)curHead).get(1);
            }
        }
        Term[] termArray = new Term[]{Numeric.Companion.of(curHeadProb), curHead};
        accumulator.add(Struct.Companion.of("::", termArray));
    }
}

