/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.problog;

import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.operators.OperatorSet;
import it.unibo.tuprolog.solve.AbstractWrapper;
import it.unibo.tuprolog.solve.ProbExtensions;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.SolveOptions;
import it.unibo.tuprolog.solve.Solver;
import it.unibo.tuprolog.solve.channel.InputChannel;
import it.unibo.tuprolog.solve.channel.InputStore;
import it.unibo.tuprolog.solve.channel.OutputChannel;
import it.unibo.tuprolog.solve.channel.OutputStore;
import it.unibo.tuprolog.solve.exception.Warning;
import it.unibo.tuprolog.solve.flags.FlagStore;
import it.unibo.tuprolog.solve.library.Libraries;
import it.unibo.tuprolog.solve.problog.lib.knowledge.ProbExplanation;
import it.unibo.tuprolog.solve.problog.lib.knowledge.ProbExplanationTerm;
import it.unibo.tuprolog.solve.problog.lib.knowledge.ProblogTheory;
import it.unibo.tuprolog.solve.problog.lib.knowledge.impl.BinaryDecisionDiagramExplanation;
import it.unibo.tuprolog.solve.problog.lib.primitive.ProbQuery;
import it.unibo.tuprolog.solve.problog.lib.primitive.ProbSetConfig;
import it.unibo.tuprolog.solve.problog.lib.rules.Prob;
import it.unibo.tuprolog.theory.Theory;
import it.unibo.tuprolog.utils.Castable;
import it.unibo.tuprolog.utils.Taggable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010,\u001a\u00020\u0001H\u0016J`\u0010-\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001dH\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u000205H\u0016J\u001e\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\"\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u0002052\n\u00108\u001a\u000609j\u0002`:H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002030<2\u0006\u00104\u001a\u000205H\u0016J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u0002030<2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\"\u0010;\u001a\b\u0012\u0004\u0012\u0002030<2\u0006\u00104\u001a\u0002052\n\u00108\u001a\u000609j\u0002`:H\u0016J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010>\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0018\u0010>\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u001c\u0010>\u001a\u0002032\u0006\u00104\u001a\u0002052\n\u00108\u001a\u000609j\u0002`:H\u0016J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010 R\u0012\u0010'\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0007R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001d8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010 \u00a8\u0006@"}, d2={"Lit/unibo/tuprolog/solve/problog/ProblogSolver;", "Lit/unibo/tuprolog/solve/Solver;", "solver", "(Lit/unibo/tuprolog/solve/Solver;)V", "dynamicKb", "Lit/unibo/tuprolog/theory/Theory;", "getDynamicKb", "()Lit/unibo/tuprolog/theory/Theory;", "flags", "Lit/unibo/tuprolog/solve/flags/FlagStore;", "getFlags", "()Lit/unibo/tuprolog/solve/flags/FlagStore;", "inputChannels", "Lit/unibo/tuprolog/solve/channel/InputStore;", "getInputChannels", "()Lit/unibo/tuprolog/solve/channel/InputStore;", "libraries", "Lit/unibo/tuprolog/solve/library/Libraries;", "getLibraries", "()Lit/unibo/tuprolog/solve/library/Libraries;", "operators", "Lit/unibo/tuprolog/core/operators/OperatorSet;", "getOperators", "()Lit/unibo/tuprolog/core/operators/OperatorSet;", "outputChannels", "Lit/unibo/tuprolog/solve/channel/OutputStore;", "getOutputChannels", "()Lit/unibo/tuprolog/solve/channel/OutputStore;", "standardError", "Lit/unibo/tuprolog/solve/channel/OutputChannel;", "", "getStandardError", "()Lit/unibo/tuprolog/solve/channel/OutputChannel;", "standardInput", "Lit/unibo/tuprolog/solve/channel/InputChannel;", "getStandardInput", "()Lit/unibo/tuprolog/solve/channel/InputChannel;", "standardOutput", "getStandardOutput", "staticKb", "getStaticKb", "warnings", "Lit/unibo/tuprolog/solve/exception/Warning;", "getWarnings", "clone", "copy", "stdIn", "stdOut", "stdErr", "solve", "Lkotlin/sequences/Sequence;", "Lit/unibo/tuprolog/solve/Solution;", "goal", "Lit/unibo/tuprolog/core/Struct;", "options", "Lit/unibo/tuprolog/solve/SolveOptions;", "timeout", "", "Lit/unibo/tuprolog/solve/TimeDuration;", "solveList", "", "solveNonProbabilistically", "solveOnce", "solveProbabilistically", "solve-problog"})
public class ProblogSolver
implements Solver {
    @NotNull
    private final Solver solver;

    public ProblogSolver(@NotNull Solver solver2) {
        Intrinsics.checkNotNullParameter(solver2, "solver");
        this.solver = solver2;
    }

    @Override
    @NotNull
    public Theory getDynamicKb() {
        return this.solver.getDynamicKb();
    }

    @Override
    @NotNull
    public FlagStore getFlags() {
        return this.solver.getFlags();
    }

    @Override
    @NotNull
    public InputStore getInputChannels() {
        return this.solver.getInputChannels();
    }

    @Override
    @NotNull
    public Libraries getLibraries() {
        return this.solver.getLibraries();
    }

    @Override
    @NotNull
    public OperatorSet getOperators() {
        return this.solver.getOperators();
    }

    @Override
    @NotNull
    public OutputStore getOutputChannels() {
        return this.solver.getOutputChannels();
    }

    @Override
    @NotNull
    public OutputChannel<String> getStandardError() {
        return this.solver.getStandardError();
    }

    @Override
    @NotNull
    public InputChannel<String> getStandardInput() {
        return this.solver.getStandardInput();
    }

    @Override
    @NotNull
    public OutputChannel<String> getStandardOutput() {
        return this.solver.getStandardOutput();
    }

    @Override
    @NotNull
    public Theory getStaticKb() {
        return this.solver.getStaticKb();
    }

    @Override
    @NotNull
    public OutputChannel<Warning> getWarnings() {
        return this.solver.getWarnings();
    }

    private final Sequence<Solution> solveNonProbabilistically(Struct goal, SolveOptions options2) {
        Var anonVar = Var.Companion.anonymous();
        Object this_$iv = (Term[])ProbSetConfig.INSTANCE;
        boolean $i$f$getFunctor = false;
        String string2 = ((AbstractWrapper)this_$iv).getSignature().getName();
        this_$iv = new Term[]{ProbSetConfig.INSTANCE.toProbConfigTerm(options2)};
        Term term = Struct.Companion.of(string2, (Term[])this_$iv);
        this_$iv = Prob.INSTANCE;
        $i$f$getFunctor = false;
        Term[] termArray = new Term[]{anonVar, goal};
        return SequencesKt.map(this.solver.solve((Struct)Tuple.Companion.of(term, Struct.Companion.of(((AbstractWrapper)this_$iv).getSignature().getName(), termArray)), options2), (Function1)new Function1<Solution, Solution>(goal, anonVar){
            final /* synthetic */ Struct $goal;
            final /* synthetic */ Var $anonVar;
            {
                this.$goal = $goal;
                this.$anonVar = $anonVar;
                super(1);
            }

            @NotNull
            public final Solution invoke(@NotNull Solution it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Solution solution = it;
                return solution instanceof Solution.Yes ? (Solution)Solution.Companion.yes(this.$goal, ((Solution.Yes)it).getSubstitution().filter((Function2<? super Var, ? super Term, Boolean>)new Function2<Var, Term, Boolean>(this.$anonVar){
                    final /* synthetic */ Var $anonVar;
                    {
                        this.$anonVar = $anonVar;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Var key, @NotNull Term $noName_1) {
                        Intrinsics.checkNotNullParameter(key, "key");
                        Intrinsics.checkNotNullParameter($noName_1, "$noName_1");
                        return !Intrinsics.areEqual(key, this.$anonVar);
                    }
                })) : (solution instanceof Solution.Halt ? (Solution)Solution.Companion.halt(this.$goal, ((Solution.Halt)it).getException()) : (Solution)Solution.Companion.no(this.$goal));
            }
        });
    }

    private final Sequence<Solution> solveProbabilistically(Struct goal, SolveOptions options2) {
        Var probabilityVar = Var.Companion.of("Prob");
        Var bddVar = Var.Companion.of("BDD");
        AbstractWrapper this_$iv = ProbQuery.INSTANCE;
        boolean $i$f$getFunctor = false;
        Term[] termArray = new Term[]{probabilityVar, goal, ProbSetConfig.INSTANCE.toProbConfigTerm(options2), bddVar};
        return SequencesKt.map(this.solver.solve(Struct.Companion.of(this_$iv.getSignature().getName(), termArray), options2), (Function1)new Function1<Solution, Solution>(probabilityVar, bddVar, goal, options2){
            final /* synthetic */ Var $probabilityVar;
            final /* synthetic */ Var $bddVar;
            final /* synthetic */ Struct $goal;
            final /* synthetic */ SolveOptions $options;
            {
                this.$probabilityVar = $probabilityVar;
                this.$bddVar = $bddVar;
                this.$goal = $goal;
                this.$options = $options;
                super(1);
            }

            @NotNull
            public final Solution invoke(@NotNull Solution it) {
                Solution solution;
                Solution newSolution2;
                Intrinsics.checkNotNullParameter(it, "it");
                Term probabilityTerm = (Term)it.getSubstitution().get(this.$probabilityVar);
                Term bddTerm = (Term)it.getSubstitution().get(this.$bddVar);
                Castable<Solution> castable = it;
                Solution solution2 = castable instanceof Solution.Yes ? (Solution)Solution.Companion.yes(this.$goal, ((Solution.Yes)it).getSubstitution().filter((Function2<? super Var, ? super Term, Boolean>)new Function2<Var, Term, Boolean>(this.$probabilityVar, this.$bddVar){
                    final /* synthetic */ Var $probabilityVar;
                    final /* synthetic */ Var $bddVar;
                    {
                        this.$probabilityVar = $probabilityVar;
                        this.$bddVar = $bddVar;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Var key, @NotNull Term $noName_1) {
                        Intrinsics.checkNotNullParameter(key, "key");
                        Intrinsics.checkNotNullParameter($noName_1, "$noName_1");
                        return !Intrinsics.areEqual(key, this.$probabilityVar) && !Intrinsics.areEqual(key, this.$bddVar);
                    }
                })) : (newSolution2 = castable instanceof Solution.Halt ? (Solution)Solution.Companion.halt(this.$goal, ((Solution.Halt)it).getException()) : (Solution)Solution.Companion.no(this.$goal));
                if (!ProbExtensions.isProbabilistic(this.$options)) {
                    solution = newSolution2;
                } else {
                    ProbExplanation explanation;
                    castable = probabilityTerm;
                    Solution solution3 = newSolution2 = castable instanceof Numeric ? (Solution)ProbExtensions.setProbability((Taggable)newSolution2, ((Numeric)probabilityTerm).getDecimalValue().toDouble()) : (Solution)ProbExtensions.setProbability((Taggable)newSolution2, Double.NaN);
                    if (bddTerm != null && bddTerm instanceof ProbExplanationTerm && (explanation = ((ProbExplanationTerm)bddTerm).getExplanation()) instanceof BinaryDecisionDiagramExplanation) {
                        newSolution2 = ProbExtensions.setBinaryDecisionDiagram(newSolution2, ((BinaryDecisionDiagramExplanation)explanation).getDiagram());
                    }
                    solution = newSolution2;
                }
                return solution;
            }
        });
    }

    @Override
    @NotNull
    public Sequence<Solution> solve(@NotNull Struct goal, @NotNull SolveOptions options2) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        Intrinsics.checkNotNullParameter(options2, "options");
        return !ProbExtensions.isProbabilistic(options2) ? this.solveNonProbabilistically(goal, options2) : this.solveProbabilistically(goal, options2);
    }

    @Override
    @NotNull
    public Sequence<Solution> solve(@NotNull Struct goal, long timeout) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        return this.solve(goal, SolveOptions.Companion.allLazilyWithTimeout(timeout));
    }

    @Override
    @NotNull
    public Sequence<Solution> solve(@NotNull Struct goal) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        return this.solve(goal, SolveOptions.Companion.getDEFAULT());
    }

    @Override
    @NotNull
    public List<Solution> solveList(@NotNull Struct goal, long timeout) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        return SequencesKt.toList(this.solve(goal, timeout));
    }

    @Override
    @NotNull
    public List<Solution> solveList(@NotNull Struct goal) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        return SequencesKt.toList(this.solve(goal));
    }

    @Override
    @NotNull
    public List<Solution> solveList(@NotNull Struct goal, @NotNull SolveOptions options2) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        Intrinsics.checkNotNullParameter(options2, "options");
        return SequencesKt.toList(this.solve(goal, options2));
    }

    @Override
    @NotNull
    public Solution solveOnce(@NotNull Struct goal, long timeout) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        return SequencesKt.first(this.solve(goal, SolveOptions.Companion.someLazilyWithTimeout(1, timeout)));
    }

    @Override
    @NotNull
    public Solution solveOnce(@NotNull Struct goal) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        return SequencesKt.first(this.solve(goal, SolveOptions.Companion.someLazily(1)));
    }

    @Override
    @NotNull
    public Solution solveOnce(@NotNull Struct goal, @NotNull SolveOptions options2) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        Intrinsics.checkNotNullParameter(options2, "options");
        return SequencesKt.first(this.solve(goal, options2.setLimit(1)));
    }

    @Override
    @NotNull
    public Solver copy(@NotNull Libraries libraries2, @NotNull FlagStore flags, @NotNull Theory staticKb, @NotNull Theory dynamicKb, @NotNull InputChannel<String> stdIn, @NotNull OutputChannel<String> stdOut, @NotNull OutputChannel<String> stdErr, @NotNull OutputChannel<Warning> warnings) {
        Intrinsics.checkNotNullParameter(libraries2, "libraries");
        Intrinsics.checkNotNullParameter(flags, "flags");
        Intrinsics.checkNotNullParameter(staticKb, "staticKb");
        Intrinsics.checkNotNullParameter(dynamicKb, "dynamicKb");
        Intrinsics.checkNotNullParameter(stdIn, "stdIn");
        Intrinsics.checkNotNullParameter(stdOut, "stdOut");
        Intrinsics.checkNotNullParameter(stdErr, "stdErr");
        Intrinsics.checkNotNullParameter(warnings, "warnings");
        return new ProblogSolver(this.solver.copy(libraries2, flags, ProblogTheory.Companion.of(staticKb), ProblogTheory.Companion.of(dynamicKb), stdIn, stdOut, stdErr, warnings));
    }

    @Override
    @NotNull
    public Solver clone() {
        return new ProblogSolver(this.solver.clone());
    }
}

