/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.libs.oop.exceptions;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.solve.ExecutionContext;
import it.unibo.tuprolog.solve.Signature;
import it.unibo.tuprolog.solve.exception.LogicError;
import it.unibo.tuprolog.solve.exception.error.ExistenceError;
import it.unibo.tuprolog.solve.libs.oop.TypeUtilsJvmKt;
import it.unibo.tuprolog.solve.libs.oop.exceptions.OopException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lit/unibo/tuprolog/solve/libs/oop/exceptions/PropertyAssignmentException;", "Lit/unibo/tuprolog/solve/libs/oop/exceptions/OopException;", "type", "Lkotlin/reflect/KClass;", "missingPropertyName", "", "admissibleTypes", "", "(Lkotlin/reflect/KClass;Ljava/lang/String;Ljava/util/Set;)V", "getAdmissibleTypes", "()Ljava/util/Set;", "culprit", "Lit/unibo/tuprolog/core/Term;", "getCulprit", "()Lit/unibo/tuprolog/core/Term;", "getMissingPropertyName", "()Ljava/lang/String;", "getType", "()Lkotlin/reflect/KClass;", "toLogicError", "Lit/unibo/tuprolog/solve/exception/LogicError;", "context", "Lit/unibo/tuprolog/solve/ExecutionContext;", "signature", "Lit/unibo/tuprolog/solve/Signature;", "oop-lib"})
public final class PropertyAssignmentException
extends OopException {
    @NotNull
    private final KClass<?> type;
    @NotNull
    private final String missingPropertyName;
    @NotNull
    private final Set<KClass<?>> admissibleTypes;

    public PropertyAssignmentException(@NotNull KClass<?> type2, @NotNull String missingPropertyName, @NotNull Set<? extends KClass<?>> admissibleTypes) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(missingPropertyName, "missingPropertyName");
        Intrinsics.checkNotNullParameter(admissibleTypes, "admissibleTypes");
        super("There is no property on type " + TypeUtilsJvmKt.getFullName(type2) + " which is named `" + missingPropertyName + "` and can be assigned to a value of type " + OopException.Companion.pretty$oop_lib(admissibleTypes), null, 2, null);
        this.type = type2;
        this.missingPropertyName = missingPropertyName;
        this.admissibleTypes = admissibleTypes;
    }

    @NotNull
    public final KClass<?> getType() {
        return this.type;
    }

    @NotNull
    public final String getMissingPropertyName() {
        return this.missingPropertyName;
    }

    @NotNull
    public final Set<KClass<?>> getAdmissibleTypes() {
        return this.admissibleTypes;
    }

    @Override
    @NotNull
    public LogicError toLogicError(@NotNull ExecutionContext context2, @NotNull Signature signature2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        String string2 = this.getMessage();
        return ExistenceError.Companion.of(context2, ExistenceError.ObjectType.OOP_PROPERTY, this.getCulprit(), string2 == null ? "" : string2);
    }

    @Override
    @NotNull
    protected Term getCulprit() {
        return Atom.Companion.of(TypeUtilsJvmKt.getFullName(this.type) + "::" + this.missingPropertyName + ": " + OopException.Companion.pretty$oop_lib(this.admissibleTypes));
    }
}

