/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.impl;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.operators.OperatorSet;
import it.unibo.tuprolog.solve.ExecutionContext;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.SolveOptions;
import it.unibo.tuprolog.solve.Solver;
import it.unibo.tuprolog.solve.Utils;
import it.unibo.tuprolog.solve.channel.InputChannel;
import it.unibo.tuprolog.solve.channel.InputStore;
import it.unibo.tuprolog.solve.channel.OutputChannel;
import it.unibo.tuprolog.solve.channel.OutputStore;
import it.unibo.tuprolog.solve.directives.ClauseExtensions;
import it.unibo.tuprolog.solve.directives.ClausePartition;
import it.unibo.tuprolog.solve.directives.ClausePartitionExtensionsKt;
import it.unibo.tuprolog.solve.exception.Warning;
import it.unibo.tuprolog.solve.exception.warning.InitializationIssue;
import it.unibo.tuprolog.solve.flags.FlagStore;
import it.unibo.tuprolog.solve.library.Libraries;
import it.unibo.tuprolog.theory.MutableTheory;
import it.unibo.tuprolog.theory.Theory;
import it.unibo.tuprolog.utils.IterUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BK\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H&Jf\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020,0.2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010.H&J\u0013\u00102\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0002J\b\u00105\u001a\u000206H\u0016J[\u00107\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010&\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H$\u00a2\u0006\u0002\u00108J4\u00109\u001a\u00020:2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010;\u001a\u00020\u00102\b\b\u0002\u0010<\u001a\u00020\u0010H\u0004J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0004J\b\u0010A\u001a\u00020:H\u0014J\u0018\u0010B\u001a\u00020:2\u0006\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020\u0010H\u0002J\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010H\u001a\u00020>2\u0006\u0010I\u001a\u00020JJ\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010H\u001a\u00020>2\u0006\u0010I\u001a\u00020JH$J\u0010\u0010L\u001a\u00020:2\u0006\u0010H\u001a\u00020>H\u0002J\b\u0010M\u001a\u00020,H\u0016J!\u0010N\u001a\u00020:2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020P\u00a2\u0006\u0002\bQH\u0004J\u0010\u0010R\u001a\u00020:2\u0006\u0010S\u001a\u00020TH\u0002R\u0018\u0010\u0012\u001a\u00028\u0000X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019\u00a8\u0006E"}, d2={"Lit/unibo/tuprolog/solve/impl/AbstractSolver;", "E", "Lit/unibo/tuprolog/solve/ExecutionContext;", "Lit/unibo/tuprolog/solve/Solver;", "libraries", "Lit/unibo/tuprolog/solve/library/Libraries;", "flags", "Lit/unibo/tuprolog/solve/flags/FlagStore;", "initialStaticKb", "Lit/unibo/tuprolog/theory/Theory;", "initialDynamicKb", "inputChannels", "Lit/unibo/tuprolog/solve/channel/InputStore;", "outputChannels", "Lit/unibo/tuprolog/solve/channel/OutputStore;", "trustKb", "", "(Lit/unibo/tuprolog/solve/library/Libraries;Lit/unibo/tuprolog/solve/flags/FlagStore;Lit/unibo/tuprolog/theory/Theory;Lit/unibo/tuprolog/theory/Theory;Lit/unibo/tuprolog/solve/channel/InputStore;Lit/unibo/tuprolog/solve/channel/OutputStore;Z)V", "currentContext", "getCurrentContext", "()Lit/unibo/tuprolog/solve/ExecutionContext;", "setCurrentContext", "(Lit/unibo/tuprolog/solve/ExecutionContext;)V", "dynamicKb", "getDynamicKb", "()Lit/unibo/tuprolog/theory/Theory;", "getFlags", "()Lit/unibo/tuprolog/solve/flags/FlagStore;", "getInputChannels", "()Lit/unibo/tuprolog/solve/channel/InputStore;", "getLibraries", "()Lit/unibo/tuprolog/solve/library/Libraries;", "operators", "Lit/unibo/tuprolog/core/operators/OperatorSet;", "getOperators", "()Lit/unibo/tuprolog/core/operators/OperatorSet;", "getOutputChannels", "()Lit/unibo/tuprolog/solve/channel/OutputStore;", "staticKb", "getStaticKb", "clone", "copy", "stdIn", "Lit/unibo/tuprolog/solve/channel/InputChannel;", "", "stdOut", "Lit/unibo/tuprolog/solve/channel/OutputChannel;", "stdErr", "warnings", "Lit/unibo/tuprolog/solve/exception/Warning;", "equals", "other", "", "hashCode", "", "initializeContext", "(Lit/unibo/tuprolog/solve/library/Libraries;Lit/unibo/tuprolog/solve/flags/FlagStore;Lit/unibo/tuprolog/theory/Theory;Lit/unibo/tuprolog/theory/Theory;Lit/unibo/tuprolog/core/operators/OperatorSet;Lit/unibo/tuprolog/solve/channel/InputStore;Lit/unibo/tuprolog/solve/channel/OutputStore;Z)Lit/unibo/tuprolog/solve/ExecutionContext;", "initializeKb", "", "appendStatic", "appendDynamic", "loadGoal", "Lit/unibo/tuprolog/core/Struct;", "theory", "Lit/unibo/tuprolog/core/Atom;", "onInitialize", "resetKb", "resetStatic", "resetDynamic", "solve", "Lkotlin/sequences/Sequence;", "Lit/unibo/tuprolog/solve/Solution;", "goal", "options", "Lit/unibo/tuprolog/solve/SolveOptions;", "solveImpl", "solveInitialGoal", "toString", "updateContext", "operator", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "updateContextWith", "clausePartition", "Lit/unibo/tuprolog/solve/directives/ClausePartition;"})
public abstract class AbstractSolver<E extends ExecutionContext>
implements Solver {
    public AbstractSolver(@NotNull Libraries libraries2, @NotNull FlagStore flags, @NotNull Theory initialStaticKb, @NotNull Theory initialDynamicKb, @NotNull InputStore inputChannels, @NotNull OutputStore outputChannels, boolean trustKb) {
        Intrinsics.checkNotNullParameter(libraries2, "libraries");
        Intrinsics.checkNotNullParameter(flags, "flags");
        Intrinsics.checkNotNullParameter(initialStaticKb, "initialStaticKb");
        Intrinsics.checkNotNullParameter(initialDynamicKb, "initialDynamicKb");
        Intrinsics.checkNotNullParameter(inputChannels, "inputChannels");
        Intrinsics.checkNotNullParameter(outputChannels, "outputChannels");
        this.setCurrentContext(this.initializeContext(libraries2, flags, initialStaticKb.toImmutableTheory(), initialDynamicKb.toMutableTheory(), Utils.toOperatorSet(Utils.getAllOperators(libraries2, new Theory[0])), inputChannels, outputChannels, trustKb));
        if (!trustKb) {
            AbstractSolver.initializeKb$default(this, initialStaticKb, initialDynamicKb, false, false, 12, null);
        }
        this.onInitialize();
    }

    public /* synthetic */ AbstractSolver(Libraries libraries2, FlagStore flagStore2, Theory theory2, Theory theory3, InputStore inputStore, OutputStore outputStore, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            libraries2 = Libraries.Companion.empty();
        }
        if ((n & 2) != 0) {
            flagStore2 = FlagStore.Companion.empty();
        }
        if ((n & 4) != 0) {
            theory2 = Theory.Companion.empty();
        }
        if ((n & 8) != 0) {
            theory3 = MutableTheory.Companion.empty();
        }
        if ((n & 0x10) != 0) {
            inputStore = InputStore.Companion.fromStandard$default(InputStore.Companion, null, 1, null);
        }
        if ((n & 0x20) != 0) {
            outputStore = OutputStore.Companion.fromStandard$default(OutputStore.Companion, null, null, null, 7, null);
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(libraries2, flagStore2, theory2, theory3, inputStore, outputStore, bl);
    }

    @NotNull
    protected abstract E getCurrentContext();

    protected abstract void setCurrentContext(@NotNull E var1);

    protected void onInitialize() {
    }

    @NotNull
    protected abstract E initializeContext(@NotNull Libraries var1, @NotNull FlagStore var2, @NotNull Theory var3, @NotNull Theory var4, @NotNull OperatorSet var5, @NotNull InputStore var6, @NotNull OutputStore var7, boolean var8);

    public static /* synthetic */ ExecutionContext initializeContext$default(AbstractSolver abstractSolver, Libraries libraries2, FlagStore flagStore2, Theory theory2, Theory theory3, OperatorSet operatorSet2, InputStore inputStore, OutputStore outputStore, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initializeContext");
        }
        if ((n & 1) != 0) {
            libraries2 = Libraries.Companion.empty();
        }
        if ((n & 2) != 0) {
            flagStore2 = FlagStore.Companion.empty();
        }
        if ((n & 4) != 0) {
            theory2 = Theory.Companion.empty();
        }
        if ((n & 8) != 0) {
            theory3 = MutableTheory.Companion.empty();
        }
        if ((n & 0x20) != 0) {
            inputStore = InputStore.Companion.fromStandard$default(InputStore.Companion, null, 1, null);
        }
        if ((n & 0x40) != 0) {
            outputStore = OutputStore.Companion.fromStandard$default(OutputStore.Companion, null, null, null, 7, null);
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return abstractSolver.initializeContext(libraries2, flagStore2, theory2, theory3, operatorSet2, inputStore, outputStore, bl);
    }

    protected final void updateContext(@NotNull Function1<? super E, ? extends ExecutionContext> operator) {
        Intrinsics.checkNotNullParameter(operator, "operator");
        this.setCurrentContext(operator.invoke(this.getCurrentContext()));
    }

    @NotNull
    protected final Struct loadGoal(@NotNull Atom theory2) {
        Intrinsics.checkNotNullParameter(theory2, "theory");
        Term[] termArray = new Term[]{theory2};
        return Struct.Companion.of("consult", termArray);
    }

    private final void resetKb(boolean resetStatic, boolean resetDynamic) {
        this.updateContext(new Function1<E, ExecutionContext>(resetStatic, resetDynamic){
            final /* synthetic */ boolean $resetStatic;
            final /* synthetic */ boolean $resetDynamic;
            {
                this.$resetStatic = $resetStatic;
                this.$resetDynamic = $resetDynamic;
                super(1);
            }

            @NotNull
            public final ExecutionContext invoke(@NotNull E $this$updateContext) {
                Intrinsics.checkNotNullParameter($this$updateContext, "$this$updateContext");
                return ExecutionContext.DefaultImpls.update$default($this$updateContext, null, null, this.$resetStatic ? Theory.Companion.emptyIndexed() : $this$updateContext.getStaticKb(), this.$resetDynamic ? (Theory)MutableTheory.Companion.emptyIndexed() : $this$updateContext.getDynamicKb(), null, null, null, null, 243, null);
            }
        });
    }

    private final void updateContextWith(ClausePartition clausePartition) {
        this.updateContext(new Function1<E, ExecutionContext>(clausePartition){
            final /* synthetic */ ClausePartition $clausePartition;
            {
                this.$clausePartition = $clausePartition;
                super(1);
            }

            @NotNull
            public final ExecutionContext invoke(@NotNull E $this$updateContext) {
                Intrinsics.checkNotNullParameter($this$updateContext, "$this$updateContext");
                Theory theory2 = $this$updateContext.getStaticKb().plus(this.$clausePartition.getStaticClauses()).toImmutableTheory();
                MutableTheory mutableTheory2 = $this$updateContext.getDynamicKb().plus(this.$clausePartition.getDynamicClauses()).toMutableTheory();
                OperatorSet operatorSet2 = $this$updateContext.getOperators().plus(this.$clausePartition.getOperators());
                FlagStore flagStore2 = $this$updateContext.getFlags().plus(this.$clausePartition.getFlagStore());
                return ExecutionContext.DefaultImpls.update$default($this$updateContext, null, flagStore2, theory2, mutableTheory2, operatorSet2, null, null, null, 225, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected final void initializeKb(@Nullable Theory staticKb, @Nullable Theory dynamicKb, boolean appendStatic, boolean appendDynamic) {
        Iterable $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Theory theory2;
        Theory theory3 = staticKb;
        boolean bl = false;
        boolean bl2 = false;
        Theory it = theory3;
        boolean bl3 = false;
        boolean bl4 = it == null || it.getSize() == 0L;
        if (bl4) {
            theory3 = dynamicKb;
            bl = false;
            bl2 = false;
            it = theory3;
            boolean bl5 = false;
            boolean bl6 = it == null || it.getSize() == 0L;
            if (bl6) {
                return;
            }
        }
        ClausePartition staticKbPartitioning = (theory2 = staticKb) == null ? null : ClauseExtensions.partition$default(theory2, false, 1, null);
        Theory theory4 = dynamicKb;
        ClausePartition dynamicKbPartitioning = theory4 == null ? null : ClauseExtensions.partition(theory4, false);
        ClausePartition merged = ClausePartitionExtensionsKt.plus(staticKbPartitioning, dynamicKbPartitioning);
        this.resetKb(!appendStatic, !appendDynamic);
        Iterable $this$map$iv = merged.getIncludes();
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Atom atom2 = (Atom)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            Struct struct = this.loadGoal((Atom)it2);
            collection.add(struct);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Struct p0 = (Struct)element$iv;
            boolean bl8 = false;
            this.solveInitialGoal(p0);
        }
        this.updateContextWith(merged);
        $this$forEach$iv = merged.getInitialGoals();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Struct p0 = (Struct)element$iv;
            boolean bl9 = false;
            this.solveInitialGoal(p0);
        }
    }

    public static /* synthetic */ void initializeKb$default(AbstractSolver abstractSolver, Theory theory2, Theory theory3, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initializeKb");
        }
        if ((n & 1) != 0) {
            theory2 = null;
        }
        if ((n & 2) != 0) {
            theory3 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        abstractSolver.initializeKb(theory2, theory3, bl, bl2);
    }

    private final void solveInitialGoal(Struct goal) {
        Iterator<Solution> iterator2 = this.solve(goal).iterator();
        while (iterator2.hasNext()) {
            Solution solution = iterator2.next();
            Solution solution2 = solution;
            if (solution2 instanceof Solution.No) {
                this.getWarnings().write(new InitializationIssue(goal, null, (ExecutionContext)this.getCurrentContext()));
                continue;
            }
            if (!(solution2 instanceof Solution.Halt)) continue;
            this.getWarnings().write(new InitializationIssue(goal, ((Solution.Halt)solution).getException(), ((Solution.Halt)solution).getException().getContexts()));
        }
    }

    @Override
    @NotNull
    public final Libraries getLibraries() {
        return this.getCurrentContext().getLibraries();
    }

    @Override
    @NotNull
    public final FlagStore getFlags() {
        return this.getCurrentContext().getFlags();
    }

    @Override
    @NotNull
    public final Theory getStaticKb() {
        return this.getCurrentContext().getStaticKb();
    }

    @Override
    @NotNull
    public final Theory getDynamicKb() {
        return this.getCurrentContext().getDynamicKb();
    }

    @Override
    @NotNull
    public final InputStore getInputChannels() {
        return this.getCurrentContext().getInputChannels();
    }

    @Override
    @NotNull
    public final OutputStore getOutputChannels() {
        return this.getCurrentContext().getOutputChannels();
    }

    @Override
    @NotNull
    public final OperatorSet getOperators() {
        return this.getCurrentContext().getOperators();
    }

    @Override
    @NotNull
    public final Sequence<Solution> solve(@NotNull Struct goal, @NotNull SolveOptions options2) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        Intrinsics.checkNotNullParameter(options2, "options");
        Sequence<Solution> solutionSequence2 = this.solveImpl(goal, options2);
        if (options2.getLimit() > 0) {
            solutionSequence2 = SequencesKt.take(solutionSequence2, options2.getLimit());
        }
        if (options2.isEager()) {
            solutionSequence2 = IterUtils.buffered(solutionSequence2);
        }
        return solutionSequence2;
    }

    @NotNull
    protected abstract Sequence<Solution> solveImpl(@NotNull Struct var1, @NotNull SolveOptions var2);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(this.getClass()), Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        AbstractSolver cfr_ignored_0 = (AbstractSolver)other;
        return Intrinsics.areEqual(this.getCurrentContext(), ((AbstractSolver)other).getCurrentContext());
    }

    public int hashCode() {
        return this.getCurrentContext().hashCode();
    }

    @Override
    @NotNull
    public abstract AbstractSolver<E> copy(@NotNull Libraries var1, @NotNull FlagStore var2, @NotNull Theory var3, @NotNull Theory var4, @NotNull InputChannel<String> var5, @NotNull OutputChannel<String> var6, @NotNull OutputChannel<String> var7, @NotNull OutputChannel<Warning> var8);

    @Override
    @NotNull
    public abstract AbstractSolver<E> clone();

    @NotNull
    public String toString() {
        Libraries this_$iv = this.getLibraries();
        boolean $i$f$getLibraryAliases = false;
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(libraries=" + this_$iv.keySet() + ", staticKb=" + CollectionsKt.toList(this.getStaticKb().getClauses()) + ", dynamicKb=" + CollectionsKt.toList(this.getDynamicKb().getClauses()) + ", operators=" + this.getOperators() + "flags=" + this.getFlags() + ", inputChannels=" + this.getInputChannels() + ", outputChannels=" + this.getOutputChannels() + ", )";
    }

    @Override
    @NotNull
    public Sequence<Solution> solve(@NotNull Struct goal) {
        return Solver.DefaultImpls.solve(this, goal);
    }

    @Override
    @NotNull
    public Sequence<Solution> solve(@NotNull Struct goal, long timeout) {
        return Solver.DefaultImpls.solve(this, goal, timeout);
    }

    @Override
    @NotNull
    public List<Solution> solveList(@NotNull Struct goal) {
        return Solver.DefaultImpls.solveList(this, goal);
    }

    @Override
    @NotNull
    public List<Solution> solveList(@NotNull Struct goal, @NotNull SolveOptions options2) {
        return Solver.DefaultImpls.solveList((Solver)this, goal, options2);
    }

    @Override
    @NotNull
    public List<Solution> solveList(@NotNull Struct goal, long timeout) {
        return Solver.DefaultImpls.solveList((Solver)this, goal, timeout);
    }

    @Override
    @NotNull
    public Solution solveOnce(@NotNull Struct goal) {
        return Solver.DefaultImpls.solveOnce(this, goal);
    }

    @Override
    @NotNull
    public Solution solveOnce(@NotNull Struct goal, @NotNull SolveOptions options2) {
        return Solver.DefaultImpls.solveOnce((Solver)this, goal, options2);
    }

    @Override
    @NotNull
    public Solution solveOnce(@NotNull Struct goal, long timeout) {
        return Solver.DefaultImpls.solveOnce((Solver)this, goal, timeout);
    }

    @Override
    @NotNull
    public OutputChannel<String> getStandardError() {
        return Solver.DefaultImpls.getStandardError(this);
    }

    @Override
    @NotNull
    public InputChannel<String> getStandardInput() {
        return Solver.DefaultImpls.getStandardInput(this);
    }

    @Override
    @NotNull
    public OutputChannel<String> getStandardOutput() {
        return Solver.DefaultImpls.getStandardOutput(this);
    }

    @Override
    @NotNull
    public OutputChannel<Warning> getWarnings() {
        return Solver.DefaultImpls.getWarnings(this);
    }

    public AbstractSolver() {
        this(null, null, null, null, null, null, false, 127, null);
    }
}

