/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.concurrent.fsm;

import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.solve.AbstractWrapper;
import it.unibo.tuprolog.solve.ExecutionContext;
import it.unibo.tuprolog.solve.concurrent.ConcurrentExecutionContext;
import it.unibo.tuprolog.solve.concurrent.fsm.EndState;
import it.unibo.tuprolog.solve.concurrent.fsm.ExceptionalState;
import it.unibo.tuprolog.solve.concurrent.fsm.State;
import it.unibo.tuprolog.solve.concurrent.fsm.StateGoalSelection;
import it.unibo.tuprolog.solve.concurrent.fsm.StateHalt;
import it.unibo.tuprolog.solve.concurrent.fsm.Utils;
import it.unibo.tuprolog.solve.concurrent.stdlib.rule.Catch;
import it.unibo.tuprolog.solve.exception.LogicError;
import it.unibo.tuprolog.solve.exception.ResolutionException;
import it.unibo.tuprolog.solve.exception.error.MessageError;
import it.unibo.tuprolog.solve.exception.error.SystemError;
import it.unibo.tuprolog.unify.Unificator;
import it.unibo.tuprolog.utils.Cursor;
import it.unibo.tuprolog.utils.CursorExtensions;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130&H\u0016J\t\u0010'\u001a\u00020(H\u00d6\u0001J\f\u0010)\u001a\u00020**\u00020\"H\u0002J\f\u0010+\u001a\u00020\u0018*\u00020\u001dH\u0002J\f\u0010,\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006-"}, d2={"Lit/unibo/tuprolog/solve/concurrent/fsm/StateException;", "Lit/unibo/tuprolog/solve/concurrent/fsm/ExceptionalState;", "exception", "Lit/unibo/tuprolog/solve/exception/ResolutionException;", "context", "Lit/unibo/tuprolog/solve/concurrent/ConcurrentExecutionContext;", "(Lit/unibo/tuprolog/solve/exception/ResolutionException;Lit/unibo/tuprolog/solve/concurrent/ConcurrentExecutionContext;)V", "getContext", "()Lit/unibo/tuprolog/solve/concurrent/ConcurrentExecutionContext;", "getException", "()Lit/unibo/tuprolog/solve/exception/ResolutionException;", "finalState", "Lit/unibo/tuprolog/solve/concurrent/fsm/EndState;", "getFinalState", "()Lit/unibo/tuprolog/solve/concurrent/fsm/EndState;", "handleExceptionInParentContext", "getHandleExceptionInParentContext", "()Lit/unibo/tuprolog/solve/concurrent/fsm/StateException;", "clone", "Lit/unibo/tuprolog/solve/concurrent/fsm/State;", "component1", "component2", "copy", "equals", "", "other", "", "handleCatch", "catchGoal", "Lit/unibo/tuprolog/core/Struct;", "catcher", "Lit/unibo/tuprolog/core/Substitution;", "handleStruct", "error", "Lit/unibo/tuprolog/solve/exception/LogicError;", "hashCode", "", "next", "", "toString", "", "getExceptionContent", "Lit/unibo/tuprolog/core/Term;", "isCatch", "toPublicException", "solve-concurrent"})
public final class StateException
implements ExceptionalState {
    @NotNull
    private final ResolutionException exception;
    @NotNull
    private final ConcurrentExecutionContext context;

    public StateException(@NotNull ResolutionException exception2, @NotNull ConcurrentExecutionContext context2) {
        Intrinsics.checkNotNullParameter(exception2, "exception");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.exception = exception2;
        this.context = context2;
    }

    @Override
    @NotNull
    public ResolutionException getException() {
        return this.exception;
    }

    @Override
    @NotNull
    public ConcurrentExecutionContext getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCatch(Struct $this$isCatch) {
        if ($this$isCatch.getArity() != 3) return false;
        AbstractWrapper this_$iv = Catch.INSTANCE;
        boolean $i$f$getFunctor = false;
        if (!Intrinsics.areEqual($this$isCatch.getFunctor(), this_$iv.getSignature().getName())) return false;
        return true;
    }

    private final Term getExceptionContent(LogicError $this$getExceptionContent) {
        LogicError logicError = $this$getExceptionContent;
        return logicError instanceof MessageError ? ((MessageError)$this$getExceptionContent).getContent() : (Term)$this$getExceptionContent.getErrorStruct();
    }

    private final ResolutionException toPublicException(ResolutionException $this$toPublicException) {
        ResolutionException resolutionException = $this$toPublicException;
        return resolutionException instanceof MessageError ? (ResolutionException)SystemError.Companion.forUncaughtError((LogicError)$this$toPublicException) : $this$toPublicException;
    }

    private final EndState getFinalState() {
        return new StateHalt(this.toPublicException(this.getException()), ConcurrentExecutionContext.copy$default(this.getContext(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0L, 0L, null, 0, this.nextStep(), 262143, null));
    }

    private final StateException getHandleExceptionInParentContext() {
        ResolutionException resolutionException = this.getException();
        ConcurrentExecutionContext concurrentExecutionContext = this.getContext().getParent();
        Intrinsics.checkNotNull(concurrentExecutionContext);
        return new StateException(resolutionException, ConcurrentExecutionContext.copy$default(concurrentExecutionContext, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0L, 0L, null, 0, this.nextStep(), 262143, null));
    }

    private final State handleStruct(Struct catchGoal, LogicError error) {
        State state;
        if (this.isCatch(catchGoal)) {
            Substitution catcher = Unificator.Companion.mguWith(catchGoal.get(1), this.getExceptionContent(error));
            state = this.handleCatch(catchGoal, catcher);
        } else {
            state = this.getContext().isRoot() ? (State)this.getFinalState() : (State)this.getHandleExceptionInParentContext();
        }
        return state;
    }

    private final State handleCatch(Struct catchGoal, Substitution catcher) {
        State state;
        if (catcher.isSuccess()) {
            Substitution newSubstitution = this.getContext().getSubstitution().plus(catcher).filter((Collection<? extends Var>)this.getContext().getInterestingVariables());
            Term subGoals2 = catchGoal.get(2).get(newSubstitution, new Substitution[0]);
            Cursor<? extends Term> newGoals = CursorExtensions.plus(Utils.toGoals(subGoals2), this.getContext().getGoals().getNext());
            ConcurrentExecutionContext concurrentExecutionContext = this.getContext();
            Substitution.Unifier unifier = newSubstitution.castToUnifier();
            long l = this.nextStep();
            state = new StateGoalSelection(ConcurrentExecutionContext.copy$default(concurrentExecutionContext, null, null, null, null, null, null, null, null, null, unifier, null, newGoals, null, null, 0L, 0L, null, 0, l, 247295, null));
        } else {
            state = this.getContext().isRoot() ? (State)this.getFinalState() : (State)this.getHandleExceptionInParentContext();
        }
        return state;
    }

    @Override
    @NotNull
    public Iterable<State> next() {
        State state;
        ResolutionException resolutionException = this.getException();
        if (resolutionException instanceof LogicError) {
            Term term = this.getContext().getCurrentGoal();
            Intrinsics.checkNotNull(term);
            Term catchGoal = term;
            state = catchGoal.isStruct() ? this.handleStruct(catchGoal.castToStruct(), (LogicError)this.getException()) : (this.getContext().isRoot() ? (State)this.getFinalState() : (State)this.getHandleExceptionInParentContext());
        } else {
            state = this.getFinalState();
        }
        return CollectionsKt.listOf(state);
    }

    @Override
    @NotNull
    public State clone(@NotNull ConcurrentExecutionContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        return this.copy(this.getException(), context2);
    }

    @Override
    @Nullable
    public EndState asEndState() {
        return ExceptionalState.DefaultImpls.asEndState(this);
    }

    @Override
    @NotNull
    public EndState castToEndState() {
        return ExceptionalState.DefaultImpls.castToEndState(this);
    }

    @Override
    public boolean isEndState() {
        return ExceptionalState.DefaultImpls.isEndState(this);
    }

    @Override
    @NotNull
    public ExecutionContext skipThrow(@NotNull ConcurrentExecutionContext $this$skipThrow) {
        return ExceptionalState.DefaultImpls.skipThrow(this, $this$skipThrow);
    }

    @Override
    public int nextDepth() {
        return ExceptionalState.DefaultImpls.nextDepth(this);
    }

    @Override
    public long nextStep() {
        return ExceptionalState.DefaultImpls.nextStep(this);
    }

    @Override
    public int previousDepth() {
        return ExceptionalState.DefaultImpls.previousDepth(this);
    }

    @NotNull
    public final ResolutionException component1() {
        return this.getException();
    }

    @NotNull
    public final ConcurrentExecutionContext component2() {
        return this.getContext();
    }

    @NotNull
    public final StateException copy(@NotNull ResolutionException exception2, @NotNull ConcurrentExecutionContext context2) {
        Intrinsics.checkNotNullParameter(exception2, "exception");
        Intrinsics.checkNotNullParameter(context2, "context");
        return new StateException(exception2, context2);
    }

    public static /* synthetic */ StateException copy$default(StateException stateException, ResolutionException resolutionException, ConcurrentExecutionContext concurrentExecutionContext, int n, Object object) {
        if ((n & 1) != 0) {
            resolutionException = stateException.getException();
        }
        if ((n & 2) != 0) {
            concurrentExecutionContext = stateException.getContext();
        }
        return stateException.copy(resolutionException, concurrentExecutionContext);
    }

    @NotNull
    public String toString() {
        return "StateException(exception=" + this.getException() + ", context=" + this.getContext() + ')';
    }

    public int hashCode() {
        int result2 = this.getException().hashCode();
        result2 = result2 * 31 + this.getContext().hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StateException)) {
            return false;
        }
        StateException stateException = (StateException)other;
        if (!Intrinsics.areEqual(this.getException(), stateException.getException())) {
            return false;
        }
        return Intrinsics.areEqual(this.getContext(), stateException.getContext());
    }
}

