/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.serialize;

import it.unibo.tuprolog.serialize.MimeType;
import it.unibo.tuprolog.serialize.MimeTypeExtensions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001J\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lit/unibo/tuprolog/serialize/ObjectsUtils;", "", "()V", "deeplyEqual", "", "obj1", "obj2", "parseAsObject", "string", "", "mimeType", "Lit/unibo/tuprolog/serialize/MimeType;", "serialize-core"})
public final class ObjectsUtils {
    @NotNull
    public static final ObjectsUtils INSTANCE = new ObjectsUtils();

    private ObjectsUtils() {
    }

    @NotNull
    public final Object parseAsObject(@NotNull String string2, @NotNull MimeType mimeType) {
        Intrinsics.checkNotNullParameter(string2, "string");
        Intrinsics.checkNotNullParameter(mimeType, "mimeType");
        Object object = MimeTypeExtensions.getObjectMapper(mimeType).readValue(string2, Object.class);
        Intrinsics.checkNotNullExpressionValue(object, "mimeType.objectMapper.re\u2026.lang.Object::class.java)");
        return object;
    }

    public final boolean deeplyEqual(@Nullable Object obj1, @Nullable Object obj2) {
        boolean bl;
        block16: {
            if (obj1 instanceof Number && obj2 instanceof Number) {
                bl = Intrinsics.areEqual(((Number)obj1).toString(), ((Number)obj2).toString());
            } else if (obj1 instanceof List && obj2 instanceof List) {
                if (((List)obj1).size() != ((List)obj2).size()) {
                    bl = false;
                } else {
                    Sequence $this$all$iv = SequencesKt.zip(CollectionsKt.asSequence((Iterable)obj1), CollectionsKt.asSequence((Iterable)obj2));
                    boolean $i$f$all = false;
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        Pair element$iv;
                        Pair it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (INSTANCE.deeplyEqual(it.getFirst(), it.getSecond())) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            } else if (obj1 instanceof Map && obj2 instanceof Map) {
                if (((Map)obj1).size() != ((Map)obj2).size()) {
                    bl = false;
                } else if (!Intrinsics.areEqual(((Map)obj1).keySet(), ((Map)obj2).keySet())) {
                    bl = false;
                } else {
                    Iterable $this$all$iv = ((Map)obj1).keySet();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator3 = $this$all$iv.iterator();
                        while (iterator3.hasNext()) {
                            Object element$iv;
                            Object it = element$iv = iterator3.next();
                            boolean bl3 = false;
                            Map map2 = (Map)obj1;
                            boolean bl4 = false;
                            Object v = map2.get(it);
                            map2 = (Map)obj2;
                            bl4 = false;
                            if (INSTANCE.deeplyEqual(v, map2.get(it))) continue;
                            bl = false;
                            break block16;
                        }
                        bl = true;
                    }
                }
            } else {
                bl = Intrinsics.areEqual(obj1, obj2);
            }
        }
        return bl;
    }
}

