/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.impl;

import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermVisitor;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.impl.TermImpl;
import it.unibo.tuprolog.utils.IterUtils;
import it.unibo.tuprolog.utils.Taggable;
import it.unibo.tuprolog.utils.TaggableExtensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ!\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u0011H\u0014J\b\u0010&\u001a\u00020\u0017H\u0014J\u0016\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0017J\u0013\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010\nH\u0086\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0017H\u0002J\b\u0010+\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0018\u00100\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0017H\u0014J\u0010\u00101\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0002H\u0014J!\u00102\u001a\u00020\u00022\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000703\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u00104J\u0016\u00102\u001a\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000705H\u0016J\u0016\u00102\u001a\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000706H\u0016J\u0010\u00107\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0011\u00108\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0007H\u0086\u0004J\b\u00109\u001a\u00020\u0004H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006:"}, d2={"Lit/unibo/tuprolog/core/impl/AbstractStruct;", "Lit/unibo/tuprolog/core/impl/TermImpl;", "Lit/unibo/tuprolog/core/Struct;", "functor", "", "args", "", "Lit/unibo/tuprolog/core/Term;", "tags", "", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/Map;)V", "getArgs", "()Ljava/util/List;", "getFunctor", "()Ljava/lang/String;", "hashCodeCache", "", "getHashCodeCache", "()I", "hashCodeCache$delegate", "Lkotlin/Lazy;", "isFunctorWellFormed", "", "()Z", "isGround", "accept", "T", "visitor", "Lit/unibo/tuprolog/core/TermVisitor;", "(Lit/unibo/tuprolog/core/TermVisitor;)Ljava/lang/Object;", "addFirst", "argument", "addLast", "applyNonEmptyUnifier", "unifier", "Lit/unibo/tuprolog/core/Substitution$Unifier;", "argsHashCode", "checkGroundness", "equals", "other", "useVarCompleteName", "equalsImpl", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "insertAt", "index", "itemsAreEqual", "itemsAreStructurallyEqual", "setArgs", "", "([Lit/unibo/tuprolog/core/Term;)Lit/unibo/tuprolog/core/Struct;", "", "Lkotlin/sequences/Sequence;", "setFunctor", "structurallyEquals", "toString", "core"})
public abstract class AbstractStruct
extends TermImpl
implements Struct {
    @NotNull
    private final String functor;
    @NotNull
    private final List<Term> args;
    @NotNull
    private final Lazy hashCodeCache$delegate;

    public AbstractStruct(@NotNull String functor, @NotNull List<? extends Term> args2, @NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(functor, "functor");
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(tags, "tags");
        super(tags);
        this.functor = functor;
        this.args = args2;
        this.hashCodeCache$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ AbstractStruct this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                int result2 = this.this$0.getFunctor().hashCode();
                result2 = 31 * result2 + this.this$0.getArity();
                result2 = 31 * result2 + this.this$0.argsHashCode();
                return result2;
            }
        });
    }

    public /* synthetic */ AbstractStruct(String string2, List list, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(string2, list, map2);
    }

    @Override
    @NotNull
    public String getFunctor() {
        return this.functor;
    }

    @Override
    @NotNull
    public List<Term> getArgs() {
        return this.args;
    }

    @Override
    public boolean isGround() {
        return this.checkGroundness();
    }

    protected boolean checkGroundness() {
        return SequencesKt.none(this.getVariables());
    }

    @Override
    @NotNull
    public Struct freshCopy() {
        return this.freshCopy(Scope.Companion.empty());
    }

    @Override
    @NotNull
    public Struct freshCopy(@NotNull Scope scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return this.isGround() ? (Struct)this : (Struct)TaggableExtensions.setTags((Taggable)scope2.structOf(this.getFunctor(), SequencesKt.map(this.getArgsSequence(), (Function1)new Function1<Term, Term>(scope2){
            final /* synthetic */ Scope $scope;
            {
                this.$scope = $scope;
                super(1);
            }

            @NotNull
            public final Term invoke(@NotNull Term it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.freshCopy(this.$scope);
            }
        })), this.getTags());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean structurallyEquals(@NotNull Term other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (!other.isStruct()) return false;
        Struct struct = other.castToStruct();
        boolean bl = false;
        boolean bl2 = false;
        Struct it = struct;
        boolean bl3 = false;
        if (!Intrinsics.areEqual(this.getFunctor(), it.getFunctor())) return false;
        if (this.getArity() != it.getArity()) return false;
        if (!this.itemsAreStructurallyEqual(it)) return false;
        return true;
    }

    protected boolean itemsAreStructurallyEqual(@NotNull Struct other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int n = 0;
        int n2 = this.getArity();
        if (n < n2) {
            do {
                int i;
                if (this.getArgAt(i = n++).structurallyEquals(other.get(i))) continue;
                return false;
            } while (n < n2);
        }
        return true;
    }

    @Override
    public boolean isFunctorWellFormed() {
        return Struct.Companion.isWellFormedFunctor(this.getFunctor());
    }

    @Override
    public final boolean equals(@Nullable Object other) {
        boolean bl;
        Term term;
        boolean $i$f$asTerm = false;
        Term term2 = term = other instanceof Term ? (Term)other : null;
        if (term == null) {
            bl = false;
        } else {
            Struct struct = term.asStruct();
            if (struct == null) {
                bl = false;
            } else {
                boolean bl2;
                Struct struct2 = struct;
                boolean bl3 = false;
                boolean bl4 = false;
                Struct it = struct2;
                boolean bl5 = false;
                bl = bl2 = this.equalsImpl(it, true);
            }
        }
        return bl;
    }

    protected boolean itemsAreEqual(@NotNull Struct other, boolean useVarCompleteName) {
        Intrinsics.checkNotNullParameter(other, "other");
        int n = 0;
        int n2 = this.getArity();
        if (n < n2) {
            do {
                int i;
                if (this.getArgAt(i = n++).equals(other.get(i), useVarCompleteName)) continue;
                return false;
            } while (n < n2);
        }
        return true;
    }

    @Override
    public final boolean equals(@NotNull Term other, boolean useVarCompleteName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(other, "other");
        Struct struct = other.asStruct();
        if (struct == null) {
            bl = false;
        } else {
            boolean bl2;
            Struct struct2 = struct;
            boolean bl3 = false;
            boolean bl4 = false;
            Struct it = struct2;
            boolean bl5 = false;
            bl = bl2 = this.equalsImpl(it, useVarCompleteName);
        }
        return bl;
    }

    private final boolean equalsImpl(Struct other, boolean useVarCompleteName) {
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getFunctor(), other.getFunctor())) {
            return false;
        }
        if (this.getArity() != other.getArity()) {
            return false;
        }
        return this.itemsAreEqual(other, useVarCompleteName);
    }

    @Override
    protected int getHashCodeCache() {
        Lazy lazy = this.hashCodeCache$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    protected int argsHashCode() {
        return IterUtils.itemWiseHashCode((Iterable)this.getArgs());
    }

    @Override
    @NotNull
    public String toString() {
        String escaped = Struct.Companion.escapeFunctorIfNecessary$default(Struct.Companion, this.getFunctor(), false, false, 6, null);
        String quoted = Struct.Companion.enquoteFunctorIfNecessary(escaped);
        return Intrinsics.stringPlus(quoted, this.getArity() > 0 ? '(' + CollectionsKt.joinToString$default(this.getArgs(), ", ", null, null, 0, null, null, 62, null) + ')' : "");
    }

    @Override
    @NotNull
    public Struct addLast(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        return Struct.Companion.of(this.getFunctor(), CollectionsKt.plus((Collection)this.getArgs(), argument2));
    }

    @Override
    @NotNull
    public Struct addFirst(@NotNull Term argument2) {
        Intrinsics.checkNotNullParameter(argument2, "argument");
        return Struct.Companion.of(this.getFunctor(), CollectionsKt.plus((Collection)CollectionsKt.listOf(argument2), (Iterable)this.getArgs()));
    }

    @Override
    @NotNull
    public Struct insertAt(int index, @NotNull Term argument2) {
        Term[] termArray;
        Intrinsics.checkNotNullParameter(argument2, "argument");
        boolean bl = 0 <= index ? index < this.getArity() : false;
        if (bl) {
            Collection $this$toTypedArray$iv = this.getArgs();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            termArray = thisCollection$iv.toArray(new Term[0]);
            if (termArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
        } else {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds " + CollectionsKt.getIndices((Collection)this.getArgs()));
        }
        Term[] argsArray = termArray;
        String string2 = this.getFunctor();
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread(ArraysKt.sliceArray(argsArray, RangesKt.until(0, index)));
        spreadBuilder.add(argument2);
        spreadBuilder.addSpread(ArraysKt.sliceArray(argsArray, RangesKt.until(index, this.getArity())));
        return Struct.Companion.of(string2, (Term[])spreadBuilder.toArray(new Term[spreadBuilder.size()]));
    }

    @Override
    @NotNull
    public Struct setFunctor(@NotNull String functor) {
        Intrinsics.checkNotNullParameter(functor, "functor");
        return Struct.Companion.of(functor, this.getArgs());
    }

    @Override
    @NotNull
    public Struct setArgs(Term ... args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        return Struct.Companion.of(this.getFunctor(), Arrays.copyOf(args2, args2.length));
    }

    @Override
    @NotNull
    public Struct setArgs(@NotNull Iterable<? extends Term> args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        return Struct.Companion.of(this.getFunctor(), args2);
    }

    @Override
    @NotNull
    public Struct setArgs(@NotNull Sequence<? extends Term> args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        return Struct.Companion.of(this.getFunctor(), args2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Term applyNonEmptyUnifier(@NotNull Substitution.Unifier unifier) {
        Collection<Term> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(unifier, "unifier");
        Iterable iterable = this.getArgs();
        String string2 = this.getFunctor();
        Struct.Companion companion = Struct.Companion;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Term term = (Term)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Term term2 = it.apply(unifier);
            collection.add(term2);
        }
        collection = (List)destination$iv$iv;
        return (Term)TaggableExtensions.setTags((Taggable)companion.of(string2, (List<? extends Term>)collection), this.getTags());
    }

    @Override
    public <T> T accept(@NotNull TermVisitor<T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitStruct(this);
    }

    @Override
    @NotNull
    public Struct append(@NotNull Term argument2) {
        return Struct.DefaultImpls.append(this, argument2);
    }

    @Override
    @NotNull
    public Term get(int index) {
        return Struct.DefaultImpls.get(this, index);
    }

    @Override
    @NotNull
    public Term getArgAt(int index) {
        return Struct.DefaultImpls.getArgAt(this, index);
    }

    @Override
    @NotNull
    public Sequence<Term> getArgsSequence() {
        return Struct.DefaultImpls.getArgsSequence(this);
    }

    @Override
    public int getArity() {
        return Struct.DefaultImpls.getArity(this);
    }

    @Override
    @NotNull
    public Indicator getIndicator() {
        return Struct.DefaultImpls.getIndicator(this);
    }

    @Override
    public boolean isAtom() {
        return Struct.DefaultImpls.isAtom(this);
    }

    @Override
    public boolean isBlock() {
        return Struct.DefaultImpls.isBlock(this);
    }

    @Override
    public boolean isClause() {
        return Struct.DefaultImpls.isClause(this);
    }

    @Override
    public boolean isCons() {
        return Struct.DefaultImpls.isCons(this);
    }

    @Override
    public boolean isDirective() {
        return Struct.DefaultImpls.isDirective(this);
    }

    @Override
    public boolean isEmptyBlock() {
        return Struct.DefaultImpls.isEmptyBlock(this);
    }

    @Override
    public boolean isEmptyList() {
        return Struct.DefaultImpls.isEmptyList(this);
    }

    @Override
    public boolean isFact() {
        return Struct.DefaultImpls.isFact(this);
    }

    @Override
    public boolean isFail() {
        return Struct.DefaultImpls.isFail(this);
    }

    @Override
    public boolean isIndicator() {
        return Struct.DefaultImpls.isIndicator(this);
    }

    @Override
    public boolean isList() {
        return Struct.DefaultImpls.isList(this);
    }

    @Override
    public boolean isRule() {
        return Struct.DefaultImpls.isRule(this);
    }

    @Override
    public boolean isStruct() {
        return Struct.DefaultImpls.isStruct(this);
    }

    @Override
    public boolean isTrue() {
        return Struct.DefaultImpls.isTrue(this);
    }

    @Override
    public boolean isTuple() {
        return Struct.DefaultImpls.isTuple(this);
    }

    @Override
    @NotNull
    public Sequence<Var> getVariables() {
        return Struct.DefaultImpls.getVariables(this);
    }

    @Override
    @NotNull
    public Struct asStruct() {
        return Struct.DefaultImpls.asStruct(this);
    }
}

