/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Block;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Cons;
import it.unibo.tuprolog.core.Constant;
import it.unibo.tuprolog.core.Directive;
import it.unibo.tuprolog.core.EmptyBlock;
import it.unibo.tuprolog.core.EmptyList;
import it.unibo.tuprolog.core.Fact;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.List;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Recursive;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Terms;
import it.unibo.tuprolog.core.Truth;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.impl.StructImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\bf\u0018\u0000 C2\u00020\u0001:\u0001CJ\u0010\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0001H'J\u0010\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0001H'J\u0010\u00105\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0001H\u0017J\b\u00106\u001a\u00020\u0000H\u0016J\b\u00107\u001a\u00020\u0000H&J\u0010\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209H&J\u0011\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u000eH\u0097\u0002J\u0010\u0010<\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u000eH\u0017J\u0018\u0010=\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u0001H'J!\u0010>\u001a\u00020\u00002\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010?\"\u00020\u0001H'\u00a2\u0006\u0002\u0010@J\u0016\u0010>\u001a\u00020\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010AH'J\u0016\u0010>\u001a\u00020\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\tH'J\u0010\u0010B\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H'R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0005\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0005\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u00138&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0005\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u00188VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0005\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001eR\u0014\u0010\"\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0014\u0010#\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001eR\u0014\u0010$\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0014\u0010%\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001eR\u0014\u0010&\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u001a\u0010'\u001a\u00020\u001d8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u0005\u001a\u0004\b'\u0010\u001eR\u0014\u0010)\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001eR\u0014\u0010*\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001eR\u0014\u0010+\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001eR\u0014\u0010,\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001eR\u0014\u0010-\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001eR\u0014\u0010.\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001eR\u001a\u0010/\u001a\b\u0012\u0004\u0012\u0002000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\f\u00a8\u0006D"}, d2={"Lit/unibo/tuprolog/core/Struct;", "Lit/unibo/tuprolog/core/Term;", "args", "", "getArgs$annotations", "()V", "getArgs", "()Ljava/util/List;", "argsSequence", "Lkotlin/sequences/Sequence;", "getArgsSequence$annotations", "getArgsSequence", "()Lkotlin/sequences/Sequence;", "arity", "", "getArity$annotations", "getArity", "()I", "functor", "", "getFunctor$annotations", "getFunctor", "()Ljava/lang/String;", "indicator", "Lit/unibo/tuprolog/core/Indicator;", "getIndicator$annotations", "getIndicator", "()Lit/unibo/tuprolog/core/Indicator;", "isAtom", "", "()Z", "isBlock", "isClause", "isCons", "isDirective", "isEmptyBlock", "isEmptyList", "isFact", "isFail", "isFunctorWellFormed", "isFunctorWellFormed$annotations", "isIndicator", "isList", "isRule", "isStruct", "isTrue", "isTuple", "variables", "Lit/unibo/tuprolog/core/Var;", "getVariables", "addFirst", "argument", "addLast", "append", "asStruct", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "get", "index", "getArgAt", "insertAt", "setArgs", "", "([Lit/unibo/tuprolog/core/Term;)Lit/unibo/tuprolog/core/Struct;", "", "setFunctor", "Companion", "core"})
public interface Struct
extends Term {
    @NotNull
    public static final Companion Companion = it.unibo.tuprolog.core.Struct$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final Regex WELL_FORMED_FUNCTOR_PATTERN = Terms.WELL_FORMED_FUNCTOR_PATTERN;
    @JvmField
    @NotNull
    public static final Regex NON_PRINTABLE_CHARACTER_PATTERN = Terms.NON_PRINTABLE_CHARACTER_PATTERN;

    @Override
    public boolean isStruct();

    @Override
    public boolean isClause();

    @Override
    public boolean isRule();

    @Override
    public boolean isDirective();

    @Override
    public boolean isFact();

    @Override
    public boolean isTuple();

    @Override
    public boolean isAtom();

    @Override
    public boolean isList();

    @Override
    public boolean isCons();

    @Override
    public boolean isBlock();

    @Override
    public boolean isEmptyBlock();

    @Override
    public boolean isEmptyList();

    @Override
    public boolean isTrue();

    @Override
    public boolean isFail();

    @Override
    public boolean isIndicator();

    @Override
    @NotNull
    public Sequence<Var> getVariables();

    @Override
    @NotNull
    public Struct freshCopy();

    @Override
    @NotNull
    public Struct freshCopy(@NotNull Scope var1);

    @Override
    @NotNull
    public Struct asStruct();

    @NotNull
    public Struct append(@NotNull Term var1);

    @NotNull
    public Struct addLast(@NotNull Term var1);

    @NotNull
    public Struct addFirst(@NotNull Term var1);

    @NotNull
    public Struct insertAt(int var1, @NotNull Term var2);

    @NotNull
    public Struct setFunctor(@NotNull String var1);

    @NotNull
    public String getFunctor();

    public boolean isFunctorWellFormed();

    public int getArity();

    @NotNull
    public Indicator getIndicator();

    @NotNull
    public java.util.List<Term> getArgs();

    @NotNull
    public Sequence<Term> getArgsSequence();

    @NotNull
    public Term getArgAt(int var1);

    @NotNull
    public Struct setArgs(Term ... var1);

    @NotNull
    public Struct setArgs(@NotNull Iterable<? extends Term> var1);

    @NotNull
    public Struct setArgs(@NotNull Sequence<? extends Term> var1);

    @NotNull
    public Term get(int var1);

    @JvmStatic
    public static boolean isWellFormedFunctor(@NotNull String string2) {
        return Companion.isWellFormedFunctor(string2);
    }

    @JvmStatic
    @NotNull
    public static String enquoteFunctor(@NotNull String string2) {
        return Companion.enquoteFunctor(string2);
    }

    @JvmStatic
    @NotNull
    public static String enquoteFunctorIfNecessary(@NotNull String string2) {
        return Companion.enquoteFunctorIfNecessary(string2);
    }

    @JvmStatic
    public static boolean functorNeedsEscape(@NotNull String string2) {
        return Companion.functorNeedsEscape(string2);
    }

    @JvmStatic
    @NotNull
    public static String escapeFunctor(@NotNull String string2, boolean escapeSingleQuotes, boolean escapeDoubleQuotes) {
        return Companion.escapeFunctor(string2, escapeSingleQuotes, escapeDoubleQuotes);
    }

    @JvmStatic
    @NotNull
    public static String escapeFunctorIfNecessary(@NotNull String string2, boolean escapeSingleQuotes, boolean escapeDoubleQuotes) {
        return Companion.escapeFunctorIfNecessary(string2, escapeSingleQuotes, escapeDoubleQuotes);
    }

    @JvmStatic
    @NotNull
    public static Struct template(@NotNull String functor, int arity) {
        return Companion.template(functor, arity);
    }

    @JvmStatic
    @NotNull
    public static Struct of(@NotNull String functor, @NotNull java.util.List<? extends Term> args2) {
        return Companion.of(functor, args2);
    }

    @JvmStatic
    @NotNull
    public static Struct of(@NotNull String functor, Term ... args2) {
        return Companion.of(functor, args2);
    }

    @JvmStatic
    @NotNull
    public static Struct of(@NotNull String functor, @NotNull Sequence<? extends Term> args2) {
        return Companion.of(functor, args2);
    }

    @JvmStatic
    @NotNull
    public static Struct of(@NotNull String functor, @NotNull Iterable<? extends Term> args2) {
        return Companion.of(functor, args2);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, @NotNull java.util.List<? extends Term> terms) {
        return Companion.fold(operator, terms);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, @NotNull java.util.List<? extends Term> terms, @Nullable Term terminal) {
        return Companion.fold(operator, terms, terminal);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, @NotNull Sequence<? extends Term> terms, @Nullable Term terminal) {
        return Companion.fold(operator, terms, terminal);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, @NotNull Sequence<? extends Term> terms) {
        return Companion.fold(operator, terms);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, @NotNull Iterable<? extends Term> terms, @Nullable Term terminal) {
        return Companion.fold(operator, terms, terminal);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, @NotNull Iterable<? extends Term> terms) {
        return Companion.fold(operator, terms);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, @NotNull Term[] terms, @Nullable Term terminal) {
        return Companion.fold(operator, terms, terminal);
    }

    @JvmStatic
    @NotNull
    public static Struct fold(@NotNull String operator, Term ... terms) {
        return Companion.fold(operator, terms);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J$\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007J$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007J)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015J3\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0007\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0007J)\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00072\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0007J\u001e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0007J\u001e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0007J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0007R\u0013\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006#"}, d2={"Lit/unibo/tuprolog/core/Struct$Companion;", "", "()V", "NON_PRINTABLE_CHARACTER_PATTERN", "Lkotlin/text/Regex;", "WELL_FORMED_FUNCTOR_PATTERN", "enquoteFunctor", "", "string", "enquoteFunctorIfNecessary", "escapeFunctor", "escapeSingleQuotes", "", "escapeDoubleQuotes", "escapeFunctorIfNecessary", "fold", "Lit/unibo/tuprolog/core/Struct;", "operator", "terms", "", "Lit/unibo/tuprolog/core/Term;", "(Ljava/lang/String;[Lit/unibo/tuprolog/core/Term;)Lit/unibo/tuprolog/core/Struct;", "terminal", "(Ljava/lang/String;[Lit/unibo/tuprolog/core/Term;Lit/unibo/tuprolog/core/Term;)Lit/unibo/tuprolog/core/Struct;", "", "", "Lkotlin/sequences/Sequence;", "functorNeedsEscape", "isWellFormedFunctor", "of", "functor", "args", "template", "arity", "", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        public final boolean isWellFormedFunctor(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            return Terms.WELL_FORMED_FUNCTOR_PATTERN.matches(string2);
        }

        @JvmStatic
        @NotNull
        public final String enquoteFunctor(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            return '\'' + string2 + '\'';
        }

        @JvmStatic
        @NotNull
        public final String enquoteFunctorIfNecessary(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            return this.isWellFormedFunctor(string2) ? string2 : this.enquoteFunctor(string2);
        }

        @JvmStatic
        public final boolean functorNeedsEscape(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            return NON_PRINTABLE_CHARACTER_PATTERN.containsMatchIn(string2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String escapeFunctor(@NotNull String string2, boolean escapeSingleQuotes, boolean escapeDoubleQuotes) {
            Object v1;
            void $this$reduceOrNull$iv;
            Intrinsics.checkNotNullParameter(string2, "string");
            Object object = string2;
            boolean bl = false;
            char[] cArray = ((String)object).toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "(this as java.lang.String).toCharArray()");
            object = SequencesKt.map(ArraysKt.asSequence(cArray), (Function1)new Function1<Character, String>(escapeSingleQuotes, escapeDoubleQuotes){
                final /* synthetic */ boolean $escapeSingleQuotes;
                final /* synthetic */ boolean $escapeDoubleQuotes;
                {
                    this.$escapeSingleQuotes = $escapeSingleQuotes;
                    this.$escapeDoubleQuotes = $escapeDoubleQuotes;
                    super(1);
                }

                @NotNull
                public final String invoke(char it) {
                    return Terms.INSTANCE.escapeChar(it, this.$escapeSingleQuotes, this.$escapeDoubleQuotes);
                }
            });
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    Object t = iterator$iv.next();
                    String p0 = (String)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = Intrinsics.stringPlus(p0, p1);
                }
                v1 = accumulator$iv;
            }
            String string3 = v1;
            return string3 == null ? "" : string3;
        }

        public static /* synthetic */ String escapeFunctor$default(Companion companion, String string2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = !bl;
            }
            return companion.escapeFunctor(string2, bl, bl2);
        }

        @JvmStatic
        @NotNull
        public final String escapeFunctorIfNecessary(@NotNull String string2, boolean escapeSingleQuotes, boolean escapeDoubleQuotes) {
            Intrinsics.checkNotNullParameter(string2, "string");
            return this.functorNeedsEscape(string2) ? this.escapeFunctor(string2, escapeSingleQuotes, escapeDoubleQuotes) : string2;
        }

        public static /* synthetic */ String escapeFunctorIfNecessary$default(Companion companion, String string2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = !bl;
            }
            return companion.escapeFunctorIfNecessary(string2, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Struct template(@NotNull String functor, int arity) {
            Collection<Var> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(functor, "functor");
            boolean bl = arity >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "Arity must be a non-negative integer";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            Iterable iterable = RangesKt.until(0, arity);
            String string3 = functor;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl5 = false;
                Var var = Var.Companion.anonymous();
                collection.add(var);
            }
            collection = (java.util.List)destination$iv$iv;
            return companion.of(string3, (java.util.List<? extends Term>)collection);
        }

        @JvmStatic
        @NotNull
        public final Struct of(@NotNull String functor, @NotNull java.util.List<? extends Term> args2) {
            Struct struct;
            Intrinsics.checkNotNullParameter(functor, "functor");
            Intrinsics.checkNotNullParameter(args2, "args");
            if (args2.size() == 2 && Intrinsics.areEqual(".", functor)) {
                struct = Cons.Companion.of(CollectionsKt.first(args2), CollectionsKt.last(args2));
            } else if (args2.size() == 2 && Intrinsics.areEqual(":-", functor) && CollectionsKt.first(args2).isStruct()) {
                Term[] termArray = new Term[]{CollectionsKt.last(args2)};
                struct = Rule.Companion.of(CollectionsKt.first(args2).castToStruct(), termArray);
            } else {
                struct = args2.size() == 2 && Intrinsics.areEqual(",", functor) ? (Struct)Tuple.Companion.of(args2) : (args2.size() == 2 && Intrinsics.areEqual("/", functor) ? (Struct)Indicator.Companion.of(CollectionsKt.first(args2), CollectionsKt.last(args2)) : (args2.size() == 1 && Intrinsics.areEqual("{}", functor) ? (Struct)Block.Companion.of(args2) : (args2.size() == 1 && Intrinsics.areEqual(":-", functor) ? (Struct)Directive.Companion.of(CollectionsKt.first(args2), new Term[0]) : (args2.isEmpty() ? (Struct)Atom.Companion.of(functor) : (Struct)new StructImpl(functor, args2, MapsKt.emptyMap())))));
            }
            return struct;
        }

        @JvmStatic
        @NotNull
        public final Struct of(@NotNull String functor, Term ... args2) {
            Intrinsics.checkNotNullParameter(functor, "functor");
            Intrinsics.checkNotNullParameter(args2, "args");
            return this.of(functor, ArraysKt.toList(args2));
        }

        @JvmStatic
        @NotNull
        public final Struct of(@NotNull String functor, @NotNull Sequence<? extends Term> args2) {
            Intrinsics.checkNotNullParameter(functor, "functor");
            Intrinsics.checkNotNullParameter(args2, "args");
            return this.of(functor, SequencesKt.toList(args2));
        }

        @JvmStatic
        @NotNull
        public final Struct of(@NotNull String functor, @NotNull Iterable<? extends Term> args2) {
            Intrinsics.checkNotNullParameter(functor, "functor");
            Intrinsics.checkNotNullParameter(args2, "args");
            return this.of(functor, CollectionsKt.toList(args2));
        }

        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, @NotNull java.util.List<? extends Term> terms) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            return this.fold(operator, terms, (Term)null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, @NotNull java.util.List<? extends Term> terms, @Nullable Term terminal) {
            Object object;
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            if (Intrinsics.areEqual(operator, ".") && Intrinsics.areEqual(terminal, EmptyList.Companion.invoke())) {
                object = List.Companion.of(terms);
            } else if (Intrinsics.areEqual(operator, ".") && terminal == null) {
                object = List.Companion.from(terms);
            } else if (Intrinsics.areEqual(operator, ",")) {
                object = Tuple.Companion.of(CollectionsKt.plus((Collection)terms, (Iterable)CollectionsKt.listOfNotNull(terminal)));
            } else if (terminal == null) {
                void $this$foldRight$iv322;
                boolean bl = terms.size() >= 2;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string2 = "Struct requires at least two terms to fold";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                java.util.List<? extends Term> list = CollectionsKt.slice(terms, RangesKt.until(0, CollectionsKt.getLastIndex(terms) - 1));
                Term[] termArray = new Term[]{terms.get(CollectionsKt.getLastIndex(terms) - 1), terms.get(CollectionsKt.getLastIndex(terms))};
                Struct initial$iv22 = this.of(operator, termArray);
                boolean $i$f$foldRight2 = false;
                Struct accumulator$iv = initial$iv22;
                if (!$this$foldRight$iv322.isEmpty()) {
                    ListIterator iterator$iv = $this$foldRight$iv322.listIterator($this$foldRight$iv322.size());
                    while (iterator$iv.hasPrevious()) {
                        void b;
                        Struct struct = accumulator$iv;
                        Term a = (Term)iterator$iv.previous();
                        boolean bl5 = false;
                        Term[] termArray2 = new Term[]{a, (Term)b};
                        accumulator$iv = $$INSTANCE.of(operator, termArray2);
                    }
                }
                object = accumulator$iv;
            } else {
                Collection $this$foldRight$iv322 = terms;
                boolean initial$iv22 = false;
                boolean $this$foldRight$iv322 = !$this$foldRight$iv322.isEmpty();
                initial$iv22 = false;
                boolean $i$f$foldRight2 = false;
                if (!$this$foldRight$iv322) {
                    boolean bl = false;
                    String $i$f$foldRight2 = "Struct requires at least two terms to fold";
                    throw (Throwable)new IllegalArgumentException($i$f$foldRight2.toString());
                }
                java.util.List<? extends Term> $this$foldRight$iv322 = CollectionsKt.slice(terms, RangesKt.until(0, CollectionsKt.getLastIndex(terms)));
                Object initial$iv22 = new Term[]{terms.get(CollectionsKt.getLastIndex(terms)), terminal};
                initial$iv22 = this.of(operator, (Term)initial$iv22);
                $i$f$foldRight2 = false;
                Object accumulator$iv = initial$iv22;
                if (!$this$foldRight$iv322.isEmpty()) {
                    ListIterator<? extends Term> iterator$iv = $this$foldRight$iv322.listIterator($this$foldRight$iv322.size());
                    while (iterator$iv.hasPrevious()) {
                        Object b = accumulator$iv;
                        Term a = iterator$iv.previous();
                        boolean bl = false;
                        Term[] termArray = new Term[]{a, (Term)b};
                        accumulator$iv = $$INSTANCE.of(operator, termArray);
                    }
                }
                object = accumulator$iv;
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, @NotNull Sequence<? extends Term> terms, @Nullable Term terminal) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            return this.fold(operator, SequencesKt.toList(terms), terminal);
        }

        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, @NotNull Sequence<? extends Term> terms) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            return this.fold(operator, terms, null);
        }

        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, @NotNull Iterable<? extends Term> terms, @Nullable Term terminal) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            return this.fold(operator, CollectionsKt.toList(terms), terminal);
        }

        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, @NotNull Iterable<? extends Term> terms) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            return this.fold(operator, terms, null);
        }

        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, @NotNull Term[] terms, @Nullable Term terminal) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            return this.fold(operator, ArraysKt.toList(terms), terminal);
        }

        @JvmStatic
        @NotNull
        public final Struct fold(@NotNull String operator, Term ... terms) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(terms, "terms");
            return this.fold(operator, CollectionsKt.listOf(Arrays.copyOf(terms, terms.length)));
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isStruct(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean isClause(@NotNull Struct this_) {
            boolean bl;
            Intrinsics.checkNotNullParameter(this_, "this");
            if (!Intrinsics.areEqual(":-", this_.getFunctor())) return false;
            int n = this_.getArity();
            switch (n) {
                case 2: {
                    bl = this_.getArgAt(0).isStruct();
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            if (!bl) return false;
            return true;
        }

        public static boolean isRule(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.isClause() && this_.getArity() == 2;
        }

        public static boolean isDirective(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.isClause() && this_.getArity() == 1;
        }

        public static boolean isFact(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.isRule() && this_.getArgAt(1).isTrue();
        }

        public static boolean isTuple(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Intrinsics.areEqual(this_.getFunctor(), ",") && this_.getArity() == 2;
        }

        public static boolean isAtom(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getArity() == 0;
        }

        public static boolean isList(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.isCons() || this_.isEmptyList();
        }

        public static boolean isCons(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Intrinsics.areEqual(".", this_.getFunctor()) && this_.getArity() == 2;
        }

        public static boolean isBlock(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Intrinsics.areEqual("{}", this_.getFunctor()) && this_.getArity() == 1 || this_.isEmptyBlock();
        }

        public static boolean isEmptyBlock(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Intrinsics.areEqual("{}", this_.getFunctor()) && this_.getArity() == 0;
        }

        public static boolean isEmptyList(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Intrinsics.areEqual("[]", this_.getFunctor()) && this_.getArity() == 0;
        }

        public static boolean isTrue(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.isAtom() && Intrinsics.areEqual("true", this_.getFunctor());
        }

        public static boolean isFail(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.isAtom() && Intrinsics.areEqual("fail", this_.getFunctor());
        }

        public static boolean isIndicator(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Intrinsics.areEqual("/", this_.getFunctor()) && this_.getArity() == 2;
        }

        @NotNull
        public static Sequence<Var> getVariables(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return SequencesKt.flatMap(this_.getArgsSequence(), variables.1.INSTANCE);
        }

        @NotNull
        public static Struct asStruct(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_;
        }

        @NotNull
        public static Struct append(@NotNull Struct this_, @NotNull Term argument2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(argument2, "argument");
            return this_.addLast(argument2);
        }

        public static /* synthetic */ void getFunctor$annotations() {
        }

        public static /* synthetic */ void isFunctorWellFormed$annotations() {
        }

        public static int getArity(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getArgs().size();
        }

        public static /* synthetic */ void getArity$annotations() {
        }

        @NotNull
        public static Indicator getIndicator(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Indicator.Companion.of(this_.getFunctor(), this_.getArity());
        }

        public static /* synthetic */ void getIndicator$annotations() {
        }

        public static /* synthetic */ void getArgs$annotations() {
        }

        @NotNull
        public static Sequence<Term> getArgsSequence(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return CollectionsKt.asSequence((Iterable)this_.getArgs());
        }

        public static /* synthetic */ void getArgsSequence$annotations() {
        }

        @NotNull
        public static Term getArgAt(@NotNull Struct this_, int index) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getArgs().get(index);
        }

        @NotNull
        public static Term get(@NotNull Struct this_, int index) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getArgAt(index);
        }

        @Nullable
        public static <T extends Term> T as(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.as(this_);
        }

        @NotNull
        public static <T extends Term> T castTo(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castTo(this_);
        }

        @NotNull
        public static Term apply(@NotNull Struct this_, @NotNull Substitution substitution, Substitution ... substitutions) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(substitution, "substitution");
            Intrinsics.checkNotNullParameter(substitutions, "substitutions");
            return Term.DefaultImpls.apply(this_, substitution, substitutions);
        }

        @Nullable
        public static Atom asAtom(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asAtom(this_);
        }

        @Nullable
        public static Block asBlock(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asBlock(this_);
        }

        @Nullable
        public static Clause asClause(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asClause(this_);
        }

        @Nullable
        public static Cons asCons(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asCons(this_);
        }

        @Nullable
        public static Constant asConstant(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asConstant(this_);
        }

        @Nullable
        public static Directive asDirective(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asDirective(this_);
        }

        @Nullable
        public static EmptyBlock asEmptyBlock(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asEmptyBlock(this_);
        }

        @Nullable
        public static EmptyList asEmptyList(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asEmptyList(this_);
        }

        @Nullable
        public static Fact asFact(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asFact(this_);
        }

        @Nullable
        public static Indicator asIndicator(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asIndicator(this_);
        }

        @Nullable
        public static Integer asInteger(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asInteger(this_);
        }

        @Nullable
        public static List asList(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asList(this_);
        }

        @Nullable
        public static Numeric asNumeric(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asNumeric(this_);
        }

        @Nullable
        public static Real asReal(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asReal(this_);
        }

        @Nullable
        public static Recursive asRecursive(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asRecursive(this_);
        }

        @Nullable
        public static Rule asRule(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asRule(this_);
        }

        @NotNull
        public static Term asTerm(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asTerm(this_);
        }

        @Nullable
        public static Truth asTruth(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asTruth(this_);
        }

        @Nullable
        public static Tuple asTuple(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asTuple(this_);
        }

        @Nullable
        public static Var asVar(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.asVar(this_);
        }

        @NotNull
        public static Atom castToAtom(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToAtom(this_);
        }

        @NotNull
        public static Block castToBlock(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToBlock(this_);
        }

        @NotNull
        public static Clause castToClause(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToClause(this_);
        }

        @NotNull
        public static Cons castToCons(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToCons(this_);
        }

        @NotNull
        public static Constant castToConstant(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToConstant(this_);
        }

        @NotNull
        public static Directive castToDirective(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToDirective(this_);
        }

        @NotNull
        public static EmptyBlock castToEmptyBlock(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToEmptyBlock(this_);
        }

        @NotNull
        public static EmptyList castToEmptyList(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToEmptyList(this_);
        }

        @NotNull
        public static Fact castToFact(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToFact(this_);
        }

        @NotNull
        public static Indicator castToIndicator(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToIndicator(this_);
        }

        @NotNull
        public static Integer castToInteger(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToInteger(this_);
        }

        @NotNull
        public static List castToList(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToList(this_);
        }

        @NotNull
        public static Numeric castToNumeric(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToNumeric(this_);
        }

        @NotNull
        public static Real castToReal(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToReal(this_);
        }

        @NotNull
        public static Recursive castToRecursive(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToRecursive(this_);
        }

        @NotNull
        public static Rule castToRule(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToRule(this_);
        }

        @NotNull
        public static Struct castToStruct(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToStruct(this_);
        }

        @NotNull
        public static Term castToTerm(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToTerm(this_);
        }

        @NotNull
        public static Truth castToTruth(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToTruth(this_);
        }

        @NotNull
        public static Tuple castToTuple(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToTuple(this_);
        }

        @NotNull
        public static Var castToVar(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.castToVar(this_);
        }

        @NotNull
        public static Term get(@NotNull Struct this_, @NotNull Substitution substitution, Substitution ... substitutions) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(substitution, "substitution");
            Intrinsics.checkNotNullParameter(substitutions, "substitutions");
            return Term.DefaultImpls.get(this_, substitution, substitutions);
        }

        public static boolean isConstant(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isConstant(this_);
        }

        public static boolean isGround(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isGround(this_);
        }

        public static boolean isInteger(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isInteger(this_);
        }

        public static boolean isNumber(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isNumber(this_);
        }

        public static boolean isReal(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isReal(this_);
        }

        public static boolean isRecursive(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isRecursive(this_);
        }

        public static boolean isTruth(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isTruth(this_);
        }

        public static boolean isVar(@NotNull Struct this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Term.DefaultImpls.isVar(this_);
        }

        @Nullable
        public static <T> T getTag(@NotNull Struct this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(name, "name");
            return Term.DefaultImpls.getTag(this_, name);
        }

        public static int compareTo(@NotNull Struct this_, @NotNull Term other) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(other, "other");
            return Term.DefaultImpls.compareTo(this_, other);
        }

        public static boolean containsTag(@NotNull Struct this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(name, "name");
            return Term.DefaultImpls.containsTag(this_, name);
        }
    }
}

