/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Block;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Cons;
import it.unibo.tuprolog.core.Constant;
import it.unibo.tuprolog.core.Directive;
import it.unibo.tuprolog.core.EmptyBlock;
import it.unibo.tuprolog.core.EmptyList;
import it.unibo.tuprolog.core.Fact;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.List;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Recursive;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Terms;
import it.unibo.tuprolog.core.Truth;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.impl.IntegerImpl;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.gciatto.kt.math.BigDecimal;
import org.gciatto.kt.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\b\u0010\u0010\u001a\u00020\u0000H&J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0012\u0010\r\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0014"}, d2={"Lit/unibo/tuprolog/core/Integer;", "Lit/unibo/tuprolog/core/Numeric;", "decimalValue", "Lorg/gciatto/kt/math/BigDecimal;", "getDecimalValue", "()Lorg/gciatto/kt/math/BigDecimal;", "intValue", "Lorg/gciatto/kt/math/BigInteger;", "getIntValue", "()Lorg/gciatto/kt/math/BigInteger;", "isInteger", "", "()Z", "value", "getValue", "asInteger", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "Companion", "core"})
public interface Integer
extends Numeric {
    @NotNull
    public static final Companion Companion = it.unibo.tuprolog.core.Integer$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final Regex PATTERN = Terms.INTEGER_PATTERN;
    @JvmField
    @NotNull
    public static final Integer ZERO = Companion.of(BigInteger.ZERO);
    @JvmField
    @NotNull
    public static final Integer ONE = Companion.of(BigInteger.ONE);
    @JvmField
    @NotNull
    public static final Integer MINUS_ONE = Companion.of(BigInteger.Companion.of(-1));

    @Override
    public boolean isInteger();

    @Override
    @NotNull
    public BigInteger getValue();

    @Override
    @NotNull
    public BigDecimal getDecimalValue();

    @Override
    @NotNull
    public BigInteger getIntValue();

    @Override
    @NotNull
    public Integer freshCopy();

    @Override
    @NotNull
    public Integer freshCopy(@NotNull Scope var1);

    @Override
    @NotNull
    public Integer asInteger();

    @JvmStatic
    @NotNull
    public static Integer of(@NotNull BigInteger integer) {
        return Companion.of(integer);
    }

    @JvmStatic
    @NotNull
    public static Integer of(long integer) {
        return Companion.of(integer);
    }

    @JvmStatic
    @NotNull
    public static Integer of(int integer) {
        return Companion.of(integer);
    }

    @JvmStatic
    @NotNull
    public static Integer of(short integer) {
        return Companion.of(integer);
    }

    @JvmStatic
    @NotNull
    public static Integer of(byte integer) {
        return Companion.of(integer);
    }

    @JvmStatic
    @NotNull
    public static Integer of(@NotNull String integer) {
        return Companion.of(integer);
    }

    @JvmStatic
    @NotNull
    public static Integer of(@NotNull String integer, int radix) {
        return Companion.of(integer, radix);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\fH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0011H\u0007R\u0013\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0012"}, d2={"Lit/unibo/tuprolog/core/Integer$Companion;", "", "()V", "MINUS_ONE", "Lit/unibo/tuprolog/core/Integer;", "ONE", "PATTERN", "Lkotlin/text/Regex;", "ZERO", "of", "integer", "", "", "", "", "", "radix", "Lorg/gciatto/kt/math/BigInteger;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Integer of(@NotNull BigInteger integer) {
            Intrinsics.checkNotNullParameter(integer, "integer");
            return new IntegerImpl(integer, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final Integer of(long integer) {
            return this.of(BigInteger.Companion.of(integer));
        }

        @JvmStatic
        @NotNull
        public final Integer of(int integer) {
            return this.of(BigInteger.Companion.of(integer));
        }

        @JvmStatic
        @NotNull
        public final Integer of(short integer) {
            return this.of(BigInteger.Companion.of((long)integer));
        }

        @JvmStatic
        @NotNull
        public final Integer of(byte integer) {
            return this.of(BigInteger.Companion.of((long)integer));
        }

        @JvmStatic
        @NotNull
        public final Integer of(@NotNull String integer) {
            Intrinsics.checkNotNullParameter(integer, "integer");
            return this.of(BigInteger.Companion.of(integer));
        }

        @JvmStatic
        @NotNull
        public final Integer of(@NotNull String integer, int radix) {
            Intrinsics.checkNotNullParameter(integer, "integer");
            return this.of(BigInteger.Companion.of(integer, radix));
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isInteger(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return true;
        }

        @NotNull
        public static BigDecimal getDecimalValue(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return BigDecimal.Companion.of$default(BigDecimal.Companion, this_.getValue(), null, 2, null);
        }

        @NotNull
        public static BigInteger getIntValue(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getValue();
        }

        @NotNull
        public static Integer asInteger(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_;
        }

        @Nullable
        public static <T extends Term> T as(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.as(this_);
        }

        @NotNull
        public static <T extends Term> T castTo(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castTo(this_);
        }

        @NotNull
        public static Term apply(@NotNull Integer this_, @NotNull Substitution substitution, Substitution ... substitutions) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(substitution, "substitution");
            Intrinsics.checkNotNullParameter(substitutions, "substitutions");
            return Numeric.DefaultImpls.apply(this_, substitution, substitutions);
        }

        @Nullable
        public static Atom asAtom(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asAtom(this_);
        }

        @Nullable
        public static Block asBlock(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asBlock(this_);
        }

        @Nullable
        public static Clause asClause(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asClause(this_);
        }

        @Nullable
        public static Cons asCons(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asCons(this_);
        }

        @Nullable
        public static Directive asDirective(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asDirective(this_);
        }

        @Nullable
        public static EmptyBlock asEmptyBlock(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asEmptyBlock(this_);
        }

        @Nullable
        public static EmptyList asEmptyList(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asEmptyList(this_);
        }

        @Nullable
        public static Fact asFact(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asFact(this_);
        }

        @Nullable
        public static Indicator asIndicator(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asIndicator(this_);
        }

        @Nullable
        public static List asList(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asList(this_);
        }

        @Nullable
        public static Real asReal(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asReal(this_);
        }

        @Nullable
        public static Recursive asRecursive(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asRecursive(this_);
        }

        @Nullable
        public static Rule asRule(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asRule(this_);
        }

        @Nullable
        public static Struct asStruct(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asStruct(this_);
        }

        @NotNull
        public static Term asTerm(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asTerm(this_);
        }

        @Nullable
        public static Truth asTruth(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asTruth(this_);
        }

        @Nullable
        public static Tuple asTuple(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asTuple(this_);
        }

        @Nullable
        public static Var asVar(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asVar(this_);
        }

        @NotNull
        public static Atom castToAtom(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToAtom(this_);
        }

        @NotNull
        public static Block castToBlock(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToBlock(this_);
        }

        @NotNull
        public static Clause castToClause(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToClause(this_);
        }

        @NotNull
        public static Cons castToCons(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToCons(this_);
        }

        @NotNull
        public static Constant castToConstant(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToConstant(this_);
        }

        @NotNull
        public static Directive castToDirective(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToDirective(this_);
        }

        @NotNull
        public static EmptyBlock castToEmptyBlock(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToEmptyBlock(this_);
        }

        @NotNull
        public static EmptyList castToEmptyList(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToEmptyList(this_);
        }

        @NotNull
        public static Fact castToFact(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToFact(this_);
        }

        @NotNull
        public static Indicator castToIndicator(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToIndicator(this_);
        }

        @NotNull
        public static Integer castToInteger(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToInteger(this_);
        }

        @NotNull
        public static List castToList(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToList(this_);
        }

        @NotNull
        public static Numeric castToNumeric(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToNumeric(this_);
        }

        @NotNull
        public static Real castToReal(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToReal(this_);
        }

        @NotNull
        public static Recursive castToRecursive(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToRecursive(this_);
        }

        @NotNull
        public static Rule castToRule(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToRule(this_);
        }

        @NotNull
        public static Struct castToStruct(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToStruct(this_);
        }

        @NotNull
        public static Term castToTerm(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToTerm(this_);
        }

        @NotNull
        public static Truth castToTruth(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToTruth(this_);
        }

        @NotNull
        public static Tuple castToTuple(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToTuple(this_);
        }

        @NotNull
        public static Var castToVar(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.castToVar(this_);
        }

        public static int compareValueTo(@NotNull Integer this_, @NotNull Numeric other) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(other, "other");
            return Numeric.DefaultImpls.compareValueTo(this_, other);
        }

        @NotNull
        public static Term get(@NotNull Integer this_, @NotNull Substitution substitution, Substitution ... substitutions) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(substitution, "substitution");
            Intrinsics.checkNotNullParameter(substitutions, "substitutions");
            return Numeric.DefaultImpls.get(this_, substitution, substitutions);
        }

        public static boolean isAtom(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isAtom(this_);
        }

        public static boolean isBlock(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isBlock(this_);
        }

        public static boolean isClause(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isClause(this_);
        }

        public static boolean isCons(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isCons(this_);
        }

        public static boolean isDirective(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isDirective(this_);
        }

        public static boolean isEmptyBlock(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isEmptyBlock(this_);
        }

        public static boolean isEmptyList(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isEmptyList(this_);
        }

        public static boolean isFact(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isFact(this_);
        }

        public static boolean isFail(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isFail(this_);
        }

        public static boolean isGround(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isGround(this_);
        }

        public static boolean isIndicator(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isIndicator(this_);
        }

        public static boolean isList(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isList(this_);
        }

        public static boolean isReal(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isReal(this_);
        }

        public static boolean isRecursive(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isRecursive(this_);
        }

        public static boolean isRule(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isRule(this_);
        }

        public static boolean isStruct(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isStruct(this_);
        }

        public static boolean isTrue(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isTrue(this_);
        }

        public static boolean isTruth(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isTruth(this_);
        }

        public static boolean isTuple(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isTuple(this_);
        }

        public static boolean isVar(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isVar(this_);
        }

        @Nullable
        public static <T> T getTag(@NotNull Integer this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(name, "name");
            return Numeric.DefaultImpls.getTag(this_, name);
        }

        @NotNull
        public static Constant asConstant(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asConstant(this_);
        }

        @NotNull
        public static Numeric asNumeric(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.asNumeric(this_);
        }

        public static int compareTo(@NotNull Integer this_, @NotNull Term other) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(other, "other");
            return Numeric.DefaultImpls.compareTo(this_, other);
        }

        public static boolean containsTag(@NotNull Integer this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(name, "name");
            return Numeric.DefaultImpls.containsTag(this_, name);
        }

        public static boolean isConstant(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isConstant(this_);
        }

        public static boolean isNumber(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.isNumber(this_);
        }

        @NotNull
        public static Sequence<Var> getVariables(@NotNull Integer this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return Numeric.DefaultImpls.getVariables(this_);
        }
    }
}

