/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.use;

import guru.nidi.graphviz.attribute.Font;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.Size;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Node;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class FontTools {
    private FontTools() {
    }

    public static List<String> availableFontNames() {
        return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    public static void availableFontNamesGraph(File output) throws IOException {
        MutableGraph g = Factory.mutGraph().graphAttrs().add(Rank.dir(Rank.RankDir.LEFT_TO_RIGHT)).nodeAttrs().add(Size.mode(Size.Mode.MINIMUM).margin(0.1, 0.1).size(0.0, 0.0), Shape.RECTANGLE);
        List<String> fonts = FontTools.availableFontNames();
        fonts.sort(Comparator.reverseOrder());
        for (String f : fonts) {
            g.add((LinkSource)((Node)Factory.node(f + "2").with(Label.of("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz"))).with(Font.name(f)));
            g.add((LinkSource)((Node)Factory.node(f + "3").with(Label.of("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"))).with(Font.name(f)));
            g.add((LinkSource)Factory.node(f).with(Font.name(f)));
        }
        Graphviz.fromGraph(g).render(Format.PNG).toFile(output);
    }

    public static void main(String[] args2) throws IOException {
        Graphviz.useEngine(new GraphvizV8Engine(), new GraphvizEngine[0]);
        System.out.println("Available fonts: " + FontTools.availableFontNames());
        String fontShow = "font-show.png";
        System.out.println("Creating image with all fonts 'font-show.png'.");
        FontTools.availableFontNamesGraph(new File("font-show.png"));
        if (args2.length < 2) {
            System.out.println("Usage: FontTools <font name> <font adjust>");
            System.exit(0);
        }
    }
}

