/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.attribute.validate.ValidatorFormat;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizCmdLineEngine;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.GraphvizPostProcessor;
import guru.nidi.graphviz.engine.GraphvizPreProcessor;
import guru.nidi.graphviz.engine.GraphvizProcessor;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import guru.nidi.graphviz.engine.InvalidCharsRemover;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.ProcessOptions;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.engine.SvgImagePathsRestorer;
import guru.nidi.graphviz.engine.SvgSizeAdjuster;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Serializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Graphviz {
    private static final Logger LOG;
    private static final List<GraphvizProcessor> DEFAULT_PROCESSORS;
    private static final Pattern DPI_PATTERN;
    @Nullable
    private static volatile List<GraphvizEngine> availableEngines;
    @Nullable
    private static volatile BlockingQueue<GraphvizEngine> engineQueue;
    @Nullable
    private static volatile GraphvizEngine engine;
    @Nullable
    private final MutableGraph graph;
    @Nullable
    private final String src;
    final Rasterizer rasterizer;
    final ProcessOptions processOptions;
    final Options options;
    private final List<GraphvizProcessor> processors;
    @Nullable
    private final Consumer<ValidatorMessage> messageConsumer;

    private Graphviz(@Nullable MutableGraph graph, @Nullable String src, ProcessOptions processOptions) {
        this(graph, src, Rasterizer.DEFAULT, processOptions, Options.create(), DEFAULT_PROCESSORS, null);
    }

    private Graphviz(@Nullable MutableGraph graph, @Nullable String src, Rasterizer rasterizer, ProcessOptions processOptions, Options options2, List<GraphvizProcessor> processors, @Nullable Consumer<ValidatorMessage> messageConsumer) {
        this.graph = graph;
        this.src = src;
        this.rasterizer = rasterizer;
        this.processOptions = processOptions;
        this.options = options2;
        this.processors = processors;
        this.messageConsumer = messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<GraphvizEngine> availableEngines() {
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (availableEngines == null) {
                availableEngines = new ArrayList<GraphvizEngine>();
                if (GraphvizCmdLineEngine.AVAILABLE) {
                    availableEngines.add(new GraphvizCmdLineEngine());
                }
                if (GraphvizV8Engine.AVAILABLE) {
                    availableEngines.add(new GraphvizV8Engine());
                }
                if (GraphvizJdkEngine.AVAILABLE) {
                    availableEngines.add(new GraphvizJdkEngine());
                }
                if (availableEngines.isEmpty()) {
                    LOG.warn("No GraphvizEngine is available. Either add the needed dependencies on the classpath or explicitly use 'Graphviz.useEngine(new GraphvizServerEngine())'.");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return availableEngines;
        }
    }

    public static void useDefaultEngines() {
        Graphviz.useEngine(Graphviz.availableEngines());
    }

    public static void useEngine(GraphvizEngine first2, GraphvizEngine ... rest) {
        ArrayList<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
        engines.add(first2);
        engines.addAll(Arrays.asList(rest));
        Graphviz.useEngine(engines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void useEngine(List<GraphvizEngine> engines) {
        if (engines.isEmpty()) {
            Graphviz.useDefaultEngines();
            return;
        }
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engineQueue == null) {
                engineQueue = new ArrayBlockingQueue<GraphvizEngine>(1);
            } else {
                try {
                    Graphviz.getEngine().close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            engine = null;
            Graphviz.doUseEngine(engines);
            return;
        }
    }

    private static void doUseEngine(List<GraphvizEngine> engines) {
        if (engines.isEmpty()) {
            engineQueue.add(new ErrorGraphvizEngine());
        } else {
            engines.get(0).init(e -> engineQueue.add((GraphvizEngine)e), e -> Graphviz.doUseEngine(engines.subList(1, engines.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GraphvizEngine getEngine() {
        if (engineQueue == null) {
            Graphviz.useDefaultEngines();
        }
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engine == null) {
                try {
                    engine = engineQueue.poll(120L, TimeUnit.SECONDS);
                    if (engine == null) {
                        throw new GraphvizException("Initializing graphviz engine took too long.");
                    }
                    if (engine instanceof ErrorGraphvizEngine) {
                        throw new GraphvizException("None of the provided engines could be initialized.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseEngine() {
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engine != null) {
                Graphviz.doReleaseEngine(engine);
            }
            if (engineQueue != null) {
                for (GraphvizEngine engine : engineQueue) {
                    Graphviz.doReleaseEngine(engine);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            engine = null;
            engineQueue = null;
            return;
        }
    }

    private static void doReleaseEngine(GraphvizEngine engine) {
        try {
            engine.close();
        }
        catch (Exception e) {
            throw new GraphvizException("Problem closing engine", e);
        }
    }

    public static void noHeadless() {
        System.setProperty("java.awt.headless", "false");
    }

    public static Graphviz fromFile(File src) throws IOException {
        try (FileInputStream in = new FileInputStream(src);){
            Graphviz graphviz = Graphviz.fromString(GraphvizLoader.readAsString(in)).basedir(src.getAbsoluteFile().getParentFile());
            return graphviz;
        }
    }

    public static Graphviz fromGraph(Graph graph) {
        return Graphviz.fromGraph((MutableGraph)((Object)graph));
    }

    public static Graphviz fromGraph(MutableGraph graph) {
        return new Graphviz(graph, null, new ProcessOptions());
    }

    public static Graphviz fromString(String src) {
        return new Graphviz(null, src, new ProcessOptions().dpi(Graphviz.dpi(src)));
    }

    public Graphviz engine(Engine engine) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options.engine(engine), this.processors, this.messageConsumer);
    }

    public Graphviz totalMemory(@Nullable Integer totalMemory) {
        Options opts = this.options.totalMemory(totalMemory);
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, opts, this.processors, this.messageConsumer);
    }

    public Graphviz yInvert(@Nullable Boolean yInvert) {
        Options opts = this.options.yInvert(yInvert);
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, opts, this.processors, this.messageConsumer);
    }

    public Graphviz basedir(File basedir) {
        Options opts = this.options.basedir(basedir);
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, opts, this.processors, this.messageConsumer);
    }

    public Graphviz width(int width) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions.width(width), this.options, this.processors, this.messageConsumer);
    }

    public Graphviz height(int height) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions.height(height), this.options, this.processors, this.messageConsumer);
    }

    public Graphviz scale(double scale) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions.scale(scale), this.options, this.processors, this.messageConsumer);
    }

    public Graphviz preProcessor(GraphvizPreProcessor preProcessor) {
        return this.processor(preProcessor);
    }

    public Graphviz postProcessor(GraphvizPostProcessor postProcessor) {
        return this.processor(postProcessor);
    }

    public Graphviz processor(GraphvizProcessor processor) {
        ArrayList<GraphvizProcessor> ps = new ArrayList<GraphvizProcessor>(this.processors);
        ps.add(processor);
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options, ps, this.messageConsumer);
    }

    public Graphviz notValidating() {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options, this.processors, null);
    }

    public Graphviz validating(Consumer<ValidatorMessage> messageConsumer) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options, this.processors, messageConsumer);
    }

    public Renderer rasterize(Rasterizer rasterizer) {
        if (rasterizer == Rasterizer.NONE) {
            throw new IllegalArgumentException("The provided rasterizer implementation was not found. Make sure that either 'guru.nidi.com.kitfox:svgSalamander' or 'org.apache.xmlgraphics:batik-rasterizer' is available on the classpath.");
        }
        Options opts = this.options.format(rasterizer.format());
        Graphviz g = new Graphviz(this.graph, this.src, rasterizer, this.processOptions, opts, this.processors, this.messageConsumer);
        return new Renderer(g, Format.PNG);
    }

    public Renderer render(Format format) {
        Options opts = this.options.format(format);
        Graphviz g = new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, opts, this.processors, this.messageConsumer);
        return new Renderer(g, format);
    }

    EngineResult execute() {
        String source = this.src == null ? this.serializer().serialize(this.graph) : this.src;
        ProcessOptions processOpts = this.processOptions.dpi(Graphviz.dpi(source));
        return new Graphviz(this.graph, source, this.rasterizer, processOpts, this.options, this.processors, this.messageConsumer).doExecute();
    }

    private Serializer serializer() {
        Serializer serializer = new Serializer().forEngine(this.options.engine.forValidator()).forFormat(this.rasterizer instanceof BuiltInRasterizer ? ValidatorFormat.UNKNOWN_FORMAT : this.options.format.forValidator());
        return this.messageConsumer == null ? serializer : serializer.validating(this.messageConsumer);
    }

    private static double dpi(String src) {
        Matcher matcher = DPI_PATTERN.matcher(src);
        return matcher.find() ? Double.parseDouble(matcher.group(1)) : 72.0;
    }

    private EngineResult doExecute() {
        return this.applyPostProcessors(this.options.format == Format.DOT ? EngineResult.fromString(this.src) : Graphviz.getEngine().execute(this.applyPreProcessors(this.src), this.options, this.rasterizer));
    }

    private String applyPreProcessors(String source) {
        String src = source;
        for (GraphvizProcessor proc2 : this.processors) {
            src = proc2.preProcess(src, this.options, this.processOptions);
        }
        return src;
    }

    private EngineResult applyPostProcessors(EngineResult result2) {
        EngineResult res = result2;
        for (GraphvizProcessor proc2 : this.processors) {
            res = proc2.postProcess(res, this.options, this.processOptions);
        }
        return res;
    }

    static {
        if (System.getProperty("java.awt.headless") == null) {
            System.setProperty("java.awt.headless", "true");
        }
        LOG = LoggerFactory.getLogger(Graphviz.class);
        DEFAULT_PROCESSORS = Arrays.asList(new InvalidCharsRemover(), new SvgSizeAdjuster(), new SvgImagePathsRestorer());
        DPI_PATTERN = Pattern.compile("\"?dpi\"?\\s*=\\s*\"?([0-9.]+)\"?", 2);
    }

    private static class ErrorGraphvizEngine
    implements GraphvizEngine {
        private ErrorGraphvizEngine() {
        }

        @Override
        public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        }

        @Override
        public EngineResult execute(String src, Options options2, Rasterizer rasterizer) {
            return EngineResult.fromString("");
        }

        @Override
        public void close() {
        }
    }
}

