/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.util.Utils;
import java.security.AccessController;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public final class PrismSettings {
    public static final boolean verbose;
    public static final boolean debug;
    public static final boolean trace;
    public static final boolean printAllocs;
    public static final boolean isVsyncEnabled;
    public static final boolean dirtyOptsEnabled;
    public static final boolean occlusionCullingEnabled;
    public static final boolean scrollCacheOpt;
    public static final boolean threadCheck;
    public static final boolean cacheSimpleShapes;
    public static final boolean cacheComplexShapes;
    public static final boolean useNewImageLoader;
    public static final List<String> tryOrder;
    public static final int prismStatFrequency;
    public static final RasterizerType rasterizerSpec;
    public static final String refType;
    public static final boolean forceRepaint;
    public static final boolean noFallback;
    public static final boolean showDirtyRegions;
    public static final boolean showOverdraw;
    public static final boolean printRenderGraph;
    public static final int minRTTSize;
    public static final int dirtyRegionCount;
    public static final boolean disableBadDriverWarning;
    public static final boolean forceGPU;
    public static final int maxTextureSize;
    public static final int primTextureSize;
    public static final boolean disableRegionCaching;
    public static final boolean forcePow2;
    public static final boolean noClampToZero;
    public static final boolean disableD3D9Ex;
    public static final boolean allowHiDPIScaling;
    public static final long maxVram;
    public static final long targetVram;
    public static final boolean poolStats;
    public static final boolean poolDebug;
    public static final boolean disableEffects;
    public static final int glyphCacheWidth;
    public static final int glyphCacheHeight;
    public static final String perfLog;
    public static final boolean perfLogExitFlush;
    public static final boolean perfLogFirstPaintFlush;
    public static final boolean perfLogFirstPaintExit;
    public static final boolean superShader;
    public static final boolean forceUploadingPainter;
    public static final boolean forceAlphaTestShader;
    public static final boolean forceNonAntialiasedShape;

    private PrismSettings() {
    }

    private static void printBooleanOption(boolean bl, String string2) {
        if (bl) {
            System.out.println(string2);
        } else {
            System.out.print("Not ");
            System.out.print(Character.toLowerCase(string2.charAt(0)));
            System.out.println(string2.substring(1));
        }
    }

    private static int parseInt(String string2, int n, int n2, String string3) {
        return "true".equalsIgnoreCase(string2) ? n2 : PrismSettings.parseInt(string2, n, string3);
    }

    private static int parseInt(String string2, int n, String string3) {
        block3: {
            if (string2 != null) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (Exception exception2) {
                    if (string3 == null) break block3;
                    System.err.println(string3);
                }
            }
        }
        return n;
    }

    private static long parseLong(String string2, long l, long l2, String string3) {
        block15: {
            if (string2 != null && string2.length() > 0) {
                long l3 = 1L;
                if (string2.endsWith("%")) {
                    if (l2 > 0L) {
                        try {
                            string2 = string2.substring(0, string2.length() - 1);
                            double d = Double.parseDouble(string2);
                            if (d >= 0.0 && d <= 100.0) {
                                return Math.round((double)l2 * d / 100.0);
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (string3 != null) {
                        System.err.println(string3);
                    }
                    return l;
                }
                if (string2.endsWith("k") || string2.endsWith("K")) {
                    l3 = 1024L;
                } else if (string2.endsWith("m") || string2.endsWith("M")) {
                    l3 = 0x100000L;
                } else if (string2.endsWith("g") || string2.endsWith("G")) {
                    l3 = 0x40000000L;
                }
                if (l3 > 1L) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                try {
                    return Long.parseLong(string2) * l3;
                }
                catch (Exception exception3) {
                    if (string3 == null) break block15;
                    System.err.println(string3);
                }
            }
        }
        return l;
    }

    private static String[] split(String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static boolean getBoolean(Properties properties2, String string2, boolean bl) {
        String string3 = properties2.getProperty(string2);
        return string3 != null ? Boolean.parseBoolean(string3) : bl;
    }

    private static boolean getBoolean(Properties properties2, String string2, boolean bl, boolean bl2) {
        String string3 = properties2.getProperty(string2);
        if (string3 != null && string3.length() == 0) {
            return bl2;
        }
        return string3 != null ? Boolean.parseBoolean(string3) : bl;
    }

    private static int getInt(Properties properties2, String string2, int n, int n2, String string3) {
        return PrismSettings.parseInt(properties2.getProperty(string2), n, n2, string3);
    }

    private static int getInt(Properties properties2, String string2, int n, String string3) {
        return PrismSettings.parseInt(properties2.getProperty(string2), n, string3);
    }

    private static long getLong(Properties properties2, String string2, long l, String string3) {
        return PrismSettings.parseLong(properties2.getProperty(string2), l, 0L, string3);
    }

    private static long getLong(Properties properties2, String string2, long l, long l2, String string3) {
        return PrismSettings.parseLong(properties2.getProperty(string2), l, l2, string3);
    }

    static {
        int n;
        Object object;
        Properties properties2 = (Properties)AccessController.doPrivileged(() -> System.getProperties());
        isVsyncEnabled = PrismSettings.getBoolean(properties2, "prism.vsync", true) && !PrismSettings.getBoolean(properties2, "javafx.animation.fullspeed", false);
        dirtyOptsEnabled = PrismSettings.getBoolean(properties2, "prism.dirtyopts", true);
        occlusionCullingEnabled = dirtyOptsEnabled && PrismSettings.getBoolean(properties2, "prism.occlusion.culling", true);
        dirtyRegionCount = Utils.clamp(0, PrismSettings.getInt(properties2, "prism.dirtyregioncount", 6, null), 15);
        scrollCacheOpt = PrismSettings.getBoolean(properties2, "prism.scrollcacheopt", false);
        threadCheck = PrismSettings.getBoolean(properties2, "prism.threadcheck", false);
        showDirtyRegions = PrismSettings.getBoolean(properties2, "prism.showdirty", false);
        showOverdraw = PrismSettings.getBoolean(properties2, "prism.showoverdraw", false);
        printRenderGraph = PrismSettings.getBoolean(properties2, "prism.printrendergraph", false);
        forceRepaint = PrismSettings.getBoolean(properties2, "prism.forcerepaint", false);
        noFallback = PrismSettings.getBoolean(properties2, "prism.noFallback", false);
        String string2 = properties2.getProperty("prism.cacheshapes", "complex");
        if ("all".equals(string2) || "true".equals(string2)) {
            cacheSimpleShapes = true;
            cacheComplexShapes = true;
        } else if ("complex".equals(string2)) {
            cacheSimpleShapes = false;
            cacheComplexShapes = true;
        } else {
            cacheSimpleShapes = false;
            cacheComplexShapes = false;
        }
        useNewImageLoader = PrismSettings.getBoolean(properties2, "prism.newiio", true);
        verbose = PrismSettings.getBoolean(properties2, "prism.verbose", false);
        prismStatFrequency = PrismSettings.getInt(properties2, "prism.printStats", 0, 1, "Try -Dprism.printStats=<true or number>");
        debug = PrismSettings.getBoolean(properties2, "prism.debug", false);
        trace = PrismSettings.getBoolean(properties2, "prism.trace", false);
        printAllocs = PrismSettings.getBoolean(properties2, "prism.printallocs", false);
        disableBadDriverWarning = PrismSettings.getBoolean(properties2, "prism.disableBadDriverWarning", false);
        forceGPU = PrismSettings.getBoolean(properties2, "prism.forceGPU", false);
        String string3 = properties2.getProperty("prism.order");
        String[] stringArray = string3 != null ? PrismSettings.split(string3, ",") : (PlatformUtil.isWindows() ? new String[]{"d3d", "sw"} : (PlatformUtil.isMac() ? new String[]{"es2", "sw"} : (PlatformUtil.isIOS() ? new String[]{"es2"} : (PlatformUtil.isAndroid() ? new String[]{"es2"} : (PlatformUtil.isLinux() ? new String[]{"es2", "sw"} : new String[]{"sw"})))));
        tryOrder = List.of(stringArray);
        RasterizerType rasterizerType = null;
        String string4 = properties2.getProperty("prism.rasterizerorder");
        if (string4 != null) {
            object = PrismSettings.split(string4.toLowerCase(), ",");
            n = ((String[])object).length;
            block9: for (int i = 0; i < n; ++i) {
                Object object2;
                switch (object2 = object[i]) {
                    case "marlin": 
                    case "doublemarlin": {
                        rasterizerType = RasterizerType.DoubleMarlin;
                        break block9;
                    }
                    case "floatmarlin": {
                        rasterizerType = RasterizerType.FloatMarlin;
                        break block9;
                    }
                }
            }
        }
        if (rasterizerType == null) {
            boolean bl = PrismSettings.getBoolean(properties2, "prism.marlin.double", true);
            rasterizerType = bl ? RasterizerType.DoubleMarlin : RasterizerType.FloatMarlin;
        }
        rasterizerSpec = rasterizerType;
        object = properties2.getProperty("prism.primtextures");
        primTextureSize = object == null ? (PlatformUtil.isEmbedded() ? -1 : 0) : (((String)object).equals("true") ? -1 : (((String)object).equals("false") ? 0 : PrismSettings.parseInt((String)object, 0, "Try -Dprism.primtextures=[true|false|<number>]")));
        refType = properties2.getProperty("prism.reftype");
        forcePow2 = PrismSettings.getBoolean(properties2, "prism.forcepowerof2", false);
        noClampToZero = PrismSettings.getBoolean(properties2, "prism.noclamptozero", false);
        allowHiDPIScaling = PrismSettings.getBoolean(properties2, "prism.allowhidpi", true);
        maxVram = PrismSettings.getLong(properties2, "prism.maxvram", 0x20000000L, "Try -Dprism.maxvram=<long>[kKmMgG]");
        targetVram = PrismSettings.getLong(properties2, "prism.targetvram", maxVram / 8L, maxVram, "Try -Dprism.targetvram=<long>[kKmMgG]|<double(0,100)>%");
        poolStats = PrismSettings.getBoolean(properties2, "prism.poolstats", false);
        poolDebug = PrismSettings.getBoolean(properties2, "prism.pooldebug", false);
        if (verbose) {
            System.out.print("Prism pipeline init order: ");
            for (String string5 : tryOrder) {
                System.out.print(string5 + " ");
            }
            System.out.println("");
            if (string4 != null) {
                System.out.println("Requested rasterizer preference order: " + string4);
            }
            System.out.println("Using " + rasterizerType);
            PrismSettings.printBooleanOption(dirtyOptsEnabled, "Using dirty region optimizations");
            if (primTextureSize == 0) {
                System.out.println("Not using texture mask for primitives");
            } else if (primTextureSize < 0) {
                System.out.println("Using system sized mask for primitives");
            } else {
                System.out.println("Using " + primTextureSize + " sized mask for primitives");
            }
            PrismSettings.printBooleanOption(forcePow2, "Forcing power of 2 sizes for textures");
            PrismSettings.printBooleanOption(!noClampToZero, "Using hardware CLAMP_TO_ZERO mode");
            PrismSettings.printBooleanOption(allowHiDPIScaling, "Opting in for HiDPI pixel scaling");
        }
        if ((n = PrismSettings.getInt(properties2, "prism.maxTextureSize", 4096, "Try -Dprism.maxTextureSize=<number>")) <= 0) {
            n = Integer.MAX_VALUE;
        }
        maxTextureSize = n;
        minRTTSize = PrismSettings.getInt(properties2, "prism.minrttsize", PlatformUtil.isEmbedded() ? 16 : 0, "Try -Dprism.minrttsize=<number>");
        disableRegionCaching = PrismSettings.getBoolean(properties2, "prism.disableRegionCaching", false);
        disableD3D9Ex = PrismSettings.getBoolean(properties2, "prism.disableD3D9Ex", false);
        disableEffects = PrismSettings.getBoolean(properties2, "prism.disableEffects", false);
        glyphCacheWidth = PrismSettings.getInt(properties2, "prism.glyphCacheWidth", 1024, "Try -Dprism.glyphCacheWidth=<number>");
        glyphCacheHeight = PrismSettings.getInt(properties2, "prism.glyphCacheHeight", 1024, "Try -Dprism.glyphCacheHeight=<number>");
        perfLog = properties2.getProperty("sun.perflog");
        perfLogExitFlush = PrismSettings.getBoolean(properties2, "sun.perflog.fx.exitflush", false, true);
        perfLogFirstPaintFlush = PrismSettings.getBoolean(properties2, "sun.perflog.fx.firstpaintflush", false, true);
        perfLogFirstPaintExit = PrismSettings.getBoolean(properties2, "sun.perflog.fx.firstpaintexit", false, true);
        superShader = PrismSettings.getBoolean(properties2, "prism.supershader", true);
        forceUploadingPainter = PrismSettings.getBoolean(properties2, "prism.forceUploadingPainter", false);
        forceAlphaTestShader = PrismSettings.getBoolean(properties2, "prism.forceAlphaTestShader", false);
        forceNonAntialiasedShape = PrismSettings.getBoolean(properties2, "prism.forceNonAntialiasedShape", false);
    }

    public static enum RasterizerType {
        FloatMarlin("Float Precision Marlin Rasterizer"),
        DoubleMarlin("Double Precision Marlin Rasterizer");

        private String publicName;

        private RasterizerType(String string3) {
            this.publicName = string3;
        }

        public String toString() {
            return this.publicName;
        }
    }
}

