/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.marlin.MarlinConst;
import java.lang.ref.Cleaner;

public final class MarlinUtils {
    private static final PlatformLogger LOG = MarlinConst.USE_LOGGER ? PlatformLogger.getLogger("prism.marlin") : null;
    private static final Cleaner cleaner = Cleaner.create();

    private MarlinUtils() {
    }

    public static void logInfo(String string2) {
        if (MarlinConst.USE_LOGGER) {
            LOG.info(string2);
        } else if (MarlinConst.ENABLE_LOGS) {
            System.out.print("INFO: ");
            System.out.println(string2);
        }
    }

    public static void logException(String string2, Throwable throwable) {
        if (MarlinConst.USE_LOGGER) {
            LOG.warning(string2, throwable);
        } else if (MarlinConst.ENABLE_LOGS) {
            System.out.print("WARNING: ");
            System.out.println(string2);
            throwable.printStackTrace(System.err);
        }
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        return threadGroup;
    }

    static Cleaner getCleaner() {
        return cleaner;
    }
}

