/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.glass.ui.Screen;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.FXPermissions;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.AndroidFontFinder;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.DFontDecoder;
import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontFileWriter;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.LogicalFont;
import com.sun.javafx.font.MacFontFinder;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismCompositeFontResource;
import com.sun.javafx.font.PrismFont;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.WindowsFontMap;
import com.sun.javafx.text.GlyphLayout;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public abstract class PrismFontFactory
implements FontFactory {
    public static final boolean debugFonts;
    public static final boolean isWindows;
    public static final boolean isLinux;
    public static final boolean isMacOSX;
    public static final boolean isIOS;
    public static final boolean isAndroid;
    public static final boolean isEmbedded;
    public static final int cacheLayoutSize;
    private static int subPixelMode;
    public static final int SUB_PIXEL_ON = 1;
    public static final int SUB_PIXEL_Y = 2;
    public static final int SUB_PIXEL_NATIVE = 4;
    private static float fontSizeLimit;
    private static boolean lcdEnabled;
    private static float lcdContrast;
    private static String jreFontDir;
    private static final String jreDefaultFont = "Lucida Sans Regular";
    private static final String jreDefaultFontLC = "lucida sans regular";
    private static final String jreDefaultFontFile = "LucidaSansRegular.ttf";
    private static final String CT_FACTORY = "com.sun.javafx.font.coretext.CTFactory";
    private static final String DW_FACTORY = "com.sun.javafx.font.directwrite.DWFactory";
    private static final String FT_FACTORY = "com.sun.javafx.font.freetype.FTFactory";
    HashMap<String, FontResource> fontResourceMap = new HashMap();
    HashMap<String, CompositeFontResource> compResourceMap = new HashMap();
    private static PrismFontFactory theFontFactory;
    private HashMap<String, PrismFontFile> fileNameToFontResourceMap = new HashMap();
    private ArrayList<WeakReference<PrismFontFile>> tmpFonts;
    private static final String[] STR_ARRAY;
    private volatile HashMap<String, String> fontToFileMap = null;
    private HashMap<String, String> fileToFontMap = null;
    private HashMap<String, String> fontToFamilyNameMap = null;
    private HashMap<String, ArrayList<String>> familyToFontListMap = null;
    private static String sysFontDir;
    private static String userFontDir;
    private static ArrayList<String> allFamilyNames;
    private static ArrayList<String> allFontNames;
    private static Thread fileCloser;
    private HashMap<String, PrismFontFile> embeddedFonts;
    private int numEmbeddedFonts = 0;
    private static float systemFontSize;
    private static String systemFontFamily;
    private static String monospaceFontFamily;

    private static String getJDKFontDir() {
        return System.getProperty("java.home", "") + File.separator + "lib" + File.separator + "fonts";
    }

    private static String getNativeFactoryName() {
        if (isWindows) {
            return DW_FACTORY;
        }
        if (isMacOSX || isIOS) {
            return CT_FACTORY;
        }
        if (isLinux || isAndroid) {
            return FT_FACTORY;
        }
        return null;
    }

    public static float getFontSizeLimit() {
        return fontSizeLimit;
    }

    public static synchronized PrismFontFactory getFontFactory() {
        if (theFontFactory != null) {
            return theFontFactory;
        }
        String string2 = PrismFontFactory.getNativeFactoryName();
        if (string2 == null) {
            throw new InternalError("cannot find a native font factory");
        }
        if (debugFonts) {
            System.err.println("Loading FontFactory " + string2);
            if (subPixelMode != 0) {
                Object object = "Subpixel: enabled";
                if ((subPixelMode & 2) != 0) {
                    object = (String)object + ", vertical";
                }
                if ((subPixelMode & 4) != 0) {
                    object = (String)object + ", native";
                }
                System.err.println((String)object);
            }
        }
        if ((theFontFactory = PrismFontFactory.getFontFactory(string2)) == null) {
            throw new InternalError("cannot load font factory: " + string2);
        }
        return theFontFactory;
    }

    private static synchronized PrismFontFactory getFontFactory(String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getMethod("getFactory", null);
            return (PrismFontFactory)method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            if (debugFonts) {
                System.err.println("Loading font factory failed " + string2);
            }
            return null;
        }
    }

    protected abstract PrismFontFile createFontFile(String var1, String var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7) throws Exception;

    public abstract GlyphLayout createGlyphLayout();

    private PrismFontFile createFontResource(String string2, int n) {
        return this.createFontResource(null, string2, n, true, false, false, false);
    }

    private PrismFontFile createFontResource(String string2, String string3, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string4 = (string3 + n).toLowerCase();
        PrismFontFile prismFontFile = this.fileNameToFontResourceMap.get(string4);
        if (prismFontFile != null) {
            return prismFontFile;
        }
        try {
            prismFontFile = this.createFontFile(string2, string3, n, bl, bl2, bl3, bl4);
            if (bl) {
                this.storeInMap(prismFontFile.getFullName(), prismFontFile);
                this.fileNameToFontResourceMap.put(string4, prismFontFile);
            }
            return prismFontFile;
        }
        catch (Exception exception2) {
            if (debugFonts) {
                exception2.printStackTrace();
            }
            return null;
        }
    }

    private PrismFontFile createFontResource(String string2, String string3) {
        PrismFontFile[] prismFontFileArray = this.createFontResources(string2, string3, true, false, false, false, false);
        if (prismFontFileArray == null || prismFontFileArray.length == 0) {
            return null;
        }
        return prismFontFileArray[0];
    }

    private PrismFontFile[] createFontResources(String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        PrismFontFile[] prismFontFileArray = null;
        if (string3 == null) {
            return null;
        }
        PrismFontFile prismFontFile = this.createFontResource(string2, string3, 0, bl, bl2, bl3, bl4);
        if (prismFontFile == null) {
            return null;
        }
        int n = !bl5 ? 1 : prismFontFile.getFontCount();
        prismFontFileArray = new PrismFontFile[n];
        prismFontFileArray[0] = prismFontFile;
        if (n == 1) {
            return prismFontFileArray;
        }
        PrismFontFile.FileRefCounter fileRefCounter = null;
        if (bl3) {
            fileRefCounter = prismFontFile.createFileRefCounter();
        }
        int n2 = 1;
        do {
            String string4 = (string3 + n2).toLowerCase();
            try {
                prismFontFile = this.fileNameToFontResourceMap.get(string4);
                if (prismFontFile != null) {
                    prismFontFileArray[n2] = prismFontFile;
                    continue;
                }
                prismFontFile = this.createFontFile(null, string3, n2, bl, bl2, bl3, bl4);
                if (prismFontFile == null) {
                    return null;
                }
                if (fileRefCounter != null) {
                    prismFontFile.setAndIncFileRefCounter(fileRefCounter);
                }
                prismFontFileArray[n2] = prismFontFile;
                String string5 = prismFontFile.getFullName();
                if (!bl) continue;
                this.storeInMap(string5, prismFontFile);
                this.fileNameToFontResourceMap.put(string4, prismFontFile);
            }
            catch (Exception exception2) {
                if (debugFonts) {
                    exception2.printStackTrace();
                }
                return null;
            }
        } while (++n2 < n);
        return prismFontFileArray;
    }

    private String dotStyleStr(boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2) {
                return "";
            }
            return ".italic";
        }
        if (!bl2) {
            return ".bold";
        }
        return ".bolditalic";
    }

    private void storeInMap(String string2, FontResource fontResource) {
        if (string2 == null || fontResource == null) {
            return;
        }
        if (fontResource instanceof PrismCompositeFontResource) {
            System.err.println(string2 + " is a composite " + fontResource);
            Thread.dumpStack();
            return;
        }
        this.fontResourceMap.put(string2.toLowerCase(), fontResource);
    }

    synchronized void addDecodedFont(PrismFontFile prismFontFile) {
        prismFontFile.setIsDecoded(true);
        this.addTmpFont(prismFontFile);
    }

    private synchronized void addTmpFont(PrismFontFile prismFontFile) {
        if (this.tmpFonts == null) {
            this.tmpFonts = new ArrayList();
        }
        WeakReference<PrismFontFile> weakReference = prismFontFile.isRegistered() ? new WeakReference<PrismFontFile>(prismFontFile) : prismFontFile.createFileDisposer(this, prismFontFile.getFileRefCounter());
        this.tmpFonts.add(weakReference);
        this.addFileCloserHook();
    }

    synchronized void removeTmpFont(WeakReference<PrismFontFile> weakReference) {
        if (this.tmpFonts != null) {
            this.tmpFonts.remove(weakReference);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized FontResource getFontResource(String string2, boolean bl, boolean bl2, boolean bl3) {
        void var9_14;
        int n;
        String string3;
        Object object;
        String string32;
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        String string4 = string2.toLowerCase();
        Object object3 = this.lookupResource(string4 + (string32 = this.dotStyleStr(bl, bl2)), bl3);
        if (object3 != null) {
            return object3;
        }
        if (this.embeddedFonts != null && bl3) {
            object3 = this.lookupResource(string4 + string32, false);
            if (object3 != null) {
                return new PrismCompositeFontResource((FontResource)object3, string4 + string32);
            }
            for (PrismFontFile object22 : this.embeddedFonts.values()) {
                object = object22.getFamilyName().toLowerCase();
                if (!((String)object).equals(string4)) continue;
                return new PrismCompositeFontResource(object22, string4 + string32);
            }
        }
        if (isWindows && (string3 = WindowsFontMap.findFontFile(string4, n = (bl ? 1 : 0) + (bl2 ? 2 : 0))) != null && (object3 = this.createFontResource(null, string3)) != null) {
            if (bl == object3.isBold() && bl2 == object3.isItalic() && !string32.isEmpty()) {
                this.storeInMap(string4 + string32, (FontResource)object3);
            }
            if (bl3) {
                object3 = new PrismCompositeFontResource((FontResource)object3, string4 + string32);
            }
            return object3;
        }
        this.getFullNameToFileMap();
        ArrayList<String> arrayList = this.familyToFontListMap.get(string4);
        if (arrayList == null) {
            return null;
        }
        Object var9_13 = null;
        object = null;
        Object object2 = null;
        Object object4 = null;
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            String string5 = (String)iterator2.next();
            String string6 = string5.toLowerCase();
            object3 = this.fontResourceMap.get(string6);
            if (object3 == null) {
                String string7 = this.findFile(string6);
                if (string7 != null) {
                    object3 = this.getFontResource(string5, string7);
                }
                if (object3 == null) continue;
                this.storeInMap(string6, (FontResource)object3);
            }
            if (bl == object3.isBold() && bl2 == object3.isItalic()) {
                this.storeInMap(string4 + string32, (FontResource)object3);
                if (bl3) {
                    object3 = new PrismCompositeFontResource((FontResource)object3, string4 + string32);
                }
                return object3;
            }
            if (!object3.isBold()) {
                if (!object3.isItalic()) {
                    Object object5 = object3;
                    continue;
                }
                object2 = object3;
                continue;
            }
            if (!object3.isItalic()) {
                object = object3;
                continue;
            }
            object4 = object3;
        }
        object3 = !bl && !bl2 ? (object != null ? object : (object2 != null ? object2 : object4)) : (bl && !bl2 ? (var9_14 != null ? var9_14 : (object4 != null ? object4 : object2)) : (!bl && bl2 ? (object4 != null ? object4 : (var9_14 != null ? var9_14 : object)) : (object2 != null ? object2 : (object != null ? object : var9_14))));
        if (object3 != null) {
            this.storeInMap(string4 + string32, (FontResource)object3);
            if (bl3) {
                object3 = new PrismCompositeFontResource((FontResource)object3, string4 + string32);
            }
        }
        return object3;
    }

    @Override
    public synchronized PGFont createFont(String string2, boolean bl, boolean bl2, float f) {
        FontResource fontResource = null;
        if (string2 != null && !string2.isEmpty()) {
            PGFont pGFont = LogicalFont.getLogicalFont(string2, bl, bl2, f);
            if (pGFont != null) {
                return pGFont;
            }
            fontResource = this.getFontResource(string2, bl, bl2, true);
        }
        if (fontResource == null) {
            return LogicalFont.getLogicalFont("System", bl, bl2, f);
        }
        return new PrismFont(fontResource, fontResource.getFullName(), f);
    }

    @Override
    public synchronized PGFont createFont(String string2, float f) {
        FontResource fontResource = null;
        if (string2 != null && !string2.isEmpty()) {
            PGFont pGFont = LogicalFont.getLogicalFont(string2, f);
            if (pGFont != null) {
                return pGFont;
            }
            fontResource = this.getFontResource(string2, null, true);
        }
        if (fontResource == null) {
            return LogicalFont.getLogicalFont("System Regular", f);
        }
        return new PrismFont(fontResource, fontResource.getFullName(), f);
    }

    private PrismFontFile getFontResource(String string2, String string3) {
        PrismFontFile prismFontFile = null;
        if (isMacOSX) {
            DFontDecoder dFontDecoder;
            block9: {
                dFontDecoder = null;
                if (string2 != null && string3.endsWith(".dfont")) {
                    dFontDecoder = new DFontDecoder();
                    try {
                        dFontDecoder.openFile();
                        dFontDecoder.decode(string2);
                        dFontDecoder.closeFile();
                        string3 = dFontDecoder.getFile().getPath();
                    }
                    catch (Exception exception2) {
                        string3 = null;
                        dFontDecoder.deleteFile();
                        dFontDecoder = null;
                        if (!debugFonts) break block9;
                        exception2.printStackTrace();
                    }
                }
            }
            if (string3 != null) {
                prismFontFile = this.createFontResource(string2, string3);
            }
            if (dFontDecoder != null) {
                if (prismFontFile != null) {
                    this.addDecodedFont(prismFontFile);
                } else {
                    dFontDecoder.deleteFile();
                }
            }
        } else {
            prismFontFile = this.createFontResource(string2, string3);
        }
        return prismFontFile;
    }

    @Override
    public synchronized PGFont deriveFont(PGFont pGFont, boolean bl, boolean bl2, float f) {
        FontResource fontResource = pGFont.getFontResource();
        return new PrismFont(fontResource, fontResource.getFullName(), f);
    }

    private FontResource lookupResource(String string2, boolean bl) {
        if (bl) {
            return this.compResourceMap.get(string2);
        }
        return this.fontResourceMap.get(string2);
    }

    public synchronized FontResource getFontResource(String string2, String string3, boolean bl) {
        Object object;
        String string4;
        FontResource fontResource = null;
        if (string2 != null) {
            string4 = string2.toLowerCase();
            object = this.lookupResource(string4, bl);
            if (object != null) {
                return object;
            }
            if (this.embeddedFonts != null && bl) {
                fontResource = this.lookupResource(string4, false);
                if (fontResource != null) {
                    fontResource = new PrismCompositeFontResource(fontResource, string4);
                }
                if (fontResource != null) {
                    return fontResource;
                }
            }
        }
        if (isWindows && string2 != null && (object = WindowsFontMap.findFontFile(string4 = string2.toLowerCase(), -1)) != null && (fontResource = this.createFontResource(null, (String)object)) != null) {
            if (bl) {
                fontResource = new PrismCompositeFontResource(fontResource, string4);
            }
            return fontResource;
        }
        this.getFullNameToFileMap();
        if (string2 != null && string3 != null && (fontResource = this.getFontResource(string2, string3)) != null) {
            if (bl) {
                fontResource = new PrismCompositeFontResource(fontResource, string2.toLowerCase());
            }
            return fontResource;
        }
        if (string2 != null && (fontResource = this.getFontResourceByFullName(string2, bl)) != null) {
            return fontResource;
        }
        if (string3 != null && (fontResource = this.getFontResourceByFileName(string3, bl)) != null) {
            return fontResource;
        }
        return null;
    }

    boolean isInstalledFont(String string2) {
        String string3;
        if (isWindows) {
            if (string2.toLowerCase().contains("\\windows\\fonts")) {
                return true;
            }
            File file = new File(string2);
            string3 = file.getName();
        } else {
            if (isMacOSX && string2.toLowerCase().contains("/library/fonts")) {
                return true;
            }
            File file = new File(string2);
            string3 = file.getPath();
        }
        this.getFullNameToFileMap();
        return this.fileToFontMap.get(string3.toLowerCase()) != null;
    }

    private synchronized FontResource getFontResourceByFileName(String string2, boolean bl) {
        if (this.fontToFileMap.size() <= 1) {
            return null;
        }
        String string3 = this.fileToFontMap.get(string2.toLowerCase());
        FontResource fontResource = null;
        if (string3 == null) {
            fontResource = this.createFontResource(string2, 0);
            if (fontResource != null) {
                String string4 = fontResource.getFullName().toLowerCase();
                this.storeInMap(string4, fontResource);
                if (bl) {
                    fontResource = new PrismCompositeFontResource(fontResource, string4);
                }
            }
        } else {
            String string5;
            String string6 = string3.toLowerCase();
            fontResource = this.lookupResource(string6, bl);
            if (fontResource == null && (string5 = this.findFile(string6)) != null) {
                fontResource = this.getFontResource(string3, string5);
                if (fontResource != null) {
                    this.storeInMap(string6, fontResource);
                }
                if (bl) {
                    fontResource = new PrismCompositeFontResource(fontResource, string6);
                }
            }
        }
        return fontResource;
    }

    private synchronized FontResource getFontResourceByFullName(String string2, boolean bl) {
        String string3 = string2.toLowerCase();
        if (this.fontToFileMap.size() <= 1) {
            string2 = jreDefaultFont;
        }
        FontResource fontResource = null;
        String string4 = this.findFile(string3);
        if (string4 != null && (fontResource = this.getFontResource(string2, string4)) != null) {
            this.storeInMap(string3, fontResource);
            if (bl) {
                fontResource = new PrismCompositeFontResource(fontResource, string3);
            }
        }
        return fontResource;
    }

    FontResource getDefaultFontResource(boolean bl) {
        FontResource fontResource = this.lookupResource(jreDefaultFontLC, bl);
        if (fontResource == null) {
            fontResource = this.createFontResource(jreDefaultFont, jreFontDir + jreDefaultFontFile);
            if (fontResource == null) {
                String string2;
                String string3;
                Object object = this.fontToFileMap.keySet().iterator();
                while (object.hasNext() && (fontResource = this.createFontResource(jreDefaultFontLC, string3 = this.findFile(string2 = object.next()))) == null) {
                }
                if (fontResource == null && isLinux && (object = FontConfigManager.getDefaultFontPath()) != null) {
                    fontResource = this.createFontResource(jreDefaultFontLC, (String)object);
                }
                if (fontResource == null) {
                    return null;
                }
            }
            this.storeInMap(jreDefaultFontLC, fontResource);
            if (bl) {
                fontResource = new PrismCompositeFontResource(fontResource, jreDefaultFontLC);
            }
        }
        return fontResource;
    }

    private String findFile(String string2) {
        if (string2.equals(jreDefaultFontLC)) {
            return jreFontDir + jreDefaultFontFile;
        }
        this.getFullNameToFileMap();
        String string3 = this.fontToFileMap.get(string2);
        if (isWindows) {
            string3 = PrismFontFactory.getPathNameWindows(string3);
        }
        return string3;
    }

    private static native byte[] getFontPath();

    private static native String regReadFontLink(String var0);

    private static native String getEUDCFontFile();

    private static void getPlatformFontDirs() {
        if (userFontDir != null || sysFontDir != null) {
            return;
        }
        byte[] byArray = PrismFontFactory.getFontPath();
        String string2 = new String(byArray);
        int n = string2.indexOf(59);
        if (n < 0) {
            sysFontDir = string2;
        } else {
            sysFontDir = string2.substring(0, n);
            userFontDir = string2.substring(n + 1, string2.length());
        }
    }

    static ArrayList<String>[] getLinkedFonts(String string2, boolean bl) {
        String[] stringArray;
        String string3;
        ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
        if (isMacOSX) {
            arrayListArray[0].add("/Library/Fonts/Arial Unicode.ttf");
            arrayListArray[1].add("Arial Unicode MS");
            arrayListArray[0].add(jreFontDir + jreDefaultFontFile);
            arrayListArray[1].add(jreDefaultFont);
            arrayListArray[0].add("/System/Library/Fonts/Apple Symbols.ttf");
            arrayListArray[1].add("Apple Symbols");
            arrayListArray[0].add("/System/Library/Fonts/Apple Color Emoji.ttc");
            arrayListArray[1].add("Apple Color Emoji");
            arrayListArray[0].add("/System/Library/Fonts/STHeiti Light.ttf");
            arrayListArray[1].add("Heiti SC Light");
            return arrayListArray;
        }
        if (!isWindows) {
            return arrayListArray;
        }
        if (bl) {
            arrayListArray[0].add(null);
            arrayListArray[1].add(string2);
        }
        if ((string3 = PrismFontFactory.regReadFontLink(string2)) != null && string3.length() > 0) {
            stringArray = string3.split("\u0000");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string4;
                String[] stringArray2 = stringArray[i].split(",");
                int n2 = stringArray2.length;
                String string5 = PrismFontFactory.getPathNameWindows(stringArray2[0]);
                String string6 = string4 = n2 > 1 ? stringArray2[1] : null;
                if (string4 != null && arrayListArray[1].contains(string4) || string4 == null && arrayListArray[0].contains(string5)) continue;
                arrayListArray[0].add(string5);
                arrayListArray[1].add(string4);
            }
        }
        if ((stringArray = PrismFontFactory.getEUDCFontFile()) != null) {
            arrayListArray[0].add(stringArray);
            arrayListArray[1].add(null);
        }
        arrayListArray[0].add(jreFontDir + jreDefaultFontFile);
        arrayListArray[1].add(jreDefaultFont);
        if (PlatformUtil.isWinVistaOrLater()) {
            arrayListArray[0].add(PrismFontFactory.getPathNameWindows("mingliub.ttc"));
            arrayListArray[1].add("MingLiU-ExtB");
            if (PlatformUtil.isWin7OrLater()) {
                arrayListArray[0].add(PrismFontFactory.getPathNameWindows("seguisym.ttf"));
                arrayListArray[1].add("Segoe UI Symbol");
            } else {
                arrayListArray[0].add(PrismFontFactory.getPathNameWindows("cambria.ttc"));
                arrayListArray[1].add("Cambria Math");
            }
        }
        return arrayListArray;
    }

    private void resolveWindowsFonts(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        String string2;
        ArrayList<String> arrayList = null;
        for (String object : hashMap2.keySet()) {
            Object n = hashMap.get(object);
            if (n != null) continue;
            int string3 = object.indexOf("  ");
            if (string3 > 0) {
                string2 = object.substring(0, string3);
                n = hashMap.get(string2 = string2.concat(object.substring(string3 + 1)));
                if (n == null || hashMap2.containsKey(string2)) continue;
                hashMap.remove(string2);
                hashMap.put(object, (String)n);
                continue;
            }
            if (object.equals("marlett")) {
                hashMap.put(object, "marlett.ttf");
                continue;
            }
            if (object.equals("david")) {
                n = hashMap.get("david regular");
                if (n == null) continue;
                hashMap.remove("david regular");
                hashMap.put("david", (String)n);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(object);
        }
        if (arrayList != null) {
            HashSet hashSet = new HashSet();
            HashMap<String, String> hashMap4 = new HashMap<String, String>();
            hashMap4.putAll(hashMap);
            for (String string4 : hashMap2.keySet()) {
                hashMap4.remove(string4);
            }
            for (String i : hashMap4.keySet()) {
                hashSet.add((String)hashMap4.get(i));
                hashMap.remove(i);
            }
            this.resolveFontFiles(hashSet, arrayList, hashMap, hashMap2, hashMap3);
            if (arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ArrayList<String> arrayList2;
                    string2 = arrayList.get(i);
                    String string3 = hashMap2.get(string2);
                    if (string3 != null && (arrayList2 = hashMap3.get(string3)) != null && arrayList2.size() <= 1) {
                        hashMap3.remove(string3);
                    }
                    hashMap2.remove(string2);
                }
            }
        }
    }

    private void resolveFontFiles(HashSet<String> hashSet, ArrayList<String> arrayList, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        for (String string2 : hashSet) {
            try {
                PrismFontFile prismFontFile;
                int n = 0;
                String string3 = PrismFontFactory.getPathNameWindows(string2);
                while ((prismFontFile = this.createFontResource(string3, n++)) != null) {
                    String string4 = prismFontFile.getFullName().toLowerCase();
                    String string5 = prismFontFile.getLocaleFullName().toLowerCase();
                    if (arrayList.contains(string4) || arrayList.contains(string5)) {
                        hashMap.put(string4, string2);
                        arrayList.remove(string4);
                        if (arrayList.contains(string5)) {
                            arrayList.remove(string5);
                            String string6 = prismFontFile.getFamilyName();
                            String string7 = string6.toLowerCase();
                            hashMap2.remove(string5);
                            hashMap2.put(string4, string6);
                            ArrayList<String> arrayList2 = hashMap3.get(string7);
                            if (arrayList2 != null) {
                                arrayList2.remove(prismFontFile.getLocaleFullName());
                            } else {
                                String string8 = prismFontFile.getLocaleFamilyName().toLowerCase();
                                arrayList2 = hashMap3.get(string8);
                                if (arrayList2 != null) {
                                    hashMap3.remove(string8);
                                }
                                arrayList2 = new ArrayList();
                                hashMap3.put(string7, arrayList2);
                            }
                            arrayList2.add(prismFontFile.getFullName());
                        }
                    }
                    if (n < prismFontFile.getFontCount()) continue;
                }
            }
            catch (Exception exception2) {
                if (!debugFonts) continue;
                exception2.printStackTrace();
            }
        }
    }

    static native void populateFontFileNameMap(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    static String getPathNameWindows(final String string2) {
        if (string2 == null) {
            return null;
        }
        PrismFontFactory.getPlatformFontDirs();
        File file = new File(string2);
        if (file.isAbsolute()) {
            return string2;
        }
        if (userFontDir == null) {
            return sysFontDir + "\\" + string2;
        }
        String string3 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                File file = new File(sysFontDir + "\\" + string2);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                return userFontDir + "\\" + string2;
            }
        });
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    @Override
    public String[] getFontFamilyNames() {
        if (allFamilyNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LogicalFont.addFamilies(arrayList);
            if (this.embeddedFonts != null) {
                for (PrismFontFile object : this.embeddedFonts.values()) {
                    if (arrayList.contains(object.getFamilyName())) continue;
                    arrayList.add(object.getFamilyName());
                }
            }
            this.getFullNameToFileMap();
            for (String string2 : this.fontToFamilyNameMap.values()) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            Collections.sort(arrayList);
            allFamilyNames = new ArrayList<String>(arrayList);
        }
        return allFamilyNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames() {
        if (allFontNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LogicalFont.addFullNames(arrayList);
            if (this.embeddedFonts != null) {
                for (PrismFontFile object : this.embeddedFonts.values()) {
                    if (arrayList.contains(object.getFullName())) continue;
                    arrayList.add(object.getFullName());
                }
            }
            this.getFullNameToFileMap();
            for (ArrayList arrayList2 : this.familyToFontListMap.values()) {
                for (String string2 : arrayList2) {
                    arrayList.add(string2);
                }
            }
            Collections.sort(arrayList);
            allFontNames = arrayList;
        }
        return allFontNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames(String string2) {
        ArrayList<String> arrayList;
        String[] stringArray = LogicalFont.getFontsInFamily(string2);
        if (stringArray != null) {
            return stringArray;
        }
        if (this.embeddedFonts != null) {
            arrayList = null;
            for (PrismFontFile prismFontFile : this.embeddedFonts.values()) {
                if (!prismFontFile.getFamilyName().equalsIgnoreCase(string2)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(prismFontFile.getFullName());
            }
            if (arrayList != null) {
                return arrayList.toArray(STR_ARRAY);
            }
        }
        this.getFullNameToFileMap();
        string2 = string2.toLowerCase();
        arrayList = this.familyToFontListMap.get(string2);
        if (arrayList != null) {
            return arrayList.toArray(STR_ARRAY);
        }
        return STR_ARRAY;
    }

    public final int getSubPixelMode() {
        return subPixelMode;
    }

    public boolean isLCDTextSupported() {
        return lcdEnabled;
    }

    @Override
    public boolean isPlatformFont(String string2) {
        if (string2 == null) {
            return false;
        }
        String string3 = string2.toLowerCase();
        if (LogicalFont.isLogicalFont(string3)) {
            return true;
        }
        if (string3.startsWith("lucida sans")) {
            return true;
        }
        String string4 = PrismFontFactory.getSystemFont("System").toLowerCase();
        return string3.startsWith(string4);
    }

    public static boolean isJreFont(FontResource fontResource) {
        String string2 = fontResource.getFileName();
        return string2.startsWith(jreFontDir);
    }

    public static float getLCDContrast() {
        if (lcdContrast == -1.0f) {
            lcdContrast = isWindows ? (float)PrismFontFactory.getLCDContrastWin32() / 1000.0f : 1.3f;
        }
        return lcdContrast;
    }

    private synchronized void addFileCloserHook() {
        if (fileCloser == null) {
            Runnable runnable = () -> {
                if (this.embeddedFonts != null) {
                    for (PrismFontFile object : this.embeddedFonts.values()) {
                        object.disposeOnShutdown();
                    }
                }
                if (this.tmpFonts != null) {
                    for (WeakReference weakReference : this.tmpFonts) {
                        PrismFontFile prismFontFile = (PrismFontFile)weakReference.get();
                        if (prismFontFile == null) continue;
                        prismFontFile.disposeOnShutdown();
                    }
                }
            };
            AccessController.doPrivileged(() -> {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                fileCloser = new Thread(threadGroup, runnable);
                fileCloser.setContextClassLoader(null);
                Runtime.getRuntime().addShutdownHook(fileCloser);
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PGFont[] loadEmbeddedFont(String string2, InputStream inputStream, float f, boolean bl, boolean bl2) {
        if (!this.hasPermission()) {
            return new PGFont[]{this.createFont("System Regular", f)};
        }
        if (FontFileWriter.hasTempPermission()) {
            return this.loadEmbeddedFont0(string2, inputStream, f, bl, bl2);
        }
        FontFileWriter.FontTracker fontTracker = FontFileWriter.FontTracker.getTracker();
        boolean bl3 = false;
        try {
            bl3 = fontTracker.acquirePermit();
            if (!bl3) {
                PGFont[] pGFontArray = null;
                return pGFontArray;
            }
            PGFont[] pGFontArray = this.loadEmbeddedFont0(string2, inputStream, f, bl, bl2);
            return pGFontArray;
        }
        catch (InterruptedException interruptedException) {
            PGFont[] pGFontArray = null;
            return pGFontArray;
        }
        finally {
            if (bl3) {
                fontTracker.releasePermit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGFont[] loadEmbeddedFont0(String string2, InputStream inputStream, float f, boolean bl, boolean bl2) {
        int n;
        Object[] objectArray;
        PrismFontFile[] prismFontFileArray = null;
        FontFileWriter fontFileWriter = new FontFileWriter();
        try {
            File file = fontFileWriter.openFile();
            objectArray = new byte[8192];
            while ((n = inputStream.read((byte[])objectArray)) >= 0) {
                fontFileWriter.writeBytes((byte[])objectArray, 0, n);
            }
            fontFileWriter.closeFile();
            prismFontFileArray = this.loadEmbeddedFont1(string2, file.getPath(), bl, true, fontFileWriter.isTracking(), bl2);
            if (prismFontFileArray != null && prismFontFileArray.length > 0 && prismFontFileArray[0].isDecoded()) {
                fontFileWriter.deleteFile();
            }
            this.addFileCloserHook();
        }
        catch (Exception exception2) {
            fontFileWriter.deleteFile();
        }
        finally {
            if (prismFontFileArray == null) {
                fontFileWriter.deleteFile();
            }
        }
        if (prismFontFileArray != null && prismFontFileArray.length > 0) {
            if (f <= 0.0f) {
                f = PrismFontFactory.getSystemFontSize();
            }
            int n2 = prismFontFileArray.length;
            objectArray = new PrismFont[n2];
            for (n = 0; n < n2; ++n) {
                objectArray[n] = (byte)new PrismFont(prismFontFileArray[n], prismFontFileArray[n].getFullName(), f);
            }
            return objectArray;
        }
        return null;
    }

    @Override
    public PGFont[] loadEmbeddedFont(String string2, String string3, float f, boolean bl, boolean bl2) {
        if (!this.hasPermission()) {
            return new PGFont[]{this.createFont("System Regular", f)};
        }
        this.addFileCloserHook();
        PrismFontFile[] prismFontFileArray = this.loadEmbeddedFont1(string2, string3, bl, false, false, bl2);
        if (prismFontFileArray != null && prismFontFileArray.length > 0) {
            if (f <= 0.0f) {
                f = PrismFontFactory.getSystemFontSize();
            }
            int n = prismFontFileArray.length;
            PGFont[] pGFontArray = new PGFont[n];
            for (int i = 0; i < n; ++i) {
                pGFontArray[i] = new PrismFont(prismFontFileArray[i], prismFontFileArray[i].getFullName(), f);
            }
            return pGFontArray;
        }
        return null;
    }

    private void removeEmbeddedFont(String string2) {
        PrismFontFile prismFontFile = this.embeddedFonts.get(string2);
        if (prismFontFile == null) {
            return;
        }
        this.embeddedFonts.remove(string2);
        String string3 = string2.toLowerCase();
        this.fontResourceMap.remove(string3);
        this.compResourceMap.remove(string3);
        Iterator<CompositeFontResource> iterator2 = this.compResourceMap.values().iterator();
        while (iterator2.hasNext()) {
            CompositeFontResource compositeFontResource = iterator2.next();
            if (compositeFontResource.getSlotResource(0) != prismFontFile) continue;
            iterator2.remove();
        }
    }

    protected boolean registerEmbeddedFont(String string2) {
        return true;
    }

    public int test_getNumEmbeddedFonts() {
        return this.numEmbeddedFonts;
    }

    private synchronized PrismFontFile[] loadEmbeddedFont1(String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string4;
        Object object;
        PrismFontFile prismFontFile;
        int n;
        ++this.numEmbeddedFonts;
        PrismFontFile[] prismFontFileArray = this.createFontResources(string2, string3, bl, true, bl2, bl3, bl4);
        if (prismFontFileArray == null || prismFontFileArray.length == 0) {
            return null;
        }
        if (this.embeddedFonts == null) {
            this.embeddedFonts = new HashMap();
        }
        boolean bl5 = true;
        for (n = 0; n < prismFontFileArray.length; ++n) {
            prismFontFile = prismFontFileArray[n];
            object = prismFontFile.getFamilyName();
            if (object == null || ((String)object).length() == 0) {
                return null;
            }
            string4 = prismFontFile.getFullName();
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            String string5 = prismFontFile.getPSName();
            if (string5 == null || string5.length() == 0) {
                return null;
            }
            FontResource fontResource = this.embeddedFonts.get(string4);
            if (fontResource == null || !prismFontFile.equals(fontResource)) continue;
            bl5 = false;
        }
        if (bl5 && !this.registerEmbeddedFont(prismFontFileArray[0].getFileName())) {
            return null;
        }
        if (bl2 && !prismFontFileArray[0].isDecoded()) {
            this.addTmpFont(prismFontFileArray[0]);
        }
        if (!bl) {
            return prismFontFileArray;
        }
        if (string2 != null && !string2.isEmpty()) {
            this.embeddedFonts.put(string2, prismFontFileArray[0]);
            this.storeInMap(string2, prismFontFileArray[0]);
        }
        for (n = 0; n < prismFontFileArray.length; ++n) {
            prismFontFile = prismFontFileArray[n];
            object = prismFontFile.getFamilyName();
            string4 = prismFontFile.getFullName();
            this.removeEmbeddedFont(string4);
            this.embeddedFonts.put(string4, prismFontFile);
            this.storeInMap(string4, prismFontFile);
            object = (String)object + this.dotStyleStr(prismFontFile.isBold(), prismFontFile.isItalic());
            this.storeInMap((String)object, prismFontFile);
            this.compResourceMap.remove(((String)object).toLowerCase());
        }
        return prismFontFileArray;
    }

    private void logFontInfo(String string2, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        System.err.println(string2);
        for (String string3 : hashMap.keySet()) {
            System.err.println("font=" + string3 + " file=" + hashMap.get(string3));
        }
        for (String string3 : hashMap2.keySet()) {
            System.err.println("font=" + string3 + " family=" + hashMap2.get(string3));
        }
        for (String string3 : hashMap3.keySet()) {
            System.err.println("family=" + string3 + " fonts=" + hashMap3.get(string3));
        }
    }

    private synchronized HashMap<String, String> getFullNameToFileMap() {
        if (this.fontToFileMap == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(100);
            this.fontToFamilyNameMap = new HashMap(100);
            this.familyToFontListMap = new HashMap(50);
            this.fileToFontMap = new HashMap(100);
            if (isWindows) {
                PrismFontFactory.getPlatformFontDirs();
                PrismFontFactory.populateFontFileNameMap(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
                if (debugFonts) {
                    System.err.println("Windows Locale ID=" + PrismFontFactory.getSystemLCID());
                    this.logFontInfo(" *** WINDOWS FONTS BEFORE RESOLVING", hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
                this.resolveWindowsFonts(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                if (debugFonts) {
                    this.logFontInfo(" *** WINDOWS FONTS AFTER RESOLVING", hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
            } else if (isMacOSX || isIOS) {
                MacFontFinder.populateFontFileNameMap(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
            } else if (isLinux) {
                FontConfigManager.populateMaps(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.getDefault());
                if (debugFonts) {
                    this.logFontInfo(" *** FONTCONFIG LOCATED FONTS:", hashMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
            } else if (isAndroid) {
                AndroidFontFinder.populateFontFileNameMap(hashMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
            } else {
                this.fontToFileMap = hashMap;
                return this.fontToFileMap;
            }
            for (String string2 : hashMap.keySet()) {
                String string3 = hashMap.get(string2);
                this.fileToFontMap.put(string3.toLowerCase(), string2);
            }
            this.fontToFileMap = hashMap;
            if (isAndroid) {
                this.populateFontFileNameMapGeneric(AndroidFontFinder.getSystemFontsDir());
            }
            this.populateFontFileNameMapGeneric(jreFontDir);
        }
        return this.fontToFileMap;
    }

    @Override
    public final boolean hasPermission() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(FXPermissions.LOAD_FONT_PERMISSION);
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    void addToMaps(PrismFontFile prismFontFile) {
        if (prismFontFile == null) {
            return;
        }
        String string2 = prismFontFile.getFullName();
        String string3 = prismFontFile.getFamilyName();
        if (string2 == null || string3 == null) {
            return;
        }
        String string4 = string2.toLowerCase();
        String string5 = string3.toLowerCase();
        this.fontToFileMap.put(string4, prismFontFile.getFileName());
        this.fontToFamilyNameMap.put(string4, string3);
        ArrayList<String> arrayList = this.familyToFontListMap.get(string5);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.familyToFontListMap.put(string5, arrayList);
        }
        arrayList.add(string2);
    }

    void populateFontFileNameMapGeneric(String string2) {
        File file = new File(string2);
        String[] stringArray = null;
        try {
            stringArray = AccessController.doPrivileged(() -> file.list(TTFilter.getInstance()));
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                PrismFontFile prismFontFile;
                String string3 = string2 + File.separator + stringArray[i];
                if (!this.registerEmbeddedFont(string3)) continue;
                int n = 0;
                if ((prismFontFile = this.createFontResource(string3, n++)) == null) continue;
                this.addToMaps(prismFontFile);
                while (n < prismFontFile.getFontCount() && (prismFontFile = this.createFontResource(string3, n++)) != null) {
                    this.addToMaps(prismFontFile);
                }
                continue;
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
    }

    static native int getLCDContrastWin32();

    private static native float getSystemFontSizeNative();

    private static native String getSystemFontNative();

    public static float getSystemFontSize() {
        if (systemFontSize == -1.0f) {
            if (isWindows) {
                systemFontSize = PrismFontFactory.getSystemFontSizeNative();
            } else if (isMacOSX || isIOS) {
                systemFontSize = MacFontFinder.getSystemFontSize();
            } else if (isAndroid) {
                systemFontSize = AndroidFontFinder.getSystemFontSize();
            } else if (isEmbedded) {
                try {
                    int n = Screen.getMainScreen().getResolutionY();
                    systemFontSize = (float)n / 6.0f;
                }
                catch (NullPointerException nullPointerException) {
                    systemFontSize = 13.0f;
                }
            } else {
                systemFontSize = 13.0f;
            }
        }
        return systemFontSize;
    }

    public static String getSystemFont(String string2) {
        if (string2.equals("System")) {
            if (systemFontFamily == null) {
                if (isWindows) {
                    systemFontFamily = PrismFontFactory.getSystemFontNative();
                    if (systemFontFamily == null) {
                        systemFontFamily = "Arial";
                    }
                } else if (isMacOSX || isIOS) {
                    systemFontFamily = MacFontFinder.getSystemFont();
                    if (systemFontFamily == null) {
                        systemFontFamily = "Lucida Grande";
                    }
                } else {
                    systemFontFamily = isAndroid ? AndroidFontFinder.getSystemFont() : "Lucida Sans";
                }
            }
            return systemFontFamily;
        }
        if (string2.equals("SansSerif")) {
            return "Arial";
        }
        if (string2.equals("Serif")) {
            return "Times New Roman";
        }
        if (monospaceFontFamily != null || isMacOSX) {
            // empty if block
        }
        if (monospaceFontFamily == null) {
            monospaceFontFamily = "Courier New";
        }
        return monospaceFontFamily;
    }

    static native short getSystemLCID();

    static {
        fontSizeLimit = 80.0f;
        lcdContrast = -1.0f;
        isWindows = PlatformUtil.isWindows();
        isMacOSX = PlatformUtil.isMac();
        isLinux = PlatformUtil.isLinux();
        isIOS = PlatformUtil.isIOS();
        isAndroid = PlatformUtil.isAndroid();
        isEmbedded = PlatformUtil.isEmbedded();
        int[] nArray = new int[]{65536};
        debugFonts = AccessController.doPrivileged(() -> {
            NativeLibLoader.loadLibrary("javafx_font");
            String string2 = System.getProperty("prism.debugfonts", "");
            boolean bl = "true".equals(string2);
            jreFontDir = PrismFontFactory.getJDKFontDir();
            String string3 = System.getProperty("com.sun.javafx.fontSize");
            systemFontSize = -1.0f;
            if (string3 != null) {
                try {
                    systemFontSize = Float.parseFloat(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Cannot parse font size '" + string3 + "'");
                }
            }
            if ((string3 = System.getProperty("prism.subpixeltext", "on")).indexOf("on") != -1 || string3.indexOf("true") != -1) {
                subPixelMode = 1;
            }
            if (string3.indexOf("native") != -1) {
                subPixelMode |= 5;
            }
            if (string3.indexOf("vertical") != -1) {
                subPixelMode |= 7;
            }
            if ((string3 = System.getProperty("prism.fontSizeLimit")) != null) {
                try {
                    fontSizeLimit = Float.parseFloat(string3);
                    if (fontSizeLimit <= 0.0f) {
                        fontSizeLimit = Float.POSITIVE_INFINITY;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Cannot parse fontSizeLimit '" + string3 + "'");
                }
            }
            boolean bl2 = isIOS || isAndroid || isEmbedded;
            String string4 = bl2 ? "false" : "true";
            String string5 = System.getProperty("prism.lcdtext", string4);
            lcdEnabled = string5.equals("true");
            string3 = System.getProperty("prism.cacheLayoutSize");
            if (string3 != null) {
                try {
                    nArray[0] = Integer.parseInt(string3);
                    if (nArray[0] < 0) {
                        nArray[0] = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Cannot parse cache layout size '" + string3 + "'");
                }
            }
            return bl;
        });
        cacheLayoutSize = nArray[0];
        theFontFactory = null;
        STR_ARRAY = new String[0];
        sysFontDir = null;
        userFontDir = null;
        fileCloser = null;
        systemFontFamily = null;
        monospaceFontFamily = null;
    }

    private static class TTFilter
    implements FilenameFilter {
        static TTFilter ttFilter;

        @Override
        public boolean accept(File file, String string2) {
            int n = string2.length() - 4;
            if (n <= 0) {
                return false;
            }
            return string2.startsWith(".ttf", n) || string2.startsWith(".TTF", n) || string2.startsWith(".ttc", n) || string2.startsWith(".TTC", n) || string2.startsWith(".otf", n) || string2.startsWith(".OTF", n);
        }

        private TTFilter() {
        }

        static TTFilter getInstance() {
            if (ttFilter == null) {
                ttFilter = new TTFilter();
            }
            return ttFilter;
        }
    }
}

