/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean verbose = false;
    private static boolean usingModules = false;
    private static File libDir = null;
    private static String libPrefix = "";
    private static String libSuffix = "";

    public static synchronized void loadLibrary(String string2) {
        if (!loaded.contains(string2)) {
            StackWalker stackWalker = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
            Class<?> clazz = stackWalker.getCallerClass();
            NativeLibLoader.loadLibraryInternal(string2, null, clazz);
            loaded.add(string2);
        }
    }

    public static synchronized void loadLibrary(String string2, List<String> list) {
        if (!loaded.contains(string2)) {
            StackWalker stackWalker = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
            Class<?> clazz = stackWalker.getCallerClass();
            NativeLibLoader.loadLibraryInternal(string2, list, clazz);
            loaded.add(string2);
        }
    }

    private static String[] initializePath(String string2) {
        String string3 = System.getProperty(string2, "");
        String string4 = File.pathSeparator;
        int n = string3.length();
        int n2 = string3.indexOf(string4);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string3.indexOf(string4, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string3.indexOf(string4);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string3.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string3.indexOf(string4, n2);
        }
        stringArray[n3] = string3.substring(n2, n);
        return stringArray;
    }

    private static void loadLibraryInternal(String string2, List<String> list, Class clazz) {
        try {
            NativeLibLoader.loadLibraryFullPath(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (verbose && !usingModules) {
                System.err.println("WARNING: " + unsatisfiedLinkError);
            }
            if (NativeLibLoader.loadLibraryFromResource(string2, list, clazz)) {
                return;
            }
            String[] stringArray = NativeLibLoader.initializePath("java.library.path");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Object object = stringArray[i];
                    if (!((String)object).endsWith(File.separator)) {
                        object = (String)object + File.separator;
                    }
                    String string3 = System.mapLibraryName(string2);
                    File file = new File((String)object + string3);
                    System.load(file.getAbsolutePath());
                    if (verbose) {
                        System.err.println("Loaded " + file.getAbsolutePath() + " from java.library.path");
                    }
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    continue;
                }
            }
            try {
                System.loadLibrary(string2);
                if (verbose) {
                    System.err.println("System.loadLibrary(" + string2 + ") succeeded");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                if ("ios".equals(System.getProperty("os.name").toLowerCase(Locale.ROOT)) && string2.contains("-")) {
                    string2 = string2.replace("-", "_");
                    System.loadLibrary(string2);
                    return;
                }
                throw unsatisfiedLinkError3;
            }
        }
    }

    private static boolean loadLibraryFromResource(String string2, List<String> list, Class clazz) {
        return NativeLibLoader.installLibraryFromResource(string2, list, clazz, true);
    }

    private static boolean installLibraryFromResource(String string2, List<String> list, Class clazz, boolean bl) {
        try {
            Object object;
            Object object2;
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    boolean bl2 = NativeLibLoader.installLibraryFromResource((String)object, null, clazz, false);
                }
            }
            if ((object = clazz.getResourceAsStream((String)(object2 = "/" + System.mapLibraryName(string2)))) != null) {
                String string3 = NativeLibLoader.cacheLibrary((InputStream)object, (String)object2, clazz);
                if (bl) {
                    System.load(string3);
                    if (verbose) {
                        System.err.println("Loaded library " + (String)object2 + " from resource");
                    }
                } else if (verbose) {
                    System.err.println("Unpacked library " + (String)object2 + " from resource");
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            System.err.println("Loading library " + string2 + " from resource failed: " + throwable);
            throwable.printStackTrace();
        }
        return false;
    }

    private static String cacheLibrary(InputStream inputStream, String string2, Class clazz) throws IOException {
        Object object;
        Object object2;
        String string3 = System.getProperty("javafx.version", "versionless");
        Object object3 = System.getProperty("javafx.cachedir", "");
        if (((String)object3).isEmpty()) {
            object3 = System.getProperty("user.home") + "/.openjfx/cache/" + string3;
        }
        File file = new File((String)object3);
        boolean bl = true;
        if (file.exists()) {
            if (!file.isDirectory()) {
                System.err.println("Cache exists but is not a directory: " + file);
                bl = false;
            }
        } else if (!file.mkdirs()) {
            System.err.println("Can not create cache at " + file);
            bl = false;
        }
        if (!file.canRead()) {
            bl = false;
        }
        if (!bl) {
            object2 = System.getProperty("user.name", "anonymous");
            String string4 = System.getProperty("java.io.tmpdir") + "/.openjfx_" + (String)object2 + "/cache/" + string3;
            file = new File(string4);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IOException("Cache exists but is not a directory: " + file);
                }
            } else if (!file.mkdirs()) {
                throw new IOException("Can not create cache at " + file);
            }
        }
        object2 = new File(file, string2);
        boolean bl2 = true;
        if (((File)object2).exists()) {
            try {
                DigestInputStream digestInputStream = new DigestInputStream(inputStream, MessageDigest.getInstance("MD5"));
                digestInputStream.getMessageDigest().reset();
                byte[] byArray = new byte[4096];
                while (digestInputStream.read(byArray) != -1) {
                }
                object = digestInputStream.getMessageDigest().digest();
                inputStream.close();
                inputStream = clazz.getResourceAsStream(string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                object = new byte[1];
            }
            byte[] byArray = NativeLibLoader.calculateCheckSum((File)object2);
            if (!Arrays.equals((byte[])object, byArray)) {
                Files.delete(((File)object2).toPath());
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            object = ((File)object2).toPath();
            Files.copy(inputStream, (Path)object, new CopyOption[0]);
        }
        object = ((File)object2).getAbsolutePath();
        return object;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray;
            try (DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, MessageDigest.getInstance("MD5"));){
                digestInputStream.getMessageDigest().reset();
                byte[] byArray2 = new byte[4096];
                while (digestInputStream.read(byArray2) != -1) {
                }
                byArray = digestInputStream.getMessageDigest().digest();
            }
            return byArray;
        }
        catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception2) {
            return new byte[0];
        }
    }

    private static void loadLibraryFullPath(String string2) {
        try {
            Object object;
            Class<NativeLibLoader> clazz;
            if (usingModules) {
                throw new UnsatisfiedLinkError("ignored");
            }
            if (libDir == null) {
                clazz = NativeLibLoader.class;
                object = "NativeLibLoader.class";
                String string3 = clazz.getResource((String)object).toString();
                if (string3.startsWith("jrt:")) {
                    usingModules = true;
                    throw new UnsatisfiedLinkError("ignored");
                }
                if (!string3.startsWith("jar:file:") || string3.indexOf(33) == -1) {
                    throw new UnsatisfiedLinkError("Invalid URL for class: " + string3);
                }
                String string4 = string3.substring(4, string3.lastIndexOf(33));
                int n = Math.max(string4.lastIndexOf(47), string4.lastIndexOf(92));
                String string5 = System.getProperty("os.name");
                String string6 = null;
                if (string5.startsWith("Windows")) {
                    string6 = "../bin";
                } else if (string5.startsWith("Mac")) {
                    string6 = ".";
                } else if (string5.startsWith("Linux")) {
                    string6 = ".";
                }
                String string7 = string4.substring(0, n) + "/" + string6;
                libDir = new File(new URI(string7).getPath());
                if (string5.startsWith("Windows")) {
                    libPrefix = "";
                    libSuffix = ".dll";
                } else if (string5.startsWith("Mac")) {
                    libPrefix = "lib";
                    libSuffix = ".dylib";
                } else if (string5.startsWith("Linux")) {
                    libPrefix = "lib";
                    libSuffix = ".so";
                }
            }
            object = new File(libDir, libPrefix + string2 + libSuffix);
            clazz = ((File)object).getCanonicalPath();
            System.load((String)((Object)clazz));
            if (verbose) {
                System.err.println("Loaded " + ((File)object).getAbsolutePath() + " from relative path");
            }
        }
        catch (Exception exception2) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(exception2);
        }
    }

    static {
        AccessController.doPrivileged(() -> {
            verbose = Boolean.getBoolean("javafx.verbose");
            return null;
        });
    }
}

