/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstantDeserializer<T extends Temporal>
extends JSR310DateTimeDeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    private static final Pattern ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX = Pattern.compile("\\+00:?(00)?$");
    protected static final Pattern ISO8601_COLONLESS_OFFSET_REGEX = Pattern.compile("[+-][0-9]{4}(?=\\[|$)");
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null, true);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.isEqual(OffsetDateTime.MIN) || d.isEqual(OffsetDateTime.MAX) ? d : d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), true);
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, a -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), ZonedDateTime::withZoneSameInstant, false);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;
    protected final boolean replaceZeroOffsetAsZ;
    protected final Boolean _adjustToContextTZOverride;

    protected InstantDeserializer(Class<T> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust, boolean replaceZeroOffsetAsZ) {
        super(supportedType, formatter);
        this.parsedToValue = parsedToValue;
        this.fromMilliseconds = fromMilliseconds;
        this.fromNanoseconds = fromNanoseconds;
        this.adjust = adjust == null ? (d, z) -> d : adjust;
        this.replaceZeroOffsetAsZ = replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = null;
    }

    protected InstantDeserializer(InstantDeserializer<T> base2, DateTimeFormatter f) {
        super(base2.handledType(), f);
        this.parsedToValue = base2.parsedToValue;
        this.fromMilliseconds = base2.fromMilliseconds;
        this.fromNanoseconds = base2.fromNanoseconds;
        this.adjust = base2.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base2._adjustToContextTZOverride;
    }

    protected InstantDeserializer(InstantDeserializer<T> base2, Boolean adjustToContextTimezoneOverride) {
        super(base2.handledType(), base2._formatter);
        this.parsedToValue = base2.parsedToValue;
        this.fromMilliseconds = base2.fromMilliseconds;
        this.fromNanoseconds = base2.fromNanoseconds;
        this.adjust = base2.adjust;
        this.replaceZeroOffsetAsZ = base2.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = adjustToContextTimezoneOverride;
    }

    protected InstantDeserializer(InstantDeserializer<T> base2, DateTimeFormatter f, Boolean leniency) {
        super(base2.handledType(), f, leniency);
        this.parsedToValue = base2.parsedToValue;
        this.fromMilliseconds = base2.fromMilliseconds;
        this.fromNanoseconds = base2.fromNanoseconds;
        this.adjust = base2.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base2._adjustToContextTZOverride;
    }

    @Override
    protected InstantDeserializer<T> withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dtf);
    }

    @Override
    protected InstantDeserializer<T> withLeniency(Boolean leniency) {
        return new InstantDeserializer<T>(this, this._formatter, leniency);
    }

    @Override
    protected InstantDeserializer<T> withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext ctxt, BeanProperty property, JsonFormat.Value formatOverrides) {
        InstantDeserializer deser = (InstantDeserializer)super._withFormatOverrides(ctxt, property, formatOverrides);
        Boolean B = formatOverrides.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        if (!Objects.equals(B, deser._adjustToContextTZOverride)) {
            return new InstantDeserializer<T>(deser, B);
        }
        return deser;
    }

    @Override
    public T deserialize(JsonParser parser, DeserializationContext context2) throws IOException {
        switch (parser.currentTokenId()) {
            case 8: {
                return this._fromDecimal(context2, parser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(context2, parser.getLongValue());
            }
            case 6: {
                return this._fromString(parser, context2, parser.getText());
            }
            case 1: {
                return this._fromString(parser, context2, context2.extractScalarFromObject(parser, this, this.handledType()));
            }
            case 12: {
                return (T)((Temporal)parser.getEmbeddedObject());
            }
            case 3: {
                return (T)((Temporal)this._deserializeFromArray(parser, context2));
            }
        }
        return (T)((Temporal)this._handleUnexpectedToken(context2, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT));
    }

    protected boolean shouldAdjustToContextTimezone(DeserializationContext context2) {
        return this._adjustToContextTZOverride != null ? this._adjustToContextTZOverride.booleanValue() : context2.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    protected int _countPeriods(String str2) {
        int commas = 0;
        int end = str2.length();
        for (int i = 0; i < end; ++i) {
            char ch = str2.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            if (ch == '.') {
                ++commas;
                continue;
            }
            return -1;
        }
        return commas;
    }

    protected T _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        Temporal value;
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (T)((Temporal)this._fromEmptyString(p, ctxt, string2));
        }
        if (this._formatter == DateTimeFormatter.ISO_INSTANT || this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            int dots = this._countPeriods(string2);
            if (dots >= 0) {
                try {
                    if (dots == 0) {
                        return this._fromLong(ctxt, Long.parseLong(string2));
                    }
                    if (dots == 1) {
                        return this._fromDecimal(ctxt, new BigDecimal(string2));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string2 = this.replaceZeroOffsetAsZIfNecessary(string2);
        }
        if (this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            string2 = this.addInColonToOffsetIfMissing(string2);
        }
        try {
            TemporalAccessor acc = this._formatter.parse(string2);
            value = (Temporal)this.parsedToValue.apply(acc);
            if (this.shouldAdjustToContextTimezone(ctxt)) {
                return (T)((Temporal)this.adjust.apply(value, this.getZone(ctxt)));
            }
        }
        catch (DateTimeException e) {
            value = (Temporal)this._handleDateTimeException(ctxt, e, string2);
        }
        return (T)value;
    }

    protected T _fromLong(DeserializationContext context2, long timestamp) {
        if (context2.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(timestamp, 0, this.getZone(context2))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(timestamp, this.getZone(context2))));
    }

    protected T _fromDecimal(DeserializationContext context2, BigDecimal value) {
        FromDecimalArguments args2 = DecimalUtils.extractSecondsAndNanos(value, (s, ns) -> new FromDecimalArguments((long)s, (int)ns, this.getZone(context2)));
        return (T)((Temporal)this.fromNanoseconds.apply(args2));
    }

    private ZoneId getZone(DeserializationContext context2) {
        return this._valueClass == Instant.class ? null : context2.getTimeZone().toZoneId();
    }

    private String replaceZeroOffsetAsZIfNecessary(String text) {
        if (this.replaceZeroOffsetAsZ) {
            return ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX.matcher(text).replaceFirst("Z");
        }
        return text;
    }

    private String addInColonToOffsetIfMissing(String text) {
        Matcher matcher = ISO8601_COLONLESS_OFFSET_REGEX.matcher(text);
        if (matcher.find()) {
            StringBuilder sb = new StringBuilder(matcher.group(0));
            sb.insert(3, ":");
            return matcher.replaceFirst(sb.toString());
        }
        return text;
    }

    public static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        FromDecimalArguments(long integer, int fraction, ZoneId zoneId) {
            this.integer = integer;
            this.fraction = fraction;
            this.zoneId = zoneId;
        }
    }

    public static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        FromIntegerArguments(long value, ZoneId zoneId) {
            this.value = value;
            this.zoneId = zoneId;
        }
    }
}

