save_help="\n    Save the current state of the LocalStack container in a Cloud Pod. A Cloud Pod can be exported locally or\n    registered within the LocalStack platform (with a Pro license). An optional message can be attached to any\n    Cloud Pod. Furthermore, one could decide to export only a subset of services with the optional --service option.\n\n    \x08\n    To export on a local path run the following command:\n    localstack pod save file://<path_on_disk>/<pod_name>\n\n    The output will be a <pod_name> zip file in the specified directory. This Cloud Pod instance can be restored at any\n    point in time with the load command.\n\n    To use the LocalStack platform for storage, the desired Cloud Pod's name will suffice, e,g.:\n\n    \x08\n    localstack pod save <pod_name>\n\n    Please be aware that each following save invocation with the same name will result in a new version being created.\n    "
delete_help='\n    Delete a Cloud Pod registered on the remote LocalStack platform. This command will remove all the versions\n    of a Cloud Pod, and the operation is not reversible.\n    '
load_help="\n    Load a Cloud Pod into the running LocalStack container. Users can import Pods from different sources: community\n    users can store and retrieve Pods from local storage or any provided HTTP URL; licensed users can take advantage of\n    the LocalStack platform to ease the storage, versioning, and retrieval of Cloud Pods.\n\n    The --source option specifies a URI scheme that points to the Cloud Pod's resources to import.\n\n    \x08\n    We support the following protocols:\n    localstack pod load file://<path_on_disk>\n    localstack pod load https://<some_url>\n    localstack pod load git://<user>/<repo>/<local_repo_path>\n\n    The latter option is merely a shortcut for --source https://raw.githubusercontent.com/<user>/<repo>/<branch>/<path>\n\n    Importing via a provided --source is available for all users.\n    Licensed users can omit this option and simply provide a name for their Cloud Pods.\n    "
list_help='\n    List all the Cloud Pods available for a single user, or for an entire organization, if the user is part of one.\n\n    With the --public flag, it lists the all the available public Cloud Pods. A public Cloud Pod is available across\n    the boundary of a user ond/or organization. In other words, any public Cloud Pod can be injected by any other\n    user holding a LocalStack Pro (or above) license.\n    '
versions_help='\n    List the versions available for a Cloud Pod. Each invocation of the save command is going to create a new version\n    for a named Cloud Pod, if a Pod with such name already does exist in the LocalStack platform.\n    '