from typing import Optional, Callable, Any, Union, List, Tuple, Sequence


def playString(keys: str, flags: int = ...) -> None: ...


def displayText(text: str, isError: bool = ..., logText: bool = ...) -> None: ...


def getClipboard() -> str: ...


def getCurrentModule() -> Tuple[str, str, int]: ...


def getCurrentUser() -> Tuple[str, str]: ...


def getMicState() -> str: ...


def setMicState(newState: str) -> None: ...


def execScript(command: str, args: List[str] = ..., comment: str = ...) -> None: ...


def getCallbackDepth() -> int: ...


def recognitionMimic(words: List[str]) -> None: ...


def playEvents(events: List[Tuple[int, int, int]]) -> None: ...


def getCursorPos() -> Tuple[int, int]: ...


def getScreenSize() -> Tuple[int, int]: ...


def inputFromFile(fileName: str, realtime: int = ..., playlist: Sequence[Union[int, Tuple[int, int]]] = ...,
                  uttDetect: int = ...) -> None: ...


def setTimerCallback(pCallback: Optional[Callable[[], Any]], nMilliseconds: int) -> None: ...


def getTrainingMode() -> Optional[Tuple[str, int]]: ...


def startTraining(mode: str) -> None: ...


def finishTraining(bProcess: int) -> None: ...


def createUser(userName: str, baseModel: str = ..., baseTopic: str = ...) -> None: ...


def openUser(userName: str) -> None: ...


def saveUser() -> None: ...


def getUserTraining() -> Optional[str]: ...


def getAllUsers() -> List[str]: ...


def getWordInfo(word: str, flags: int = ...) -> int: ...


def deleteWord(word: str) -> None: ...


def addWord(word: str, wordInfo: int = ..., pronList: Union[str, List[str]] = ...) -> int: ...


def setWordInfo(word: str, wordInfo: int) -> None: ...


def getWordProns(wordName: str) -> Optional[List[str]]: ...


def setTrayIcon(iconName: str = ..., toolTip: str = ..., callback: Callable[[int], Any] = ...) -> None: ...


def setBeginCallback(callback: Optional[Callable[[Tuple[str, str, int]], None]]) -> None: ...


def setChangeCallback(callback: Optional[Callable[[str, Any], None]]) -> None: ...


def isNatSpeakRunning() -> int: ...


def natConnect(bUseThreads: bool) -> None: ...


def natDisconnect() -> None: ...


def waitForSpeech(timeout_ms: int = 0) -> None: ...


class GramObj:

    def load(self, binary: Union[str, bytes], allResults: int = 0, hypothesis: int = 0) -> None: ...

    def unload(self) -> None: ...

    def activate(self, ruleName: Optional[str], window: int) -> None: ...

    def deactivate(self, ruleName: str) -> None: ...

    def setExclusive(self, state: bool) -> None: ...

    def setBeginCallBack(self, callback: Optional[Callable[[Tuple[str, str, int]], None]]) -> None: ...

    def setResultsCallBack(self, callback: Optional[Callable[[List[Tuple[str, int]], 'ResObj'], None]]) -> None: ...

    def setHypothesisCallBack(self, callback: Optional[Callable[[List[str]], None]]) -> None: ...

    def emptyList(self, listName: str) -> None: ...

    def appendList(self, listName: str, word: str) -> None: ...

    def setContext(self, beforeText: str = ..., afterText: str = ...) -> None: ...

    def setSelectText(self, text: str) -> None: ...

    def getSelectText(self) -> str: ...


class ResObj:

    def getResults(self, choice: int = 0) -> Optional[List[Tuple[str, int]]]: ...

    def getWords(self, choice: int = 0) -> Optional[List[str]]: ...

    def correction(self, words: List[str]) -> None: ...

    def getWave(self) -> str: ...

    def getWordInfo(self, choice: int = 0) -> Optional[List[Tuple[str, int, int, int, int, int, str]]]: ...

    def getSelectInfo(self, gramObj: GramObj, choice: int = 0) -> Tuple[int, int]: ...


class DictObj:

    def activate(self, window: int) -> None: ...

    def deactivate(self, ) -> None: ...

    def setBeginCallback(self, callback: Optional[Callable[[Tuple[str, str, int]], None]]) -> None: ...

    def setChangeCallback(self, callback: Optional[Callable[[int, int, str, int, int], None]]) -> None: ...

    def setLock(self, state: int) -> None: ...

    def getLength(self) -> int: ...

    def setText(self, text: str, start: int, end: int = ...) -> None: ...

    def getText(self, start: int, end: int = ...) -> str: ...

    def setTextSel(self, start: int, end: int = ...) -> None: ...

    def getTextSel(self) -> Tuple[int, int]: ...

    def setVisibleText(self, start: int, end: int = ...) -> None: ...

    def getVisibleText(self) -> Tuple[int, int]: ...


class NatError(Exception): ...


class InvalidWord(NatError): ...


class UnknownName(NatError): ...


class OutOfRange(NatError): ...


class MimicFailed(NatError): ...


class BadGrammar(NatError): ...


class WrongState(NatError): ...


class BadWindow(NatError): ...


class SyntaxError(NatError): ...


class UserExists(NatError): ...


class ValueError(NatError): ...


class DataMissing(NatError): ...


class WrongType(NatError): ...
