# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-01-25T08:33:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Field


class KCOCartItemRequest(BaseModel):
    reference: str = Field(..., title="Reference")
    quantity: int = Field(..., ge=1, title="Quantity")


class KCOCartItemResponse(BaseModel):
    reference: str = Field(..., title="Reference")
    quantity: int = Field(..., title="Quantity")
    name: Optional[str] = Field(None, title="Name")
    variant: Optional[str] = Field(None, title="Variant")
    total: Optional[float] = Field(None, title="Total")
    error: Optional[str] = Field(None, title="Error")
    warning: Optional[str] = Field(None, title="Warning")


class KCOCartRequest(BaseModel):
    items: list[KCOCartItemRequest] = Field(
        ..., min_items=1, title="Items", unique_items=True
    )


class KCOCartResponse(BaseModel):
    items: list[KCOCartItemResponse] = Field(..., title="Items")
    total: float = Field(..., title="Total")


class CountryCodeEnum(str, Enum):
    AF = "AF"
    AX = "AX"
    AL = "AL"
    DZ = "DZ"
    AS = "AS"
    AD = "AD"
    AO = "AO"
    AI = "AI"
    AQ = "AQ"
    AG = "AG"
    AR = "AR"
    AM = "AM"
    AW = "AW"
    AU = "AU"
    AT = "AT"
    AZ = "AZ"
    BS = "BS"
    BH = "BH"
    BD = "BD"
    BB = "BB"
    BY = "BY"
    BE = "BE"
    BZ = "BZ"
    BJ = "BJ"
    BM = "BM"
    BT = "BT"
    BO = "BO"
    BQ = "BQ"
    BA = "BA"
    BW = "BW"
    BV = "BV"
    BR = "BR"
    IO = "IO"
    BN = "BN"
    BG = "BG"
    BF = "BF"
    BI = "BI"
    KH = "KH"
    CM = "CM"
    CA = "CA"
    CV = "CV"
    KY = "KY"
    CF = "CF"
    TD = "TD"
    CL = "CL"
    CN = "CN"
    CX = "CX"
    CC = "CC"
    CO = "CO"
    KM = "KM"
    CG = "CG"
    CD = "CD"
    CK = "CK"
    CR = "CR"
    CI = "CI"
    HR = "HR"
    CU = "CU"
    CW = "CW"
    CY = "CY"
    CZ = "CZ"
    DK = "DK"
    DJ = "DJ"
    DM = "DM"
    DO = "DO"
    EC = "EC"
    EG = "EG"
    SV = "SV"
    GQ = "GQ"
    ER = "ER"
    EE = "EE"
    ET = "ET"
    FK = "FK"
    FO = "FO"
    FJ = "FJ"
    FI = "FI"
    FR = "FR"
    GF = "GF"
    PF = "PF"
    TF = "TF"
    GA = "GA"
    GM = "GM"
    GE = "GE"
    DE = "DE"
    GH = "GH"
    GI = "GI"
    GR = "GR"
    GL = "GL"
    GD = "GD"
    GP = "GP"
    GU = "GU"
    GT = "GT"
    GG = "GG"
    GN = "GN"
    GW = "GW"
    GY = "GY"
    HT = "HT"
    HM = "HM"
    VA = "VA"
    HN = "HN"
    HK = "HK"
    HU = "HU"
    IS = "IS"
    IN = "IN"
    ID = "ID"
    IR = "IR"
    IQ = "IQ"
    IE = "IE"
    IM = "IM"
    IL = "IL"
    IT = "IT"
    JM = "JM"
    JP = "JP"
    JE = "JE"
    JO = "JO"
    KZ = "KZ"
    KE = "KE"
    KI = "KI"
    KP = "KP"
    KR = "KR"
    XK = "XK"
    KW = "KW"
    KG = "KG"
    LA = "LA"
    LV = "LV"
    LB = "LB"
    LS = "LS"
    LR = "LR"
    LY = "LY"
    LI = "LI"
    LT = "LT"
    LU = "LU"
    MO = "MO"
    MK = "MK"
    MG = "MG"
    MW = "MW"
    MY = "MY"
    MV = "MV"
    ML = "ML"
    MT = "MT"
    MH = "MH"
    MQ = "MQ"
    MR = "MR"
    MU = "MU"
    YT = "YT"
    MX = "MX"
    FM = "FM"
    MD = "MD"
    MC = "MC"
    MN = "MN"
    ME = "ME"
    MS = "MS"
    MA = "MA"
    MZ = "MZ"
    MM = "MM"
    NA = "NA"
    NR = "NR"
    NP = "NP"
    NL = "NL"
    NC = "NC"
    NZ = "NZ"
    NI = "NI"
    NE = "NE"
    NG = "NG"
    NU = "NU"
    NF = "NF"
    MP = "MP"
    NO = "NO"
    OM = "OM"
    PK = "PK"
    PW = "PW"
    PS = "PS"
    PA = "PA"
    PG = "PG"
    PY = "PY"
    PE = "PE"
    PH = "PH"
    PN = "PN"
    PL = "PL"
    PT = "PT"
    PR = "PR"
    QA = "QA"
    RE = "RE"
    RO = "RO"
    RU = "RU"
    RW = "RW"
    BL = "BL"
    SH = "SH"
    KN = "KN"
    LC = "LC"
    MF = "MF"
    PM = "PM"
    VC = "VC"
    WS = "WS"
    SM = "SM"
    ST = "ST"
    SA = "SA"
    SN = "SN"
    RS = "RS"
    SC = "SC"
    SL = "SL"
    SG = "SG"
    SX = "SX"
    SK = "SK"
    SI = "SI"
    SB = "SB"
    SO = "SO"
    ZA = "ZA"
    GS = "GS"
    SS = "SS"
    ES = "ES"
    LK = "LK"
    SD = "SD"
    SR = "SR"
    SJ = "SJ"
    SZ = "SZ"
    SE = "SE"
    CH = "CH"
    SY = "SY"
    TW = "TW"
    TJ = "TJ"
    TZ = "TZ"
    TH = "TH"
    TL = "TL"
    TG = "TG"
    TK = "TK"
    TO = "TO"
    TT = "TT"
    TN = "TN"
    TR = "TR"
    TM = "TM"
    TC = "TC"
    TV = "TV"
    UG = "UG"
    UA = "UA"
    AE = "AE"
    GB = "GB"
    US = "US"
    UM = "UM"
    UY = "UY"
    UZ = "UZ"
    VU = "VU"
    VE = "VE"
    VN = "VN"
    VG = "VG"
    VI = "VI"
    WF = "WF"
    EH = "EH"
    YE = "YE"
    ZM = "ZM"
    ZW = "ZW"


class KCOCheckoutResponse(BaseModel):
    cart: KCOCartResponse
    snippet: Optional[str] = Field(None, title="Snippet")


class KCOConfirmResponse(BaseModel):
    purchase_number: Optional[int] = Field(None, ge=1, title="Purchase Number")
    snippet: str = Field(..., title="Snippet")


class KCOShippingRequest(BaseModel):
    reference: str = Field(..., title="Reference")


class OutOfStock(BaseModel):
    sku: str = Field(..., description="The over-allocated SKU.")
    quantity: int = Field(
        ..., description="The amount of over-allocation for this SKU."
    )


class Stock(BaseModel):
    sku: str = Field(..., description="Reference to the affected SKU.")
    quantity: int = Field(
        ..., description="The delta of the inventory adjustment.", ge=1
    )


class StockAdjustment(BaseModel):
    sku: str = Field(..., description="Reference to the affected SKU.")
    quantity: int = Field(..., description="The delta of the inventory adjustment.")


class StockAvailability(BaseModel):
    sku: str = Field(..., description="The SKU regarding this stock quantity.")
    quantity: int = Field(..., description="The current stock quantity for this SKU.")


class KCOCheckoutRequest(BaseModel):
    cart: KCOCartRequest
    country_code: Optional[Union[CountryCodeEnum, str]] = Field(
        None, title="Country Code"
    )
    shipping: Optional[KCOShippingRequest] = None


class PaginatedStockAvailabilityList(BaseModel):
    count: Optional[int] = Field(None, example=123)
    next: Optional[AnyUrl] = Field(
        None, example="http://api.example.org/accounts/?offset=400&limit=100"
    )
    previous: Optional[AnyUrl] = Field(
        None, example="http://api.example.org/accounts/?offset=200&limit=100"
    )
    results: Optional[list[StockAvailability]] = None
