# Generated by Django 3.2.11 on 2022-02-08 10:47

import json
import django.core.serializers.json
from django.db import migrations, models


def convert_task_args_to_json(apps, schema_editor):
    Task = apps.get_model("core", "Task")
    updated_tasks = []
    for task in Task.objects.only("args", "kwargs").iterator():
        try:
            update = False
            if isinstance(task.args, str):
                task.args = json.loads(task.args)
                update = True
            if isinstance(task.kwargs, str):
                task.kwargs = json.loads(task.kwargs)
                update = True
            if update:
                updated_tasks.append(task)
        except ValueError:
            # Catch and ignore all cases of JSON transcoding errors.
            # This is not even expected to be hit, but the migration should be fault tolerant.
            pass
        if len(updated_tasks) > 1000:
            Task.objects.bulk_update(updated_tasks, ["args", "kwargs"])
            updated_tasks.clear()

    Task.objects.bulk_update(updated_tasks, ["args", "kwargs"])


def convert_task_args_to_str(apps, schema_editor):
    Task = apps.get_model("core", "Task")
    encoder = django.core.serializers.json.DjangoJSONEncoder
    updated_tasks = []
    for task in Task.objects.only("args", "kwargs").iterator():
        try:
            update = False
            if not isinstance(task.args, str):
                task.args = json.dumps(task.args, cls=encoder)
                update = True
            if not isinstance(task.kwargs, str):
                task.kwargs = json.dumps(task.kwargs, cls=encoder)
                update = True
            if update:
                updated_tasks.append(task)
        except ValueError:
            # Catch and ignore all cases of JSON transcoding errors.
            # This is not even expected to be hit, but the migration should be fault tolerant.
            pass
        if len(updated_tasks) > 1000:
            Task.objects.bulk_update(updated_tasks, ["args", "kwargs"])
            updated_tasks.clear()

    Task.objects.bulk_update(updated_tasks, ["args", "kwargs"])


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0085_contentredirectcontentguard'),
    ]

    operations = [
        migrations.AlterField(
            model_name='task',
            name='args',
            field=models.JSONField(encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
        ),
        migrations.AlterField(
            model_name='task',
            name='kwargs',
            field=models.JSONField(encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
        ),
        migrations.RunPython(code=convert_task_args_to_json, reverse_code=convert_task_args_to_str, elidable=True),
    ]
