# Generated by Django 3.2.6 on 2021-09-29 14:00

from urllib.parse import urlparse, urlunparse

from django.db import migrations


def move_remote_url_credentials(apps, schema_editor):
    Remote = apps.get_model("core", "Remote")

    for remote in Remote.objects.filter(url__contains="@").iterator():
        url = urlparse(remote.url)

        if not remote.username:
            remote.username = url.username
        if not remote.password:
            remote.password = url.password

        _, url_split = url.netloc.rsplit("@", maxsplit=1)
        remote.url = urlunparse(url._replace(netloc=url_split))
        remote.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0076_remove_reserved_resource'),
    ]

    operations = [
        migrations.RunPython(
            code=move_remote_url_credentials,
            reverse_code=migrations.RunPython.noop,
            elidable=True,
        )
    ]
